/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import com.itextpdf.text.Rectangle;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ReasonCodeEnum;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.TransactionBatchBO;
import nl.ibs.fac.bp.DepreciationProposalBP;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.gov.boadapters.CreditBO;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.PdfHelper;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.Stopwatch;

public class DepreciationProposalToPDF
extends PdfHelper {
    public static final String CLASSNAME = DepreciationProposalToPDF.class.getName();
    private static final String FILENAME = "DepreciationProposal";
    private static final String REPORTTITLE = "DepreciationProposal";
    private static final String[] LABELS = new String[]{"assetId", "proFormaTypeId", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5", "description", "period", "amount2", "amount3", "reasonCode"};
    private static final int[] SIZES = new int[]{50, 50, 50, 50, 50, 50, 50, 100, 25, 75, 75, 100};
    private static final boolean[] RIGHTALIGN;
    private boolean[] rightAlign;
    private List fields;
    private FMSHelper fmsHelper;
    private FISHelper fisHelper;
    private DBData dbData;
    private String companyOrDataSetId;
    private String companyId;
    private String bookYear;
    private String[] level;
    private int lastLevel = 0;
    private String[] previous;
    private BigDecimal[] totalAmount2;
    private BigDecimal[] totalAmount3;
    private BigDecimal totalGenAmount2 = new BigDecimal(0);
    private BigDecimal totalGenAmount3 = new BigDecimal(0);

    static {
        boolean[] blArray = new boolean[12];
        blArray[9] = true;
        blArray[10] = true;
        RIGHTALIGN = blArray;
    }

    public DepreciationProposalToPDF(String[][] selections, Collection collection, List fields, String[][] labels, int[] sizes, boolean[] rightAlign, FMSHelper fmsHelper, FISHelper fisHelper, DBData dbData, String companyOrDataSetId, String companyId, String bookYear, String[] level) throws Exception {
        super("DepreciationProposal", selections, collection, labels, sizes, rightAlign, fmsHelper, fisHelper, companyId, bookYear);
        this.document.setPageSize(new Rectangle(1500.0f, 900.0f));
        this.fields = fields;
        this.rightAlign = rightAlign;
        this.fmsHelper = fmsHelper;
        this.fisHelper = fisHelper;
        this.dbData = dbData;
        this.companyOrDataSetId = companyOrDataSetId;
        this.companyId = companyId;
        this.bookYear = bookYear;
        this.level = level;
        this.previous = new String[level.length];
        this.totalAmount2 = new BigDecimal[level.length];
        this.totalAmount3 = new BigDecimal[level.length];
    }

    @Override
    protected String[] getRowValues(Object object) throws Exception {
        String typeId;
        Transaction transaction = (Transaction)object;
        String[] value = new String[this.rightAlign.length];
        String id = "";
        String cora = transaction.getCora();
        if ("A".equals(cora)) {
            id = transaction.getAssetId();
            value[this.fields.indexOf((Object)"description")] = transaction.getAsset().getDescription();
        } else {
            id = transaction.getCreditId();
            value[this.fields.indexOf((Object)"description")] = ((Credit)CreditBO.get((Company)CompanyBO.get(this.dbData, this.companyId)[0], transaction.getCreditId())[0]).getDescription();
        }
        if (this.rightAlign[this.fields.indexOf("assetId")]) {
            try {
                id = String.valueOf(Integer.parseInt(id));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        value[this.fields.indexOf((Object)"assetId")] = id;
        value[this.fields.indexOf((Object)"proFormaTypeId")] = typeId = transaction.getProFormaTypeId();
        value[this.fields.indexOf((Object)"period")] = PeriodHelper.toString(transaction.getBookYear(), transaction.getPeriod());
        value[this.fields.indexOf((Object)"amount2")] = IBSDecimal.format(transaction.getAmount2());
        value[this.fields.indexOf((Object)"amount3")] = IBSDecimal.format(transaction.getAmount3());
        value[this.fields.indexOf((Object)"reasonCode")] = ReasonCodeEnum.getValue(transaction.getReasonCode());
        String finDimId1 = transaction.getFinDimId1();
        String finDimId2 = transaction.getFinDimId2();
        String finDimId3 = transaction.getFinDimId3();
        String finDimId4 = transaction.getFinDimId4();
        String finDimId5 = transaction.getFinDimId5();
        value[this.fields.indexOf((Object)"finDimId1")] = this.unFormatId(finDimId1);
        value[this.fields.indexOf((Object)"finDimId2")] = this.unFormatId(finDimId2);
        value[this.fields.indexOf((Object)"finDimId3")] = this.unFormatId(finDimId3);
        value[this.fields.indexOf((Object)"finDimId4")] = this.unFormatId(finDimId4);
        value[this.fields.indexOf((Object)"finDimId5")] = this.unFormatId(finDimId5);
        String newValue = null;
        int i = this.level.length - 1;
        while (i > 0) {
            String sIndex = this.level[i];
            if (sIndex != null) {
                int index = Integer.parseInt(sIndex);
                if (index == 0) {
                    newValue = finDimId1;
                }
                if (index == 1) {
                    newValue = finDimId2;
                }
                if (index == 2) {
                    newValue = finDimId3;
                }
                if (index == 3) {
                    newValue = finDimId4;
                }
                if (index == 4) {
                    newValue = finDimId5;
                }
                if (index == 5) {
                    newValue = typeId;
                }
                if (index == 6) {
                    newValue = id;
                }
                if (this.previous[index] == null) {
                    this.totalAmount2[index] = new BigDecimal(0);
                    this.totalAmount3[index] = new BigDecimal(0);
                } else if (!newValue.equals(this.previous[index])) {
                    this.addTotalRow(index);
                    this.lastLevel = i;
                    int j = this.level.length - 1;
                    while (j >= i) {
                        sIndex = this.level[j];
                        if (sIndex != null) {
                            int jindex = Integer.parseInt(sIndex);
                            this.totalAmount2[jindex] = new BigDecimal(0);
                            this.totalAmount3[jindex] = new BigDecimal(0);
                            this.previous[jindex] = null;
                        }
                        --j;
                    }
                }
                this.previous[index] = newValue;
                this.totalAmount2[index] = this.totalAmount2[index].add(transaction.getAmount2());
                this.totalAmount3[index] = this.totalAmount3[index].add(transaction.getAmount3());
            }
            --i;
        }
        this.totalGenAmount2 = this.totalGenAmount2.add(transaction.getAmount2());
        this.totalGenAmount3 = this.totalGenAmount3.add(transaction.getAmount3());
        return value;
    }

    protected void addTotalRow(int index) throws Exception {
        String[] value = new String[this.rightAlign.length];
        value[0] = this.totalText;
        value[1] = this.previous[index];
        if (index < 5 && value[1].trim().length() > 0) {
            String description = null;
            if (this.fisHelper != null) {
                description = this.fisHelper.getDescription(value[1], this.companyId, this.bookYear, index + 1);
            }
            if (this.fmsHelper != null) {
                description = this.fmsHelper.getDescription(value[1], index + 1);
            }
            if (description != null) {
                value[1] = description;
            }
        }
        if (index == 5) {
            AssetType assetType = (AssetType)AssetTypeBO.get(this.dbData, this.companyOrDataSetId, this.previous[index])[0];
            value[1] = assetType.getDescription();
        }
        value[this.fields.indexOf((Object)"amount2")] = IBSDecimal.format(this.totalAmount2[index]);
        value[this.fields.indexOf((Object)"amount3")] = IBSDecimal.format(this.totalAmount3[index]);
        this.addTableRow(value);
        this.addEmptyTableRow();
    }

    @Override
    protected void addTotalRow() throws Exception {
        int i = this.lastLevel;
        while (i > 0) {
            String sIndex = this.level[i];
            if (sIndex != null) {
                this.addTotalRow(Integer.parseInt(sIndex));
            }
            --i;
        }
    }

    @Override
    protected void addTotalGenRow() throws Exception {
        String[] value = new String[this.rightAlign.length];
        value[0] = this.totalText;
        value[1] = this.totalGenText;
        value[this.fields.indexOf((Object)"amount2")] = IBSDecimal.format(this.totalGenAmount2);
        value[this.fields.indexOf((Object)"amount3")] = IBSDecimal.format(this.totalGenAmount3);
        this.addTableRow(value);
    }

    private String unFormatId(String id) throws Exception {
        if (this.fisHelper == null) {
            return id;
        }
        return FISHelper.unFormatId(id);
    }

    private static String unFormatId(Environment env, String id) throws Exception {
        if (id == null || id.equals("")) {
            return id;
        }
        if (env.getOperationArea().trim().length() != 0) {
            return id;
        }
        return new BigDecimal(id).toString();
    }

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            DepreciationProposalToPDF.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        TransactionBatch transactionBatch;
        if (Log.debug() && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                Log.debug((String)args[i]);
                ++i;
            }
        }
        String[][] selections = BatchJobHelper.getSelections(args);
        Map map = BatchJobHelper.getSelections(selections);
        String companyId = (String)map.get("Company");
        DBData dbData = BOAdapter.getDBData(map);
        Environment env = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        if (map.containsKey("batchId")) {
            int batchId = Integer.parseInt((String)map.get("batchId"));
            transactionBatch = (TransactionBatch)TransactionBatchBO.get(dbData, companyId, batchId)[0];
        } else {
            transactionBatch = DepreciationProposalBP.getCurrentDepreciationBatch(dbData, companyId);
            if (transactionBatch != null) {
                map.put("batchId", "" + transactionBatch.getBatchId());
            }
        }
        if (transactionBatch == null) {
            String message = LanguageHelper.getString("nl.ibs.fac.language", "batch_not_found");
            Log.error((String)message);
            return;
        }
        map.put("governmentActivated", new Boolean(env.getGovernmentActivated()));
        String[][] modifiedSelections = DepreciationProposalToPDF.modifySelections(selections, env, transactionBatch);
        if (transactionBatch.getCodeFiscal()) {
            DepreciationProposalToPDF.processAccountingPrinciple(args, map, modifiedSelections, env, transactionBatch, false);
        }
        if (transactionBatch.getCodeAccountingPrinciple2() || env.getGovernmentActivated()) {
            DepreciationProposalToPDF.processAccountingPrinciple(args, map, modifiedSelections, env, transactionBatch, true);
        }
    }

    static String[][] modifySelections(String[][] selections, Environment env, TransactionBatch transactionBatch) throws Exception {
        String[][] modifiedSelections = new String[16][2];
        int index = 0;
        String[] tokens = new String[7];
        String[] values = new String[7];
        String selectionValue = DepreciationProposalToPDF.retrieveSelection("User", selections);
        modifiedSelections[index][0] = "Gebruiker";
        modifiedSelections[index][1] = ": " + selectionValue;
        selectionValue = DepreciationProposalToPDF.retrieveSelection("facLib", selections);
        modifiedSelections[++index][0] = "FAC - omgeving";
        modifiedSelections[index][1] = ": " + selectionValue;
        modifiedSelections[++index][0] = "Afschrijvingsvoorstel";
        modifiedSelections[index][1] = ": " + transactionBatch.getBatchId();
        selectionValue = DepreciationProposalToPDF.retrieveSelection("Company", selections);
        modifiedSelections[++index][0] = "Bedrijf";
        modifiedSelections[index][1] = ": " + selectionValue;
        modifiedSelections[++index][0] = "Periode";
        modifiedSelections[index][1] = ": " + transactionBatch.getEndYear() + "-" + transactionBatch.getEndPeriod();
        modifiedSelections[++index][0] = "Verslaggevingssoort";
        modifiedSelections[index][1] = ": ";
        modifiedSelections[++index][0] = " ";
        modifiedSelections[index][1] = " ";
        ++index;
        String from = DepreciationProposalToPDF.retrieveSelection("FromAsset", selections);
        String to = DepreciationProposalToPDF.retrieveSelection("ToAsset", selections);
        tokens[0] = "assetId";
        values[0] = LanguageHelper.getString("nl.ibs.fac.language", tokens[0]);
        if (from != null && !from.equals("") || to != null && !to.equals("")) {
            modifiedSelections[index][0] = "Activum";
            modifiedSelections[index][1] = ": " + from + " - " + to;
        }
        ++index;
        from = DepreciationProposalToPDF.retrieveSelection("FromType", selections);
        to = DepreciationProposalToPDF.retrieveSelection("ToType", selections);
        tokens[1] = "proFormaTypeId";
        values[1] = LanguageHelper.getString("nl.ibs.fac.language", tokens[1]);
        if (from != null && !from.equals("") || to != null && !to.equals("")) {
            modifiedSelections[index][0] = "Type";
            modifiedSelections[index][1] = ": " + from + " - " + to;
        }
        ++index;
        from = DepreciationProposalToPDF.retrieveSelection("FromFinDimId1", selections);
        to = DepreciationProposalToPDF.retrieveSelection("ToFinDimId1", selections);
        tokens[2] = "finDimId1";
        values[2] = env.getName1();
        if (from != null && !from.equals("") || to != null && !to.equals("")) {
            modifiedSelections[index][0] = "Kostenplaats";
            modifiedSelections[index][1] = ": " + DepreciationProposalToPDF.unFormatId(env, from) + " - " + DepreciationProposalToPDF.unFormatId(env, to);
        }
        ++index;
        from = DepreciationProposalToPDF.retrieveSelection("FromFinDimId2", selections);
        to = DepreciationProposalToPDF.retrieveSelection("ToFinDimId2", selections);
        tokens[3] = "finDimId2";
        values[3] = env.getName2();
        if (from != null && !from.equals("") || to != null && !to.equals("")) {
            modifiedSelections[index][0] = "Kostendrager";
            modifiedSelections[index][1] = ": " + DepreciationProposalToPDF.unFormatId(env, from) + " - " + DepreciationProposalToPDF.unFormatId(env, to);
        }
        ++index;
        from = DepreciationProposalToPDF.retrieveSelection("FromFinDimId3", selections);
        to = DepreciationProposalToPDF.retrieveSelection("ToFinDimId3", selections);
        tokens[4] = "finDimId3";
        values[4] = env.getName3();
        if (from != null && !from.equals("") || to != null && !to.equals("")) {
            modifiedSelections[index][0] = "Statistieknummer-1";
            modifiedSelections[index][1] = ": " + DepreciationProposalToPDF.unFormatId(env, from) + " - " + DepreciationProposalToPDF.unFormatId(env, to);
        }
        ++index;
        from = DepreciationProposalToPDF.retrieveSelection("FromFinDimId4", selections);
        to = DepreciationProposalToPDF.retrieveSelection("ToFinDimId4", selections);
        tokens[5] = "finDimId4";
        values[5] = env.getName4();
        if (from != null && !from.equals("") || to != null && !to.equals("")) {
            modifiedSelections[index][0] = "Statistieknummer-2";
            modifiedSelections[index][1] = ": " + DepreciationProposalToPDF.unFormatId(env, from) + " - " + DepreciationProposalToPDF.unFormatId(env, to);
        }
        ++index;
        from = DepreciationProposalToPDF.retrieveSelection("FromFinDimId5", selections);
        to = DepreciationProposalToPDF.retrieveSelection("ToFinDimId5", selections);
        tokens[6] = "finDimId5";
        values[6] = env.getName5();
        if (from != null && !from.equals("") || to != null && !to.equals("")) {
            modifiedSelections[index][0] = "Statistieknummer-3";
            modifiedSelections[index][1] = ": " + DepreciationProposalToPDF.unFormatId(env, from) + " - " + DepreciationProposalToPDF.unFormatId(env, to);
        }
        ++index;
        String sortOrder = DepreciationProposalToPDF.retrieveSelection("orderBy", selections);
        if (sortOrder != null && !sortOrder.equals("")) {
            modifiedSelections[index][0] = "Sorteren op";
            String[] orderByTokens = BOAdapter.getOrderBy(sortOrder);
            String orderByValues = "";
            int i = 0;
            while (i < orderByTokens.length) {
                if (i > 0) {
                    orderByValues = String.valueOf(orderByValues) + ", ";
                }
                int j = 0;
                while (j < tokens.length) {
                    if (orderByTokens[i].trim().equals(tokens[j].trim())) {
                        orderByValues = String.valueOf(orderByValues) + values[j];
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            modifiedSelections[index][1] = ": " + orderByValues;
        }
        ++index;
        String levels = DepreciationProposalToPDF.retrieveSelection("levels", selections);
        boolean levelFound = false;
        if (levels != null && !levels.equals("")) {
            modifiedSelections[index][0] = "Totalen per";
            String levelValues = "";
            int i = 0;
            while (i < levels.length()) {
                int x = Integer.parseInt(levels.substring(i, i + 1));
                if (x > 0 && i > 0) {
                    levelValues = String.valueOf(levelValues) + ", ";
                }
                if (x <= 0) break;
                levelValues = String.valueOf(levelValues) + values[x + 1];
                levelFound = true;
                ++i;
            }
            if (levelFound) {
                modifiedSelections[index][1] = ": " + levelValues;
            } else {
                modifiedSelections[index][0] = null;
                modifiedSelections[index][1] = null;
            }
        }
        ++index;
        return modifiedSelections;
    }

    private static String retrieveSelection(String key, String[][] selections) throws Exception {
        int i = 0;
        while (i < selections.length) {
            if (key.equals(selections[i][0])) {
                return selections[i][1];
            }
            ++i;
        }
        return null;
    }

    private static void processAccountingPrinciple(String[] args, Map map, String[][] modifiedSelections, Environment environment, TransactionBatch transactionBatch, boolean ap2) throws Exception {
        String bookYear;
        if (ap2) {
            map.remove("AccountingPrinciple2");
            modifiedSelections[5][1] = environment.getGovernmentActivated() ? ": " + environment.getAPName3() : ": " + environment.getAPName2();
        } else {
            modifiedSelections[5][1] = ": " + environment.getAPName1();
        }
        map.put("AccountingPrinciple2", new Boolean(ap2));
        LoginHelper loginHelper = BatchJobHelper.getLoginHelper(map);
        String message = loginHelper.login();
        if (message != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        String companyId = (String)map.get("Company");
        message = loginHelper.login(environment, companyId, bookYear = (String)map.get("BookYear"));
        if (message != null && message.trim().length() > 0) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        FMSHelper fmsHelper = null;
        FISHelper fisHelper = null;
        if (environment.getOperationArea().trim().length() > 0) {
            fmsHelper = new FMSHelper(loginHelper);
        } else {
            fisHelper = new FISHelper(loginHelper);
        }
        DBData dbData = transactionBatch.getDBData();
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        String[] finTexts = new String[5];
        if (company.retrieveFinancialDimension1Usage() != 0) {
            finTexts[0] = environment.getShortName1();
        }
        if (company.retrieveFinancialDimension2Usage() != 0) {
            finTexts[1] = environment.getShortName2();
        }
        if (company.retrieveFinancialDimension3Usage() != 0) {
            finTexts[2] = environment.getShortName3();
        }
        if (company.retrieveFinancialDimension4Usage() != 0) {
            finTexts[3] = environment.getShortName4();
        }
        if (company.retrieveFinancialDimension5Usage() != 0) {
            finTexts[4] = environment.getShortName5();
        }
        List fields = BOAdapter.getFields(map, LABELS);
        int size = LABELS.length;
        String[][] labels = new String[1][size];
        int[] sizes = new int[size];
        boolean[] rightAlign = new boolean[size];
        int i = 0;
        while (i < size) {
            int j = fields.indexOf(LABELS[i]);
            labels[0][j] = String.valueOf(LABELS[i].substring(0, 1).toUpperCase()) + LABELS[i].substring(1);
            sizes[j] = SIZES[i];
            rightAlign[j] = RIGHTALIGN[i];
            if (LABELS[i].equals("assetId")) {
                if (AssetBO.isIdNumeric(company, false)) {
                    rightAlign[j] = true;
                }
            } else if (LABELS[i].equals("finDimId1")) {
                if (finTexts[0] == null) {
                    sizes[j] = 0;
                } else {
                    labels[0][j] = finTexts[0];
                }
            } else if (LABELS[i].equals("finDimId2")) {
                if (finTexts[1] == null) {
                    sizes[j] = 0;
                } else {
                    labels[0][j] = finTexts[1];
                }
            } else if (LABELS[i].equals("finDimId3")) {
                if (finTexts[2] == null) {
                    sizes[j] = 0;
                } else {
                    labels[0][j] = finTexts[2];
                }
            } else if (LABELS[i].equals("finDimId4")) {
                if (finTexts[3] == null) {
                    sizes[j] = 0;
                } else {
                    labels[0][j] = finTexts[3];
                }
            } else if (LABELS[i].equals("finDimId5")) {
                if (finTexts[4] == null) {
                    sizes[j] = 0;
                } else {
                    labels[0][j] = finTexts[4];
                }
            } else if (LABELS[i].equals("amount2")) {
                labels[0][j] = "DepreciationValue";
            } else if (LABELS[i].equals("amount3")) {
                labels[0][j] = "InterestValue";
            }
            ++i;
        }
        String companyOrDataSetId = companyId;
        String dataSetId = company.getDataSetId();
        if (dataSetId != null) {
            companyOrDataSetId = dataSetId;
        }
        DepreciationProposalToPDF depreciationProposalToPDF = new DepreciationProposalToPDF(modifiedSelections, TransactionBO.getTransactions(map, transactionBatch), fields, labels, sizes, rightAlign, fmsHelper, fisHelper, dbData, companyOrDataSetId, companyId, bookYear, BOAdapter.getTotalLevels(map));
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, String.valueOf(LanguageHelper.getString("nl.ibs.fac.language", "DepreciationProposal")) + '-' + modifiedSelections[5][1].substring(2), "pdf"));
        fos.write(depreciationProposalToPDF.createPdf().toByteArray());
        fos.close();
        loginHelper.logout(environment, companyId, bookYear);
        loginHelper.logout();
    }

    @Override
    protected int[] getColumnsToCumulate() throws Exception {
        return null;
    }
}

