/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.CSVHelper;
import nl.ibs.fac.ui.IncomingFinancialTransactionSelection;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.Stopwatch;

public class IncomingFinancialTransactionToCSV
extends CSVHelper {
    public static final String CLASSNAME = IncomingFinancialTransactionToCSV.class.getName();
    private static final String FILENAME = "IncomingFinancialTransactionReport";
    private int numberOfColumns;
    private boolean[] used = new boolean[5];
    private String[] attr;
    private IncomingFinancialTransaction ift = null;
    private NumericIdTransformer numericIdTransformer = new NumericIdTransformer();

    public IncomingFinancialTransactionToCSV(String[][] selections, Collection collection, String[][] labels, FMSHelper fmsHelper, FISHelper fisHelper, boolean[] used) throws Exception {
        super(selections, collection, labels, fmsHelper, fisHelper);
        this.numberOfColumns = labels[0].length;
        this.used = used;
        this.attr = new String[this.numberOfColumns];
    }

    @Override
    protected String[] getRowValues(Object object) throws Exception {
        this.ift = (IncomingFinancialTransaction)object;
        return this.getAttributes();
    }

    private String[] getAttributes() throws Exception {
        int a = 0;
        this.attr[a++] = PeriodHelper.toString(this.ift.getBookYear(), this.ift.getPeriod());
        this.attr[a++] = this.ift.getDescription();
        this.attr[a++] = IBSDecimal.format(this.ift.getTransactionValue(), true);
        this.attr[a++] = IBSDecimal.format(this.ift.getUnAllocatedValue(), true);
        this.attr[a++] = (String)this.numericIdTransformer.transform(this.ift.getMainAccount());
        if (this.used[0]) {
            this.attr[a++] = (String)this.numericIdTransformer.transform(this.ift.getFinDimId1());
        }
        if (this.used[1]) {
            this.attr[a++] = (String)this.numericIdTransformer.transform(this.ift.getFinDimId2());
        }
        if (this.used[2]) {
            this.attr[a++] = (String)this.numericIdTransformer.transform(this.ift.getFinDimId3());
        }
        if (this.used[3]) {
            this.attr[a++] = (String)this.numericIdTransformer.transform(this.ift.getFinDimId4());
        }
        if (this.used[4]) {
            this.attr[a++] = (String)this.numericIdTransformer.transform(this.ift.getFinDimId5());
        }
        this.attr[a++] = "" + this.ift.getSystemItemNumber();
        this.attr[a++] = this.ift.getVoucherId();
        this.attr[a++] = "" + this.ift.getInternalInvoiceId();
        return this.attr;
    }

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            IncomingFinancialTransactionToCSV.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        String[][] selections;
        Map map;
        LoginHelper loginHelper;
        String message;
        if (Log.debug() && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                Log.debug((String)args[i]);
                ++i;
            }
        }
        if ((message = (loginHelper = BatchJobHelper.getLoginHelper(map = BatchJobHelper.getSelections(selections = BatchJobHelper.getSelections(args)))).login()) != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        Environment environment = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        String companyId = (String)map.get("Company");
        DBData dbData = BOAdapter.getDBData(map);
        String bookYear = (String)map.get("BookYear");
        message = loginHelper.login(environment, companyId, bookYear);
        if (message != null && message.trim().length() > 0) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        FMSHelper fmsHelper = null;
        FISHelper fisHelper = null;
        if (environment.getOperationArea().trim().length() > 0) {
            fmsHelper = new FMSHelper(loginHelper);
        } else {
            fisHelper = new FISHelper(loginHelper);
        }
        boolean[] used = new boolean[5];
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        used[0] = company.getFinancialDimension1Usage() != 0;
        used[1] = company.getFinancialDimension2Usage() != 0;
        used[2] = company.getFinancialDimension3Usage() != 0;
        used[3] = company.getFinancialDimension4Usage() != 0;
        used[4] = company.getFinancialDimension5Usage() != 0;
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(LanguageHelper.getString("nl.ibs.fac.language", "Period"));
        labels.add(LanguageHelper.getString("nl.ibs.fac.language", "Description"));
        labels.add(LanguageHelper.getString("nl.ibs.fac.language", "Amount"));
        labels.add(LanguageHelper.getString("nl.ibs.fac.language", "ToAccountFor"));
        labels.add(LanguageHelper.getString("nl.ibs.fac.language", "MainAccount"));
        if (used[0]) {
            labels.add(environment.getShortName1());
        }
        if (used[1]) {
            labels.add(environment.getShortName2());
        }
        if (used[2]) {
            labels.add(environment.getShortName3());
        }
        if (used[3]) {
            labels.add(environment.getShortName4());
        }
        if (used[4]) {
            labels.add(environment.getShortName5());
        }
        labels.add(LanguageHelper.getString("nl.ibs.fac.language", "SystemItemNumber.short"));
        labels.add(LanguageHelper.getString("nl.ibs.fac.language", "VoucherId.short"));
        labels.add(LanguageHelper.getString("nl.ibs.fac.language", "InternalInvoiceId.short"));
        String[][] LABELS = new String[][]{new String[0]};
        LABELS[0] = new String[labels.size()];
        int i = 0;
        while (i < labels.size()) {
            LABELS[0][i] = (String)labels.get(i);
            ++i;
        }
        String selectionAsString = (String)map.get(IncomingFinancialTransactionSelection.IFTSELECTION);
        IncomingFinancialTransactionSelection selection = new IncomingFinancialTransactionSelection(selectionAsString);
        IncomingFinancialTransactionToCSV reconciliationToCSV = new IncomingFinancialTransactionToCSV(selections, selection.getCollection(), LABELS, fmsHelper, fisHelper, used);
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, FILENAME, "csv"));
        fos.write(reconciliationToCSV.createCsv());
        fos.close();
        loginHelper.logout(environment, companyId, bookYear);
        loginHelper.logout();
    }
}

