/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import com.itextpdf.text.Rectangle;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyAccountingPrincipleDefaultBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.bp.ProofDepreciationBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.CompanyAccountingPrincipleDefault;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.gov.bp.CreditDepreciationBP;
import nl.ibs.fac.gov.reports.CreditProofDepreciationReportHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.PdfHelper;
import nl.ibs.fac.reports.ProofDepreciationReportHelper;
import nl.ibs.fac.ui.AssetSelection;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.Stopwatch;

public class ProofDepreciationToPDF
extends PdfHelper {
    public static final String CLASSNAME = ProofDepreciationToPDF.class.getName();
    private static final String FILENAME = "ProofDepreciationReport";
    private static final String REPORTTITLE = "ProofDepreciationReport";
    private String[][] LABELS = new String[][]{new String[0]};
    private int[] SIZES = null;
    private boolean[] RIGHTALIGN = null;
    private NumericIdTransformer numericIdTransformer = new NumericIdTransformer();
    private String[] variablePeriodNames = null;
    private int theAccountingPrinciple = 0;
    private int accountingPrinciple = 0;
    private int bookYearFrom = 0;
    private int numberOfYears = 0;
    private int numberOfPeriods = 0;
    private int numberOfColumns = 0;
    private int printedLines = 0;
    private int[] orderByField = null;
    private boolean numericId;
    private boolean credit = false;
    private Environment env = null;
    private Asset asset = null;
    private Credit theCredit = null;
    private String periodType = null;
    private HashMap amounts = null;
    private ProofDepreciationBP proofDepreciationBP = null;
    private CreditDepreciationBP creditDepreciationBP = null;
    private AssetSelection selection;
    private BigDecimal[] creditAmounts;
    private boolean interest;

    public ProofDepreciationToPDF(String reportTitle, String[][] selections, AssetSelection assetSelection, Environment environment, Company company, String bookYear, boolean governmentActivated, FMSHelper fmsHelper, FISHelper fisHelper, boolean interest) throws Exception {
        super(reportTitle, selections, assetSelection.getCollection(), fmsHelper, fisHelper, company.getId(), bookYear);
        this.selection = assetSelection;
        this.orderByField = assetSelection.getOrderBy();
        this.env = environment;
        if (company.getNumberOfPeriods() != -1) {
            this.numberOfPeriods = company.getNumberOfPeriods();
        } else {
            Company dataSet = company.getDataSet();
            this.numberOfPeriods = dataSet.getNumberOfPeriods();
        }
        this.proofDepreciationBP = new ProofDepreciationBP(company, this.numberOfPeriods);
        this.creditDepreciationBP = new CreditDepreciationBP(company, this.numberOfPeriods);
        this.numericId = AssetBO.isIdNumeric(company, false);
        this.theAccountingPrinciple = Integer.parseInt(this.extractFromSelections("AccountingPrinciple"));
        this.accountingPrinciple = Integer.parseInt(this.extractFromSelections("AccountingPrinciple"));
        this.bookYearFrom = Integer.parseInt(this.extractFromSelections("BookYearFrom"));
        this.numberOfYears = Integer.parseInt(this.extractFromSelections("NumberOfYears"));
        this.periodType = this.extractFromSelections("PeriodType");
        this.interest = interest;
        this.createLabels();
        this.init();
    }

    private void init() throws Exception {
        this.document.setPageSize(new Rectangle(2000.0f, 1200.0f));
        this.cumulator = this.createCumulator();
        this.createTable(true, this.LABELS, this.SIZES, this.RIGHTALIGN, null);
        this.addTableHeaderFirstLine();
        this.addTableHeader(1);
    }

    private void createLabels() throws Exception {
        String depr = LanguageHelper.getString("nl.ibs.fac.language", "Depreciation");
        String intr = LanguageHelper.getString("nl.ibs.fac.language", "Interest");
        String name = null;
        this.variablePeriodNames = new String[this.periodType.equals("B") ? this.numberOfYears : this.numberOfYears * this.numberOfPeriods];
        int vpn = 0;
        ArrayList<String> _labels = new ArrayList<String>();
        _labels.add("Id");
        _labels.add("Description");
        _labels.add("Investment");
        _labels.add("Depreciation");
        _labels.add("BookValue");
        int i = 0;
        while (i < this.numberOfYears) {
            if (this.periodType.equals("B")) {
                name = String.valueOf(this.bookYearFrom + i);
                this.variablePeriodNames[vpn++] = name;
                _labels.add(String.valueOf(depr) + "\n" + name);
                if (this.interest) {
                    _labels.add(String.valueOf(intr) + "\n" + name);
                }
            } else {
                int p = 1;
                while (p <= this.numberOfPeriods) {
                    name = PeriodHelper.toString(this.bookYearFrom + i, p);
                    this.variablePeriodNames[vpn++] = name;
                    _labels.add(String.valueOf(depr) + "\n" + name);
                    if (this.interest) {
                        _labels.add(String.valueOf(intr) + "\n" + name);
                    }
                    ++p;
                }
            }
            ++i;
        }
        _labels.add("Investment");
        _labels.add("Depreciation");
        _labels.add("BookValue");
        this.numberOfColumns = _labels.size();
        this.LABELS[0] = new String[this.numberOfColumns];
        i = 0;
        while (i < this.numberOfColumns) {
            this.LABELS[0][i] = (String)_labels.get(i);
            ++i;
        }
        int[] _sizes = new int[this.numberOfColumns];
        int i2 = 0;
        while (i2 < _sizes.length) {
            _sizes[i2] = i2 == 0 ? 400 : (i2 == 1 ? 1000 : 500);
            ++i2;
        }
        this.SIZES = _sizes;
        boolean[] _aligns = new boolean[this.numberOfColumns];
        int i3 = 0;
        while (i3 < _aligns.length) {
            _aligns[i3] = i3 >= 2;
            ++i3;
        }
        this.RIGHTALIGN = _aligns;
        this.value = new String[this.numberOfColumns];
        this.bold = new boolean[this.numberOfColumns];
        this.translate = new boolean[this.numberOfColumns];
    }

    private void addTableHeaderFirstLine() throws Exception {
        this.resetCellBorders();
        int c = 0;
        this.setCell(c++, "", false, false);
        this.setCell(c++, "", false, false);
        this.setCellBorder(c, 5);
        this.setCell(c++, "", false, false);
        this.setCellBorder(c, 1);
        this.setCell(c++, LanguageHelper.getString("nl.ibs.fac.language", "BalanceBegin"), false, false);
        this.setCellBorder(c, 9);
        this.setCell(c++, "", false, false);
        if (this.interest) {
            int i = 0;
            while (i < this.variablePeriodNames.length * 2) {
                this.setCellBorder(c, 1);
                this.setCell(c++, "", false, false);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.variablePeriodNames.length) {
                this.setCell(c++, "", false, false);
                ++i;
            }
        }
        this.setCellBorder(c, 5);
        this.setCell(c++, "", false, false);
        this.setCellBorder(c, 1);
        this.setCell(c++, LanguageHelper.getString("nl.ibs.fac.language", "BalanceEnd"), false, false);
        this.setCellBorder(c, 9);
        this.setCell(c++, "", false, false);
        this.addTableRow();
        this.resetCellBorders();
        this.setCellBorder(2, 4);
        this.setCellBorder(5, 4);
        if (this.interest) {
            this.setCellBorder(5 + this.variablePeriodNames.length * 2, 4);
        } else {
            this.setCellBorder(5 + this.variablePeriodNames.length, 4);
        }
    }

    @Override
    protected void processObject(Object object) throws Exception {
        if (object instanceof Credit) {
            this.theCredit = (Credit)object;
            if (this.theAccountingPrinciple == 9) {
                this.accountingPrinciple = 3;
            }
            this.printCredit();
            return;
        }
        this.asset = (Asset)object;
        if (this.theAccountingPrinciple == 9) {
            this.accountingPrinciple = 1;
        }
        this.asset = (Asset)object;
        this.printSubTotals();
        this.amounts = new HashMap();
        this.printedLines = 0;
        this.amounts = ProofDepreciationReportHelper.addAmountsFromTransactions(this.amounts, this.asset, this.accountingPrinciple, this.bookYearFrom, this.numberOfYears, this.periodType);
        this.amounts = ProofDepreciationReportHelper.addAmountsFromProofDepreciation(this.amounts, this.proofDepreciationBP, this.asset, this.accountingPrinciple, this.bookYearFrom, this.numberOfYears, this.numberOfPeriods, this.periodType);
        this.printAsset(this.amounts);
    }

    private void printCredit() throws Exception {
        if (!this.selection.getIncludeDisinvested() && this.theCredit.getState() < 2) {
            return;
        }
        if (this.theCredit.getClosingYear() > 0 && this.theCredit.getClosingYear() < this.bookYearFrom) {
            return;
        }
        String[] attr = this.getCreditPrintAttributes();
        int i = 0;
        while (i < attr.length) {
            this.setCell(i, attr[i], false, false);
            ++i;
        }
        this.addTableRow();
    }

    private String[] getCreditPrintAttributes() throws Exception {
        String[] attr = new String[this.numberOfColumns];
        int v = 0;
        attr[v++] = this.theCredit.getId();
        attr[v++] = this.theCredit.getDescription();
        this.creditAmounts = CreditProofDepreciationReportHelper.retrieveAmounts(this.creditDepreciationBP, this.theCredit, this.bookYearFrom, this.numberOfYears);
        attr[v++] = IBSDecimal.format(this.creditAmounts[0], true);
        attr[v++] = IBSDecimal.format(this.creditAmounts[1], true);
        attr[v++] = IBSDecimal.format(this.creditAmounts[0].subtract(this.creditAmounts[1]), true);
        int i = 0;
        while (i < this.variablePeriodNames.length) {
            attr[v++] = IBSDecimal.format(this.creditAmounts[i * 2 + 2], true);
            if (this.interest) {
                attr[v++] = IBSDecimal.format(this.creditAmounts[i * 2 + 3], true);
            }
            ++i;
        }
        if (this.interest) {
            attr[v++] = IBSDecimal.format(this.creditAmounts[this.variablePeriodNames.length * 2 + 2], true);
            attr[v++] = IBSDecimal.format(this.creditAmounts[this.variablePeriodNames.length * 2 + 3], true);
            attr[v++] = IBSDecimal.format(this.creditAmounts[this.variablePeriodNames.length * 2 + 2].subtract(this.creditAmounts[this.variablePeriodNames.length * 2 + 3]), true);
        } else {
            attr[v++] = IBSDecimal.format(this.creditAmounts[this.variablePeriodNames.length + 2], true);
            attr[v++] = IBSDecimal.format(this.creditAmounts[this.variablePeriodNames.length + 3], true);
            attr[v++] = IBSDecimal.format(this.creditAmounts[this.variablePeriodNames.length + 2].subtract(this.creditAmounts[this.variablePeriodNames.length * 2 + 3]), true);
        }
        return attr;
    }

    private void printAsset(HashMap amounts) throws Exception {
        if (this.asset.getDisinvestmentYear() > 0 && this.asset.getDisinvestmentYear() < this.bookYearFrom) {
            return;
        }
        String[] attr = this.getPrintAttributes(amounts);
        int i = 0;
        while (i < attr.length) {
            this.setCell(i, attr[i], false, false);
            ++i;
        }
        this.addTableRow();
        this.cumulate(this.asset);
    }

    private String[] getPrintAttributes(HashMap amounts) throws Exception {
        BigDecimal invBegin = ProofDepreciationReportHelper.getAmount(amounts, this.asset, "INV", this.bookYearFrom - 1, 0, this.bookYearFrom, this.periodType);
        BigDecimal depBegin = ProofDepreciationReportHelper.getAmount(amounts, this.asset, "DEP", this.bookYearFrom - 1, 0, this.bookYearFrom, this.periodType);
        depBegin = depBegin.add(ProofDepreciationReportHelper.getAmount(amounts, this.asset, "DEB", this.bookYearFrom - 1, 0, this.bookYearFrom, this.periodType));
        BigDecimal invCurr = null;
        BigDecimal depCurr = null;
        BigDecimal debCurr = null;
        BigDecimal intCurr = null;
        BigDecimal invEnd = invBegin;
        BigDecimal depEnd = depBegin;
        int v = 0;
        int year = 0;
        int period = 0;
        String[] attr = new String[this.numberOfColumns];
        attr[v++] = ProofDepreciationToPDF.formatAssetId(this.asset, this.numericId);
        attr[v++] = this.asset.getDescription();
        attr[v++] = IBSDecimal.format(invBegin, true);
        attr[v++] = IBSDecimal.format(depBegin, true);
        attr[v++] = IBSDecimal.format(invBegin.subtract(depBegin), true);
        int i = 0;
        while (i < this.variablePeriodNames.length) {
            if (this.periodType.equals("B")) {
                year = Integer.parseInt(this.variablePeriodNames[i]);
                period = 0;
            } else {
                year = Integer.parseInt(this.variablePeriodNames[i].substring(0, 4));
                period = Integer.parseInt(this.variablePeriodNames[i].substring(5));
            }
            invCurr = ProofDepreciationReportHelper.getAmount(amounts, this.asset, "INV", year, period, this.bookYearFrom, this.periodType);
            depCurr = ProofDepreciationReportHelper.getAmount(amounts, this.asset, "DEP", year, period, this.bookYearFrom, this.periodType);
            debCurr = ProofDepreciationReportHelper.getAmount(amounts, this.asset, "DEB", year, period, this.bookYearFrom, this.periodType);
            intCurr = ProofDepreciationReportHelper.getAmount(amounts, this.asset, "INT", year, period, this.bookYearFrom, this.periodType);
            invEnd = invEnd.add(invCurr);
            depEnd = depEnd.add(depCurr);
            depEnd = depEnd.add(debCurr);
            attr[v++] = IBSDecimal.format(depCurr, true);
            if (this.interest) {
                attr[v++] = IBSDecimal.format(intCurr, true);
            }
            ++i;
        }
        attr[v++] = IBSDecimal.format(invEnd, true);
        attr[v++] = IBSDecimal.format(depEnd, true);
        attr[v++] = IBSDecimal.format(invEnd.subtract(depEnd), true);
        return attr;
    }

    protected void printSubTotals() throws Exception {
        int o = this.orderByField.length;
        int[] orderBy = new int[o];
        int i = 0;
        while (i < this.orderByField.length) {
            orderBy[i] = this.orderByField[--o];
            ++i;
        }
        o = 0;
        while (o < orderBy.length) {
            int lvl = orderBy[o];
            if (lvl > 0 && this.cumulator.getSwitchCumulationLevel(lvl) && (this.cumulator.levelBreak(this.asset, lvl) || this.endOfFile) && (lvl != 8 || this.printedLines > 1)) {
                this.addSubTotalRow(lvl);
            }
            ++o;
        }
        if (this.endOfFile && this.selection.getGrandTotal()) {
            this.addSubTotalRow(0);
        }
    }

    @Override
    protected void addTotalGenRow() throws Exception {
        this.printSubTotals();
    }

    protected void addSubTotalRow(int level) throws Exception {
        String id = (String)this.numericIdTransformer.transform(this.cumulator.getLevelValue(level)[0]);
        String descr = this.cumulator.getLevelValue(level)[1];
        if (level >= 1 && level <= 6) {
            descr = this.getFinDimDescription(id, level - 1);
        }
        BigDecimal[] total = this.getTotalsForLevel(level);
        if (level == 0) {
            this.setCell(0, this.totalGenText, false, true);
            this.setCell(1, "", false, true);
        } else {
            this.setCell(0, this.totalText, false, true);
            this.setCell(1, String.valueOf(this.cumulator.getLevelName(level, this.env)) + " " + id + " (" + descr + ")", false, true);
        }
        int i = 2;
        while (i < this.numberOfColumns) {
            this.setCell(i, IBSDecimal.format(total[i], true), false, true);
            ++i;
        }
        this.addTableRow();
        this.addEmptyTableRow();
    }

    @Override
    protected int[] getColumnsToCumulate() throws Exception {
        int[] result = this.interest ? new int[(this.variablePeriodNames == null ? 6 : this.variablePeriodNames.length * 2) + 6] : new int[(this.variablePeriodNames == null ? 6 : this.variablePeriodNames.length) + 6];
        int nr = 2;
        int i = 0;
        while (i < result.length) {
            result[i] = nr++;
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            ProofDepreciationToPDF.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        String bookYear;
        String companyId;
        String[][] selections;
        Map map;
        LoginHelper loginHelper;
        String message;
        if (Log.debug() && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                Log.debug((String)args[i]);
                ++i;
            }
        }
        if ((message = (loginHelper = BatchJobHelper.getLoginHelper(map = BatchJobHelper.getSelections(selections = BatchJobHelper.getSelections(args)))).login()) != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        boolean governmentActivated = Boolean.valueOf((String)map.get("governmentActivated"));
        String assetSelectionAsString = (String)map.get(AssetSelection.ASSETSELECTION);
        String assetSelectionAsString2 = (String)map.get(String.valueOf(AssetSelection.ASSETSELECTION) + "2");
        AssetSelection assetSelection = new AssetSelection(String.valueOf(assetSelectionAsString) + assetSelectionAsString2);
        assetSelection.governmentActivated = governmentActivated;
        assetSelection.ap = Integer.parseInt((String)map.get("AccountingPrinciple"));
        Environment environment = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        message = loginHelper.login(environment, companyId = (String)map.get("Company"), bookYear = (String)map.get("BookYear"));
        if (message != null && message.trim().length() > 0) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        FMSHelper fmsHelper = null;
        FISHelper fisHelper = null;
        if (environment.getOperationArea().trim().length() > 0) {
            fmsHelper = new FMSHelper(loginHelper);
        } else {
            fisHelper = new FISHelper(loginHelper);
        }
        DBData dbData = BOAdapter.getDBData(map);
        int accountingPrinciple = Integer.parseInt((String)map.get("AccountingPrinciple"));
        CompanyAccountingPrincipleDefault capd = (CompanyAccountingPrincipleDefault)CompanyAccountingPrincipleDefaultBO.get(dbData, companyId, accountingPrinciple)[0];
        boolean interest = capd == null ? true : capd.getCalculateInterest();
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        ProofDepreciationToPDF proofDepreciationToPDF = new ProofDepreciationToPDF("ProofDepreciationReport", selections, assetSelection, environment, company, bookYear, governmentActivated, fmsHelper, fisHelper, interest);
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, "ProofDepreciationReport", "pdf"));
        fos.write(proofDepreciationToPDF.createPdf().toByteArray());
        fos.close();
        loginHelper.logout(environment, companyId, bookYear);
        loginHelper.logout();
    }
}

