/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.TransactionTypeEnum;
import nl.ibs.fac.db.Transaction;

public class ReconciliationReportBean {
    public static final String PAGE = ReconciliationReportBean.class.getName();
    private Collection transactions = null;
    private Collection transactionsToRemove = null;
    private Transaction transaction = null;
    private Iterator transIter = null;
    private static final BigDecimal ZERO = new BigDecimal(0.0);
    private BigDecimal investment;
    private BigDecimal disinvestment;
    private BigDecimal depreciation;
    private BigDecimal disDepr;
    private BigDecimal yield;
    private BigDecimal result;
    private BigDecimal interest;
    private int bookYearFrom;
    private int periodFrom;

    public ReconciliationReportBean(Collection transactions, int bookYearFrom, int periodFrom) throws Exception {
        this.transactions = transactions;
        this.bookYearFrom = bookYearFrom;
        this.periodFrom = periodFrom;
        this.init();
    }

    private void init() throws Exception {
        this.resetAmounts();
        this.transactionsToRemove = new ArrayList();
        this.transIter = this.transactions.iterator();
        while (this.transIter.hasNext()) {
            this.transaction = (Transaction)this.transIter.next();
            if (PeriodHelper.isBefore(this.transaction.getBookYearForJournalization(), this.transaction.getPeriodForJournalization(), this.bookYearFrom, this.periodFrom) || this.transaction.getTransactionType() == 20) {
                this.add(this.transaction);
                this.transactionsToRemove.add(this.transaction);
                continue;
            }
            this.transactions.removeAll(this.transactionsToRemove);
            this.transIter = this.transactions.iterator();
            return;
        }
    }

    private void resetAmounts() throws Exception {
        this.investment = ZERO;
        this.disinvestment = ZERO;
        this.depreciation = ZERO;
        this.disDepr = ZERO;
        this.yield = ZERO;
        this.result = ZERO;
        this.interest = ZERO;
    }

    private void add(Transaction _transaction) throws Exception {
        switch (_transaction.getMainTransactionType()) {
            case 1: {
                this.investment = this.investment.add(this.transaction.getAmount1());
                this.depreciation = this.depreciation.add(this.transaction.getAmount2());
                break;
            }
            case 2: {
                this.disinvestment = this.disinvestment.add(this.transaction.getAmount1());
                this.disDepr = this.disDepr.add(this.transaction.getAmount2());
                this.yield = this.yield.add(this.transaction.getAmount3());
                if (this.transaction.getTransactionType() != 50) {
                    this.result = this.disinvestment.subtract(this.disDepr).add(this.yield).negate();
                    break;
                }
                this.result = ZERO;
                break;
            }
            case 3: {
                this.depreciation = this.depreciation.add(this.transaction.getAmount2());
                this.interest = this.interest.add(this.transaction.getAmount3());
            }
        }
    }

    public boolean next() throws Exception {
        if (this.transIter.hasNext()) {
            this.resetAmounts();
            this.transaction = (Transaction)this.transIter.next();
            this.add(this.transaction);
            return true;
        }
        this.transaction = null;
        return false;
    }

    public String getTransactionTypeDescr() throws Exception {
        return TransactionTypeEnum.getValue(this.transaction.getTransactionType());
    }

    public String getDescription() throws Exception {
        return this.transaction.getDescription();
    }

    public String getProFormaTypeId() throws Exception {
        return this.transaction.getProFormaTypeId();
    }

    public String getFinPeriod() throws Exception {
        return String.valueOf(this.transaction.getBookYearForJournalization()) + "-" + this.transaction.getPeriodForJournalization();
    }

    public String getFacPeriod() throws Exception {
        return String.valueOf(this.transaction.getBookYear()) + "-" + this.transaction.getPeriod();
    }

    public String getFinDimId1() throws Exception {
        return this.transaction.getFinDimId1();
    }

    public String getFinDimId2() throws Exception {
        return this.transaction.getFinDimId2();
    }

    public BigDecimal getInvestment() throws Exception {
        return this.investment;
    }

    public BigDecimal getDisInvestment() throws Exception {
        return this.disinvestment;
    }

    public BigDecimal getDepreciation() throws Exception {
        return this.depreciation;
    }

    public BigDecimal getDisDepr() throws Exception {
        return this.disDepr;
    }

    public BigDecimal getYieldValue() throws Exception {
        return this.yield;
    }

    public BigDecimal getResult() throws Exception {
        return this.result;
    }

    public BigDecimal getInterest() throws Exception {
        return this.interest;
    }

    public BigDecimal getBookValue() throws Exception {
        return this.investment.subtract(this.depreciation).add(this.disinvestment).subtract(this.disDepr);
    }
}

