/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import java.io.FileOutputStream;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyAccountingPrincipleDefaultBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.FinancialDimensionHistoryBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.CompanyAccountingPrincipleDefault;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.FinancialDimensionHistory;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.CSVHelper;
import nl.ibs.fac.reports.ReconciliationReportBean;
import nl.ibs.fac.ui.AssetSelection;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.Stopwatch;

public class ReconciliationToCSV
extends CSVHelper {
    public static final String CLASSNAME = ReconciliationToCSV.class.getName();
    private static final String FILENAME = "ReconciliationReport";
    private int accountingPrinciple;
    private int bookYearFrom;
    private int periodFrom;
    private int bookYearTo;
    private int periodTo;
    private int numberOfColumns;
    private boolean doLoop;
    private boolean credit;
    private boolean first;
    private Asset asset;
    private ReconciliationReportBean bean;
    private String balanceBegin = LanguageHelper.getString("nl.ibs.fac.language", "BalanceBegin");
    private AssetSelection assetSelection;
    private boolean interest;

    public ReconciliationToCSV(String[][] selections, AssetSelection assetSelection, String[][] labels, FMSHelper fmsHelper, FISHelper fisHelper, boolean interest) throws Exception {
        super(selections, assetSelection.getCollection(), labels, fmsHelper, fisHelper);
        this.accountingPrinciple = Integer.parseInt(this.extractFromSelections("AccountingPrinciple", selections));
        this.bookYearFrom = Integer.parseInt(this.extractFromSelections("BookYearFrom", selections));
        this.periodFrom = Integer.parseInt(this.extractFromSelections("PeriodFrom", selections));
        this.bookYearTo = Integer.parseInt(this.extractFromSelections("BookYearTo", selections));
        this.periodTo = Integer.parseInt(this.extractFromSelections("PeriodTo", selections));
        this.numberOfColumns = labels[0].length;
        this.assetSelection = assetSelection;
        this.interest = interest;
    }

    @Override
    protected String[] getRowValues(Object object) throws Exception {
        this.asset = (Asset)object;
        this.printAsset();
        return new String[]{""};
    }

    private void printAsset() throws Exception {
        if (!this.assetSelection.getIncludeDisinvested() && this.asset.getDisinvestmentYear() > 0 && PeriodHelper.isBefore(this.asset.getDisinvestmentYear(), this.asset.getDisinvestmentPeriod(), this.bookYearFrom, this.periodFrom)) {
            return;
        }
        this.bean = this.createBean();
        this.doLoop = true;
        this.first = true;
        while (this.doLoop) {
            this.addRow(this.getPrintAttributes(this.first));
            this.first = false;
            this.doLoop = this.bean.next();
        }
    }

    private String[] getPrintAttributes(boolean first) throws Exception {
        int v = 0;
        String[] attr = new String[this.numberOfColumns];
        if (first) {
            attr[v++] = this.balanceBegin;
            attr[v++] = this.asset.getParentId() == null ? this.asset.getId() : this.asset.getParentId();
            attr[v++] = this.asset.getParentId() == null ? "" : this.asset.getId();
            attr[v++] = this.asset.getDescription();
            attr[v++] = this.asset.getTypeId();
            String[] dimensions = this.retrieveFinancialDimensions(this.bookYearFrom, this.periodFrom);
            attr[v++] = dimensions[0];
            attr[v++] = dimensions[1];
            attr[v++] = "";
            attr[v++] = "";
            attr[v++] = "";
        } else {
            attr[v++] = "";
            attr[v++] = this.asset.getParentId() == null ? this.asset.getId() : this.asset.getParentId();
            attr[v++] = this.asset.getParentId() == null ? "" : this.asset.getId();
            attr[v++] = this.bean.getDescription();
            attr[v++] = this.bean.getProFormaTypeId();
            attr[v++] = this.bean.getFinDimId1();
            attr[v++] = this.bean.getFinDimId2();
            attr[v++] = this.bean.getTransactionTypeDescr();
            attr[v++] = this.bean.getFinPeriod();
            attr[v++] = this.bean.getFacPeriod();
        }
        attr[v++] = IBSDecimal.format(this.bean.getInvestment());
        attr[v++] = IBSDecimal.format(this.bean.getDepreciation());
        attr[v++] = IBSDecimal.format(this.bean.getDisInvestment());
        attr[v++] = IBSDecimal.format(this.bean.getDisDepr());
        attr[v++] = IBSDecimal.format(this.bean.getYieldValue());
        attr[v++] = IBSDecimal.format(this.bean.getResult());
        if (this.interest) {
            attr[v++] = IBSDecimal.format(this.bean.getInterest());
        }
        attr[v++] = IBSDecimal.format(this.bean.getBookValue());
        return attr;
    }

    private String[] retrieveFinancialDimensions(int year, int period) throws Exception {
        FinancialDimensionHistory fdh;
        String[] dimensions = new String[]{"", ""};
        if (PeriodHelper.isAfterOrEquals(this.asset.getFinDimYearFrom(), this.asset.getFinDimPeriodFrom(), year, period) && (fdh = FinancialDimensionHistoryBO.getLast(this.asset, year, period - 1)) != null) {
            dimensions[0] = fdh.getFinDimId1();
            dimensions[1] = fdh.getFinDimId2();
            return dimensions;
        }
        dimensions[0] = this.asset.getFinDimId1();
        dimensions[1] = this.asset.getFinDimId2();
        return dimensions;
    }

    private ReconciliationReportBean createBean() throws Exception {
        ReconciliationReportBean bean = null;
        Valuation valuation = (Valuation)ValuationBO.getValuation(this.asset.getDBData(), this.asset.getCompanyId(), this.asset.getCora(), this.asset.getId(), this.accountingPrinciple)[0];
        if (valuation != null || this.asset.getParentAsset() && !this.asset.getSubAsset()) {
            bean = new ReconciliationReportBean(TransactionBO.getBeforeOrEquals(this.asset, this.bookYearTo, this.periodTo, this.accountingPrinciple, true, true), this.bookYearFrom, this.periodFrom);
        }
        return bean;
    }

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            ReconciliationToCSV.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        String bookYear;
        String companyId;
        String[][] selections;
        Map map;
        LoginHelper loginHelper;
        String message;
        if (Log.debug() && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                Log.debug((String)args[i]);
                ++i;
            }
        }
        if ((message = (loginHelper = BatchJobHelper.getLoginHelper(map = BatchJobHelper.getSelections(selections = BatchJobHelper.getSelections(args)))).login()) != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        Environment environment = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        message = loginHelper.login(environment, companyId = (String)map.get("Company"), bookYear = (String)map.get("BookYear"));
        if (message != null && message.trim().length() > 0) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        FMSHelper fmsHelper = null;
        FISHelper fisHelper = null;
        if (environment.getOperationArea().trim().length() > 0) {
            fmsHelper = new FMSHelper(loginHelper);
        } else {
            fisHelper = new FISHelper(loginHelper);
        }
        DBData dbData = BOAdapter.getDBData(map);
        int accountingPrinciple = Integer.parseInt((String)map.get("AccountingPrinciple"));
        CompanyAccountingPrincipleDefault capd = (CompanyAccountingPrincipleDefault)CompanyAccountingPrincipleDefaultBO.get(dbData, companyId, accountingPrinciple)[0];
        boolean interest = capd == null ? true : capd.getCalculateInterest();
        String[][] LABELS = new String[][]{{"", "Asset", "SubId", "Description", "Type", environment.getName1(), environment.getName2(), "MainTransactionType", "PeriodJRN", "PeriodFAC", "Investment", "Depreciation", "DisInvestment", "DisDepr", "YieldValue", "ResultValue", "Interest", "BookValue"}};
        String[][] LABELSNOINTEREST = new String[][]{{"", "Asset", "SubId", "Description", "Type", environment.getName1(), environment.getName2(), "MainTransactionType", "PeriodJRN", "PeriodFAC", "Investment", "Depreciation", "DisInvestment", "DisDepr", "YieldValue", "ResultValue", "BookValue"}};
        String assetSelectionAsString = (String)map.get(AssetSelection.ASSETSELECTION);
        String assetSelectionAsString2 = (String)map.get(String.valueOf(AssetSelection.ASSETSELECTION) + "2");
        AssetSelection assetSelection = new AssetSelection(String.valueOf(assetSelectionAsString) + assetSelectionAsString2);
        ReconciliationToCSV reconciliationToCSV = interest ? new ReconciliationToCSV(selections, assetSelection, LABELS, fmsHelper, fisHelper, interest) : new ReconciliationToCSV(selections, assetSelection, LABELSNOINTEREST, fmsHelper, fisHelper, interest);
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, FILENAME, "csv"));
        fos.write(reconciliationToCSV.createCsv());
        fos.close();
        loginHelper.logout(environment, companyId, bookYear);
        loginHelper.logout();
    }
}

