/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import com.itextpdf.text.Rectangle;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyAccountingPrincipleDefaultBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.CompanyAccountingPrincipleDefault;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.PdfHelper;
import nl.ibs.fac.reports.ReconciliationReportBean;
import nl.ibs.fac.ui.AssetSelection;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.Stopwatch;

public class ReconciliationToPDF
extends PdfHelper {
    public static final String CLASSNAME = ReconciliationToPDF.class.getName();
    private static final String FILENAME = "ReconciliationReport";
    private static final String REPORTTITLE = "ReconciliationReport";
    private static final String[][] LABELS = new String[][]{{"", "", "", "", "", "", "", "", "Investment", "Depreciation", "DisInvestment", "DisDepr", "YieldValue", "ResultValue", "Interest", "BookValue"}};
    private static final String[][] LABELSNOINTEREST = new String[][]{{"", "", "", "", "", "", "", "", "Investment", "Depreciation", "DisInvestment", "DisDepr", "YieldValue", "ResultValue", "BookValue"}};
    private static final int[] SIZES = new int[]{400, 1000, 500, 500, 500, 1000, 300, 300, 500, 500, 500, 500, 500, 500, 500, 500};
    private static final int[] SIZESNOINTEREST = new int[]{400, 1000, 500, 500, 500, 1000, 300, 300, 500, 500, 500, 500, 500, 500, 500};
    private static final boolean[] TRANSLATE;
    private static final boolean[] TRANSLATENOINTEREST;
    private static final boolean[] RIGHTALIGN;
    private static final boolean[] RIGHTALIGNNOINTEREST;
    private static final NumericIdTransformer NUMERICIDTRANSFORMER;
    private int accountingPrinciple = 0;
    private int bookYearFrom = 0;
    private int periodFrom = 0;
    private int bookYearTo = 0;
    private int periodTo = 0;
    private int numberOfColumns = 0;
    private int[] orderByField = null;
    private boolean numericId;
    private boolean justTotals;
    private boolean credit = false;
    private Environment env = null;
    private ReconciliationReportBean bean = null;
    private Asset asset = null;
    private AssetSelection selection;
    private boolean interest;

    static {
        boolean[] blArray = new boolean[16];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[11] = true;
        blArray[12] = true;
        blArray[13] = true;
        blArray[14] = true;
        blArray[15] = true;
        TRANSLATE = blArray;
        boolean[] blArray2 = new boolean[15];
        blArray2[0] = true;
        blArray2[1] = true;
        blArray2[2] = true;
        blArray2[5] = true;
        blArray2[6] = true;
        blArray2[7] = true;
        blArray2[8] = true;
        blArray2[9] = true;
        blArray2[10] = true;
        blArray2[11] = true;
        blArray2[12] = true;
        blArray2[13] = true;
        blArray2[14] = true;
        TRANSLATENOINTEREST = blArray2;
        boolean[] blArray3 = new boolean[16];
        blArray3[8] = true;
        blArray3[9] = true;
        blArray3[10] = true;
        blArray3[11] = true;
        blArray3[12] = true;
        blArray3[13] = true;
        blArray3[14] = true;
        blArray3[15] = true;
        RIGHTALIGN = blArray3;
        boolean[] blArray4 = new boolean[15];
        blArray4[8] = true;
        blArray4[9] = true;
        blArray4[10] = true;
        blArray4[11] = true;
        blArray4[12] = true;
        blArray4[13] = true;
        blArray4[14] = true;
        RIGHTALIGNNOINTEREST = blArray4;
        NUMERICIDTRANSFORMER = new NumericIdTransformer();
    }

    public ReconciliationToPDF(String reportTitle, String[][] selections, AssetSelection assetSelection, boolean governmentActivated, Environment environment, FMSHelper fmsHelper, FISHelper fisHelper, String companyId, String bookYear, boolean numericId, boolean justTotals, boolean interest) throws Exception {
        super(reportTitle, selections, assetSelection.getCollection(), fmsHelper, fisHelper, companyId, bookYear);
        this.selection = assetSelection;
        this.orderByField = assetSelection.getOrderBy();
        this.accountingPrinciple = Integer.parseInt(this.extractFromSelections("AccountingPrinciple"));
        this.bookYearFrom = Integer.parseInt(this.extractFromSelections("BookYearFrom"));
        this.periodFrom = Integer.parseInt(this.extractFromSelections("PeriodFrom"));
        this.bookYearTo = Integer.parseInt(this.extractFromSelections("BookYearTo"));
        this.periodTo = Integer.parseInt(this.extractFromSelections("PeriodTo"));
        this.env = environment;
        this.numericId = numericId;
        this.numberOfColumns = interest ? LABELS[0].length : LABELSNOINTEREST[0].length;
        this.value = new String[this.numberOfColumns];
        this.bold = new boolean[this.numberOfColumns];
        this.translate = TRANSLATE;
        this.justTotals = justTotals;
        this.interest = interest;
        this.init();
    }

    private void init() throws Exception {
        this.document.setPageSize(new Rectangle(2000.0f, 1200.0f));
        ReconciliationToPDF.LABELS[0][0] = this.justTotals ? "" : this.cumulator.getLevelName(8, this.env);
        ReconciliationToPDF.LABELS[0][1] = "Description";
        ReconciliationToPDF.LABELS[0][2] = this.justTotals ? "" : "Type";
        ReconciliationToPDF.LABELS[0][3] = this.justTotals ? "" : this.env.getName1();
        ReconciliationToPDF.LABELS[0][4] = this.justTotals ? "" : this.env.getName2();
        ReconciliationToPDF.LABELS[0][5] = this.justTotals ? "" : "MainTransactionType";
        ReconciliationToPDF.LABELS[0][6] = this.justTotals ? "" : "PeriodJRN";
        ReconciliationToPDF.LABELS[0][7] = this.justTotals ? "" : "PeriodFAC";
        ReconciliationToPDF.LABELSNOINTEREST[0][0] = this.justTotals ? "" : this.cumulator.getLevelName(8, this.env);
        ReconciliationToPDF.LABELSNOINTEREST[0][1] = "Description";
        ReconciliationToPDF.LABELSNOINTEREST[0][2] = this.justTotals ? "" : "Type";
        ReconciliationToPDF.LABELSNOINTEREST[0][3] = this.justTotals ? "" : this.env.getName1();
        ReconciliationToPDF.LABELSNOINTEREST[0][4] = this.justTotals ? "" : this.env.getName2();
        ReconciliationToPDF.LABELSNOINTEREST[0][5] = this.justTotals ? "" : "MainTransactionType";
        ReconciliationToPDF.LABELSNOINTEREST[0][6] = this.justTotals ? "" : "PeriodJRN";
        String string = ReconciliationToPDF.LABELSNOINTEREST[0][7] = this.justTotals ? "" : "PeriodFAC";
        if (this.interest) {
            this.createTable(true, LABELS, SIZES, RIGHTALIGN, TRANSLATE);
        } else {
            this.createTable(true, LABELSNOINTEREST, SIZESNOINTEREST, RIGHTALIGNNOINTEREST, TRANSLATENOINTEREST);
        }
        this.addTableHeader();
    }

    @Override
    protected void processObject(Object object) throws Exception {
        this.asset = (Asset)object;
        this.printSubTotals();
        this.bean = this.createBean();
        if (this.bean != null) {
            this.printBean(true);
            while (this.bean.next()) {
                this.printBean(false);
            }
        }
    }

    private ReconciliationReportBean createBean() throws Exception {
        ReconciliationReportBean bean = null;
        if (!this.selection.getIncludeDisinvested() && this.asset.getDisinvestmentYear() > 0 && PeriodHelper.isBefore(this.asset.getDisinvestmentYear(), this.asset.getDisinvestmentPeriod(), this.bookYearFrom, this.periodFrom)) {
            return bean;
        }
        Valuation valuation = (Valuation)ValuationBO.getValuation(this.asset.getDBData(), this.asset.getCompanyId(), this.asset.getCora(), this.asset.getId(), this.accountingPrinciple)[0];
        if (valuation != null || this.asset.getParentAsset() && !this.asset.getSubAsset()) {
            bean = new ReconciliationReportBean(TransactionBO.getBeforeOrEquals(this.asset, this.bookYearTo, this.periodTo, this.accountingPrinciple, true, true), this.bookYearFrom, this.periodFrom);
        }
        return bean;
    }

    private void printBean(boolean first) throws Exception {
        int v = 0;
        if (first) {
            this.setCell(v++, ReconciliationToPDF.formatAssetId(this.asset, this.numericId), false, false);
            this.setCell(v++, this.asset.getDescription(), false, false);
            this.setCell(v++, (String)NUMERICIDTRANSFORMER.transform(this.asset.getTypeId()), false, false);
            this.setCell(v++, (String)NUMERICIDTRANSFORMER.transform(this.asset.getFinDimId1()), false, false);
            this.setCell(v++, (String)NUMERICIDTRANSFORMER.transform(this.asset.getFinDimId2()), false, false);
            this.setCell(v++, LanguageHelper.getString("nl.ibs.fac.language", "InitialValue"), false, false);
            this.setCell(v++, "", false, false);
            this.setCell(v++, "", false, false);
        } else {
            this.setCell(v++, "", false, false);
            this.setCell(v++, "", false, false);
            this.setCell(v++, "", false, false);
            this.setCell(v++, "", false, false);
            this.setCell(v++, "", false, false);
            this.setCell(v++, this.bean.getTransactionTypeDescr(), false, false);
            this.setCell(v++, this.bean.getFinPeriod(), false, false);
            this.setCell(v++, this.bean.getFacPeriod(), false, false);
        }
        this.setCell(v++, IBSDecimal.format(this.bean.getInvestment(), true), false, false);
        this.setCell(v++, IBSDecimal.format(this.bean.getDepreciation(), true), false, false);
        this.setCell(v++, IBSDecimal.format(this.bean.getDisInvestment(), true), false, false);
        this.setCell(v++, IBSDecimal.format(this.bean.getDisDepr(), true), false, false);
        this.setCell(v++, IBSDecimal.format(this.bean.getYieldValue(), true), false, false);
        this.setCell(v++, IBSDecimal.format(this.bean.getResult(), true), false, false);
        if (this.interest) {
            this.setCell(v++, IBSDecimal.format(this.bean.getInterest(), true), false, false);
        }
        this.setCell(v++, first ? IBSDecimal.format(this.bean.getBookValue(), true) : "", false, false);
        this.cumulate(this.asset);
        if (!this.justTotals) {
            this.addTableRow();
        }
    }

    protected void printSubTotals() throws Exception {
        int o = this.orderByField.length;
        int[] orderBy = new int[o];
        int i = 0;
        while (i < this.orderByField.length) {
            orderBy[i] = this.orderByField[--o];
            ++i;
        }
        o = 0;
        while (o < orderBy.length) {
            int lvl = orderBy[o];
            if (lvl > 0 && this.cumulator.getSwitchCumulationLevel(lvl) && (this.cumulator.levelBreak(this.asset, lvl) || this.endOfFile)) {
                this.addSubTotalRow(lvl);
            }
            ++o;
        }
        if (this.endOfFile && this.selection.getGrandTotal()) {
            this.addSubTotalRow(0);
        }
    }

    protected void addSubTotalRow(int level) throws Exception {
        String id = (String)NUMERICIDTRANSFORMER.transform(this.cumulator.getLevelValue(level)[0]);
        String descr = this.cumulator.getLevelValue(level)[1];
        if (level >= 1 && level <= 6) {
            descr = this.getFinDimDescription(id, level - 1);
        }
        BigDecimal[] total = this.getTotalsForLevel(level);
        int v = 0;
        if (level == 0) {
            this.setCell(v++, this.totalGenText, false, !this.justTotals);
            this.setCell(v++, "", false, false);
        } else {
            if (level == 8 && this.justTotals) {
                this.setCell(v++, "", false, false);
            } else {
                this.setCell(v++, this.totalText, false, !this.justTotals);
            }
            this.setCell(v++, String.valueOf(this.cumulator.getLevelName(level, this.env)) + " " + id + " (" + descr + ")", false, !this.justTotals);
        }
        this.setCell(v++, "", false, false);
        this.setCell(v++, "", false, false);
        this.setCell(v++, "", false, false);
        this.setCell(v++, "", false, false);
        this.setCell(v++, "", false, false);
        this.setCell(v++, "", false, false);
        this.setCell(v++, IBSDecimal.format(total[8], true), false, !this.justTotals);
        this.setCell(v++, IBSDecimal.format(total[9], true), false, !this.justTotals);
        this.setCell(v++, IBSDecimal.format(total[10], true), false, !this.justTotals);
        this.setCell(v++, IBSDecimal.format(total[11], true), false, !this.justTotals);
        this.setCell(v++, IBSDecimal.format(total[12], true), false, !this.justTotals);
        this.setCell(v++, IBSDecimal.format(total[13], true), false, !this.justTotals);
        if (this.interest) {
            this.setCell(v++, IBSDecimal.format(total[14], true), false, !this.justTotals);
        }
        this.setCell(v++, IBSDecimal.format(total[8].subtract(total[9]).add(total[10]).subtract(total[11]), true), false, !this.justTotals);
        this.addTableRow();
        if (!this.justTotals) {
            this.addEmptyTableRow();
        }
    }

    private void printSubAssetTotal() throws Exception {
        BigDecimal[] total = this.getTotalsForLevel(-1);
        int v = 0;
        this.setCell(v++, "", false, false);
        this.setCell(v++, "", false, false);
        this.setCell(v++, "", false, false);
        this.setCell(v++, "", false, false);
        this.setCell(v++, "", false, false);
        this.setCell(v++, this.totalText, false, !this.justTotals);
        this.setCell(v++, "", false, false);
        this.setCell(v++, "", false, false);
        this.setCell(v++, IBSDecimal.format(total[8], true), false, !this.justTotals);
        this.setCell(v++, IBSDecimal.format(total[9], true), false, !this.justTotals);
        this.setCell(v++, IBSDecimal.format(total[10], true), false, !this.justTotals);
        this.setCell(v++, IBSDecimal.format(total[11], true), false, !this.justTotals);
        this.setCell(v++, IBSDecimal.format(total[12], true), false, !this.justTotals);
        this.setCell(v++, IBSDecimal.format(total[13], true), false, !this.justTotals);
        if (this.interest) {
            this.setCell(v++, IBSDecimal.format(total[14], true), false, !this.justTotals);
        }
        this.setCell(v++, IBSDecimal.format(total[8].subtract(total[9]).add(total[10]).subtract(total[11]), true), false, !this.justTotals);
        this.addTableRow();
    }

    @Override
    protected void addTotalGenRow() throws Exception {
        this.printSubTotals();
    }

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            ReconciliationToPDF.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        String bookYear;
        String companyId;
        String[][] selections;
        Map map;
        LoginHelper loginHelper;
        String message;
        if (Log.debug() && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                Log.debug((String)args[i]);
                ++i;
            }
        }
        if ((message = (loginHelper = BatchJobHelper.getLoginHelper(map = BatchJobHelper.getSelections(selections = BatchJobHelper.getSelections(args)))).login()) != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        String assetSelectionAsString = (String)map.get(AssetSelection.ASSETSELECTION);
        AssetSelection assetSelection = new AssetSelection(assetSelectionAsString);
        boolean governmentActivated = Boolean.valueOf((String)map.get("governmentActivated"));
        Environment environment = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        message = loginHelper.login(environment, companyId = (String)map.get("Company"), bookYear = (String)map.get("BookYear"));
        if (message != null && message.trim().length() > 0) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        FMSHelper fmsHelper = null;
        FISHelper fisHelper = null;
        if (environment.getOperationArea().trim().length() > 0) {
            fmsHelper = new FMSHelper(loginHelper);
        } else {
            fisHelper = new FISHelper(loginHelper);
        }
        DBData dbData = BOAdapter.getDBData(map);
        int accountingPrinciple = Integer.parseInt((String)map.get("AccountingPrinciple"));
        CompanyAccountingPrincipleDefault capd = (CompanyAccountingPrincipleDefault)CompanyAccountingPrincipleDefaultBO.get(dbData, companyId, accountingPrinciple)[0];
        boolean interest = capd == null ? true : capd.getCalculateInterest();
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        ReconciliationToPDF reconciliationToPDF = new ReconciliationToPDF("ReconciliationReport", selections, assetSelection, governmentActivated, environment, fmsHelper, fisHelper, companyId, bookYear, AssetBO.isIdNumeric(company, false), assetSelection.getJustTotals(), interest);
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, "ReconciliationReport", "pdf"));
        fos.write(reconciliationToPDF.createPdf().toByteArray());
        fos.close();
        loginHelper.logout(environment, companyId, bookYear);
        loginHelper.logout();
    }

    @Override
    protected int[] getColumnsToCumulate() throws Exception {
        if (this.interest) {
            return new int[]{8, 9, 10, 11, 12, 13, 14};
        }
        return new int[]{8, 9, 10, 11, 12, 13};
    }
}

