/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import java.io.FileOutputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import nl.ibs.fac.AssetStateEnum;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.ColumnDefinition;
import nl.ibs.fac.DepreciationMethodEnum;
import nl.ibs.fac.FacConstants;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.StartPeriodHandlingEnum;
import nl.ibs.fac.TransactionTypeEnum;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.gov.GovernmentEnumHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.UserContext;
import nl.ibs.fac.reports.ReportDefinitionHelper;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.UserSetting;
import nl.ibs.jsql.UserSettings;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBConnectionPool;

public class ReportDefinitionToCSV {
    public static final String CLASSNAME = ReportDefinitionToCSV.class.getName();
    private static final String FILENAME = "ReportDefinitionToCSV";
    private static final String FILETYPE = "csv";
    private static final int NBR_COST_COL = 6;
    private String[][] selections;
    private Environment environment;
    private DBData dbData;
    private Company company;
    private int transactionType;
    private int accountingPrinciple;
    private int fromYearForReport = 0;
    private int fromPeriodForReport = 0;
    private int toYearForReport = 0;
    private int toPeriodForReport = 0;
    private Vector columnDefinitions;
    private ColumnDefinition columnDefinition;
    private int numberOfColumns;
    private int yearPeriodFrom;
    private int yearPeriodTo;
    int reportType;
    int usage;
    private ResultSet resultSet;
    private ResultSetMetaData resultSetMetaData;
    private String nonCalcColumns = "";
    private boolean groupBy = true;
    private StringBuffer sb = new StringBuffer();
    private NumberFormat numberformat;
    private String rs;

    public static void main(String[] args) {
        try {
            ReportDefinitionToCSV.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        String[][] selections = BatchJobHelper.getSelections(args);
        String fileName = FILENAME;
        int i = 0;
        while (i < selections.length) {
            if (selections[i][0].equals("reportName")) {
                fileName = selections[i][1];
            }
            ++i;
        }
        ReportDefinitionToCSV reportDefinitionToCSV = new ReportDefinitionToCSV(selections);
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, fileName, FILETYPE));
        fos.write(reportDefinitionToCSV.createCsv());
        fos.close();
    }

    public ReportDefinitionToCSV(String[][] selections) throws Exception {
        this.selections = selections;
        this.environment = (Environment)EnvironmentBO.get(this.extractFromSelections("Environment"))[0];
        this.dbData = BOAdapter.getDBData(this.extractFromSelections("facLib"));
        this.company = (Company)CompanyBO.get(this.dbData, this.extractFromSelections("Company"))[0];
        String tt = this.extractFromSelections("transactionType");
        this.transactionType = tt == null || tt.length() == 0 ? 0 : Integer.parseInt(tt);
        this.accountingPrinciple = Integer.parseInt(this.extractFromSelections("accountingPrinciple"));
        this.fromYearForReport = Integer.parseInt(this.extractFromSelections("yearFrom"));
        this.fromPeriodForReport = Integer.parseInt(this.extractFromSelections("periodFrom"));
        this.toYearForReport = Integer.parseInt(this.extractFromSelections("yearTo"));
        this.toPeriodForReport = Integer.parseInt(this.extractFromSelections("periodTo"));
        this.yearPeriodFrom = this.fromYearForReport * 100 + this.fromPeriodForReport;
        this.yearPeriodTo = this.toYearForReport * 100 + this.toPeriodForReport;
    }

    public byte[] createCsv() throws Exception {
        this.initialize();
        this.handleSelections();
        this.handleTableHeader();
        String stmt = this.retrieveSQLStatement();
        DBConnection con = DBConnectionPool.getInstance("fac").getConnection();
        this.resultSet = con.executeQuery(stmt);
        this.resultSetMetaData = this.resultSet.getMetaData();
        this.numberformat = NumberFormat.getInstance(UserContext.getLocale());
        while (this.resultSet.next()) {
            int i = 0;
            while (i < this.numberOfColumns) {
                String value = this.getValue(i + 1);
                if (value.equals("true") || value.equals("false")) {
                    value = LanguageHelper.getString("nl.ibs.fac.language", value);
                }
                this.sb.append(value);
                this.sb.append(';');
                ++i;
            }
            this.sb.append(FacConstants.EOL);
        }
        DBConnectionPool.getInstance("fac").returnConnection(con);
        return this.sb.toString().getBytes();
    }

    private void initialize() throws Exception {
        String reportDefinitionKey = this.extractFromSelections("reportDefinitionKey");
        String[] rdkAttributes = reportDefinitionKey.split(";");
        String rdUser = rdkAttributes[0];
        String rdContext = rdkAttributes[1];
        String rdKey1 = rdkAttributes[2];
        String rdKey2 = rdkAttributes[3];
        this.reportType = Integer.parseInt(rdKey2);
        this.usage = 1;
        if (rdkAttributes.length > 4 && this.company.getId().equals(rdkAttributes[4])) {
            this.usage = 0;
        }
        UserSettings userSettings = new UserSettings("fac", rdUser, rdContext);
        Collection dummies = userSettings.getSettings("FACReportDefinition", "RS", rdKey1);
        Iterator di = dummies.iterator();
        String[] reportDDSNames = null;
        while (di.hasNext()) {
            UserSetting userSetting = (UserSetting)di.next();
            reportDDSNames = userSetting.getValue().split(",");
        }
        Vector allColumnDefinitions = ReportDefinitionHelper.retrieveAllColumnDefinitions(this.environment, false, this.company, this.reportType, this.usage);
        this.columnDefinitions = new Vector();
        boolean firstTime = true;
        int i = 0;
        while (i < reportDDSNames.length) {
            Iterator acdi = allColumnDefinitions.iterator();
            int index = 0;
            while (acdi.hasNext()) {
                ColumnDefinition columnDefinition = (ColumnDefinition)acdi.next();
                ++index;
                if (!reportDDSNames[i].equals(columnDefinition.getDdsName())) continue;
                if (reportDDSNames[i].equals("ID")) {
                    this.groupBy = false;
                }
                this.columnDefinitions.add(columnDefinition);
                if (columnDefinition.getType().equals("CC")) break;
                if (!firstTime) {
                    this.nonCalcColumns = String.valueOf(this.nonCalcColumns) + ", " + reportDDSNames[i];
                    break;
                }
                firstTime = false;
                this.nonCalcColumns = String.valueOf(this.nonCalcColumns) + reportDDSNames[i];
                break;
            }
            ++i;
        }
        this.numberOfColumns = this.columnDefinitions.size();
    }

    private void handleSelections() {
    }

    private void handleTableHeader() throws Exception {
        for (ColumnDefinition this.columnDefinition : this.columnDefinitions) {
            this.sb.append(this.columnDefinition.retrieveCSVHeaderLabel());
            this.sb.append(';');
        }
        this.sb.append(FacConstants.EOL);
    }

    private String retrieveSQLStatement() throws Exception {
        int a;
        String ddsName;
        boolean firstColumn = true;
        String stmt = ReportDefinitionHelper.retrieveSQLStatement(this.environment.getFacLib(), this.company, this.fromYearForReport, this.yearPeriodFrom, this.yearPeriodTo, this.accountingPrinciple, this.reportType, this.usage, this.nonCalcColumns);
        if (this.reportType == 1) {
            stmt = String.valueOf(stmt) + "SELECT ";
            for (ColumnDefinition columnDefinition : this.columnDefinitions) {
                ddsName = columnDefinition.getDdsName();
                if (this.groupBy && columnDefinition.getType().equals("CC")) {
                    ddsName = "SUM(" + columnDefinition.getDdsName() + ") AS " + columnDefinition.getDdsName() + "GB";
                }
                if (!firstColumn) {
                    stmt = String.valueOf(stmt) + ", " + ddsName;
                    continue;
                }
                stmt = String.valueOf(stmt) + ddsName;
                firstColumn = false;
            }
            stmt = String.valueOf(stmt) + " FROM BASETABLE ";
            if (this.groupBy) {
                stmt = String.valueOf(stmt) + "GROUP BY ";
                firstColumn = true;
                for (ColumnDefinition columnDefinition : this.columnDefinitions) {
                    ddsName = columnDefinition.getDdsName();
                    if (columnDefinition.getType().equals("CC")) continue;
                    if (!firstColumn) {
                        stmt = String.valueOf(stmt) + ", " + ddsName;
                        continue;
                    }
                    stmt = String.valueOf(stmt) + ddsName;
                    firstColumn = false;
                }
                stmt = String.valueOf(stmt) + " ORDER BY ";
                firstColumn = true;
                for (ColumnDefinition columnDefinition : this.columnDefinitions) {
                    ddsName = columnDefinition.getDdsName();
                    if (columnDefinition.getType().equals("CC")) {
                        ddsName = String.valueOf(columnDefinition.getDdsName()) + "GB";
                    }
                    if (!firstColumn) {
                        if (columnDefinition.getType().equals("CC")) continue;
                        stmt = String.valueOf(stmt) + ", " + ddsName;
                        continue;
                    }
                    stmt = String.valueOf(stmt) + ddsName;
                    firstColumn = false;
                }
            } else {
                a = this.nonCalcColumns.indexOf(", ID");
                stmt = a < 0 ? String.valueOf(stmt) + "ORDER BY ID" : String.valueOf(stmt) + "ORDER BY " + this.nonCalcColumns.substring(0, a + 4);
            }
        }
        if (this.reportType == 4) {
            stmt = String.valueOf(stmt) + "SELECT ";
            for (ColumnDefinition columnDefinition : this.columnDefinitions) {
                ddsName = columnDefinition.getDdsName();
                if (!firstColumn) {
                    stmt = String.valueOf(stmt) + ", " + ddsName;
                    continue;
                }
                stmt = String.valueOf(stmt) + ddsName;
                firstColumn = false;
            }
            stmt = String.valueOf(stmt) + " FROM BASETABLE ";
            a = this.nonCalcColumns.indexOf(", ID");
            stmt = a < 0 ? String.valueOf(stmt) + "ORDER BY ID" : String.valueOf(stmt) + "ORDER BY " + this.nonCalcColumns.substring(0, a + 4);
        }
        if (this.reportType == 2) {
            String dataLib = this.environment.getFacLib();
            stmt = String.valueOf(stmt) + "SELECT ";
            for (ColumnDefinition columnDefinition : this.columnDefinitions) {
                ddsName = columnDefinition.getDdsName();
                if (ddsName.startsWith("FINDIMID")) {
                    ddsName = "TRANSACTN." + ddsName;
                }
                if (!firstColumn) {
                    stmt = String.valueOf(stmt) + ", " + dataLib + "." + ddsName;
                    continue;
                }
                stmt = String.valueOf(stmt) + dataLib + "." + ddsName;
                firstColumn = false;
            }
            stmt = String.valueOf(stmt) + " FROM " + dataLib + ".TRANSACTN ";
            stmt = String.valueOf(stmt) + " LEFT OUTER JOIN " + dataLib + ".INCFINTRNS ";
            stmt = String.valueOf(stmt) + " ON " + dataLib + ".INCFINTRNS.ID = " + dataLib + ".TRANSACTN.INCFINTRID";
            stmt = String.valueOf(stmt) + " LEFT OUTER JOIN " + dataLib + ".ASSET ";
            stmt = String.valueOf(stmt) + " ON " + dataLib + ".ASSET.ID = " + dataLib + ".TRANSACTN.ASSETID";
            stmt = String.valueOf(stmt) + " AND " + dataLib + ".ASSET.COMPANYID = " + dataLib + ".TRANSACTN.COMPANYID";
            stmt = String.valueOf(stmt) + " AND " + dataLib + ".ASSET.CORA = " + dataLib + ".TRANSACTN.CORA";
            stmt = String.valueOf(stmt) + " WHERE " + dataLib + ".TRANSACTN.COMPANYID = '" + this.company.getId() + "' AND " + dataLib + ".TRANSACTN.CORA = 'A' AND ACCPRIN = " + this.accountingPrinciple + " AND ";
            stmt = String.valueOf(stmt) + "((JRNBOOKYR * 100) + JRNPERIOD) >= " + this.yearPeriodFrom + " AND ";
            stmt = String.valueOf(stmt) + "((JRNBOOKYR * 100) + JRNPERIOD) <= " + this.yearPeriodTo;
            if (this.transactionType != 0) {
                stmt = String.valueOf(stmt) + " AND TRANSTYP = " + this.transactionType;
            }
            stmt = String.valueOf(stmt) + " ORDER BY ASSETID, DOCUMENTNR";
        }
        if (this.reportType == 3) {
            String stmt2 = "";
            boolean bookYearSelected = false;
            boolean periodSelected = false;
            String dataLib = this.environment.getFacLib();
            stmt = String.valueOf(stmt) + "SELECT ";
            stmt2 = String.valueOf(stmt2) + "SELECT ";
            Iterator cdi = this.columnDefinitions.iterator();
            while (cdi.hasNext()) {
                String dataLib1 = dataLib;
                String dataLib2 = dataLib;
                ColumnDefinition columnDefinition = (ColumnDefinition)cdi.next();
                String ddsName2 = ddsName = columnDefinition.getDdsName();
                if (ddsName.startsWith("FINDIMID")) {
                    ddsName = "TRANSACTN." + ddsName;
                    ddsName2 = "INCFINTRNS." + ddsName2;
                }
                if (ddsName.startsWith("VOUCHERID")) {
                    ddsName = "TRANSACTN." + ddsName;
                    ddsName2 = "INCFINTRNS." + ddsName2;
                }
                if (ddsName.equalsIgnoreCase("TRANSACTN.CREDITID")) {
                    ddsName2 = "CRDBALANCE.CREDITID";
                }
                if (ddsName.equalsIgnoreCase("CREDIT.DESCR")) {
                    ddsName2 = ddsName;
                }
                if (ddsName.startsWith("CREDIT.DIMVALUE")) {
                    ddsName2 = ddsName;
                }
                if (ddsName.equalsIgnoreCase("TRANSACTN.COMPANYID")) {
                    ddsName2 = "CRDBALANCE.COMPANYID";
                }
                if (ddsName.equalsIgnoreCase("TRANSACTN.AMOUNT1")) {
                    ddsName2 = "INCFINTRNS.TRANSVALUE";
                }
                if (ddsName.equalsIgnoreCase("TRANSACTN.AMOUNT2")) {
                    ddsName2 = "000 AS A";
                    dataLib2 = "";
                }
                if (ddsName.equalsIgnoreCase("TRANSACTN.AMOUNT3")) {
                    ddsName2 = "000 AS B";
                    dataLib2 = "";
                }
                if (ddsName.equalsIgnoreCase("TRANSACTN.TRANSTYP")) {
                    ddsName2 = "999 AS C";
                    dataLib2 = "";
                }
                if (ddsName.equalsIgnoreCase("TRANSACTN.BOOKINGIND")) {
                    ddsName2 = "SUBSTR(" + dataLib + ".INCFINTRNS.BBVCATEGRY, 1, 1)";
                    dataLib2 = "";
                }
                if (ddsName.equalsIgnoreCase("TRANSACTN.DOCUMENTNR")) {
                    ddsName2 = "000 AS D";
                    dataLib2 = "";
                }
                if (ddsName.equalsIgnoreCase("TRANSACTN.DESCR")) {
                    ddsName2 = "INCFINTRNS.DESCR";
                }
                if (ddsName.equalsIgnoreCase("TRANSACTN.BOOKYEAR")) {
                    bookYearSelected = true;
                    ddsName2 = "INCFINTRNS.BOOKYEAR";
                }
                if (ddsName.equalsIgnoreCase("TRANSACTN.PERIODE")) {
                    periodSelected = true;
                    ddsName2 = "INCFINTRNS.PERIODE";
                }
                if (ddsName.equalsIgnoreCase("TRANSACTN.MAINACC1")) {
                    ddsName2 = "INCFINTRNS.MAINACC";
                }
                if (ddsName.equalsIgnoreCase("CRDBALANCE.DESCR")) {
                    ddsName2 = ddsName;
                    ddsName = "'' AS COSTDESCR";
                    dataLib1 = "";
                }
                if (!firstColumn) {
                    stmt = dataLib1.length() > 0 ? String.valueOf(stmt) + ", " + dataLib1 + "." + ddsName : String.valueOf(stmt) + ", " + ddsName;
                    if (dataLib2.length() > 0) {
                        stmt2 = String.valueOf(stmt2) + ", " + dataLib2 + "." + ddsName2;
                        continue;
                    }
                    stmt2 = String.valueOf(stmt2) + ", " + ddsName2;
                    continue;
                }
                stmt = dataLib1.length() > 0 ? String.valueOf(stmt) + dataLib1 + "." + ddsName : String.valueOf(stmt) + ddsName;
                stmt2 = dataLib2.length() > 0 ? String.valueOf(stmt2) + dataLib2 + "." + ddsName2 : String.valueOf(stmt2) + ddsName2;
                firstColumn = false;
            }
            stmt = String.valueOf(stmt) + ", " + dataLib + "." + "TRANSACTN.BOOKYEAR AS BOOKYAS";
            stmt = String.valueOf(stmt) + ", " + dataLib + "." + "TRANSACTN.PERIODE AS PERIODAS";
            stmt = String.valueOf(stmt) + " FROM " + dataLib + ".TRANSACTN ";
            stmt = String.valueOf(stmt) + " LEFT OUTER JOIN " + dataLib + ".CREDIT ";
            stmt = String.valueOf(stmt) + " ON " + dataLib + ".CREDIT.ID = " + dataLib + ".TRANSACTN.CREDITID";
            stmt = String.valueOf(stmt) + " AND " + dataLib + ".CREDIT.COMPANYID = " + dataLib + ".TRANSACTN.COMPANYID";
            stmt = String.valueOf(stmt) + " WHERE " + dataLib + ".TRANSACTN.COMPANYID = '" + this.company.getId() + "' AND " + dataLib + ".TRANSACTN.CORA = 'C' AND ";
            stmt = String.valueOf(stmt) + "((JRNBOOKYR * 100) + JRNPERIOD) >= " + this.yearPeriodFrom + " AND ";
            stmt = String.valueOf(stmt) + "((JRNBOOKYR * 100) + JRNPERIOD) <= " + this.yearPeriodTo;
            if (this.transactionType != 0) {
                stmt = String.valueOf(stmt) + " AND TRANSTYP = " + this.transactionType;
            }
            stmt2 = String.valueOf(stmt2) + ", " + dataLib + "." + "INCFINTRNS.BOOKYEAR AS BOOKYAS";
            stmt2 = String.valueOf(stmt2) + ", " + dataLib + "." + "INCFINTRNS.PERIODE AS PERIODAS";
            stmt2 = String.valueOf(stmt2) + " FROM (" + dataLib + ".INCFINTRNS ";
            stmt2 = String.valueOf(stmt2) + " LEFT OUTER JOIN (" + dataLib + ".CRDBALANCE LEFT OUTER JOIN " + dataLib + ".CREDIT ON ";
            stmt2 = String.valueOf(stmt2) + dataLib + ".CRDBALANCE.CREDITID = " + dataLib + ".CREDIT.ID AND ";
            stmt2 = String.valueOf(stmt2) + dataLib + ".CRDBALANCE.COMPANYID = " + dataLib + ".CREDIT.COMPANYID)";
            stmt2 = String.valueOf(stmt2) + " ON " + dataLib + ".CRDBALANCE.GLACCID = " + dataLib + ".INCFINTRNS.MAINACC";
            stmt2 = String.valueOf(stmt2) + " AND " + dataLib + ".CRDBALANCE.COMPANYID = " + dataLib + ".INCFINTRNS.COMPANYID)";
            stmt2 = String.valueOf(stmt2) + " WHERE " + dataLib + ".INCFINTRNS.COMPANYID = '" + this.company.getId() + "' AND " + dataLib + ".CRDBALANCE.GLACCID <> '' AND " + dataLib + ".CRDBALANCE.CREDITID <> '' AND ";
            stmt2 = String.valueOf(stmt2) + "((" + dataLib + ".INCFINTRNS.BOOKYEAR * 100) + " + dataLib + ".INCFINTRNS.PERIODE) >= " + this.yearPeriodFrom + " AND ";
            stmt2 = String.valueOf(stmt2) + "((" + dataLib + ".INCFINTRNS.BOOKYEAR * 100) + " + dataLib + ".INCFINTRNS.PERIODE) <= " + this.yearPeriodTo;
            stmt = String.valueOf(stmt) + " UNION ALL ";
            stmt = String.valueOf(stmt) + stmt2;
            stmt = String.valueOf(stmt) + " ORDER BY CREDITID, BOOKYAS, PERIODAS";
        }
        return stmt;
    }

    private String extractFromSelections(String key) throws Exception {
        String result = null;
        int i = 0;
        while (i < this.selections.length) {
            if (this.selections[i][0].equals(key)) {
                result = this.selections[i][1];
            }
            ++i;
        }
        return result;
    }

    private String getValue(int index) throws Exception {
        this.rs = this.resultSet.getString(index);
        if (this.rs == null) {
            return "";
        }
        if ("TRANSTYP".equals(this.resultSetMetaData.getColumnName(index).toUpperCase())) {
            this.rs = TransactionTypeEnum.getValue(Integer.parseInt(this.rs));
            return this.rs;
        }
        if ("STATE".equals(this.resultSetMetaData.getColumnName(index).toUpperCase())) {
            this.rs = AssetStateEnum.getValue(Integer.parseInt(this.rs));
            return this.rs;
        }
        if ("BOOKINGIND".equals(this.resultSetMetaData.getColumnName(index).toUpperCase())) {
            this.rs = GovernmentEnumHelper.getValue(5, Integer.parseInt(this.rs));
            return this.rs;
        }
        if ("DEPRMETHOD".equals(this.resultSetMetaData.getColumnName(index).toUpperCase())) {
            this.rs = DepreciationMethodEnum.getValue(Integer.parseInt(this.rs));
            return this.rs;
        }
        if ("STARTPERHM".equals(this.resultSetMetaData.getColumnName(index).toUpperCase())) {
            this.rs = StartPeriodHandlingEnum.getValue(Integer.parseInt(this.rs));
            return this.rs;
        }
        if (this.resultSetMetaData.getColumnTypeName(index).equals("DECIMAL") || this.resultSetMetaData.getColumnTypeName(index).equals("NUMERIC")) {
            this.numberformat.setMinimumFractionDigits(this.resultSetMetaData.getScale(index));
            this.numberformat.setMaximumFractionDigits(this.resultSetMetaData.getScale(index));
            return this.numberformat.format(this.resultSet.getDouble(index));
        }
        return this.rs;
    }
}

