/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Driver;
import java.sql.ResultSet;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.dataobject.HttpDataObject;
import nl.ibs.fac.FacDBConfigProperties;
import nl.ibs.fac.reports.PdfHelper;
import nl.ibs.fac.session.StartStopServlet;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBConnectionPool;

public class TestPdf
extends PdfHelper {
    private static final BigDecimal MB = new BigDecimal(0x100000);
    private static final String VERSION_DATA_TABLE = "JSQLVRSN";
    private static final String APPLICATION_VERSION = "APPLICATION_VERSION";
    private static final String VERSION_COLUMN = "VERSION_NUMBER";
    private static final String TYPE_COLUMN = "VERSION_TYPE";

    public static void main(String[] args) throws Exception {
        FileOutputStream fos = new FileOutputStream("About.pdf");
        fos.write(new TestPdf().createPdf(null).toByteArray());
        fos.close();
        System.exit(0);
    }

    public ByteArrayOutputStream createPdf(DataObject object) throws Exception {
        String title;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.document = new Document();
        this.reportTitle = title = "about";
        this.document.addTitle(title);
        PdfWriter writer = PdfWriter.getInstance((Document)this.document, (OutputStream)stream);
        writer.setPageEvent((PdfPageEvent)this);
        this.document.setPageSize(new Rectangle(892.5f, 1263.0f));
        this.document.setMargins(5.0f, 5.0f, 40.0f, 20.0f);
        this.document.open();
        String[][] labels = new String[][]{{"", ""}};
        int[] sizes = new int[]{100, 300};
        boolean[] rightAlign = new boolean[2];
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] bold = blArray;
        String[] value = new String[labels[0].length];
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        boolean[] translate = blArray2;
        this.createTable(true, labels, sizes, rightAlign, null);
        value[0] = "Application";
        value[1] = "";
        this.addTableRow(value, translate, bold);
        this.addEmptyTableRow();
        value[0] = "Application";
        value[1] = "Fixed Assets Control";
        this.addTableRow(value, translate);
        value[0] = "Version";
        value[1] = "2025.01.000";
        this.addTableRow(value, translate);
        value[0] = "ObjectLibrary";
        value[1] = StartStopServlet.getObjectLibrary();
        this.addTableRow(value, translate);
        value[0] = "ObjectLibraryVersion";
        value[1] = StartStopServlet.getObjectLibraryVersion();
        this.addTableRow(value, translate);
        this.createTable(true, labels, sizes, rightAlign, null);
        value[0] = "System";
        value[1] = "";
        this.addTableRow(value, translate, bold);
        this.addEmptyTableRow();
        if (object != null) {
            value[0] = "ServerInfo";
            value[1] = ((HttpDataObject)object).getContext().getServerInfo();
            this.addTableRow(value, translate);
        }
        value[0] = "OsName";
        value[1] = System.getProperty("os.name");
        this.addTableRow(value, translate);
        value[0] = "Version";
        value[1] = System.getProperty("os.version");
        this.addTableRow(value, translate);
        value[0] = "JavaVersion";
        value[1] = System.getProperty("java.version");
        this.addTableRow(value, translate);
        value[0] = "JavaVendor";
        value[1] = System.getProperty("java.vendor");
        this.addTableRow(value, translate);
        String property = System.getProperty("os400.gc.heap.size.init");
        if (property != null) {
            value[0] = "HeapInit";
            value[1] = property;
            this.addTableRow(value, translate);
        }
        if ((property = System.getProperty("os400.gc.heap.size.max")) == null) {
            property = String.valueOf(new BigDecimal(Runtime.getRuntime().maxMemory()).divide(MB, 0, 0).toString()) + " MB";
            value[0] = "HeapMax";
            value[1] = property;
        }
        this.addTableRow(value, translate);
        System.gc();
        property = String.valueOf(new BigDecimal(Runtime.getRuntime().freeMemory()).divide(MB, 0, 0).toString()) + " MB";
        value[0] = "FreeMemory";
        value[1] = property;
        this.addTableRow(value, translate);
        value[0] = "LogRoot";
        value[1] = StartStopServlet.getLogRoot();
        this.addTableRow(value, translate);
        if (object != null) {
            String pathToWebApp = ((HttpDataObject)object).getRequest().getSession().getServletContext().getRealPath("/WEB-INF");
            value[0] = "PathToWebApp";
            value[1] = pathToWebApp;
            this.addTableRow(value, translate);
        }
        this.createTable(true, labels, sizes, rightAlign, null);
        value[0] = "Database";
        value[1] = "";
        this.addTableRow(value, translate, bold);
        this.addEmptyTableRow();
        try {
            value[0] = "Version";
            value[1] = this.getDBVersion();
            this.addTableRow(value, translate);
        }
        catch (Exception e) {
            Log.error((Exception)e);
        }
        String driver = FacDBConfigProperties.getJDBCDriver();
        Driver driverClass = (Driver)Class.forName(driver).newInstance();
        if (driverClass != null) {
            String driverDescription = driver;
            driverDescription = String.valueOf(driverDescription) + (driverClass.jdbcCompliant() ? " JDBC compliant, " : " NOT JDBC compliant, version ");
            driverDescription = String.valueOf(driverDescription) + driverClass.getMajorVersion() + "." + driverClass.getMinorVersion() + " ";
            value[0] = "JDBCDriver";
            value[1] = driverDescription;
            this.addTableRow(value, translate);
        } else {
            value[0] = "driver";
            value[1] = String.valueOf(driver) + " not found!";
            this.addTableRow(value, translate);
        }
        value[0] = "DBURL";
        value[1] = FacDBConfigProperties.getURL();
        this.addTableRow(value, translate);
        value[0] = "DBSchema";
        value[1] = FacDBConfigProperties.getSchema();
        this.addTableRow(value, translate);
        value[0] = "DBUser";
        value[1] = FacDBConfigProperties.getUser();
        this.addTableRow(value, translate);
        this.document.add((Element)this.table);
        this.document.close();
        return stream;
    }

    private String getDBVersion() throws Exception {
        String version = null;
        DBConnectionPool pool = DBConnectionPool.getInstance("fac");
        DBConnection con = pool.getConnection();
        ResultSet rs = con.executeQuery("SELECT VERSION_NUMBER FROM " + pool.getPrefix() + VERSION_DATA_TABLE + " WHERE " + TYPE_COLUMN + " = '" + APPLICATION_VERSION + "'");
        if (rs.next()) {
            version = rs.getString(1);
        }
        pool.returnConnection(con);
        return version;
    }

    @Override
    protected int[] getColumnsToCumulate() throws Exception {
        return null;
    }
}

