/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import com.itextpdf.text.Element;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.boadapters.YearPercentageTableBO;
import nl.ibs.fac.db.YearPercentageDetail;
import nl.ibs.fac.db.YearPercentageTable;
import nl.ibs.fac.reports.PdfHelper;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.util.Stopwatch;

public class YearPercentageTableToPDF
extends PdfHelper {
    public static final String CLASSNAME = YearPercentageTableToPDF.class.getName();
    private static final String FILENAME = "YearPercentageTable";
    private static final String REPORTTITLE = "YearPercentageTables";
    private static final String[][] LABELS1 = new String[][]{{"Id", "Description", "Years"}};
    private static final int[] SIZES1 = new int[]{100, 300, 100};
    private static final boolean[] RIGHTALIGN1;
    private static final String[][] LABELS2;
    private static final int[] SIZES2;
    private static final boolean[] RIGHTALIGN2;
    private YearPercentageTable ypt = null;
    private String previousId = null;
    private String yearPercentageTableId = null;

    static {
        boolean[] blArray = new boolean[3];
        blArray[2] = true;
        RIGHTALIGN1 = blArray;
        LABELS2 = new String[][]{{"", "Year", "Percentage", ""}};
        SIZES2 = new int[]{100, 100, 100, 100};
        boolean[] blArray2 = new boolean[4];
        blArray2[1] = true;
        blArray2[2] = true;
        RIGHTALIGN2 = blArray2;
    }

    protected YearPercentageTableToPDF(String reportTitle, String[][] selections, Collection collection) throws Exception {
        super(reportTitle, selections, collection, null, null, "", "");
    }

    @Override
    protected void processObject(Object object) throws Exception {
        this.ypt = (YearPercentageTable)object;
        this.yearPercentageTableId = this.ypt.getId();
        if (this.previousId != null) {
            this.document.add((Element)this.table);
            this.table = null;
            this.document.newPage();
        }
        this.previousId = this.yearPercentageTableId;
        this.value = new String[3];
        this.translate = new boolean[]{true, true, true};
        this.bold = new boolean[3];
        this.createTable(false, LABELS1, SIZES1, RIGHTALIGN1, this.translate);
        this.addTableHeader();
        this.setCell(0, this.ypt.getId(), false, false);
        this.setCell(1, this.ypt.getDescription(), false, false);
        this.setCell(2, "" + this.ypt.getActualYears(), false, false);
        this.addTableRow();
        this.addEmptyTableRow();
        this.printYearPercentageTableDetails();
    }

    private void printYearPercentageTableDetails() throws Exception {
        this.value = new String[4];
        boolean[] blArray = new boolean[4];
        blArray[1] = true;
        blArray[2] = true;
        this.translate = blArray;
        this.bold = new boolean[4];
        this.createTable(true, LABELS2, SIZES2, RIGHTALIGN2, this.translate);
        this.addTableHeader();
        ExecutableQuery query = QueryFactory.create(YearPercentageDetail.class);
        query.setOrdering("lifeCycleYear");
        for (YearPercentageDetail yearPercentageDetail : this.ypt.getYearPercentageDetailsCollection(query)) {
            this.setCell(0, "", false, false);
            this.setCell(1, "" + (yearPercentageDetail.getLifeCycleYear() + 1), false, false);
            this.setCell(2, IBSDecimal.format(yearPercentageDetail.getPercentage(), 2), false, false);
            this.setCell(3, "", false, false);
            this.addTableRow();
        }
    }

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            YearPercentageTableToPDF.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        if (Log.debug() && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                Log.debug((String)args[i]);
                ++i;
            }
        }
        String[][] selections = BatchJobHelper.getSelections(args);
        Map map = BatchJobHelper.getSelections(selections);
        YearPercentageTableToPDF yearPercentageTableToPDF = new YearPercentageTableToPDF(REPORTTITLE, selections, YearPercentageTableBO.getYearPercentageTables(map));
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, FILENAME, "pdf"));
        fos.write(yearPercentageTableToPDF.createPdf().toByteArray());
        fos.close();
    }

    @Override
    protected int[] getColumnsToCumulate() throws Exception {
        return null;
    }

    protected int[] getLevelsToCumulate() throws Exception {
        return null;
    }
}

