/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.session;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.FacDBConfigProperties;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.sql.DBConnectionPool;
import nl.ibs.util.AS400ConnectionManager;
import nl.ibs.websphere.WebSphereHelper;

public class StartStopServlet
extends HttpServlet {
    private static final long serialVersionUID = -5634350278509815695L;
    private static String system;
    private static String library;
    private static String databaseUser;
    private static String databasePassword;
    private static String objectLibrary;
    private static String objectLibraryVersion;
    private static final String DIRECTORY = "/tomcat/logs";
    private static String logRoot;
    private static String contextName;
    private static final String WEBAPP_CLASSES = "/WEB-INF/classes";
    private static String classesPath;

    static {
        objectLibraryVersion = "";
        contextName = null;
        classesPath = null;
    }

    public void init() throws ServletException {
        Log.info((String)"FAC being started");
        try {
            logRoot = new WebSphereHelper().getLogFilePath();
            Log.info((String)logRoot);
        }
        catch (Throwable t) {
            Log.warn((String)t.getMessage());
            logRoot = DIRECTORY;
        }
        try {
            if (!StartStopServlet.settingsValid(true)) {
                Log.error((String)system);
                Log.error((String)databaseUser);
                Log.error((String)databasePassword);
                Log.error((String)library);
                throw new Exception("settings are invalid");
            }
        }
        catch (Exception e) {
            Log.error((Exception)e);
        }
        AS400ConnectionManager.instance().disconnectAll();
        Log.info((String)"FAC started");
    }

    public void destroy() {
        try {
            if (StartStopServlet.settingsValid(false) && contextName != null) {
                String dest = "/home/u4c/" + contextName;
                new File(dest).mkdirs();
                StartStopServlet.copyPropertiesFiles(classesPath, dest);
            }
        }
        catch (Exception e) {
            Log.error((Exception)e);
        }
        AS400ConnectionManager.instance().disconnectAll();
        LoginHelper.disconnectAll();
        DBConnectionPool.disconnectAllPools();
        Log.info((String)"FAC stopped");
    }

    public static void setContextName(HttpServletRequest request) throws Exception {
        if (contextName != null) {
            return;
        }
        contextName = request.getContextPath();
        classesPath = request.getSession().getServletContext().getRealPath(WEBAPP_CLASSES);
        StartStopServlet.makePropertiesFilesDirectory();
    }

    public static void copyPropertiesFiles() {
        StartStopServlet.copyPropertiesFiles("/home/u4c/" + contextName, classesPath);
    }

    private static void copyPropertiesFiles(String source, String dest) {
        FileInputStream is = null;
        FileOutputStream os = null;
        File[] files = new File(classesPath).listFiles();
        int j = 0;
        while (j < files.length) {
            if (files[j].getName().endsWith(".properties")) {
                try {
                    int length;
                    is = new FileInputStream(String.valueOf(source) + "/" + files[j].getName());
                    os = new FileOutputStream(String.valueOf(dest) + "/" + files[j].getName());
                    byte[] buffer = new byte[1024];
                    while ((length = is.read(buffer)) > 0) {
                        os.write(buffer, 0, length);
                    }
                    is.close();
                    os.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++j;
        }
    }

    private static void makePropertiesFilesDirectory() throws Exception {
        String dest;
        File file;
        if (contextName != null && !(file = new File(dest = "/home/u4c/" + contextName)).exists()) {
            file.mkdirs();
            if (!file.exists()) {
                throw new Exception(String.valueOf(dest) + " could not be created");
            }
        }
    }

    public static boolean settingsValid(boolean initialize) throws Exception {
        system = FacDBConfigProperties.getSystem();
        databaseUser = FacDBConfigProperties.getUser();
        databasePassword = FacDBConfigProperties.getPassword();
        library = FacDBConfigProperties.getSchema();
        if ("<SYSTEEM>".equals(system) || "<BIBLIOTHEEK>".equals(library) || "<GEBRUIKER>".equals(databaseUser) || "<WACHTWOORD>".equals(databasePassword)) {
            return false;
        }
        if (initialize) {
            LoginHelper loginHelper = new LoginHelper(system, databaseUser, databasePassword, library);
            String message = loginHelper.login();
            if (message == null) {
                EnvironmentBO.queryEnvironments(loginHelper);
                String[] result = BatchJobHelper.getObjectLibrary(loginHelper);
                objectLibrary = result[0];
                objectLibraryVersion = result[1];
                BatchJobHelper.setupBatch(loginHelper);
                loginHelper.logout();
            } else {
                Log.error((String)message);
            }
            DBConnectionPool.disconnectAllPools();
        }
        return true;
    }

    public static String getLibrary() {
        return library;
    }

    public static String getSystem() {
        return system;
    }

    public static String getDatabaseUser() {
        return databaseUser;
    }

    public static String getDatabasePassword() {
        return databasePassword;
    }

    public static String getObjectLibrary() {
        return objectLibrary;
    }

    public static String getObjectLibraryVersion() {
        return objectLibraryVersion;
    }

    public static boolean isValidObjectLibrary() throws Exception {
        if ("".equals(objectLibraryVersion)) {
            return true;
        }
        String unDottedDBVersion = "";
        StringTokenizer st = new StringTokenizer("2025.01.000", ".");
        while (st.hasMoreElements()) {
            unDottedDBVersion = String.valueOf(unDottedDBVersion) + st.nextToken();
        }
        Log.info((String)("unDottedDBVersion: " + unDottedDBVersion));
        return objectLibraryVersion.equals(unDottedDBVersion);
    }

    public static String getLogRoot() {
        return logRoot;
    }
}

