/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.ui;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FilterTable;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.adapters.AssetReferenceField;
import nl.ibs.fac.adapters.AssetTypeReferenceField;
import nl.ibs.fac.adapters.FISReferenceField;
import nl.ibs.fac.adapters.FMSReferenceField;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.gov.boadapters.CreditBO;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jsql.DBData;

public class AssetSelection
implements Serializable {
    private static final long serialVersionUID = 7579546489571469531L;
    private static final String[] FIELDNAMESFIS = new String[]{"finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5", "typeId", "id"};
    private static final String[] FIELDNAMESFMS = new String[]{"finDimId1", "finDimId2", "finDimId3", "finDimId4", "typeId", "id"};
    public static final String ASSETSELECTION = AssetSelection.class.getName();
    public static final String PRINT_TRANSACTIONS = "PrintTransactions";
    private final int _finApp = 0;
    private static final int _library = 1;
    private static final int _dimText0 = 2;
    private static final int _dimText1 = 3;
    private static final int _dimText2 = 4;
    private static final int _dimText3 = 5;
    private static final int _dimText4 = 6;
    private static final int _companyId = 7;
    private static final int _bookYear = 8;
    public static final int _assetFROM = 9;
    public static final int _assetTO = 10;
    public static final int _typeFROM = 11;
    public static final int _typeTO = 12;
    public static final int _dimFROM0 = 13;
    public static final int _dimTO0 = 14;
    public static final int _dimFROM1 = 15;
    public static final int _dimTO1 = 16;
    public static final int _dimFROM2 = 17;
    public static final int _dimTO2 = 18;
    public static final int _dimFROM3 = 19;
    public static final int _dimTO3 = 20;
    public static final int _dimFROM4 = 21;
    public static final int _dimTO4 = 22;
    private static final int _credit = 23;
    public static final int _parent = 24;
    public static final int _curcap = 25;
    public static final int _inclDisinvested = 26;
    public static final int _inclTransactions = 27;
    public static final int _justTotals = 28;
    public static final int _grandTotal = 29;
    public static final int _sortering = 30;
    public static final int _levels = 31;
    public static final int _description = 32;
    public static final int _exclBookValueZero = 33;
    private static final int MAX = 34;
    private boolean dspatr_showAsset;
    private boolean dspatr_showType;
    private boolean dspatr_showDim;
    private boolean dspatr_showParent;
    private boolean dspatr_showCurCap;
    private boolean dspatr_showIncl;
    private boolean dspatr_showInclTrans;
    private boolean dspatr_showJustTotals;
    private boolean dspatr_showGrandTotal;
    private boolean dspatr_showSortable;
    private boolean dspatr_showTotalizable;
    private boolean dspatr_description;
    private boolean dspatr_exclBookValueZero;
    private boolean parent = true;
    private boolean curcap = false;
    private boolean credit = false;
    private boolean inclDisinvested = true;
    private boolean exclBookValueZero = false;
    private boolean inclTransactions = false;
    private boolean justTotals = false;
    private boolean grandTotal = false;
    private boolean[] used = new boolean[]{true, true, true, true, true};
    private String finApp = null;
    private String library = null;
    private Company company = null;
    private String companyId = null;
    private String bookYear = null;
    private DBData dbData = null;
    private String SEPARATOR = ";";
    private String assetFROM = "";
    private String assetTO = "";
    private String typeFROM = "";
    private String typeTO = "";
    private String sortering = "";
    private String levels = "";
    private String description = "";
    private String[] levelName = new String[9];
    private String[] dimText = new String[]{"", "", "", "", ""};
    private String[] dimFROM = new String[]{"", "", "", "", ""};
    private String[] dimTO = new String[]{"", "", "", "", ""};
    private AssetReferenceField fldAssetFROM = null;
    private AssetReferenceField fldAssetTO = null;
    private AssetTypeReferenceField fldTypeFROM = null;
    private AssetTypeReferenceField fldTypeTO = null;
    private FinancialReferenceField[] fldDimFROM = new FinancialReferenceField[5];
    private FinancialReferenceField[] fldDimTO = new FinancialReferenceField[5];
    public CheckBox fldJustTotals;
    public CheckBox fldGrandTotal;
    private CheckBox fldParent;
    private CheckBox fldCurCap;
    public CheckBox fldInclDisinvested;
    private CheckBox fldInclTransactions;
    public CheckBox fldExclBookValueZero;
    private StringBuffer sb = new StringBuffer();
    private FilterTable table;
    private FieldGroup screen;
    private Environment environment;
    private Company dataSet;
    public boolean hideFieldGroup;
    public boolean governmentActivated;
    public int ap;

    public AssetSelection(DataObject object, boolean credit) throws Exception {
        this.environment = (Environment)object.getSessionAttribute("ActiveEnvironment");
        this.companyId = (String)object.getSessionAttribute("ActiveCompany");
        this.bookYear = (String)object.getSessionAttribute("ActiveBookYear");
        this.credit = credit;
        this.finApp = this.environment.getOperationArea().length() == 0 ? "FIS" : "FMS";
        this.library = this.environment.getFacLib();
        this.dimText[0] = this.environment.getName1();
        this.dimText[1] = this.environment.getName2();
        this.dimText[2] = this.environment.getName3();
        this.dimText[3] = this.environment.getName4();
        this.dimText[4] = this.environment.getName5();
        this.init();
    }

    public AssetSelection(String stringRepresentation) throws Exception {
        this.split(stringRepresentation);
        this.init();
    }

    private void init() throws Exception {
        this.dbData = BOAdapter.getDBData(this.library);
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.dataSet = this.company.getDataSet();
        if (this.dataSet == null) {
            this.dataSet = this.company;
        }
        this.used[0] = this.dataSet.getFinancialDimension1Usage() != 0;
        this.used[1] = this.dataSet.getFinancialDimension2Usage() != 0;
        this.used[2] = this.dataSet.getFinancialDimension3Usage() != 0;
        this.used[3] = this.dataSet.getFinancialDimension4Usage() != 0;
        this.used[4] = this.dataSet.getFinancialDimension5Usage() != 0;
        this.levelName[0] = LanguageHelper.getString("nl.ibs.fac.language", "General");
        this.levelName[1] = LanguageHelper.getString("nl.ibs.fac.language", "MainAccount");
        this.levelName[2] = this.dimText[0];
        this.levelName[3] = this.dimText[1];
        this.levelName[4] = this.dimText[2];
        this.levelName[5] = this.dimText[3];
        this.levelName[6] = this.dimText[4];
        this.levelName[7] = LanguageHelper.getString("nl.ibs.fac.language", "Type");
        this.levelName[8] = LanguageHelper.getString("nl.ibs.fac.language", "Asset");
    }

    public void getScreenValues() {
        this.assetFROM = this.fldAssetFROM.getValue().trim();
        this.assetTO = this.fldAssetTO.getValue().trim();
        this.typeFROM = this.fldTypeFROM.getValue().trim();
        this.typeTO = this.fldTypeTO.getValue().trim();
        int i = 0;
        while (i < 5) {
            if (this.used[i]) {
                this.dimFROM[i] = this.fldDimFROM[i].getFormattedId();
                this.dimTO[i] = this.fldDimTO[i].getFormattedId();
            }
            ++i;
        }
        this.parent = this.fldParent.getBoolean();
        this.curcap = this.fldCurCap.getBoolean();
        this.inclDisinvested = this.fldInclDisinvested.getBoolean();
        this.inclTransactions = this.fldInclTransactions.getBoolean();
        this.exclBookValueZero = this.fldExclBookValueZero.getBoolean();
        this.justTotals = this.fldJustTotals.getBoolean();
        this.grandTotal = this.fldGrandTotal.getBoolean();
        this.sortering = this.table.getOrderBy();
        this.levels = this.table.getLevels();
        this.description = this.table.getDescription();
    }

    public void setDisplayAttributes(boolean showAsset, boolean showType, boolean showDim, boolean showJustTotals, boolean showParent, boolean showCurCap, boolean showIncl, boolean showInclTrans, boolean showGrandTotal, boolean showSortable, boolean showTotalizable, boolean showDescription, boolean showExclBookValueZero) throws Exception {
        this.dspatr_showAsset = showAsset;
        this.dspatr_showType = showType;
        this.dspatr_showDim = showDim;
        this.dspatr_showParent = showParent;
        this.dspatr_showCurCap = showCurCap;
        this.dspatr_showIncl = showIncl;
        this.dspatr_showInclTrans = showInclTrans;
        this.dspatr_showJustTotals = showJustTotals;
        this.dspatr_showGrandTotal = showGrandTotal;
        this.dspatr_showSortable = showSortable;
        this.dspatr_showTotalizable = showTotalizable;
        this.dspatr_description = showDescription;
        this.dspatr_exclBookValueZero = showExclBookValueZero;
    }

    public void setSelectionAttribute(int key, String value) throws Exception {
        switch (key) {
            case 9: {
                this.assetFROM = value;
                break;
            }
            case 10: {
                this.assetTO = value;
                break;
            }
            case 11: {
                this.typeFROM = value;
                break;
            }
            case 12: {
                this.typeTO = value;
                break;
            }
            case 13: {
                this.dimFROM[0] = value;
                break;
            }
            case 14: {
                this.dimTO[0] = value;
                break;
            }
            case 15: {
                this.dimFROM[1] = value;
                break;
            }
            case 16: {
                this.dimTO[1] = value;
                break;
            }
            case 17: {
                this.dimFROM[2] = value;
                break;
            }
            case 18: {
                this.dimTO[2] = value;
                break;
            }
            case 19: {
                this.dimFROM[3] = value;
                break;
            }
            case 20: {
                this.dimTO[3] = value;
                break;
            }
            case 21: {
                this.dimFROM[4] = value;
                break;
            }
            case 22: {
                this.dimTO[4] = value;
                break;
            }
            case 25: {
                this.curcap = Boolean.valueOf(value);
                break;
            }
            case 29: {
                this.grandTotal = Boolean.valueOf(value);
                break;
            }
            case 26: {
                this.inclDisinvested = Boolean.valueOf(value);
                break;
            }
            case 27: {
                this.inclTransactions = Boolean.valueOf(value);
                break;
            }
            case 28: {
                this.justTotals = Boolean.valueOf(value);
                break;
            }
            case 24: {
                this.parent = Boolean.valueOf(value);
                break;
            }
            case 30: {
                this.dspatr_showSortable = Boolean.valueOf(value);
                break;
            }
            case 31: {
                this.dspatr_showTotalizable = Boolean.valueOf(value);
                break;
            }
            case 33: {
                this.dspatr_exclBookValueZero = Boolean.valueOf(value);
            }
        }
    }

    public Panel getSelectionPanel(LoginHelper loginHelper) throws Exception {
        Panel screen = new Panel();
        FieldGroup fg = new FieldGroup(LanguageHelper.getString("nl.ibs.fac.language", "SelectSort"));
        ESPGridLayout grid = new ESPGridLayout();
        this.table = this.finApp.equals("FIS") || !this.dspatr_description ? new FilterTable(FIELDNAMESFIS, this.dspatr_showSortable, this.dspatr_showTotalizable, this.dspatr_description, 100) : new FilterTable(FIELDNAMESFMS, this.dspatr_showSortable, this.dspatr_showTotalizable, this.dspatr_description, 100);
        this.table.setName("AssetSelection");
        int index = 0;
        while (index < this.dimText.length) {
            if (this.dimText[index].length() != 0) {
                if (this.finApp.equals("FIS")) {
                    this.fldDimFROM[index] = new FISReferenceField(loginHelper, this.dimText[index], index + 1, this.dataSet);
                    this.fldDimTO[index] = new FISReferenceField(loginHelper, this.dimText[index], index + 1, this.dataSet);
                } else {
                    this.fldDimFROM[index] = new FMSReferenceField(loginHelper, this.dimText[index], index + 1, this.dataSet);
                    this.fldDimTO[index] = new FMSReferenceField(loginHelper, this.dimText[index], index + 1, this.dataSet);
                }
                this.fldDimFROM[index].setValue(this.dimFROM[index]);
                this.fldDimTO[index].setValue(this.dimTO[index]);
                if (this.dspatr_showDim) {
                    if (this.used[index]) {
                        this.table.addRow(index, (Field)this.fldDimFROM[index], (Field)this.fldDimTO[index]);
                    } else if (this.dspatr_description) {
                        Field field = new Field();
                        field.setHidden(true);
                        this.table.addRow(index, field, field);
                    }
                }
            }
            ++index;
        }
        String companyOrDataSetId = this.company.getId();
        String dataSetId = this.company.getDataSetId();
        if (dataSetId != null) {
            companyOrDataSetId = dataSetId;
        }
        this.fldTypeFROM = new AssetTypeReferenceField(this.dbData, companyOrDataSetId);
        this.fldTypeFROM.setValue(this.typeFROM);
        this.fldTypeTO = new AssetTypeReferenceField(this.dbData, companyOrDataSetId);
        this.fldTypeTO.setValue(this.typeTO);
        if (this.dspatr_showType) {
            if (this.finApp.equals("FIS") || !this.dspatr_description) {
                this.table.addRow(5, (Field)this.fldTypeFROM, (Field)this.fldTypeTO);
            } else {
                this.table.addRow(4, (Field)this.fldTypeFROM, (Field)this.fldTypeTO);
            }
        }
        this.fldAssetFROM = new AssetReferenceField(this.company, null, Boolean.TRUE, true, this.credit);
        this.fldAssetFROM.setValue(this.assetFROM);
        this.fldAssetFROM.setLabel(this.credit ? "Label.Credit" : "Label.Asset");
        this.fldAssetTO = new AssetReferenceField(this.company, null, Boolean.TRUE, true, this.credit);
        this.fldAssetTO.setValue(this.assetTO);
        if (this.dspatr_showAsset) {
            if (this.finApp.equals("FIS") || !this.dspatr_description) {
                this.table.addRow(6, (Field)this.fldAssetFROM, (Field)this.fldAssetTO);
            } else {
                this.table.addRow(5, (Field)this.fldAssetFROM, (Field)this.fldAssetTO);
            }
        }
        this.table.reload();
        grid.add((UIObject)this.table, 0, 1);
        FloatBar fb = new FloatBar();
        fb.alignment(1);
        fb.addAction(this.table.getClearAction());
        grid.add((UIObject)fb, 1, 1);
        fg.add(grid);
        screen.addUIObject((UIObject)fg);
        fg = new FieldGroup(LanguageHelper.getString("nl.ibs.fac.language", "Miscellaneous"));
        this.fldJustTotals = new CheckBox(LanguageHelper.getString("nl.ibs.fac.language", "JustTotals"));
        this.fldJustTotals.setValue(this.justTotals);
        if (this.dspatr_showJustTotals) {
            fg.add(this.fldJustTotals);
        }
        this.fldGrandTotal = new CheckBox(LanguageHelper.getString("nl.ibs.fac.language", "PrintGrandTotal"));
        this.fldGrandTotal.setValue(this.grandTotal);
        if (this.dspatr_showGrandTotal) {
            fg.add(this.fldGrandTotal);
        }
        this.fldParent = new CheckBox(LanguageHelper.getString("nl.ibs.fac.language", "ParentAssets"));
        this.fldParent.setValue(this.parent);
        if (this.dspatr_showParent) {
            fg.add(this.fldParent);
        }
        this.fldCurCap = new CheckBox(LanguageHelper.getString("nl.ibs.fac.language", "CurrentCapitalizations"));
        this.fldCurCap.setValue(this.curcap);
        if (this.dspatr_showCurCap) {
            fg.add(this.fldCurCap);
        }
        this.fldInclDisinvested = new CheckBox(LanguageHelper.getString("nl.ibs.fac.language", "IncludeDisinvested"));
        this.fldInclDisinvested.setValue(this.inclDisinvested);
        if (this.dspatr_showIncl) {
            fg.add(this.fldInclDisinvested);
        }
        this.fldExclBookValueZero = new CheckBox(LanguageHelper.getString("nl.ibs.fac.language", "ExclBookValueZero"));
        this.fldExclBookValueZero.setValue(this.exclBookValueZero);
        if (this.dspatr_exclBookValueZero) {
            fg.add(this.fldExclBookValueZero);
        }
        this.fldInclTransactions = new CheckBox(LanguageHelper.getString("nl.ibs.fac.language", "IncludeTransactions"));
        this.fldInclTransactions.setValue(this.inclTransactions);
        if (this.dspatr_showInclTrans) {
            fg.add(this.fldInclTransactions);
        }
        if (!this.hideFieldGroup) {
            screen.addUIObject((UIObject)fg);
        }
        return screen;
    }

    public boolean[] getLevelBreakFields() {
        boolean[] lvl = new boolean[9];
        lvl[0] = this.grandTotal;
        int i = 0;
        while (i < this.levels.length()) {
            if (this.levels.charAt(i) != '0') {
                lvl[i + 2] = true;
            }
            ++i;
        }
        return lvl;
    }

    public String getLevelBreakFieldsAsString() {
        this.sb = new StringBuffer();
        boolean[] lvl = this.getLevelBreakFields();
        int i = 1;
        while (i < lvl.length) {
            if (lvl[i]) {
                if (this.sb.length() > 0) {
                    this.sb.append(", ");
                }
                this.sb.append(this.levelName[i]);
            }
            ++i;
        }
        return this.sb.toString();
    }

    public int[] getOrderBy() {
        int[] result = new int[9];
        int i = 0;
        while (i < result.length) {
            result[i] = -1;
            ++i;
        }
        int nr = 0;
        String[] orderBy = this.sortering.split(",");
        String s = null;
        int i2 = 0;
        while (i2 < orderBy.length) {
            s = orderBy[i2].trim().toLowerCase();
            if (s.equals("mainaccount")) {
                result[nr++] = 1;
            } else if (s.equals("findimid1")) {
                result[nr++] = 2;
            } else if (s.equals("findimid2")) {
                result[nr++] = 3;
            } else if (s.equals("findimid3")) {
                result[nr++] = 4;
            } else if (s.equals("findimid4")) {
                result[nr++] = 5;
            } else if (s.equals("findimid5")) {
                result[nr++] = 6;
            } else if (s.equals("typeid")) {
                result[nr++] = 7;
            } else if (s.equals("id")) {
                result[nr++] = 8;
            }
            ++i2;
        }
        return result;
    }

    public String getOrderByAsString() {
        this.sb = new StringBuffer();
        int[] orderBy = this.getOrderBy();
        int x = 0;
        int i = 0;
        while (i < orderBy.length) {
            x = orderBy[i];
            if (x > 0) {
                if (this.sb.length() > 0) {
                    this.sb.append(", ");
                }
                this.sb.append(this.levelName[x]);
            }
            ++i;
        }
        return this.sb.toString();
    }

    public boolean getIncludeTransactions() {
        if (this.fldInclTransactions == null) {
            return this.inclTransactions;
        }
        return this.fldInclTransactions.getBoolean();
    }

    public boolean getJustTotals() {
        return this.justTotals;
    }

    public boolean getIncludeDisinvested() {
        return this.inclDisinvested;
    }

    public boolean getExcludeBookValueZero() {
        return this.exclBookValueZero;
    }

    public boolean getGrandTotal() {
        return this.grandTotal;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection getCollection() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("facLib", this.library);
        map.put("Company", this.companyId);
        if (this.credit) {
            map.put("FromCredit", this.assetFROM);
            map.put("ToCredit", this.assetTO);
        } else {
            map.put("FromAsset", this.assetFROM);
            map.put("ToAsset", this.assetTO);
        }
        if (this.curcap) {
            map.put("currentCapitalization", "");
        }
        map.put("FromType", this.typeFROM);
        map.put("ToType", this.typeTO);
        map.put("FromFinDimId1", this.dimFROM[0]);
        map.put("ToFinDimId1", this.dimTO[0]);
        map.put("FromFinDimId2", this.dimFROM[1]);
        map.put("ToFinDimId2", this.dimTO[1]);
        map.put("FromFinDimId3", this.dimFROM[2]);
        map.put("ToFinDimId3", this.dimTO[2]);
        map.put("FromFinDimId4", this.dimFROM[3]);
        map.put("ToFinDimId4", this.dimTO[3]);
        map.put("FromFinDimId5", this.dimFROM[4]);
        map.put("ToFinDimId5", this.dimTO[4]);
        map.put("isSubsset", "true");
        map.put("includeDisinvested", Boolean.toString(this.inclDisinvested));
        map.put(PRINT_TRANSACTIONS, Boolean.toString(this.inclTransactions));
        map.put("orderBy", this.sortering);
        if (!this.governmentActivated) {
            return AssetBO.getAssets(map, this.credit);
        }
        if (this.ap < 3) {
            return AssetBO.getAssets(map, this.credit);
        }
        if (this.ap == 3) {
            return CreditBO.getCredits(map);
        }
        Collection<?> returnCollection = AssetBO.getAssets(map, this.credit);
        returnCollection.addAll(CreditBO.getCredits(map));
        return returnCollection;
    }

    public void save() throws Exception {
        this.table.save();
    }

    public String[] getStringRepresentation() throws Exception {
        this.getScreenValues();
        this.sb = new StringBuffer();
        this.append(1, this.library);
        this.append(2, this.dimText[0]);
        this.append(3, this.dimText[1]);
        this.append(4, this.dimText[2]);
        this.append(5, this.dimText[3]);
        this.append(6, this.dimText[4]);
        this.append(7, this.companyId);
        this.append(8, this.bookYear);
        this.append(9, this.assetFROM);
        this.append(10, this.assetTO);
        this.append(11, this.typeFROM);
        this.append(12, this.typeTO);
        this.append(13, this.dimFROM[0]);
        this.append(14, this.dimTO[0]);
        this.append(15, this.dimFROM[1]);
        this.append(16, this.dimTO[1]);
        this.append(17, this.dimFROM[2]);
        this.append(18, this.dimTO[2]);
        this.append(19, this.dimFROM[3]);
        this.append(20, this.dimTO[3]);
        this.append(21, this.dimFROM[4]);
        this.append(22, this.dimTO[4]);
        this.append(23, Boolean.toString(this.credit));
        this.append(28, Boolean.toString(this.justTotals));
        this.append(29, Boolean.toString(this.grandTotal));
        this.append(24, Boolean.toString(this.parent));
        this.append(25, Boolean.toString(this.curcap));
        this.append(26, Boolean.toString(this.inclDisinvested));
        this.append(27, Boolean.toString(this.inclTransactions));
        this.append(30, this.sortering);
        this.append(31, this.levels);
        this.append(32, this.description);
        this.append(33, Boolean.toString(this.exclBookValueZero));
        String[] result = new String[2];
        String s = this.sb.toString();
        if (s.length() > 256) {
            result[0] = s.substring(0, 256);
            result[1] = s.substring(256);
        } else {
            result[0] = s;
            result[1] = "";
        }
        return result;
    }

    private void append(int i, String s) {
        if (s == null) {
            s = "";
        }
        if (s.length() > 0) {
            this.sb.append(i);
            this.sb.append("=");
            this.sb.append(s);
            this.sb.append(this.SEPARATOR);
        }
    }

    private void split(String stringRepresentation) throws Exception {
        String[] tokens = stringRepresentation.split(this.SEPARATOR);
        String[] val = new String[34];
        String[] nameValuePair = null;
        int fld = 0;
        int i = 0;
        while (i < tokens.length) {
            nameValuePair = tokens[i].split("=");
            fld = Integer.parseInt(nameValuePair[0]);
            val[fld] = nameValuePair[1];
            ++i;
        }
        this.finApp = val[0] == null ? "" : val[0];
        this.library = val[1] == null ? "" : val[1];
        this.dimText[0] = val[2] == null ? "" : val[2];
        this.dimText[1] = val[3] == null ? "" : val[3];
        this.dimText[2] = val[4] == null ? "" : val[4];
        this.dimText[3] = val[5] == null ? "" : val[5];
        this.dimText[4] = val[6] == null ? "" : val[6];
        this.companyId = val[7] == null ? "" : val[7];
        this.bookYear = val[8] == null ? "" : val[8];
        this.assetFROM = val[9] == null ? "" : val[9];
        this.assetTO = val[10] == null ? "" : val[10];
        this.typeFROM = val[11] == null ? "" : val[11];
        this.typeTO = val[12] == null ? "" : val[12];
        this.dimFROM[0] = val[13] == null ? "" : val[13];
        this.dimTO[0] = val[14] == null ? "" : val[14];
        this.dimFROM[1] = val[15] == null ? "" : val[15];
        this.dimTO[1] = val[16] == null ? "" : val[16];
        this.dimFROM[2] = val[17] == null ? "" : val[17];
        this.dimTO[2] = val[18] == null ? "" : val[18];
        this.dimFROM[3] = val[19] == null ? "" : val[19];
        this.dimTO[3] = val[20] == null ? "" : val[20];
        this.dimFROM[4] = val[21] == null ? "" : val[21];
        this.dimTO[4] = val[22] == null ? "" : val[22];
        this.credit = Boolean.valueOf(val[23]);
        this.justTotals = Boolean.valueOf(val[28]);
        this.grandTotal = Boolean.valueOf(val[29]);
        this.parent = Boolean.valueOf(val[24]);
        this.curcap = Boolean.valueOf(val[25]);
        this.inclDisinvested = Boolean.valueOf(val[26]);
        this.inclTransactions = Boolean.valueOf(val[27]);
        this.sortering = val[30] == null ? "" : val[30];
        this.levels = val[31] == null ? "0000000" : val[31];
        this.description = val[32] == null ? "" : val[32];
        this.exclBookValueZero = Boolean.valueOf(val[33]);
    }

    public String toString(FISHelper fisHelper, FMSHelper fmsHelper) throws Exception {
        if (this.screen != null) {
            this.getScreenValues();
        }
        StringBuffer bf = new StringBuffer();
        boolean first = true;
        if (this.assetFROM.length() > 0 || this.assetTO.length() > 0) {
            first = false;
            bf.append(this.credit ? String.valueOf(LanguageHelper.getString("nl.ibs.fac.language", "Credit")) + ": " : String.valueOf(LanguageHelper.getString("nl.ibs.fac.language", "Asset")) + ": ");
            bf.append(this.assetFROM);
            bf.append("-");
            bf.append(this.assetTO);
        }
        if (this.typeFROM.length() > 0 || this.typeTO.length() > 0) {
            if (first) {
                first = false;
            } else {
                bf.append(", ");
            }
            bf.append("Type: ");
            bf.append(this.typeFROM);
            bf.append("-");
            bf.append(this.typeTO);
        }
        int i = 0;
        while (i < 5) {
            if (this.dimFROM[i].length() > 0 || this.dimTO[i].length() > 0) {
                if (first) {
                    first = false;
                } else {
                    bf.append(", ");
                }
                bf.append(String.valueOf(this.dimText[i]) + ": ");
                if (fisHelper != null) {
                    bf.append(FISHelper.unFormatId(this.dimFROM[i]));
                    bf.append("-");
                    bf.append(FISHelper.unFormatId(this.dimTO[i]));
                }
                if (fmsHelper != null) {
                    bf.append(fmsHelper.unFormatId(this.dimFROM[i], i + 1));
                    bf.append("-");
                    bf.append(fmsHelper.unFormatId(this.dimTO[i], i + 1));
                }
            }
            ++i;
        }
        bf.append("\nHoofdact.: ");
        bf.append(LanguageHelper.getString(this.parent));
        if (this.inclDisinvested) {
            bf.append("\nIncl. gedesinv.: ");
            bf.append(LanguageHelper.getString(this.inclDisinvested));
        }
        if (this.inclTransactions) {
            bf.append("\nIncl. transacties: ");
            bf.append(LanguageHelper.getString(this.inclTransactions));
        }
        if (this.getOrderByAsString().trim().length() > 0) {
            bf.append("\nSorteren op: ");
            bf.append(this.getOrderByAsString());
        }
        if (this.getLevelBreakFieldsAsString().trim().length() > 0) {
            bf.append("\nTotaliseren op: ");
            bf.append(this.getLevelBreakFieldsAsString());
        }
        if (this.justTotals) {
            bf.append("\nAlleen totalen: ");
            bf.append(LanguageHelper.getString(this.justTotals));
        }
        if (this.levels.trim().length() > 0) {
            bf.append("\nAfdrukken tot.generaal: ");
            bf.append(LanguageHelper.getString(this.grandTotal));
        }
        return bf.toString();
    }
}

