/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.ui;

import java.util.ArrayList;
import java.util.List;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.adapter.LogFileAdapter;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.servlet.ESPUserContext;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.LinkAction;
import nl.ibs.esp.uiobjects.LogoffActionWithConfirmation;
import nl.ibs.esp.uiobjects.Menu;
import nl.ibs.esp.uiobjects.MenuBar;
import nl.ibs.esp.uiobjects.Separator;
import nl.ibs.fac.adapters.AboutAdapter;
import nl.ibs.fac.adapters.ActiveCompanyProcess;
import nl.ibs.fac.adapters.ActiveEnvironmentProcess;
import nl.ibs.fac.adapters.AdditionalJournalingDataProcess;
import nl.ibs.fac.adapters.AdminProcess;
import nl.ibs.fac.adapters.AnalysisFieldProcess;
import nl.ibs.fac.adapters.AnalysisGroupProcess;
import nl.ibs.fac.adapters.AssetCodeAndValueImportProcess;
import nl.ibs.fac.adapters.AssetCreateProcess;
import nl.ibs.fac.adapters.AssetInfoProcess;
import nl.ibs.fac.adapters.AssetProcess;
import nl.ibs.fac.adapters.AssetSheetReportProcess;
import nl.ibs.fac.adapters.AssetTypeProcess;
import nl.ibs.fac.adapters.AssetWOZValueProcess;
import nl.ibs.fac.adapters.CalculatorProcess;
import nl.ibs.fac.adapters.CheckCurrentBatchAdapter;
import nl.ibs.fac.adapters.CompanyPeriodHandlingProcess;
import nl.ibs.fac.adapters.CompanyProcess;
import nl.ibs.fac.adapters.CurrentCapitalizationImportProcess;
import nl.ibs.fac.adapters.CurrentCapitalizationProcess;
import nl.ibs.fac.adapters.CurrentTransactionBatchInfoProcess;
import nl.ibs.fac.adapters.CurrentTransactionBatchPostProcess;
import nl.ibs.fac.adapters.DepreciationProposalCreateProcess;
import nl.ibs.fac.adapters.DepreciationProposalDeleteProcess;
import nl.ibs.fac.adapters.DepreciationProposalInfoProcess;
import nl.ibs.fac.adapters.DepreciationProposalPostProcess;
import nl.ibs.fac.adapters.DepreciationProposalReportProcess;
import nl.ibs.fac.adapters.DepreciationProposalsCreateProcess;
import nl.ibs.fac.adapters.DepreciationProposalsPostProcess;
import nl.ibs.fac.adapters.DepreciationProposalsReportProcess;
import nl.ibs.fac.adapters.EnvironmentFACSYSBEHProcess;
import nl.ibs.fac.adapters.EnvironmentProcess;
import nl.ibs.fac.adapters.GLComparisonProcess;
import nl.ibs.fac.adapters.ImportProcess;
import nl.ibs.fac.adapters.IncomingFinancialTransactionInfoProcess;
import nl.ibs.fac.adapters.IncomingFinancialTransactionProcess;
import nl.ibs.fac.adapters.IncomingFinancialTransactionReportProcess;
import nl.ibs.fac.adapters.InterestTableProcess;
import nl.ibs.fac.adapters.InternalComparisonProcess;
import nl.ibs.fac.adapters.JobLogAdapter;
import nl.ibs.fac.adapters.MassTransactionCreateProcess;
import nl.ibs.fac.adapters.MassTransactionDeleteProcess;
import nl.ibs.fac.adapters.MassTransactionImportProcess;
import nl.ibs.fac.adapters.MassTransactionPostProcess;
import nl.ibs.fac.adapters.MassTransactionUpdateProcess;
import nl.ibs.fac.adapters.ParentAssetInfoProcess;
import nl.ibs.fac.adapters.ParentAssetProcess;
import nl.ibs.fac.adapters.ProjectActiveUserAdapter;
import nl.ibs.fac.adapters.ProofDepreciationReportProcess;
import nl.ibs.fac.adapters.ReconciliationReportProcess;
import nl.ibs.fac.adapters.ReportDefinitionProcess;
import nl.ibs.fac.adapters.ReportDefinitionReportProcess;
import nl.ibs.fac.adapters.ReportFileAdapter;
import nl.ibs.fac.adapters.TransactionAggregationProcess;
import nl.ibs.fac.adapters.TransactionBatchProcess;
import nl.ibs.fac.adapters.UserGroupMenuProcess;
import nl.ibs.fac.adapters.UserProcess;
import nl.ibs.fac.adapters.UserReportFileAdapter;
import nl.ibs.fac.adapters.WorkManagementProcess;
import nl.ibs.fac.adapters.YearPercentageTableProcess;
import nl.ibs.fac.boadapters.MenuOptionBO;
import nl.ibs.fac.gov.adapters.CloseCreditProcess;
import nl.ibs.fac.gov.adapters.CostAccountProcess;
import nl.ibs.fac.gov.adapters.CreditInfoProcess;
import nl.ibs.fac.gov.adapters.CreditProcess;
import nl.ibs.fac.mc.MC_IncomingFinancialTransactionInfoProcess;
import nl.ibs.fac.usertool.FACPatchUploadAdapter;
import nl.ibs.fac.usertool.FACUserToolInvokeAdapter;
import nl.ibs.fac.usertool.FACUserToolUploadAdapter;

public abstract class FACMenuBarHelper {
    public static MenuBar getFACSYSBEHMenu(DataObject object) throws Exception {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("Menu.Setup");
        menu.setIcon("application_edit.png");
        Action action = new Action("MenuItem.Environments").setAdapter(EnvironmentFACSYSBEHProcess.getStartPage()).setMethod("show").setIcon("application.png");
        menu.addMenuItem(action);
        action = new Action("MenuItem.ActiveEnvironment").setAdapter(ActiveEnvironmentProcess.getStartPage()).setMethod("show");
        menu.addMenuItem(action);
        menu.addMenuItem(new Separator());
        action = new Action("MenuItem.UserGroups").setAdapter(UserGroupMenuProcess.getStartPage()).setMethod("show").setIcon("group.png");
        menu.addMenuItem(action);
        action = new Action("MenuItem.Users").setAdapter(UserProcess.getStartPage()).setMethod("show").setIcon("user.png");
        menu.addMenuItem(action);
        action = new Action("MenuItem.ActiveUsers", ProjectActiveUserAdapter.class, "show").setIcon("group.png");
        menu.addMenuItem(action);
        menu.addMenuItem(new Separator());
        action = new Action("MenuItem.Import").setAdapter(ImportProcess.getStartPage()).setMethod("show");
        menu.addMenuItem(action);
        action = new Action("MenuItem.WorkManagement").setAdapter(WorkManagementProcess.getStartPage()).setMethod("show");
        menu.addMenuItem(action);
        menu.addMenuItem(new Separator());
        menu.addMenuItem(new Action("Upload patch", FACPatchUploadAdapter.class).setIcon("application_edit.png"));
        menuBar.addMenu(menu);
        menu = new Menu("Menu.Help");
        menu.setIcon("information.png");
        menu.addMenuItem(new LinkAction("MenuItem.Help", "help/" + ESPUserContext.getLocale() + "/FAC/index.html").setIcon("help.png"));
        menu.addMenuItem(new Action("MenuItem.About", "text", "ABOUT", AboutAdapter.class.getName(), "about").setIcon("information.png"));
        menuBar.addMenu(menu);
        menuBar.addAction((Action)new LogoffActionWithConfirmation("logoff", object.getSessionAttribute("SingleSigOn") != null));
        return menuBar;
    }

    public static MenuBar getNoActiveEnvironmentMenu(DataObject object) throws Exception {
        MenuBar menuBar = new MenuBar();
        menuBar.addAction(new Action("MenuItem.ActiveEnvironment").setAdapter(ActiveEnvironmentProcess.getStartPage()).setMethod("show").setIcon("door_in.png"));
        Menu menu = new Menu("Menu.Help");
        menu.setIcon("information.png");
        menu.addMenuItem(new LinkAction("MenuItem.Help", "help/" + ESPUserContext.getLocale() + "/FAC/index.html").setIcon("help.png"));
        menu.addMenuItem(new Action("Title.LogFiles").setAdapter(LogFileAdapter.class.getName()).setMethod("showWithClose").setIcon("report.png"));
        menu.addMenuItem(new Action("joblog").setAdapter(JobLogAdapter.class.getName()).setMethod("main").setIcon("application_xp_terminal.png"));
        menu.addMenuItem(new Action("MenuItem.About", "text", "ABOUT", AboutAdapter.class.getName(), "about").setIcon("information.png"));
        menuBar.addMenu(menu);
        menuBar.addAction((Action)new LogoffActionWithConfirmation("logoff", object.getSessionAttribute("SingleSigOn") != null));
        return menuBar;
    }

    public static MenuBar getADMINMenu(DataObject object, boolean government) throws Exception {
        MenuBar menuBar = new MenuBar();
        menuBar.addAction(new Action("Menu.User").setAdapter(AdminProcess.getStartPage()).setMethod("show").setIcon("door_in.png"));
        Menu menu = new Menu("Menu.Management");
        menu.setIcon("application_edit.png");
        Action action = new Action("MenuItem.TransactionBatch").setAdapter(TransactionBatchProcess.getStartPage()).setMethod("show");
        menu.addMenuItem(action);
        action = new Action("MenuItem.ReportFiles", ReportFileAdapter.class);
        menu.addMenuItem(action);
        menu.addMenuItem(new Separator());
        action = new Action("MenuItem.CurrentCapitalizationImport").setAdapter(CurrentCapitalizationImportProcess.getStartPage()).setMethod("show");
        menu.addMenuItem(action);
        action = new Action("MenuItem.AssetCodeAndValueImport").setAdapter(AssetCodeAndValueImportProcess.getStartPage()).setMethod("show");
        menu.addMenuItem(action);
        action = new Action("MenuItem.MassTransactionImport").setAdapter(MassTransactionImportProcess.getStartPage()).setMethod("show");
        menu.addMenuItem(action);
        menu.addMenuItem(new Separator());
        menu.addMenuItem(new Action("MenuItem.InternalComparison").setAdapter(InternalComparisonProcess.getStartPage()).setMethod("show"));
        menu.addMenuItem(new Action("MenuItem.AggregateTransactions").setAdapter(TransactionAggregationProcess.getStartPage()).setMethod("show"));
        menu.addMenuItem(new Separator());
        menu.addMenuItem(new Action("MenuItem.UploadUserTool", FACUserToolUploadAdapter.class));
        menu.addMenuItem(new Action("MenuItem.InvokeUserTool", FACUserToolInvokeAdapter.class));
        menuBar.addMenu(menu);
        menu = new Menu("Menu.MasterMaintenance");
        menu.setIcon("cog.png");
        action = new Action("MenuItem.Environments").setAdapter(EnvironmentProcess.getStartPage()).setMethod("show");
        menu.addMenuItem(action);
        action = new Action("MenuItem.ActiveEnvironment").setAdapter(ActiveEnvironmentProcess.getStartPage()).setMethod("show");
        menu.addMenuItem(action);
        menu.addMenuItem(new Separator());
        action = new Action("MenuItem.Companies").setAdapter(CompanyProcess.getStartPage()).setMethod("show");
        menu.addMenuItem(action);
        action = new Action("MenuItem.InterestTable").setAdapter(InterestTableProcess.getStartPage()).setMethod("show");
        menu.addMenuItem(action);
        action = new Action("MenuItem.YearPercentage").setAdapter(YearPercentageTableProcess.getStartPage()).setMethod("show");
        menu.addMenuItem(action);
        menu.addMenuItem(new Separator());
        action = new Action("MenuItem.UserGroups").setAdapter(UserGroupMenuProcess.getStartPage()).setMethod("show").setIcon("group.png");
        menu.addMenuItem(action);
        action = new Action("MenuItem.Users").setAdapter(UserProcess.getStartPage()).setMethod("show").setIcon("user.png");
        menu.addMenuItem(action);
        action = new Action("MenuItem.ActiveUsers", ProjectActiveUserAdapter.class, "show").setIcon("group.png");
        menu.addMenuItem(action);
        menuBar.addMenu(menu);
        if (!government) {
            menu = new Menu("Menu.MasterProcesses");
            menu.setIcon("application_form.png");
            action = new Action("MenuItem.MC_AllocatableIFTs").setAdapter(MC_IncomingFinancialTransactionInfoProcess.getStartPage()).setMethod("show");
            menu.addMenuItem(action);
            menu.addMenuItem(new Separator());
            menu.addMenuItem(new Action("MenuItem.CreateDepreciationProposals").setAdapter(DepreciationProposalsCreateProcess.getStartPage()).setMethod("show"));
            menu.addMenuItem(new Action("MenuItem.DepreciationProposalsReport").setAdapter(DepreciationProposalsReportProcess.getStartPage()).setMethod("show"));
            menu.addMenuItem(new Action("MenuItem.PostDepreciationProposals").setAdapter(DepreciationProposalsPostProcess.getStartPage()).setMethod("show"));
            menuBar.addMenu(menu);
        }
        menu = new Menu("Menu.MassTransactions");
        menu.setIcon("database.png");
        action = new Action("MenuItem.MassTransactionsCreate").setAdapter(MassTransactionCreateProcess.getStartPage()).setMethod("show");
        menu.addMenuItem(action);
        action = new Action("MenuItem.MassTransactionsUpdate").setAdapter(MassTransactionUpdateProcess.getStartPage()).setMethod("show");
        menu.addMenuItem(action);
        action = new Action("MenuItem.MassTransactionsDelete").setAdapter(MassTransactionDeleteProcess.getStartPage()).setMethod("show");
        menu.addMenuItem(action);
        action = new Action("MenuItem.MassTransactionsPost").setAdapter(MassTransactionPostProcess.getStartPage()).setMethod("show");
        menu.addMenuItem(action);
        menuBar.addMenu(menu);
        menu = new Menu("Menu.Miscellaneous");
        menu.setIcon("application_edit.png");
        menuBar.addMenu(menu);
        action = new Action("MenuItem.ActiveCompany").setAdapter(ActiveCompanyProcess.getStartPage()).setMethod("show");
        menu.addMenuItem(action);
        menu.addMenuItem(new Separator());
        action = new Action("MenuItem.WorkManagement").setAdapter(WorkManagementProcess.getStartPage()).setMethod("show");
        menu.addMenuItem(action);
        menu = new Menu("Menu.Help");
        menu.setIcon("information.png");
        menu.addMenuItem(new LinkAction("MenuItem.Help", "help/" + ESPUserContext.getLocale() + "/FAC/index.html").setIcon("help.png"));
        menu.addMenuItem(new Action("MenuItem.About", "text", "ABOUT", AboutAdapter.class.getName(), "about").setIcon("information.png"));
        menuBar.addMenu(menu);
        menuBar.addAction(new Action("MenuItem.Signoff", CheckCurrentBatchAdapter.class, "show").setIcon("door_out.png"));
        return menuBar;
    }

    public static MenuBar getUSERMenu(String userGroupId, boolean isAdmin, boolean government, boolean usesDataSet, DataObject object) throws Exception {
        Menu menu;
        MenuBar menuBar = new MenuBar();
        boolean separatorPrevious = false;
        boolean separatorNext = false;
        ArrayList userOptions = userGroupId == null ? new ArrayList() : MenuOptionBO.getOptions(userGroupId);
        if (isAdmin) {
            menuBar.addAction(new Action("Menu.Admin").setAdapter(AdminProcess.getStartPage()).setMethod("show").setIcon("door_in.png"));
        }
        if (userOptions.contains("Menu.Allocate")) {
            menu = new Menu("Menu.Allocate");
            menu.setIcon("money_euro.png");
            menuBar.addMenu(menu);
            if (userOptions.contains("MenuItem.Allocate")) {
                menu.addMenuItem(new Action("MenuItem.Allocate").setAdapter(IncomingFinancialTransactionProcess.getStartPage()).setMethod("show"));
            }
        }
        if (userOptions.contains("Menu.Maintenance")) {
            menu = new Menu("Menu.Maintenance");
            menu.setIcon("application_edit.png");
            menuBar.addMenu(menu);
            separatorPrevious = false;
            separatorNext = false;
            if (userOptions.contains("MenuItem.Asset")) {
                menu.addMenuItem(new Action("MenuItem.Asset").setAdapter(AssetProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (userOptions.contains("MenuItem.CreateAsset")) {
                menu.addMenuItem(new Action("MenuItem.CreateAsset").setAdapter(AssetCreateProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (separatorNext) {
                separatorPrevious = separatorNext;
                separatorNext = false;
            }
            if (userOptions.contains("MenuItem.ParentAsset")) {
                separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                menu.addMenuItem(new Action("MenuItem.ParentAsset").setAdapter(ParentAssetProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (userOptions.contains("MenuItem.WOZValue")) {
                separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                menu.addMenuItem(new Action("MenuItem.WOZValue").setAdapter(AssetWOZValueProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (userOptions.contains("MenuItem.CurrentCapitalization")) {
                separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                menu.addMenuItem(new Action("MenuItem.CurrentCapitalization").setAdapter(CurrentCapitalizationProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (separatorNext) {
                separatorPrevious = separatorNext;
                separatorNext = false;
            }
            if (!usesDataSet) {
                if (userOptions.contains("MenuItem.AssetType")) {
                    separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                    menu.addMenuItem(new Action("MenuItem.AssetType").setAdapter(AssetTypeProcess.getStartPage()).setMethod("show"));
                    separatorNext = true;
                }
                if (userOptions.contains("MenuItem.AnalysisGroup")) {
                    separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                    menu.addMenuItem(new Action("MenuItem.AnalysisGroup").setAdapter(AnalysisGroupProcess.getStartPage()).setMethod("show"));
                    separatorNext = true;
                }
                if (userOptions.contains("MenuItem.AnalysisField")) {
                    separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                    menu.addMenuItem(new Action("MenuItem.AnalysisField").setAdapter(AnalysisFieldProcess.getStartPage()).setMethod("show"));
                    separatorNext = true;
                }
                if (separatorNext) {
                    separatorPrevious = separatorNext;
                    separatorNext = false;
                }
                if (userOptions.contains("MenuItem.AdditionalJournalingData") && !government) {
                    separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                    menu.addMenuItem(new Action("MenuItem.AdditionalJournalingData").setAdapter(AdditionalJournalingDataProcess.getStartPage()).setMethod("show"));
                }
            }
        }
        if (userOptions.contains("Menu.Government_1") && government) {
            menu = new Menu("Menu.Government_1");
            menu.setIcon("application_edit.png");
            menuBar.addMenu(menu);
            separatorPrevious = false;
            separatorNext = false;
            if (userOptions.contains("MenuItem.InvestmentCredit")) {
                menu.addMenuItem(new Action("MenuItem.InvestmentCredit").setAdapter(CreditProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (userOptions.contains("MenuItem.CostAccount")) {
                menu.addMenuItem(new Action("MenuItem.CostAccount").setAdapter(CostAccountProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (userOptions.contains("MenuItem.CloseCredit")) {
                menu.addMenuItem(new Action("MenuItem.CloseCredit").setAdapter(CloseCreditProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
        }
        if (userOptions.contains("Menu.Periodical")) {
            menu = new Menu("Menu.Periodical");
            menu.setIcon("calendar_edit.png");
            menuBar.addMenu(menu);
            separatorPrevious = false;
            separatorNext = false;
            if (userOptions.contains("MenuItem.PostCurrentTransactionBatch")) {
                menu.addMenuItem(new Action("MenuItem.PostCurrentTransactionBatch").setAdapter(CurrentTransactionBatchPostProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (separatorNext) {
                separatorPrevious = separatorNext;
                separatorNext = false;
            }
            if (userOptions.contains("MenuItem.CreateDepreciationProposal")) {
                separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                menu.addMenuItem(new Action("MenuItem.CreateDepreciationProposal").setAdapter(DepreciationProposalCreateProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (userOptions.contains("MenuItem.DepreciationProposalInfo")) {
                separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                menu.addMenuItem(new Action("MenuItem.DepreciationProposalInfo").setAdapter(DepreciationProposalInfoProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (userOptions.contains("MenuItem.DeleteDepreciationProposal")) {
                separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                menu.addMenuItem(new Action("MenuItem.DeleteDepreciationProposal").setAdapter(DepreciationProposalDeleteProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (userOptions.contains("MenuItem.DepreciationProposalReport")) {
                separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                menu.addMenuItem(new Action("MenuItem.DepreciationProposalReport").setAdapter(DepreciationProposalReportProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (userOptions.contains("MenuItem.PostDepreciationProposal")) {
                separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                menu.addMenuItem(new Action("MenuItem.PostDepreciationProposal").setAdapter(DepreciationProposalPostProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (separatorNext) {
                separatorPrevious = separatorNext;
                separatorNext = false;
            }
            if (userOptions.contains("MenuItem.GLComparison")) {
                separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                if (government) {
                    menu.addMenuItem(new Action("MenuItem.GLComparison").setAdapter(ESPProcess.getProcessAdapterName((String)GLComparisonProcess.PAGE, (String)GLComparisonProcess.GOV_START_PAGE)).setMethod("show"));
                } else {
                    menu.addMenuItem(new Action("MenuItem.GLComparison").setAdapter(ESPProcess.getProcessAdapterName((String)GLComparisonProcess.PAGE, (String)GLComparisonProcess.START_PAGE)).setMethod("show"));
                }
                separatorNext = true;
            }
            if (userOptions.contains("MenuItem.CompanyPeriodHandling")) {
                separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                menu.addMenuItem(new Action("MenuItem.CompanyPeriodHandling").setAdapter(CompanyPeriodHandlingProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (separatorNext) {
                separatorPrevious = separatorNext;
                separatorNext = false;
            }
            if (userOptions.contains("MenuItem.InternalComparison")) {
                separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                menu.addMenuItem(new Action("MenuItem.InternalComparison").setAdapter(InternalComparisonProcess.getStartPage()).setMethod("show"));
            }
        }
        if (userOptions.contains("Menu.Info")) {
            menu = new Menu("Menu.Info");
            menu.setIcon("information.png");
            menuBar.addMenu(menu);
            separatorPrevious = false;
            separatorNext = false;
            if (userOptions.contains("MenuItem.InvestmentCreditInfo") && government) {
                menu.addMenuItem(new Action("MenuItem.InvestmentCreditInfo").setAdapter(CreditInfoProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (separatorNext) {
                separatorPrevious = separatorNext;
                separatorNext = false;
            }
            if (userOptions.contains("MenuItem.AssetInfo")) {
                separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                menu.addMenuItem(new Action("MenuItem.AssetInfo").setAdapter(AssetInfoProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (userOptions.contains("MenuItem.ParentAssetInfo")) {
                separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                menu.addMenuItem(new Action("MenuItem.ParentAssetInfo").setAdapter(ParentAssetInfoProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (separatorNext) {
                separatorPrevious = separatorNext;
                separatorNext = false;
            }
            if (userOptions.contains("MenuItem.CurrentTransactionBatch")) {
                separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                menu.addMenuItem(new Action("MenuItem.CurrentTransactionBatch").setAdapter(CurrentTransactionBatchInfoProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (userOptions.contains("MenuItem.IncomingFinancialTransactions")) {
                separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                menu.addMenuItem(new Action("MenuItem.IncomingFinancialTransactions").setAdapter(IncomingFinancialTransactionInfoProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (separatorNext) {
                separatorPrevious = separatorNext;
                separatorNext = false;
            }
            if (userOptions.contains("MenuItem.Calculate")) {
                separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                menu.addMenuItem(new Action("MenuItem.Calculate").setAdapter(CalculatorProcess.getStartPage()).setMethod("show"));
            }
        }
        if (userOptions.contains("Menu.Reports")) {
            menu = new Menu("Menu.Reports");
            menu.setIcon("printer.png");
            menuBar.addMenu(menu);
            separatorPrevious = false;
            separatorNext = false;
            if (userOptions.contains("MenuItem.AssetSheet")) {
                menu.addMenuItem(new Action("MenuItem.AssetSheet").setAdapter(AssetSheetReportProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (userOptions.contains("MenuItem.ReconciliationReport")) {
                menu.addMenuItem(new Action("MenuItem.ReconciliationReport").setAdapter(ReconciliationReportProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (userOptions.contains("MenuItem.ProofDepreciationReport")) {
                menu.addMenuItem(new Action("MenuItem.ProofDepreciationReport").setAdapter(ProofDepreciationReportProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (separatorNext) {
                separatorPrevious = separatorNext;
                separatorNext = false;
            }
            if (userOptions.contains("MenuItem.ReportDefinition")) {
                separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                menu.addMenuItem(new Action("MenuItem.ReportDefinition").setAdapter(ReportDefinitionProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (userOptions.contains("MenuItem.CreateCSVFile")) {
                separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                menu.addMenuItem(new Action("MenuItem.CreateCSVFile").setAdapter(ReportDefinitionReportProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (separatorNext) {
                separatorPrevious = separatorNext;
                separatorNext = false;
            }
            if (userOptions.contains("MenuItem.IncomingFinancialTransactionReport")) {
                separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
                menu.addMenuItem(new Action("MenuItem.IncomingFinancialTransactionReport").setAdapter(IncomingFinancialTransactionReportProcess.getStartPage()).setMethod("show"));
                separatorNext = true;
            }
            if (separatorNext) {
                separatorPrevious = separatorNext;
                separatorNext = false;
            }
            separatorPrevious = FACMenuBarHelper.addSeparator(separatorPrevious, menu);
            menu.addMenuItem(new Action("MenuItem.UserReportFiles", UserReportFileAdapter.class));
        }
        if (userOptions.contains("Menu.MassTransactions")) {
            menu = new Menu("Menu.MassTransactions");
            menu.setIcon("database.png");
            menuBar.addMenu(menu);
            if (userOptions.contains("MenuItem.MassTransactionsCreate")) {
                menu.addMenuItem(new Action("MenuItem.MassTransactionsCreate").setAdapter(MassTransactionCreateProcess.getStartPage()).setMethod("show"));
            }
            if (userOptions.contains("MenuItem.MassTransactionsUpdate")) {
                menu.addMenuItem(new Action("MenuItem.MassTransactionsUpdate").setAdapter(MassTransactionUpdateProcess.getStartPage()).setMethod("show"));
            }
            if (userOptions.contains("MenuItem.MassTransactionsDelete")) {
                menu.addMenuItem(new Action("MenuItem.MassTransactionsDelete").setAdapter(MassTransactionDeleteProcess.getStartPage()).setMethod("show"));
            }
            if (userOptions.contains("MenuItem.MassTransactionsPost")) {
                menu.addMenuItem(new Action("MenuItem.MassTransactionsPost").setAdapter(MassTransactionPostProcess.getStartPage()).setMethod("show"));
            }
        }
        menu = new Menu("Menu.Miscellaneous");
        menu.setIcon("application_edit.png");
        menuBar.addMenu(menu);
        Action action = new Action("MenuItem.ActiveCompany").setAdapter(ActiveCompanyProcess.getStartPage()).setMethod("show");
        menu.addMenuItem(action);
        menu.addMenuItem(new Separator());
        action = new Action("MenuItem.WorkManagement").setAdapter(WorkManagementProcess.getStartPage()).setMethod("show");
        menu.addMenuItem(action);
        menu = new Menu("Menu.Help");
        menu.setIcon("information.png");
        menu.addMenuItem(new LinkAction("MenuItem.Help", "help/" + ESPUserContext.getLocale() + "/FAC/index.html").setIcon("help.png"));
        menu.addMenuItem(new Action("Title.LogFiles").setAdapter(LogFileAdapter.class.getName()).setMethod("showWithClose").setIcon("report.png"));
        menu.addMenuItem(new Action("joblog").setAdapter(JobLogAdapter.class.getName()).setMethod("main").setIcon("application_xp_terminal.png"));
        menu.addMenuItem(new Action("MenuItem.About", "text", "ABOUT", AboutAdapter.class.getName(), "about").setIcon("information.png"));
        menuBar.addMenu(menu);
        menuBar.addAction(new Action("MenuItem.Signoff", CheckCurrentBatchAdapter.class, "show").setIcon("door_out.png"));
        return menuBar;
    }

    private static boolean addSeparator(boolean add, Menu menu) throws Exception {
        if (add) {
            menu.addMenuItem(new Separator());
            add = false;
        }
        return add;
    }

    public static List getUSERMenuOptions(boolean governmentActivated) throws Exception {
        ArrayList<String> options = new ArrayList<String>();
        options.add("Menu.Allocate");
        options.add("MenuItem.Allocate");
        options.add("Menu.Maintenance");
        options.add("MenuItem.Asset");
        options.add("MenuItem.CreateAsset");
        options.add("MenuItem.ParentAsset");
        options.add("MenuItem.WOZValue");
        options.add("MenuItem.CurrentCapitalization");
        options.add("MenuItem.AssetType");
        options.add("MenuItem.AnalysisGroup");
        options.add("MenuItem.AnalysisField");
        options.add("MenuItem.AdditionalJournalingData");
        if (governmentActivated) {
            options.add("Menu.Government_1");
            options.add("MenuItem.InvestmentCredit");
            options.add("MenuItem.CostAccount");
            options.add("MenuItem.CloseCredit");
        }
        options.add("Menu.Periodical");
        options.add("MenuItem.PostCurrentTransactionBatch");
        options.add("MenuItem.CreateDepreciationProposal");
        options.add("MenuItem.DepreciationProposalInfo");
        options.add("MenuItem.DeleteDepreciationProposal");
        options.add("MenuItem.DepreciationProposalReport");
        options.add("MenuItem.PostDepreciationProposal");
        options.add("MenuItem.GLComparison");
        options.add("MenuItem.CompanyPeriodHandling");
        options.add("MenuItem.InternalComparison");
        options.add("Menu.Info");
        if (governmentActivated) {
            options.add("MenuItem.InvestmentCreditInfo");
        }
        options.add("MenuItem.AssetInfo");
        options.add("MenuItem.ParentAssetInfo");
        options.add("MenuItem.CurrentTransactionBatch");
        options.add("MenuItem.IncomingFinancialTransactions");
        options.add("MenuItem.Calculate");
        options.add("Menu.Reports");
        options.add("MenuItem.AssetSheet");
        options.add("MenuItem.ReconciliationReport");
        options.add("MenuItem.ProofDepreciationReport");
        options.add("MenuItem.ReportDefinition");
        options.add("MenuItem.CreateCSVFile");
        options.add("MenuItem.IncomingFinancialTransactionReport");
        options.add("Menu.MassTransactions");
        options.add("MenuItem.MassTransactionsCreate");
        options.add("MenuItem.MassTransactionsUpdate");
        options.add("MenuItem.MassTransactionsDelete");
        options.add("MenuItem.MassTransactionsPost");
        return options;
    }
}

