/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.usertool;

import java.util.Collection;
import java.util.HashMap;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.TransactionBatchBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.bp.DepreciationProposalBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.usertool.FACUserTool;
import nl.ibs.fac.usertool.FACUserToolInvokeAdapter;

public class AAP2
implements FACUserTool {
    FACUserToolInvokeAdapter invokeAdapter;
    int accountingPrinciple1 = 1;
    int accountingPrinciple2 = 2;
    String incomingFinancialTransactionId = null;
    int journalingState = 0;
    int batchId = -1;
    String createdByUser = "FACSYSBEH";
    Object[] objects;
    Transaction newTransaction;
    Valuation newValuation;
    int sequenceNumber = 0;

    @Override
    public void execute(String[] parameterValues) throws Exception {
        this.validatePrerequisites();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("facLib", this.invokeAdapter.getEnvironment().getFacLib());
        map.put("Company", this.invokeAdapter.getCompanyId());
        Collection<Asset> assets = AssetBO.getAssets(map, false);
        for (Asset asset : assets) {
            if (!asset.getSubAsset()) continue;
            Valuation valuation1 = (Valuation)ValuationBO.get(asset.getDBData(), asset.getCompanyId(), asset.getCora(), asset.getId(), this.accountingPrinciple1)[0];
            Valuation valuation2 = (Valuation)ValuationBO.get(asset.getDBData(), asset.getCompanyId(), asset.getCora(), asset.getId(), this.accountingPrinciple2)[0];
            if (valuation2 != null) continue;
            Collection transactions = TransactionBO.getTransactions(asset);
            for (Transaction transaction : transactions) {
                this.createDuplicateTransactionForAP2(transaction);
            }
            this.createDuplicateValuationForAP2(valuation1);
        }
    }

    private void validatePrerequisites() throws Exception {
        String companyId = this.invokeAdapter.getCompanyId();
        if (companyId == null) {
            throw new IllegalArgumentException("Er is geen bedrijf actief !");
        }
        TransactionBatch transactionBatch = DepreciationProposalBP.getCurrentDepreciationBatch(this.invokeAdapter.getDBData(), companyId);
        if (transactionBatch != null) {
            throw new IllegalArgumentException("Er is voor dit bedrijf een voorlopig afschr. voorstel aanwezig !");
        }
        Integer batchId = this.invokeAdapter.getCompany().getCurrentBatchId();
        if (batchId != null && TransactionBO.getFirstTransaction(transactionBatch = (TransactionBatch)TransactionBatchBO.get(this.invokeAdapter.getDBData(), companyId, batchId)[0]) != null) {
            throw new IllegalArgumentException("De verzamelbatch van dit bedrijf is niet leeg !");
        }
    }

    private void createDuplicateTransactionForAP2(Transaction transaction) throws Exception {
        this.sequenceNumber = transaction.getSeqNr() + 500;
        this.objects = TransactionBO.create(transaction.getDBData(), transaction.getCompanyId(), transaction.getDocumentNr(), this.sequenceNumber, transaction.getDescription(), transaction.getCora(), transaction.getAssetId(), this.accountingPrinciple2, transaction.getMainTransactionType(), transaction.getTransactionType(), transaction.getBookYear(), transaction.getPeriod(), transaction.getBookYearForJournalization(), transaction.getPeriodForJournalization(), transaction.getAmount1(), transaction.getAmount2(), transaction.getAmount3(), this.incomingFinancialTransactionId, transaction.getFinDimId1(), transaction.getFinDimId2(), transaction.getFinDimId3(), transaction.getFinDimId4(), transaction.getFinDimId5(), this.journalingState, transaction.getReasonCode(), this.batchId, this.createdByUser, transaction.getProFormaTypeId());
        if (this.objects[0] == null) {
            String message = "Duplication of transaction failed : " + transaction.getAssetId() + "/" + transaction.getDocumentAndSequenceNumber();
            throw new IllegalArgumentException(message);
        }
        this.newTransaction = (Transaction)this.objects[0];
        this.newTransaction.setState(1);
        this.newTransaction.setInfoLevel(transaction.getInfoLevel());
        if (transaction.getRevCode() > 0) {
            this.newTransaction.setRevCode(transaction.getRevCode());
            this.newTransaction.setRevDocumentNr(transaction.getRevDocumentNr());
            this.sequenceNumber = transaction.getRevSeqNr() + 500;
            this.newTransaction.setRevSeqNr(this.sequenceNumber);
        }
        this.newTransaction.setOriginalInterestPercentage(transaction.getOriginalInterestPercentage());
    }

    private void createDuplicateValuationForAP2(Valuation valuation) throws Exception {
        this.objects = ValuationBO.create(valuation.getDBData(), valuation.getCompanyId(), valuation.getCora(), valuation.getAssetId(), this.accountingPrinciple2, valuation.getDepreciationMethod(), valuation.getDegressivePercentage(), valuation.getAnnuityInterestTableId(), valuation.getAnnuityPercentage(), valuation.getYearPercentageTableId(), valuation.getStartPeriodHandlingMethod(), valuation.getStartDepreciationBookYear(), valuation.getStartDepreciationPeriod(), valuation.getDepreciatableLife(), valuation.getResidualValue(), valuation.getResidualPercentage(), valuation.getDepreciationPaused(), valuation.getInterestCalculationMethod(), valuation.getInterestTableId(), valuation.getInterestPercentage(), valuation.getNumberOfDepreciatedPeriods(), valuation.getLastDepreciationBookYear(), valuation.getLastDepreciationPeriod(), valuation.getPostedDepreciationBalance(), valuation.getPostedAcquisitionBalance(), valuation.getCurrentBookvalueBalance(), valuation.getPreviousBookvalueBalance(), valuation.getInterestBookYear(), valuation.getInterestPeriod(), valuation.getBeyondEconomicLifePercentage());
        if (this.objects[0] == null) {
            String message = "Duplication of valuation failed : " + valuation.getAssetId();
            throw new IllegalArgumentException(message);
        }
        this.newValuation = (Valuation)this.objects[0];
        if (valuation.getDocumentNr1stTransaction() > 0) {
            this.newValuation.setDocumentNr1stTransaction(valuation.getDocumentNr1stTransaction());
            this.sequenceNumber = valuation.getSeqNr1stTransaction() + 500;
            this.newValuation.setSeqNr1stTransaction(this.sequenceNumber);
        }
        if (valuation.getLastAcquisitionBookYear() > 0) {
            this.newValuation.setLastAcquisitionBookYear(valuation.getLastAcquisitionBookYear());
            this.newValuation.setLastAcquisitionPeriod(valuation.getLastAcquisitionPeriod());
        }
    }

    @Override
    public FieldGroup getFieldGroup() throws Exception {
        return null;
    }

    @Override
    public String[] validate() throws Exception {
        return null;
    }

    @Override
    public String[] getParameterDescriptions() throws Exception {
        return null;
    }

    @Override
    public String getProgramDescription() throws Exception {
        return null;
    }

    @Override
    public String getCompletionMessage() throws Exception {
        return null;
    }

    @Override
    public boolean getAS400WriterNeeded() throws Exception {
        return true;
    }

    @Override
    public void setInvoker(FACUserToolInvokeAdapter invokeAdapter) throws Exception {
        this.invokeAdapter = invokeAdapter;
    }
}

