/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.usertool;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.IncomingFinancialTransactionBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.usertool.FACUserTool;
import nl.ibs.fac.usertool.FACUserToolInvokeAdapter;

public class BERK0001
implements FACUserTool {
    FACUserToolInvokeAdapter invokeAdapter;

    @Override
    public void execute(String[] parameterValues) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("facLib", this.invokeAdapter.getEnvironment().getFacLib());
        Collection companies = CompanyBO.getCompanies(map);
        for (Company company : companies) {
            this.updateAssets(company);
            this.updateIFTs(company);
        }
    }

    private void updateAssets(Company company) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("facLib", this.invokeAdapter.getEnvironment().getFacLib());
        map.put("Company", company.getId());
        Collection<Asset> assets = AssetBO.getAssets(map, false);
        for (Asset asset : assets) {
            String finDimId;
            if (asset.getFinDimId1() != null && asset.getFinDimId1().trim() != "") {
                finDimId = this.removeLeadingZeroes(asset.getFinDimId1());
                asset.setFinDimId1(finDimId);
            }
            if (asset.getFinDimId2() == null || asset.getFinDimId2().trim() == "") continue;
            finDimId = this.removeLeadingZeroes(asset.getFinDimId2());
            asset.setFinDimId2(finDimId);
        }
    }

    private String removeLeadingZeroes(String dimIn) throws Exception {
        String dimOut = "";
        try {
            dimOut = "" + Integer.parseInt(dimIn.trim());
        }
        catch (NumberFormatException nfe) {
            return dimIn;
        }
        switch (dimOut.trim().length()) {
            case 9: {
                return dimOut;
            }
            case 8: {
                return " " + dimOut.trim();
            }
            case 7: {
                return "  " + dimOut.trim();
            }
            case 6: {
                return "   " + dimOut.trim();
            }
            case 5: {
                return "    " + dimOut.trim();
            }
            case 4: {
                return "     " + dimOut.trim();
            }
            case 3: {
                return "      " + dimOut.trim();
            }
            case 2: {
                return "       " + dimOut.trim();
            }
            case 1: {
                return "        " + dimOut.trim();
            }
            case 0: {
                return "";
            }
        }
        return dimIn;
    }

    private void updateIFTs(Company company) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("facLib", this.invokeAdapter.getEnvironment().getFacLib());
        map.put("Company", company.getId());
        Collection ifts = IncomingFinancialTransactionBO.getIncomingFinancialTransactions(map);
        Iterator ii = ifts.iterator();
        String dim = "";
        while (ii.hasNext()) {
            IncomingFinancialTransaction ift = (IncomingFinancialTransaction)ii.next();
            if (ift.getFinDimId1() != null && ift.getFinDimId1().trim() != "") {
                dim = this.move(ift.getFinDimId1());
                ift.setFinDimId1(dim);
            }
            if (ift.getFinDimId2() != null && ift.getFinDimId2().trim() != "") {
                dim = this.move(ift.getFinDimId2());
                ift.setFinDimId2(dim);
            }
            if (ift.getFinDimId3() != null && ift.getFinDimId3().trim() != "") {
                dim = this.move(ift.getFinDimId3());
                ift.setFinDimId3(dim);
            }
            if (ift.getDaybookId() != null && ift.getDaybookId().trim() != "") {
                dim = this.move(ift.getDaybookId());
                ift.setDaybookId(dim);
            }
            if (ift.getMainAccount() == null || ift.getMainAccount().trim() == "") continue;
            dim = this.move(ift.getMainAccount());
            ift.setMainAccount(dim);
        }
    }

    private String move(String dim) throws Exception {
        switch (dim.trim().length()) {
            case 9: {
                return dim;
            }
            case 8: {
                return " " + dim.trim();
            }
            case 7: {
                return "  " + dim.trim();
            }
            case 6: {
                return "   " + dim.trim();
            }
            case 5: {
                return "    " + dim.trim();
            }
            case 4: {
                return "     " + dim.trim();
            }
            case 3: {
                return "      " + dim.trim();
            }
            case 2: {
                return "       " + dim.trim();
            }
            case 1: {
                return "        " + dim.trim();
            }
            case 0: {
                return "";
            }
        }
        return dim;
    }

    @Override
    public void setInvoker(FACUserToolInvokeAdapter invokeAdapter) throws Exception {
        this.invokeAdapter = invokeAdapter;
    }

    @Override
    public FieldGroup getFieldGroup() throws Exception {
        return null;
    }

    @Override
    public String[] validate() throws Exception {
        return null;
    }

    @Override
    public String[] getParameterDescriptions() throws Exception {
        return null;
    }

    @Override
    public String getProgramDescription() throws Exception {
        return null;
    }

    @Override
    public String getCompletionMessage() throws Exception {
        return null;
    }

    @Override
    public boolean getAS400WriterNeeded() throws Exception {
        return false;
    }
}

