/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.usertool;

import java.util.Collection;
import java.util.HashMap;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.usertool.FACUserTool;
import nl.ibs.fac.usertool.FACUserToolInvokeAdapter;

public class BERK0002
implements FACUserTool {
    FACUserToolInvokeAdapter invokeAdapter;

    @Override
    public void execute(String[] parameterValues) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("facLib", this.invokeAdapter.getEnvironment().getFacLib());
        Collection companies = CompanyBO.getCompanies(map);
        for (Company company : companies) {
            this.updateTransactions(company);
        }
    }

    private void updateTransactions(Company company) throws Exception {
        Collection transactions = TransactionBO.getTransactions(company, true);
        for (Transaction transaction : transactions) {
            String finDimId;
            if (transaction.getFinDimId1() != null && transaction.getFinDimId1().trim() != "") {
                finDimId = this.removeLeadingZeroes(transaction.getFinDimId1());
                transaction.setFinDimId1(finDimId);
            }
            if (transaction.getFinDimId2() == null || transaction.getFinDimId2().trim() == "") continue;
            finDimId = this.removeLeadingZeroes(transaction.getFinDimId2());
            transaction.setFinDimId2(finDimId);
        }
    }

    private String removeLeadingZeroes(String dimIn) throws Exception {
        String dimOut = "";
        try {
            dimOut = "" + Integer.parseInt(dimIn.trim());
        }
        catch (NumberFormatException nfe) {
            return dimIn;
        }
        switch (dimOut.trim().length()) {
            case 9: {
                return dimOut;
            }
            case 8: {
                return " " + dimOut.trim();
            }
            case 7: {
                return "  " + dimOut.trim();
            }
            case 6: {
                return "   " + dimOut.trim();
            }
            case 5: {
                return "    " + dimOut.trim();
            }
            case 4: {
                return "     " + dimOut.trim();
            }
            case 3: {
                return "      " + dimOut.trim();
            }
            case 2: {
                return "       " + dimOut.trim();
            }
            case 1: {
                return "        " + dimOut.trim();
            }
            case 0: {
                return "";
            }
        }
        return dimIn;
    }

    @Override
    public void setInvoker(FACUserToolInvokeAdapter invokeAdapter) throws Exception {
        this.invokeAdapter = invokeAdapter;
    }

    @Override
    public FieldGroup getFieldGroup() throws Exception {
        return null;
    }

    @Override
    public String[] validate() throws Exception {
        return null;
    }

    @Override
    public String[] getParameterDescriptions() throws Exception {
        return null;
    }

    @Override
    public String getProgramDescription() throws Exception {
        return null;
    }

    @Override
    public String getCompletionMessage() throws Exception {
        return null;
    }

    @Override
    public boolean getAS400WriterNeeded() throws Exception {
        return false;
    }
}

