/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.usertool;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.SCS3812Writer;
import com.ibm.as400.access.SpooledFileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import nl.ibs.esp.adapter.Adapter;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.adapters.FACAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.usertool.FACUserTool;
import nl.ibs.jsql.DBData;
import nl.ibs.util.AS400Enhanced;

public class FACUserToolInvokeAdapter
extends FACAdapter {
    private static final long serialVersionUID = -967472151154123889L;
    public static String PAGE = FACUserToolInvokeAdapter.class.getName();
    private Header header = new Header("Title.InvokeUserTool", "screen_name", null);
    private FieldGroup fieldGroup = new FieldGroup();
    private Field utilityField = new Field("Label.UserTool");
    private Field descriptionField = new Field("Label.Description");
    private FloatBar floatBar_1 = new FloatBar();
    private FloatBar floatBar_2 = new FloatBar();
    private DBData dbData = null;
    private Environment env = null;
    private String companyId = null;
    private LoginHelper loginHelper;
    private boolean as400WriterNeeded = false;
    private SCS3812Writer writer;
    private StringBuffer line = new StringBuffer();
    private String blanks = "                                                                       ";
    private FACUserTool userTool;
    private String[] parameterDescriptions;
    private int numberOfParameters = 0;
    private FieldGroup parameterPanel;
    private Field[] fields;

    public FACUserToolInvokeAdapter(DataObject object) throws Exception {
        super(object);
        this.dbData = (DBData)object.getSessionAttribute("ActiveDBData");
        this.env = (Environment)object.getSessionAttribute("ActiveEnvironment");
        this.companyId = (String)object.getSessionAttribute("ActiveCompany");
        this.loginHelper = (LoginHelper)object.getSessionAttribute(LoginHelper.LOGINHELPER);
        this.initialize();
    }

    private void initialize() throws Exception {
        this.utilityField.setMandatory(true);
        this.utilityField.setLength(50);
        this.fieldGroup.add(this.utilityField);
        this.descriptionField.setLength(50);
        this.descriptionField.setReadonly(true);
        this.descriptionField.setHidden(true);
        this.fieldGroup.add(this.descriptionField);
        Action action = new Action("Button.OK", (Adapter)this, "execute");
        action.setDefault(true);
        action.setValidationEnabled(true);
        this.floatBar_1.addAction(action);
        this.floatBar_1.addAction(this.finish);
    }

    public DataObject show(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.fieldGroup);
        object.addUIObject((UIObject)this.floatBar_1);
        return object;
    }

    public DataObject execute(DataObject object) throws Exception {
        this.numberOfParameters = 0;
        Class<?> myClass = null;
        Object myObject = null;
        try {
            myClass = Class.forName("nl.ibs.fac.usertool." + this.utilityField.getValue().trim(), true, ((Object)((Object)this)).getClass().getClassLoader());
            myObject = myClass.newInstance();
        }
        catch (Exception e) {
            object.addUIObject((UIObject)new Message("Geen geldige naam opgegeven (1)!", "error"));
            return object;
        }
        if (!(myObject instanceof FACUserTool)) {
            object.addUIObject((UIObject)new Message("Geen geldige naam opgegeven (2)!", "error"));
            return object;
        }
        this.userTool = myObject;
        this.userTool.setInvoker(this);
        if (this.userTool.getAS400WriterNeeded()) {
            this.createAS400Writer();
        }
        this.parameterPanel = this.userTool.getFieldGroup();
        if (this.parameterPanel != null) {
            return this.showParameterPanel(object);
        }
        this.parameterDescriptions = this.userTool.getParameterDescriptions();
        if (this.parameterDescriptions != null) {
            this.numberOfParameters = this.parameterDescriptions.length;
        }
        if (this.numberOfParameters > 0) {
            return this.showParameterPanel(object);
        }
        return this.executeWithoutSecondPanelDisplay(object);
    }

    private DataObject executeWithoutSecondPanelDisplay(DataObject object) throws Exception {
        String[] messageTexts = this.userTool.validate();
        if (messageTexts != null) {
            this.handleMessageTexts(object, messageTexts);
            return object;
        }
        this.userTool.execute(null);
        this.handleFirstPanel(object);
        this.floatBar_1.removeAction("Button.OK");
        this.floatBar_1.getAction("Button.Exit").setDefault(true);
        object.addUIObject((UIObject)this.floatBar_1);
        object.addUIObject((UIObject)new Message(this.getCompletionMessage(), "confirm"));
        return object;
    }

    private DataObject showParameterPanel(DataObject object) throws Exception {
        this.handleFirstPanel(object);
        if (this.numberOfParameters > 0) {
            this.parameterPanel = this.createParameterPanel();
        }
        object.addUIObject((UIObject)this.parameterPanel);
        this.floatBar_2 = new FloatBar();
        Action action = new Action("Button.OK", null, null, PAGE, "executeAfterSecondPanelDisplay");
        action.setDefault(true);
        action.setValidationEnabled(true);
        this.floatBar_2.addAction(action);
        this.floatBar_2.addAction(this.finish);
        object.addUIObject((UIObject)this.floatBar_2);
        return object;
    }

    public DataObject executeAfterSecondPanelDisplay(DataObject object) throws Exception {
        String[] messageTexts = this.userTool.validate();
        if (messageTexts != null) {
            this.handleMessageTexts(object, messageTexts);
            return object;
        }
        if (this.numberOfParameters > 0) {
            this.userTool.execute(this.getParameterValues());
        } else {
            this.userTool.execute(null);
        }
        this.parameterPanel.setReadonly();
        this.floatBar_2.removeAction("Button.OK");
        this.floatBar_2.getAction("Button.Exit").setDefault(true);
        object.addUIObject((UIObject)new Message(this.getCompletionMessage(), "confirm"));
        return object;
    }

    private FieldGroup createParameterPanel() throws Exception {
        FieldGroup parameterFG = new FieldGroup();
        this.numberOfParameters = this.parameterDescriptions.length;
        this.fields = new Field[this.numberOfParameters];
        int i = 0;
        while (i < this.numberOfParameters) {
            Field field = new Field(this.parameterDescriptions[i]);
            field.setMandatory(true);
            parameterFG.add(field);
            this.fields[i] = field;
            ++i;
        }
        return parameterFG;
    }

    private String[] getParameterValues() throws Exception {
        String[] parameterValues = new String[this.numberOfParameters];
        int i = 0;
        while (i < this.numberOfParameters) {
            Field field = this.fields[i];
            parameterValues[i] = field.getValue().trim();
            ++i;
        }
        return parameterValues;
    }

    private String getCompletionMessage() throws Exception {
        String completionMessage;
        if (this.as400WriterNeeded) {
            this.writer.close();
        }
        if ((completionMessage = this.userTool.getCompletionMessage()) == null) {
            completionMessage = "Hulpprogramma succesvol uitgevoerd . . !";
        }
        return completionMessage;
    }

    private void handleFirstPanel(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)this.header);
        this.utilityField.setReadonly(true);
        if (this.userTool.getProgramDescription() != null) {
            this.descriptionField.setValue(this.userTool.getProgramDescription());
            this.descriptionField.setHidden(false);
        }
        object.addUIObject((UIObject)this.fieldGroup);
    }

    private DataObject handleMessageTexts(DataObject object, String[] messageTexts) throws Exception {
        int i = 0;
        while (i < messageTexts.length) {
            object.addUIObject((UIObject)new Message(messageTexts[i], "error"));
            ++i;
        }
        return object;
    }

    private void createAS400Writer() throws Exception {
        AS400Enhanced as400 = this.loginHelper.getAs400();
        this.writer = new SCS3812Writer((OutputStream)new SpooledFileOutputStream((AS400)as400, null, null, null), 37, (AS400)as400);
        this.as400WriterNeeded = true;
    }

    void print(String s, int width) throws Exception {
        this.append(s, width, false);
    }

    void print(BigDecimal dec, int width) throws Exception {
        this.append(dec == null ? "0" : dec.toString(), width, true);
    }

    void print(boolean b, int width) throws Exception {
        this.append(b ? "Ja" : "Nee", width, false);
    }

    void printBoolean(boolean b, int width) throws Exception {
        this.append(b ? "1" : "0", width, false);
    }

    private void append(String s, int width, boolean rightAlign) throws Exception {
        String fld;
        if (s == null) {
            s = "";
        }
        if (rightAlign) {
            fld = String.valueOf(this.blanks) + s;
            fld = fld.substring(fld.length() - width);
        } else {
            fld = String.valueOf(s) + this.blanks;
            fld = fld.substring(0, width);
        }
        this.line.append(fld);
    }

    void printLine() throws Exception {
        this.writer.write(this.line.toString());
        this.writer.newLine();
        this.line = new StringBuffer();
    }

    LoginHelper getLoginHelper() throws Exception {
        return this.loginHelper;
    }

    Environment getEnvironment() throws Exception {
        return this.env;
    }

    DBData getDBData() throws Exception {
        return this.dbData;
    }

    String getCompanyId() throws Exception {
        return this.companyId;
    }

    Company getCompany() throws Exception {
        return (Company)CompanyBO.get(this.dbData, this.companyId)[0];
    }

    public String getDescription() {
        return this.translate("Process.InvokeUserTool");
    }

    public String getShortDescription() {
        return "Process.InvokeUserTool.short";
    }

    public String getProcessIconUrl() {
        return "brick_go.png";
    }
}

