/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.usertool;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.usertool.FACUserTool;
import nl.ibs.fac.usertool.FACUserToolInvokeAdapter;

public class GLComp02
implements FACUserTool {
    FACUserToolInvokeAdapter invokeAdapter;

    @Override
    public void execute(String[] parameterValues) throws Exception {
        if (this.invokeAdapter.getCompanyId() == null) {
            throw new IllegalArgumentException("Er is geen bedrijf actief !");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("facLib", this.invokeAdapter.getEnvironment().getFacLib());
        map.put("Company", this.invokeAdapter.getCompanyId());
        Collection<Asset> assets = AssetBO.getAssets(map, false);
        for (Asset asset : assets) {
            Collection valuations = asset.getValuationsCollection(null);
            for (Valuation valuation : valuations) {
                Collection transactions = TransactionBO.getTransactions(valuation, true);
                Iterator ti = transactions.iterator();
                BigDecimal totalAmount1 = new BigDecimal("0.00");
                BigDecimal totalAmount2 = new BigDecimal("0.00");
                while (ti.hasNext()) {
                    Transaction transaction = (Transaction)ti.next();
                    totalAmount1 = totalAmount1.add(transaction.getAmount1());
                    totalAmount2 = totalAmount2.add(transaction.getAmount2());
                }
                if (totalAmount1.compareTo(valuation.getPostedAcquisitionBalance()) == 0 && totalAmount2.compareTo(valuation.getPostedDepreciationBalance()) == 0) continue;
                System.out.println(String.valueOf(asset.getId()) + "\t" + valuation.getAccountingPrinciple() + "\t" + totalAmount1 + "\t" + valuation.getPostedAcquisitionBalance() + "\t" + totalAmount2 + "\t" + valuation.getPostedDepreciationBalance());
            }
        }
    }

    @Override
    public void setInvoker(FACUserToolInvokeAdapter invokeAdapter) throws Exception {
        this.invokeAdapter = invokeAdapter;
    }

    @Override
    public FieldGroup getFieldGroup() throws Exception {
        return null;
    }

    @Override
    public String[] validate() throws Exception {
        return null;
    }

    @Override
    public String[] getParameterDescriptions() throws Exception {
        return null;
    }

    @Override
    public String getProgramDescription() throws Exception {
        return null;
    }

    @Override
    public String getCompletionMessage() throws Exception {
        return null;
    }

    @Override
    public boolean getAS400WriterNeeded() throws Exception {
        return false;
    }
}

