/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.usertool;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.adapters.AssetReferenceField;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.usertool.FACUserTool;
import nl.ibs.fac.usertool.FACUserToolInvokeAdapter;

public class MIGR0004
implements FACUserTool {
    FieldGroup panel = new FieldGroup("");
    AssetReferenceField[] assetIds = new AssetReferenceField[10];
    Field[] docNbrsFrom = new Field[10];
    Field[] seqNbrsFrom = new Field[10];
    Field[] docNbrsTo = new Field[10];
    Field[] seqNbrsTo = new Field[10];
    Field[] accountingPrinciples = new Field[10];
    CheckBox[] successes = new CheckBox[10];
    int deletedTransactions;
    int involvedAssets = 0;
    FACUserToolInvokeAdapter invokeAdapter;

    @Override
    public void execute(String[] parameterValues) throws Exception {
        int i = 0;
        while (i < 10) {
            boolean validationOK;
            Collection transactions;
            Valuation valuation;
            if (!this.assetIds[i].getValue().trim().equals("") && (valuation = (Valuation)ValuationBO.getValuation(this.invokeAdapter.getDBData(), this.invokeAdapter.getCompanyId(), "A", this.assetIds[i].getValue().trim(), Integer.parseInt(this.accountingPrinciples[i].getValue().trim()))[0]) != null && !(transactions = this.retrieveTransactionCollection(valuation, Integer.parseInt(this.docNbrsFrom[i].getValue().trim()), Integer.parseInt(this.seqNbrsFrom[i].getValue().trim()), Integer.parseInt(this.docNbrsTo[i].getValue().trim()), Integer.parseInt(this.seqNbrsTo[i].getValue().trim()))).isEmpty() && (validationOK = this.validateTransactions(transactions))) {
                this.deleteTransactions(transactions);
                this.successes[i].setValue(true);
            }
            ++i;
        }
    }

    private Collection retrieveTransactionCollection(Valuation valuation, int docNbrFrom, int seqNbrFrom, int docNbrTo, int seqNbrTo) throws Exception {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        Collection allTransactions = TransactionBO.getTransactions(valuation, true);
        if (allTransactions != null && !allTransactions.isEmpty()) {
            for (Transaction transaction : allTransactions) {
                if (transaction.getDocumentNr() < docNbrFrom || transaction.getDocumentNr() == docNbrFrom && transaction.getSeqNr() < seqNbrFrom || transaction.getDocumentNr() > docNbrTo || transaction.getDocumentNr() == docNbrTo && transaction.getSeqNr() > seqNbrTo) continue;
                transactions.add(transaction);
            }
        }
        return transactions;
    }

    private boolean validateTransactions(Collection transactions) throws Exception {
        boolean result = false;
        BigDecimal totalAmount1 = new BigDecimal("0");
        BigDecimal totalAmount2 = new BigDecimal("0");
        BigDecimal totalAmount3 = new BigDecimal("0");
        for (Transaction transaction : transactions) {
            totalAmount1 = totalAmount1.add(transaction.getAmount1());
            totalAmount2 = totalAmount2.add(transaction.getAmount2());
            totalAmount3 = totalAmount3.add(transaction.getAmount3());
        }
        if (totalAmount1.doubleValue() == 0.0 && totalAmount2.doubleValue() == 0.0 && totalAmount3.doubleValue() == 0.0) {
            result = true;
        }
        return result;
    }

    private void deleteTransactions(Collection transactions) throws Exception {
        ++this.involvedAssets;
        for (Transaction transaction : transactions) {
            transaction.delete();
            ++this.deletedTransactions;
        }
    }

    @Override
    public void setInvoker(FACUserToolInvokeAdapter invokeAdapter) throws Exception {
        this.invokeAdapter = invokeAdapter;
    }

    @Override
    public FieldGroup getFieldGroup() throws Exception {
        ESPGridLayout gridLayout = new ESPGridLayout();
        this.panel.add(gridLayout);
        gridLayout.add((UIObject)new Label("Activum"), 0, 0);
        gridLayout.add((UIObject)new Label("Transactie vanaf"), 0, 1);
        gridLayout.add((UIObject)new Label(""), 0, 2);
        gridLayout.add((UIObject)new Label("Transactie t/m"), 0, 3);
        gridLayout.add((UIObject)new Label(""), 0, 4);
        gridLayout.add((UIObject)new Label("VGS"), 0, 5);
        gridLayout.add((UIObject)new Label("OK"), 0, 6);
        int i = 0;
        while (i < 10) {
            this.assetIds[i] = new AssetReferenceField(this.invokeAdapter.getCompany(), new Boolean(true), new Boolean(true), true, false);
            this.assetIds[i].setLabel("");
            this.assetIds[i].showDescription(false);
            gridLayout.add((UIObject)this.assetIds[i], i + 1, 0);
            this.docNbrsFrom[i] = new Field("", "number");
            gridLayout.add((UIObject)this.docNbrsFrom[i], i + 1, 1);
            this.seqNbrsFrom[i] = new Field("", "number");
            this.seqNbrsFrom[i].setLength(3);
            this.seqNbrsFrom[i].setValue("1");
            gridLayout.add((UIObject)this.seqNbrsFrom[i], i + 1, 2);
            this.docNbrsTo[i] = new Field("", "number");
            gridLayout.add((UIObject)this.docNbrsTo[i], i + 1, 3);
            this.seqNbrsTo[i] = new Field("", "number");
            this.seqNbrsTo[i].setLength(3);
            this.seqNbrsTo[i].setValue("1");
            gridLayout.add((UIObject)this.seqNbrsTo[i], i + 1, 4);
            this.accountingPrinciples[i] = new Field("", "number");
            this.accountingPrinciples[i].setLength(1);
            this.accountingPrinciples[i].setValue("1");
            gridLayout.add((UIObject)this.accountingPrinciples[i], i + 1, 5);
            this.successes[i] = new CheckBox();
            this.successes[i].setReadonly(true);
            gridLayout.add((UIObject)this.successes[i], i + 1, 6);
            ++i;
        }
        return this.panel;
    }

    @Override
    public String[] validate() throws Exception {
        return null;
    }

    @Override
    public String[] getParameterDescriptions() throws Exception {
        return null;
    }

    @Override
    public String getProgramDescription() throws Exception {
        return "Verwijderen activatransacties";
    }

    @Override
    public String getCompletionMessage() throws Exception {
        String s1 = "zijn ";
        String s2 = " transacties";
        String s3 = " activa.";
        if (this.deletedTransactions == 1) {
            s1 = "is ";
            s2 = " transactie";
        }
        if (this.involvedAssets == 1) {
            s3 = " activum.";
        }
        String message = "Er " + s1 + this.deletedTransactions + s2 + " verwijderd m.b.t. " + this.involvedAssets + s3;
        return message;
    }

    @Override
    public boolean getAS400WriterNeeded() throws Exception {
        return false;
    }
}

