/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.usertool;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.usertool.FACUserTool;
import nl.ibs.fac.usertool.FACUserToolInvokeAdapter;

public class MIGR0007
implements FACUserTool {
    FACUserToolInvokeAdapter invokeAdapter;

    @Override
    public String[] getParameterDescriptions() throws Exception {
        return null;
    }

    @Override
    public void execute(String[] parameterValues) throws Exception {
        if (this.invokeAdapter.getCompanyId() == null) {
            throw new IllegalArgumentException("Er is geen bedrijf actief !");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("facLib", this.invokeAdapter.getEnvironment().getFacLib());
        map.put("Company", this.invokeAdapter.getCompanyId());
        Collection<Asset> assets = AssetBO.getAssets(map, false);
        for (Asset asset : assets) {
            Collection valuations = asset.getValuationsCollection(null);
            for (Valuation valuation : valuations) {
                if (valuation.getNumberOfDepreciatedPeriods() == valuation.getDepreciatableLife()) {
                    valuation.setPreviousBookvalueBalance(new BigDecimal("0.00"));
                }
                if (valuation.getDepreciationMethod() != 99 || valuation.getInterestCalculationMethod() == 0) continue;
                Collection transactions = TransactionBO.getTransactions(valuation, true);
                Iterator ti = transactions.iterator();
                int year = 0;
                int period = 0;
                while (ti.hasNext()) {
                    Transaction transaction = (Transaction)ti.next();
                    if (transaction.getMainTransactionType() != 3 || transaction.getTransactionType() != 70 && transaction.getTransactionType() != 71 || !PeriodHelper.isAfter(transaction.getBookYear(), transaction.getPeriod(), year, period)) continue;
                    year = transaction.getBookYear();
                    period = transaction.getPeriod();
                }
                valuation.setLastDepreciationBookYear(year);
                valuation.setLastDepreciationPeriod(period);
            }
        }
    }

    @Override
    public FieldGroup getFieldGroup() throws Exception {
        return null;
    }

    @Override
    public String[] validate() throws Exception {
        return null;
    }

    @Override
    public String getProgramDescription() throws Exception {
        return null;
    }

    @Override
    public String getCompletionMessage() throws Exception {
        return null;
    }

    @Override
    public boolean getAS400WriterNeeded() throws Exception {
        return true;
    }

    @Override
    public void setInvoker(FACUserToolInvokeAdapter invokeAdapter) throws Exception {
        this.invokeAdapter = invokeAdapter;
    }
}

