/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.usertool;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.usertool.FACUserTool;
import nl.ibs.fac.usertool.FACUserToolInvokeAdapter;

public class OSG
implements FACUserTool {
    FACUserToolInvokeAdapter invokeAdapter;
    Vector assetIds = new Vector();

    @Override
    public void execute(String[] parameterValues) throws Exception {
        if (this.invokeAdapter.getCompanyId() == null) {
            throw new IllegalArgumentException("Er is geen bedrijf actief !");
        }
        this.handleCurrenCapitalization();
        this.handleDisinvestment();
        this.handleMovementIC();
        this.handleDoubleDisinvestment();
    }

    private void handleCurrenCapitalization() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("facLib", this.invokeAdapter.getEnvironment().getFacLib());
        map.put("Company", this.invokeAdapter.getCompanyId());
        map.put("currentCapitalization", "");
        Collection<Asset> assets = AssetBO.getAssets(map, false);
        for (Asset asset : assets) {
            Collection valuations = asset.getValuationsCollection(null);
            block1: for (Valuation valuation : valuations) {
                Collection transactions = TransactionBO.getTransactions(valuation, true);
                Iterator ti = transactions.iterator();
                Transaction firstTransaction = null;
                while (ti.hasNext()) {
                    Transaction secondTransaction = (Transaction)ti.next();
                    if (firstTransaction == null) {
                        firstTransaction = secondTransaction;
                        continue;
                    }
                    if (firstTransaction.getMainTransactionType() != 1 || secondTransaction.getMainTransactionType() != 3 || !firstTransaction.getDescription().trim().equals(secondTransaction.getDescription().trim())) continue block1;
                    firstTransaction.setAmount2(firstTransaction.getAmount2().add(secondTransaction.getAmount2()));
                    secondTransaction.delete();
                    continue block1;
                }
            }
        }
    }

    private void handleDisinvestment() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("facLib", this.invokeAdapter.getEnvironment().getFacLib());
        map.put("Company", this.invokeAdapter.getCompanyId());
        Collection<Asset> assets = AssetBO.getAssets(map, false);
        for (Asset asset : assets) {
            if (asset.getState() != 4) continue;
            Collection valuations = asset.getValuationsCollection(null);
            block1: for (Valuation valuation : valuations) {
                Collection transactions = TransactionBO.getTransactions(valuation, true);
                Iterator ti = transactions.iterator();
                Transaction firstTransaction = null;
                while (ti.hasNext()) {
                    Transaction secondTransaction = (Transaction)ti.next();
                    if (firstTransaction == null) {
                        if (secondTransaction.getMainTransactionType() != 2 || secondTransaction.getTransactionType() != 30) continue;
                        firstTransaction = secondTransaction;
                        continue;
                    }
                    if (secondTransaction.getMainTransactionType() != 3 || secondTransaction.getTransactionType() != 70 || !firstTransaction.getDescription().trim().equals(secondTransaction.getDescription().trim())) continue block1;
                    firstTransaction.setAmount2(firstTransaction.getAmount2().add(secondTransaction.getAmount2()));
                    secondTransaction.delete();
                    continue block1;
                }
            }
        }
    }

    private void handleMovementIC() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("facLib", this.invokeAdapter.getEnvironment().getFacLib());
        map.put("Company", this.invokeAdapter.getCompanyId());
        Collection<Asset> assets = AssetBO.getAssets(map, false);
        for (Asset asset : assets) {
            if (asset.getState() != 5) continue;
            Collection valuations = asset.getValuationsCollection(null);
            block1: for (Valuation valuation : valuations) {
                Collection transactions = TransactionBO.getTransactions(valuation, true);
                Iterator ti = transactions.iterator();
                Transaction firstTransaction = null;
                while (ti.hasNext()) {
                    Transaction secondTransaction = (Transaction)ti.next();
                    if (firstTransaction == null) {
                        if (secondTransaction.getMainTransactionType() != 2 || secondTransaction.getTransactionType() != 50) continue;
                        firstTransaction = secondTransaction;
                        continue;
                    }
                    if (secondTransaction.getMainTransactionType() != 3 || secondTransaction.getTransactionType() != 70 || !firstTransaction.getDescription().trim().equals(secondTransaction.getDescription().trim())) continue block1;
                    firstTransaction.setAmount2(firstTransaction.getAmount2().add(secondTransaction.getAmount2()));
                    secondTransaction.delete();
                    continue block1;
                }
            }
        }
    }

    private void handleDoubleDisinvestment() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("facLib", this.invokeAdapter.getEnvironment().getFacLib());
        map.put("Company", this.invokeAdapter.getCompanyId());
        Collection<Asset> assets = AssetBO.getAssets(map, false);
        block0: for (Asset asset : assets) {
            if (asset.getState() != 4) continue;
            Collection valuations = asset.getValuationsCollection(null);
            Iterator vi = valuations.iterator();
            boolean firstValuation = true;
            while (vi.hasNext()) {
                if (!firstValuation) continue block0;
                firstValuation = false;
                Valuation valuation = (Valuation)vi.next();
                Collection transactions = TransactionBO.getTransactions(valuation, true);
                Iterator ti = transactions.iterator();
                int count = 0;
                while (ti.hasNext()) {
                    Transaction transaction = (Transaction)ti.next();
                    if (transaction.getMainTransactionType() != 3 || transaction.getTransactionType() != 30) continue;
                    ++count;
                }
                if (count <= true) continue;
                this.assetIds.add(asset.getId());
            }
        }
    }

    @Override
    public FieldGroup getFieldGroup() throws Exception {
        return null;
    }

    @Override
    public String[] validate() throws Exception {
        return null;
    }

    @Override
    public String[] getParameterDescriptions() throws Exception {
        return null;
    }

    @Override
    public String getProgramDescription() throws Exception {
        return null;
    }

    @Override
    public String getCompletionMessage() throws Exception {
        if (this.assetIds.isEmpty()) {
            return null;
        }
        String completionMessage = "";
        String assetId = "";
        int i = 0;
        while (i < this.assetIds.size()) {
            assetId = (String)this.assetIds.get(i);
            completionMessage = String.valueOf(completionMessage) + assetId.trim() + " ";
            ++i;
        }
        completionMessage = String.valueOf(completionMessage) + "!!!";
        return completionMessage;
    }

    @Override
    public boolean getAS400WriterNeeded() throws Exception {
        return false;
    }

    @Override
    public void setInvoker(FACUserToolInvokeAdapter invokeAdapter) throws Exception {
        this.invokeAdapter = invokeAdapter;
    }
}

