/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.impl.ConcurrentHashMap;

public class Cache {
    private static long lookups;
    private static long hits;
    protected static boolean printCacheStatistics;
    private ConcurrentHashMap cache = new ConcurrentHashMap();

    static {
        printCacheStatistics = DBConfig.getPrintCacheStatistics();
    }

    public Object cache(Object o) {
        if (o == null) {
            return o;
        }
        Integer key = new Integer(o.hashCode());
        Object c = this.cache.get(key);
        if (c != null) {
            return c;
        }
        this.cache.put(key, o);
        return o;
    }

    public void removeFromCache(Collection c) {
        if (c == null || c.isEmpty()) {
            return;
        }
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.cache.remove(it.next());
        }
    }

    public void removeFromCache(Object o) {
        if (this.cache == null || o == null) {
            return;
        }
        this.cache.remove(o instanceof Integer ? o : new Integer(o.hashCode()));
    }

    public Object get(Object o) {
        Object c;
        Object object = this.cache == null || o == null ? null : (c = this.cache.get(o instanceof Integer ? o : new Integer(o.hashCode())));
        if (printCacheStatistics) {
            long l = hits = c != null ? hits + 1L : hits;
            if (++lookups % 1000L == 0L) {
                Log.info((String)("Hit ratio: " + hits * 100L / lookups + "%. (" + lookups + " lookups," + hits + " hits)"));
            }
        }
        return c;
    }

    public int size() {
        return this.cache == null ? 0 : this.cache.size();
    }

    public void clear() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    public Collection values() {
        return this.cache == null ? new ArrayList() : this.cache.values();
    }
}

