/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.UserSetting;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBConnectionPool;
import nl.ibs.jsql.sql.TableDefinition;
import nl.ibs.vegas.Setting;
import nl.ibs.vegas.SettingsStore;

public class UserSettings
implements SettingsStore {
    private static final long serialVersionUID = 1L;
    private static final short MAX_VALUE_LENGTH = 253;
    private static final String IGNORE = "--1";
    private static final String TABLE = "JSQLUSRST";
    private static final String USER = "US_USER";
    private static final String CONTEXT = "US_CONTEXT";
    private static final String FUNCTION = "US_FUNCTN";
    private static final String TYPE = "US_TYPE";
    private static final String KEY1 = "US_KEY1";
    private static final String KEY2 = "US_KEY2";
    private static final String KEY3 = "US_KEY3";
    private static final String VALUE = "US_VALUE";
    private static final String SEQUENCE_NUMBER = "US_SQNCNBR";
    private static final String USERTYPE = "US_USRTYPE";
    private static final String USEREDIT = "US_USREDIT";
    private static final ArrayList EMPTY_LIST = new ArrayList(0){
        private static final long serialVersionUID = 1L;

        @Override
        public void add(int index, Object element) {
        }

        @Override
        public boolean add(Object o) {
            return false;
        }

        @Override
        public boolean addAll(Collection c) {
            return false;
        }

        @Override
        public boolean addAll(int index, Collection c) {
            return false;
        }
    };
    private static HashSet checkedDBData = new HashSet(1);
    private static HashMap cache = new HashMap(1);
    private static HashMap usersSettings = new HashMap();
    private DBData dBData;
    private String[] users;
    private String context;
    private boolean ignoreContext = false;
    private IgnoreContextProvider ignoreContextProvider;
    private StringBuffer buffer = new StringBuffer();

    public UserSettings(String application, String[] users) throws Exception {
        this(DBData.getDefaultDBData(application), users, null);
    }

    public UserSettings(String application, String user) throws Exception {
        this(DBData.getDefaultDBData(application), user, null);
    }

    public UserSettings(String application, String[] users, String context) throws Exception {
        this(DBData.getDefaultDBData(application), users, context);
    }

    public UserSettings(String application, String user, String context) throws Exception {
        this(DBData.getDefaultDBData(application), user, context);
    }

    public UserSettings(DBData dbData, String[] users) throws Exception {
        this(dbData, users, null);
    }

    public UserSettings(DBData dbData, String user) throws Exception {
        this(dbData, user, null);
    }

    public UserSettings(DBData dbData, String user, String context) throws Exception {
        this(dbData, new String[]{user}, context);
    }

    public UserSettings(DBData dbData, String[] users, String context) throws Exception {
        if (dbData == null) {
            throw new IllegalArgumentException("Tried to instantiate UserSettingsManagerOld with DBData == null!");
        }
        this.dBData = dbData;
        this.users = users;
        this.context = context;
        this.checkDB();
    }

    private void checkDB() throws Exception {
        if (!checkedDBData.contains(this.dBData)) {
            TableDefinition tableDefinition;
            DBConnection dbc;
            ConnectionProvider provider;
            block49: {
                HashMap columnDefinitions;
                block47: {
                    boolean exists;
                    block44: {
                        provider = this.getConnectionProvider();
                        this.buffer.setLength(0);
                        Statement stat = null;
                        exists = false;
                        this.buffer.append("SELECT * FROM ");
                        this.appendTableName(provider, this.buffer);
                        dbc = provider.getConnection();
                        ResultSet rs = null;
                        try {
                            try {
                                Connection con = dbc.getConnection();
                                stat = con.createStatement();
                                stat.setMaxRows(1);
                                rs = stat.executeQuery(this.buffer.toString());
                                rs.next();
                                exists = true;
                            }
                            catch (SQLException e) {
                                exists = false;
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (stat != null) {
                                    try {
                                        stat.close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                provider.returnConnection(dbc);
                                break block44;
                            }
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (stat != null) {
                                try {
                                    stat.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            provider.returnConnection(dbc);
                            throw throwable;
                        }
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (stat != null) {
                            try {
                                stat.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        provider.returnConnection(dbc);
                    }
                    if (!exists) {
                        this.buffer.setLength(0);
                        this.buffer.append("CREATE TABLE ");
                        this.appendTableName(provider, this.buffer);
                        this.buffer.append(" (");
                        this.buffer.append(UserSettings.getFieldName(provider, "user", USER));
                        this.buffer.append(" ");
                        this.buffer.append(provider.getDBMapping().getSQLDefinition("String", 35, 0));
                        this.buffer.append("\t,");
                        this.buffer.append(UserSettings.getFieldName(provider, "context", CONTEXT));
                        this.buffer.append(" ");
                        this.buffer.append(provider.getDBMapping().getSQLDefinition("String", 35, 0));
                        this.buffer.append("\t,");
                        this.buffer.append(UserSettings.getFieldName(provider, "function", FUNCTION));
                        this.buffer.append(" ");
                        this.buffer.append(provider.getDBMapping().getSQLDefinition("String", 50, 0));
                        this.buffer.append("\t,");
                        this.buffer.append(UserSettings.getFieldName(provider, "type", TYPE));
                        this.buffer.append(" ");
                        this.buffer.append(provider.getDBMapping().getSQLDefinition("String", 2, 0));
                        this.buffer.append("\t,");
                        this.buffer.append(UserSettings.getFieldName(provider, "key1", KEY1));
                        this.buffer.append(" ");
                        this.buffer.append(provider.getDBMapping().getSQLDefinition("String", 35, 0));
                        this.buffer.append("\t,");
                        this.buffer.append(UserSettings.getFieldName(provider, "key2", KEY2));
                        this.buffer.append(" ");
                        this.buffer.append(provider.getDBMapping().getSQLDefinition("String", 35, 0));
                        this.buffer.append("\t,");
                        this.buffer.append(UserSettings.getFieldName(provider, "key3", KEY3));
                        this.buffer.append(" ");
                        this.buffer.append(provider.getDBMapping().getSQLDefinition("String", 35, 0));
                        this.buffer.append("\t,");
                        this.buffer.append(UserSettings.getFieldName(provider, "value", VALUE));
                        this.buffer.append(" ");
                        this.buffer.append(provider.getDBMapping().getSQLDefinition("String", 255, 0));
                        this.buffer.append("\t,");
                        this.buffer.append(UserSettings.getFieldName(provider, "sequenceNumber", SEQUENCE_NUMBER));
                        this.buffer.append(" ");
                        this.buffer.append(provider.getDBMapping().getSQLDefinition("int", 3, 0));
                        this.buffer.append("\t");
                        this.buffer.append(")");
                        dbc = provider.getConnection();
                        try {
                            dbc.executeUpdate(this.buffer.toString());
                        }
                        finally {
                            provider.returnConnection(dbc);
                        }
                    }
                    if (!(columnDefinitions = (tableDefinition = (TableDefinition)TableDefinition.getTableDefinitions(TABLE, new String[]{"TABLE"}, DBConnectionPool.getInstance(this.dBData)).get(TABLE)).getColumnDefinitions()).containsKey(USERTYPE)) {
                        this.buffer.setLength(0);
                        this.buffer.append("ALTER TABLE ");
                        this.appendTableName(provider, this.buffer);
                        this.buffer.append(" ADD COLUMN ");
                        this.buffer.append(UserSettings.getFieldName(provider, "userType", USERTYPE));
                        this.buffer.append(" ");
                        this.buffer.append(provider.getDBMapping().getSQLDefinition("String", 2, 0));
                        this.buffer.append(" NOT NULL DEFAULT 'U'");
                        dbc = provider.getConnection();
                        try {
                            try {
                                dbc.executeUpdate(this.buffer.toString());
                            }
                            catch (SQLException e) {
                                if (e.getMessage().indexOf("SQL0612") == -1) {
                                    throw e;
                                }
                                provider.returnConnection(dbc);
                                break block47;
                            }
                        }
                        catch (Throwable throwable) {
                            provider.returnConnection(dbc);
                            throw throwable;
                        }
                        provider.returnConnection(dbc);
                    }
                }
                if (!columnDefinitions.containsKey(USEREDIT)) {
                    this.buffer.setLength(0);
                    this.buffer.append("ALTER TABLE ");
                    this.appendTableName(provider, this.buffer);
                    this.buffer.append(" ADD COLUMN ");
                    this.buffer.append(UserSettings.getFieldName(provider, "userEdit", USEREDIT));
                    this.buffer.append(" ");
                    this.buffer.append(provider.getDBMapping().getSQLDefinition("boolean", 0, 0));
                    this.buffer.append(" NOT NULL DEFAULT 'true'");
                    dbc = provider.getConnection();
                    try {
                        try {
                            dbc.executeUpdate(this.buffer.toString());
                        }
                        catch (SQLException e) {
                            if (e.getMessage().indexOf("SQL0612") == -1) {
                                throw e;
                            }
                            provider.returnConnection(dbc);
                            break block49;
                        }
                    }
                    catch (Throwable throwable) {
                        provider.returnConnection(dbc);
                        throw throwable;
                    }
                    provider.returnConnection(dbc);
                }
            }
            if (tableDefinition.getIndexDefinitions().isEmpty()) {
                dbc = provider.getConnection();
                this.buffer.setLength(0);
                this.buffer.append("CREATE UNIQUE INDEX ");
                this.buffer.append(provider.getPrefix());
                this.buffer.append("JSQL_UC_");
                this.buffer.append(TABLE);
                this.buffer.append(" ON ");
                this.appendTableName(provider, this.buffer);
                this.buffer.append("(US_USER, US_CONTEXT, US_FUNCTN, US_TYPE, US_KEY1, US_KEY2, US_KEY3, US_SQNCNBR)");
                try {
                    dbc.executeUpdate(this.buffer.toString());
                }
                finally {
                    provider.returnConnection(dbc);
                }
            }
            checkedDBData.add(this.dBData);
        }
    }

    public void setUsers(String[] users) {
        this.users = users;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getContext() {
        return this.context;
    }

    public String getUser() {
        return this.users != null && this.users.length > 0 ? this.users[0] : "";
    }

    public String[] getUsers() {
        return this.users;
    }

    public void remove() throws Exception {
        this.delete(IGNORE, IGNORE, IGNORE, IGNORE, IGNORE);
    }

    public void remove(String function) throws Exception {
        this.delete(function, IGNORE, IGNORE, IGNORE, IGNORE);
    }

    public void remove(String function, String type) throws Exception {
        this.delete(function, type, IGNORE, IGNORE, IGNORE);
    }

    public void remove(String function, String type, String key1) throws Exception {
        this.delete(function, type, key1, IGNORE, IGNORE);
    }

    public void remove(String function, String type, String key1, String key2) throws Exception {
        this.delete(function, type, key1, key2, IGNORE);
    }

    public void remove(String function, String type, String key1, String key2, String key3) throws Exception {
        this.delete(function, type, key1, key2, key3);
    }

    public int delete(String function, String type, String key1, String key2, String key3) throws Exception {
        return this.delete(function, type, key1, key2, key3, this.getIgnoreContext(function, type, key1, key2, key3));
    }

    public void remove(boolean ignoreContext) throws Exception {
        this.delete(IGNORE, IGNORE, IGNORE, IGNORE, IGNORE, ignoreContext);
    }

    public void remove(String function, boolean ignoreContext) throws Exception {
        this.delete(function, IGNORE, IGNORE, IGNORE, IGNORE, ignoreContext);
    }

    public void remove(String function, String type, boolean ignoreContext) throws Exception {
        this.delete(function, type, IGNORE, IGNORE, IGNORE, ignoreContext);
    }

    public void remove(String function, String type, String key1, boolean ignoreContext) throws Exception {
        this.delete(function, type, key1, IGNORE, IGNORE, ignoreContext);
    }

    public void remove(String function, String type, String key1, String key2, boolean ignoreContext) throws Exception {
        this.delete(function, type, key1, key2, IGNORE, ignoreContext);
    }

    public void remove(String function, String type, String key1, String key2, String key3, boolean ignoreContext) throws Exception {
        this.delete(function, type, key1, key2, key3, ignoreContext);
    }

    public int delete(String function, String type, String key1, String key2, String key3, boolean ignoreContext) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBConnection dbc = provider.getConnection();
        this.buffer.setLength(0);
        try {
            this.buffer.append("DELETE FROM ");
            this.appendTableName(provider, this.buffer);
            this.buffer.append(" WHERE ");
            int startWhere = this.buffer.length();
            this.appendGeneralFilterClause(provider, this.buffer, this.users[0], startWhere, ignoreContext);
            UserSettings.appendWhere(this.buffer, startWhere, provider, "function", FUNCTION, function, true);
            UserSettings.appendWhere(this.buffer, startWhere, provider, "type", TYPE, type, true);
            UserSettings.appendWhere(this.buffer, startWhere, provider, "key1", KEY1, key1, true);
            UserSettings.appendWhere(this.buffer, startWhere, provider, "key2", KEY2, key2, true);
            UserSettings.appendWhere(this.buffer, startWhere, provider, "key3", KEY3, key3, true);
            int result = dbc.executeUpdate(this.buffer.toString());
            if (result > 0) {
                this.clearCache(this.users[0]);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    public ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dBData);
    }

    public void setValue(String value, String function, String type) throws Exception {
        this.setValue(value, function, type, IGNORE, IGNORE, IGNORE);
    }

    public void setValue(String value, String function, String type, String key1) throws Exception {
        this.setValue(value, function, type, key1, IGNORE, IGNORE);
    }

    public void setValue(String value, String function, String type, String key1, String key2) throws Exception {
        this.setValue(value, function, type, key1, key2, IGNORE);
    }

    public void setValue(String value, String function, String type, String key1, String key2, String key3) throws Exception {
        this.setValue(value, function, type, key1, key2, key3, this.getIgnoreContext(function, type, key1, key2, key3));
    }

    protected boolean getIgnoreContext(String function, String type, String key1, String key2, String key3) {
        if (this.ignoreContextProvider != null) {
            return this.ignoreContextProvider.getIgnoreContext(function, type, key1, key2, key3);
        }
        return this.ignoreContext;
    }

    public void setValue(String value, String function, String type, boolean ignoreContext) throws Exception {
        this.setValue(value, function, type, IGNORE, IGNORE, IGNORE, ignoreContext);
    }

    public void setValue(String value, String function, String type, String key1, boolean ignoreContext) throws Exception {
        this.setValue(value, function, type, key1, IGNORE, IGNORE, ignoreContext);
    }

    public void setValue(String value, String function, String type, String key1, String key2, boolean ignoreContext) throws Exception {
        this.setValue(value, function, type, key1, key2, IGNORE, ignoreContext);
    }

    public void setValue(String value, String function, String type, String key1, String key2, String key3, boolean ignoreContext) throws Exception {
        this.remove(function, type, key1, key2, key3, ignoreContext);
        if (value == null) {
            return;
        }
        String[] values = this.getStringArray(value);
        ConnectionProvider provider = this.getConnectionProvider();
        DBConnection dbc = provider.getConnection();
        this.buffer.setLength(0);
        try {
            this.buffer.append("INSERT INTO ");
            this.appendTableName(provider, this.buffer);
            this.buffer.append(" VALUES ");
            int i = 0;
            while (i < values.length) {
                this.buffer.append(i > 0 ? ",(" : "(");
                UserSettings.appendValue(this.buffer, this.users[0], ",");
                UserSettings.appendValue(this.buffer, ignoreContext ? null : this.context, ",");
                UserSettings.appendValue(this.buffer, function, ",");
                UserSettings.appendValue(this.buffer, type, ",");
                UserSettings.appendValue(this.buffer, key1, ",");
                UserSettings.appendValue(this.buffer, key2, ",");
                UserSettings.appendValue(this.buffer, key3, ",");
                UserSettings.appendValue(this.buffer, values[i], ",");
                UserSettings.appendValue(this.buffer, i, ",");
                UserSettings.appendValue(this.buffer, "U", ",");
                UserSettings.appendValue(this.buffer, "true", ")");
                ++i;
            }
            dbc.executeUpdate(this.buffer.toString());
            this.clearCache(this.users[0]);
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    private static final void appendValue(StringBuffer buffer, String value, String separator) {
        if (value == null || value == IGNORE) {
            buffer.append("NULL");
        } else {
            buffer.append("'");
            UserSettings.escapeSingleQuotes(buffer, value);
            buffer.append("'");
        }
        if (separator != null) {
            buffer.append(separator);
        }
    }

    private static void escapeSingleQuotes(StringBuffer buffer, String string) {
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) == '\'') {
                buffer.append('\'');
            }
            buffer.append(string.charAt(i));
            ++i;
        }
    }

    private static final void appendValue(StringBuffer buffer, int number, String separator) {
        buffer.append(number);
        if (separator != null) {
            buffer.append(separator);
        }
    }

    public String getValue(String function, String type) throws Exception {
        return this.getValue(function, type, IGNORE, IGNORE, IGNORE);
    }

    public String getValue(String function, String type, String key1) throws Exception {
        return this.getValue(function, type, key1, IGNORE, IGNORE);
    }

    public String getValue(String function, String type, String key1, String key2) throws Exception {
        return this.getValue(function, type, key1, key2, IGNORE);
    }

    public String getValue(String function, String type, String key1, String key2, String key3) throws Exception {
        return this.getValue(function, type, key1, key2, key3, this.getIgnoreContext(function, type, key1, key2, key3));
    }

    public String getValue(String function, String type, boolean ignoreContext) throws Exception {
        return this.getValue(function, type, IGNORE, IGNORE, IGNORE, ignoreContext);
    }

    public String getValue(String function, String type, String key1, boolean ignoreContext) throws Exception {
        return this.getValue(function, type, key1, IGNORE, IGNORE, ignoreContext);
    }

    public String getValue(String function, String type, String key1, String key2, boolean ignoreContext) throws Exception {
        return this.getValue(function, type, key1, key2, IGNORE, ignoreContext);
    }

    public String getValue(String function, String type, String key1, String key2, String key3, boolean ignoreContext) throws Exception {
        if (this.users.length == 1) {
            return this.getValue(this.users[0], function, type, key1, key2, IGNORE, ignoreContext);
        }
        String key = this.buildKey(function, type, key1, key2, key3, ignoreContext);
        int i = 0;
        while (i < this.users.length) {
            String value = this.getCachedValue(this.users[i], key);
            if (value != null && value.length() > 0) {
                return value;
            }
            value = this.selectValue(this.users[i], function, type, key1, key2, IGNORE, ignoreContext);
            this.setCachedValue(this.users[i], key, value);
            if (value.length() > 0) {
                return value;
            }
            ++i;
        }
        return "";
    }

    private String selectValue(String user, String function, String type, String key1, String key2, String key3, boolean ignoreContext) throws Exception {
        ArrayList settings = this.getSettings(user);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < settings.size()) {
            Setting setting = (Setting)settings.get(i);
            if (this.include(function, setting.getFunction()) && this.include(type, setting.getType()) && this.include(key1, setting.getKey1()) && this.include(key2, setting.getKey2()) && this.include(key3, setting.getKey3()) && (ignoreContext || this.include(this.context, setting.getContext()))) {
                buffer.append(setting.getValue());
            }
            ++i;
        }
        return buffer.toString();
    }

    private String getCachedValue(String user, String key) {
        return (String)this.readCache("values", user, key);
    }

    private ArrayList getCachedSettings(String user, String key) {
        return (ArrayList)this.readCache("settings", user, key);
    }

    private Object readCache(String cacheType, String user, String key) {
        HashMap _cache = (HashMap)cache.get(this.dBData);
        if (_cache != null && (_cache = (HashMap)_cache.get(user)) != null && (_cache = (HashMap)_cache.get(cacheType)) != null) {
            return _cache.get(key);
        }
        return null;
    }

    private void setCachedValue(String user, String key, String value) {
        this.writeCache("values", user, key, value);
    }

    private void setCachedSettings(String user, String key, ArrayList settings) {
        this.writeCache("settings", user, key, settings);
    }

    private void writeCache(String cacheType, String user, String key, Object value) {
        HashMap<String, Object> typeCache;
        HashMap<String, HashMap<String, Object>> userCache;
        HashMap dbDataCache = (HashMap)cache.get(this.dBData);
        if (dbDataCache == null) {
            dbDataCache = new HashMap(2);
            cache.put(this.dBData, dbDataCache);
        }
        if ((userCache = (HashMap<String, HashMap<String, Object>>)dbDataCache.get(user)) == null) {
            userCache = new HashMap<String, HashMap<String, Object>>();
            dbDataCache.put(user, userCache);
        }
        if ((typeCache = (HashMap<String, Object>)userCache.get(cacheType)) == null) {
            typeCache = new HashMap<String, Object>();
            userCache.put(cacheType, typeCache);
        }
        typeCache.put(key, value);
    }

    private void clearCache() {
        this.clearCache(this.users[0]);
    }

    private void clearCache(String user) {
        HashMap _cache = (HashMap)cache.get(this.dBData);
        if (_cache != null) {
            _cache = (HashMap)_cache.get(user);
        }
        if (_cache != null) {
            _cache.clear();
        }
        if ((_cache = (HashMap)usersSettings.get(this.dBData)) != null) {
            _cache.remove(user);
        }
    }

    private String buildKey(String function, String type, String key1, String key2, String key3, boolean ignoreContext) {
        this.buffer.setLength(0);
        if (!ignoreContext && this.context != null) {
            this.buffer.append(this.context);
        }
        if (function != IGNORE && function != null) {
            if (this.buffer.length() > 0) {
                this.buffer.append("|");
            }
            this.buffer.append(function);
        }
        if (type != IGNORE && type != null) {
            if (this.buffer.length() > 0) {
                this.buffer.append("|");
            }
            this.buffer.append(type);
        }
        if (key1 != IGNORE && key1 != null) {
            this.buffer.append("|");
            this.buffer.append(key1);
        }
        if (key2 != IGNORE && key2 != null) {
            this.buffer.append("||");
            this.buffer.append(key2);
        }
        if (key3 != IGNORE && key3 != null) {
            this.buffer.append("|||");
            this.buffer.append(key3);
        }
        return this.buffer.toString();
    }

    private String getValue(String user, String function, String type, String key1, String key2, String key3, boolean ignoreContext) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBConnection dbc = provider.getConnection();
        Statement stat = null;
        this.buffer.setLength(0);
        ResultSet rs = null;
        try {
            this.buffer.append("SELECT * FROM ");
            this.appendTableName(provider, this.buffer);
            this.buffer.append(" WHERE ");
            int startWhere = this.buffer.length();
            this.appendGeneralFilterClause(provider, this.buffer, user, startWhere, ignoreContext);
            UserSettings.appendWhere(this.buffer, startWhere, provider, "function", FUNCTION, function, true);
            UserSettings.appendWhere(this.buffer, startWhere, provider, "type", TYPE, type, true);
            UserSettings.appendWhere(this.buffer, startWhere, provider, "key1", KEY1, key1, true);
            UserSettings.appendWhere(this.buffer, startWhere, provider, "key2", KEY2, key2, true);
            UserSettings.appendWhere(this.buffer, startWhere, provider, "key3", KEY3, key3, true);
            this.appendOrderBy(this.buffer, provider);
            Connection con = dbc.getConnection();
            stat = con.createStatement();
            rs = stat.executeQuery(this.buffer.toString());
            this.buffer.setLength(0);
            while (rs.next()) {
                String value = rs.getString(VALUE);
                if (value == null || value.length() < 2) continue;
                this.buffer.append(value.substring(1, value.length() - 1));
            }
            String string = this.buffer.toString();
            return string;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stat != null) {
                try {
                    stat.close();
                }
                catch (Exception exception) {}
            }
            provider.returnConnection(dbc);
        }
    }

    private void appendOrderBy(StringBuffer buffer, ConnectionProvider provider) {
        buffer.append(" ORDER BY ");
        buffer.append(UserSettings.getFieldName(provider, "user", USER));
        buffer.append(", ");
        buffer.append(UserSettings.getFieldName(provider, "context", CONTEXT));
        buffer.append(", ");
        buffer.append(UserSettings.getFieldName(provider, "function", FUNCTION));
        buffer.append(", ");
        buffer.append(UserSettings.getFieldName(provider, "type", TYPE));
        buffer.append(", ");
        buffer.append(UserSettings.getFieldName(provider, "key1", KEY1));
        buffer.append(", ");
        buffer.append(UserSettings.getFieldName(provider, "key2", KEY2));
        buffer.append(", ");
        buffer.append(UserSettings.getFieldName(provider, "key3", KEY3));
        buffer.append(", ");
        buffer.append(UserSettings.getFieldName(provider, "sequenceNumber", SEQUENCE_NUMBER));
    }

    public Collection getSettings(String function, String type, boolean ignoreContext) throws Exception {
        return this.getSettings(function, type, IGNORE, IGNORE, IGNORE, ignoreContext);
    }

    public Collection getSettings(String function, String type, String key1, boolean ignoreContext) throws Exception {
        return this.getSettings(function, type, key1, IGNORE, IGNORE, ignoreContext);
    }

    public Collection getSettings(String function, String type, String key1, String key2, boolean ignoreContext) throws Exception {
        return this.getSettings(function, type, key1, key2, IGNORE, ignoreContext);
    }

    public Collection getSettings(String function, String type) throws Exception {
        return this.getSettings(function, type, IGNORE, IGNORE, IGNORE);
    }

    public Collection getSettings(String function, String type, String key1) throws Exception {
        return this.getSettings(function, type, key1, IGNORE, IGNORE);
    }

    public Collection getSettings(String function, String type, String key1, String key2) throws Exception {
        return this.getSettings(function, type, key1, key2, IGNORE);
    }

    public Collection getSettings(String function, String type, String key1, String key2, String key3) throws Exception {
        return this.getSettings(function, type, key1, key2, key3, this.getIgnoreContext(function, type, key1, key2, key3));
    }

    public Collection getSettings(String function, String type, String key1, String key2, String key3, boolean ignoreContext) throws Exception {
        if (this.users.length == 1) {
            return this.getSettings(this.users[0], function, type, key1, key2, IGNORE, ignoreContext);
        }
        ArrayList list = new ArrayList();
        String key = this.buildKey(function, type, key1, key2, key3, ignoreContext);
        int i = 0;
        while (i < this.users.length) {
            ArrayList settings = this.getCachedSettings(this.users[i], key);
            if (settings == null) {
                settings = this.selectSettings(this.users[i], function, type, key1, key2, IGNORE, ignoreContext);
                this.setCachedSettings(this.users[i], key, settings);
            }
            if (settings != null && settings != EMPTY_LIST) {
                list.addAll(settings);
            }
            ++i;
        }
        return list;
    }

    public ArrayList selectSettings(String user, String function, String type, String key1, String key2, String key3, boolean ignoreContext) throws Exception {
        ArrayList settings = this.getSettings(user);
        ArrayList<Setting> selectedSettings = new ArrayList<Setting>(4);
        int i = 0;
        while (i < settings.size()) {
            Setting setting = (Setting)settings.get(i);
            if (this.include(function, setting.getFunction()) && this.include(type, setting.getType()) && this.include(key1, setting.getKey1()) && this.include(key2, setting.getKey2()) && this.include(key3, setting.getKey3()) && (ignoreContext || this.include(this.context, setting.getContext()))) {
                selectedSettings.add(setting);
            }
            ++i;
        }
        return selectedSettings;
    }

    private boolean include(String requestedKeyValue, String foundKeyValue) {
        if (IGNORE.equals(requestedKeyValue)) {
            return true;
        }
        if (requestedKeyValue == null) {
            return foundKeyValue == null;
        }
        return requestedKeyValue.equals(foundKeyValue);
    }

    private ArrayList getSettings(String user) throws Exception {
        ArrayList settings;
        HashMap<String, ArrayList> _cache = (HashMap<String, ArrayList>)usersSettings.get(this.dBData);
        if (_cache == null) {
            _cache = new HashMap<String, ArrayList>();
            usersSettings.put(this.dBData, _cache);
        }
        if ((settings = (ArrayList)_cache.get(user)) == null) {
            settings = this.getSettings(user, IGNORE, IGNORE, IGNORE, IGNORE, IGNORE, true);
            _cache.put(user, settings);
        }
        return settings;
    }

    public ArrayList getSettings(String user, String function, String type, String key1, String key2, String key3, boolean ignoreContext) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBConnection dbc = provider.getConnection();
        Statement stat = null;
        this.buffer.setLength(0);
        ArrayList collection = new ArrayList();
        ResultSet rs = null;
        try {
            this.buffer.append("SELECT *  FROM ");
            this.appendTableName(provider, this.buffer);
            this.buffer.append(" WHERE ");
            int startWhere = this.buffer.length();
            this.appendGeneralFilterClause(provider, this.buffer, user, startWhere, ignoreContext);
            UserSettings.appendWhere(this.buffer, startWhere, provider, "function", FUNCTION, function, true);
            UserSettings.appendWhere(this.buffer, startWhere, provider, "type", TYPE, type, true);
            UserSettings.appendWhere(this.buffer, startWhere, provider, "key1", KEY1, key1, true);
            UserSettings.appendWhere(this.buffer, startWhere, provider, "key2", KEY2, key2, true);
            UserSettings.appendWhere(this.buffer, startWhere, provider, "key3", KEY3, key3, true);
            this.appendOrderBy(this.buffer, provider);
            Connection con = dbc.getConnection();
            stat = con.createStatement();
            rs = stat.executeQuery(this.buffer.toString());
            this.buffer.setLength(0);
            UserSetting setting = null;
            while (rs.next()) {
                String value;
                if (setting == null) {
                    this.buffer.setLength(0);
                    setting = new ExtendedUserSetting(rs);
                    value = rs.getString(8);
                    if (value == null || value.length() < 2) continue;
                    this.buffer.append(value.substring(1, value.length() - 1));
                    continue;
                }
                if (!(this.isEqual(setting.getKey3(), rs.getString(7)) && this.isEqual(setting.getKey2(), rs.getString(6)) && this.isEqual(setting.getKey1(), rs.getString(5)) && this.isEqual(setting.getType(), rs.getString(4)) && this.isEqual(setting.getFunction(), rs.getString(3)) && this.isEqual(setting.getContext(), rs.getString(2)) && this.isEqual(setting.getUser(), rs.getString(1)))) {
                    setting.setValue(this.buffer.toString());
                    this.buffer.setLength(0);
                    collection.add(setting);
                    setting = new ExtendedUserSetting(rs);
                    value = rs.getString(8);
                    if (value == null || value.length() < 2) continue;
                    this.buffer.append(value.substring(1, value.length() - 1));
                    continue;
                }
                value = rs.getString(8);
                if (value == null || value.length() < 2) continue;
                this.buffer.append(value.substring(1, value.length() - 1));
            }
            if (setting != null) {
                setting.setValue(this.buffer.toString());
                collection.add(setting);
            }
            ArrayList arrayList = collection.size() > 0 ? collection : EMPTY_LIST;
            return arrayList;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stat != null) {
                try {
                    stat.close();
                }
                catch (Exception exception) {}
            }
            provider.returnConnection(dbc);
        }
    }

    private final String[] getStringArray(String value) {
        int length = value.length();
        String[] array = new String[1 + value.length() / 253];
        int i = 0;
        while (i < array.length) {
            this.buffer.setLength(0);
            this.buffer.append("|");
            this.buffer.append(value.substring(i * 253, Math.min(length, (i + 1) * 253)));
            this.buffer.append("|");
            array[i] = this.buffer.toString();
            ++i;
        }
        return array;
    }

    private static void appendWhere(StringBuffer buffer, int startWhere, ConnectionProvider provider, String name, String column, String value, boolean includeNullValuesInSelection) {
        if (value != IGNORE && (value != null || includeNullValuesInSelection)) {
            String key = UserSettings.getFieldName(provider, name, column);
            if (buffer.length() > startWhere) {
                buffer.append(" AND ");
            }
            buffer.append(key);
            if (value == null) {
                buffer.append(" IS NULL ");
            } else {
                buffer.append(" = '");
                UserSettings.escapeSingleQuotes(buffer, value);
                buffer.append("'");
            }
        }
    }

    private void appendGeneralFilterClause(ConnectionProvider provider, StringBuffer buffer, String user, int startWhere, boolean ignoreContext) {
        StringBuffer sb1 = new StringBuffer();
        UserSettings.appendWhere(sb1, startWhere, provider, "usertype", USERTYPE, "G", true);
        StringBuffer sb2 = new StringBuffer();
        UserSettings.appendWhere(sb2, startWhere, provider, "user", USER, user, true);
        buffer.append("(");
        buffer.append(sb1);
        buffer.append(" OR ");
        buffer.append(sb2);
        buffer.append(")");
        if (!ignoreContext) {
            UserSettings.appendWhere(buffer, startWhere, provider, "context", CONTEXT, this.context, true);
        }
    }

    private boolean isEqual(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }

    public void removeAllSettings() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBConnection dbc = provider.getConnection();
        this.buffer.setLength(0);
        try {
            this.buffer.append("DELETE FROM ");
            this.buffer.append(this.getConnectionProvider().getORMapping().getTableName(TABLE, TABLE));
            dbc.executeUpdate(this.buffer.toString());
            usersSettings.clear();
            cache.clear();
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    private void appendTableName(ConnectionProvider provider, StringBuffer buffer) throws Exception {
        buffer.append(provider.getPrefix());
        buffer.append(UserSettings.getTableName(provider));
    }

    private static final String getTableName(ConnectionProvider provider) {
        return TABLE;
    }

    private static final String getFieldName(ConnectionProvider provider, String name, String column) {
        return column;
    }

    public boolean isIgnoreContext() {
        return this.ignoreContext;
    }

    public void setIgnoreContext(boolean ignoreContext) {
        this.ignoreContext = ignoreContext;
    }

    public static void clearCaches() {
        usersSettings.clear();
        cache.clear();
    }

    private static final class ExtendedUserSetting
    extends UserSetting {
        private static final long serialVersionUID = 1L;

        public ExtendedUserSetting(ResultSet resultSet) throws Exception {
            this.user = resultSet.getString(1);
            this.context = resultSet.getString(2);
            this.function = resultSet.getString(3);
            this.type = resultSet.getString(4);
            this.key1 = resultSet.getString(5);
            this.key2 = resultSet.getString(6);
            this.key3 = resultSet.getString(7);
            this.value = resultSet.getString(8);
            this.userType = resultSet.getString(10);
            this.userEdit = resultSet.getBoolean(11);
        }
    }

    public static interface IgnoreContextProvider {
        public boolean getIgnoreContext(String var1, String var2, String var3, String var4, String var5);
    }
}

