/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import java.util.Map;
import nl.ibs.jsql.impl.NoResultQuery;
import nl.ibs.jsql.sql.BusinessObjectManager;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.PersistenceMetaData;
import nl.ibs.jsql.sql.PersistenceViewWrapper;
import nl.ibs.jsql.sql.ViewNameGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class ViewBusinessObjectManager
extends BusinessObjectManager {
    BusinessObjectManager target = null;
    String viewName = ViewNameGenerator.getInstance().getNewViewName();
    PersistenceViewWrapper pmdvw = null;

    public ViewBusinessObjectManager(BusinessObjectManager target, String filter, Map params, Class[] imports) throws Exception {
        if (target == null) {
            throw new IllegalArgumentException("target on view can't be null");
        }
        this.target = target;
        this.pmdvw = new PersistenceViewWrapper(target.getPersistenceMetaData(), this.viewName);
        String intFilter = "CREATE VIEW " + target.getConnectionProvider().getPrefix() + this.viewName + " AS " + filter;
        try {
            this.executeQuery(target, params, intFilter, imports);
        }
        catch (Exception e) {
            this.delete();
            this.executeQuery(target, params, intFilter, imports);
        }
    }

    private void executeQuery(BusinessObjectManager target, Map params, String intFilter, Class[] imports) throws Exception {
        NoResultQuery qry = new NoResultQuery(intFilter, 1);
        int i = 0;
        while (imports != null && i < imports.length) {
            qry.addImport(imports[i]);
            ++i;
        }
        qry.setParameters(params);
        qry.execute(target);
    }

    @Override
    public ConnectionProvider getConnectionProvider() throws Exception {
        return this.target.getConnectionProvider();
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return this.pmdvw;
    }

    @Override
    protected Object getBusinessObject(ResultSet rs) throws Exception {
        return this.target.getBusinessObjectForView(rs);
    }

    @Override
    protected Collection getCollection(ResultSet rs) throws Exception {
        return this.target.getCollectionForView(rs);
    }

    @Override
    protected ListIterator getListIterator(ResultSet rs) throws Exception {
        return this.target.getListIteratorForView(rs);
    }

    @Override
    protected Document getDocument(ResultSet resultSet) throws Exception {
        return this.target.getDocumentForView(resultSet);
    }

    @Override
    protected DocumentFragment getDocumentFragment(ResultSet resultSet) throws Exception {
        return this.target.getDocumentFragmentForView(resultSet);
    }

    @Override
    protected ArrayList getDocumentFragmentArrayList(ResultSet resultSet) throws Exception {
        return this.target.getDocumentFragmentArrayListForView(resultSet);
    }

    public void delete() throws Exception {
        String intFilter = "DROP VIEW " + this.target.getConnectionProvider().getPrefix() + this.viewName;
        NoResultQuery qry = new NoResultQuery(intFilter, 1);
        qry.execute(this.target);
    }

    public String getViewName() throws Exception {
        return String.valueOf(this.target.getConnectionProvider().getPrefix()) + this.viewName;
    }
}

