/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql.impl;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.Fillable;
import nl.ibs.jsql.FreeQuery;
import nl.ibs.jsql.Query;
import nl.ibs.jsql.impl.ConcurrentHashMap;
import nl.ibs.jsql.impl.NoResultQuery;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.BusinessObjectManager;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.ExtendedPersistenceMetaData;
import nl.ibs.jsql.sql.PersistenceMetaData;
import nl.ibs.jsql.sql.QueryTranslator;

public class QueryImplementation
implements Query {
    private static final String DROP_VIEW = "DROP VIEW";
    private static final String CREATE_VIEW = "CREATE VIEW";
    protected static final short RETURN_TWO_DIMENSIONAL_OBJECT_ARRAY = 101;
    protected static final short RETURN_OBJECT_COLLECTION = 102;
    protected static final short RETURN_NOTHING = 103;
    protected static Class[] emptyClassArray = new Class[0];
    protected static Object[] emptyObjectArray = new Object[0];
    protected static ClassLoader classLoader = QueryImplementation.class.getClassLoader();
    private String freeQuery;
    private AttributeAccessor attributeAccessor;
    protected String selectClause = null;
    protected String updateClause = null;
    protected String setClause = null;
    protected String filterClause = null;
    protected String relationFilterClause = null;
    protected String classFilterClause = null;
    protected String orderByClause = null;
    protected String preparedUpdateString = null;
    protected String preparedQueryString = null;
    protected String sqlStatement = null;
    protected boolean modified = true;
    protected boolean parameters_modified = false;
    protected boolean cacheable = false;
    protected Map imports = null;
    protected Map parameters = null;
    protected Set tables = null;
    protected PersistenceMetaData basePmd;
    protected int maxRows = 0;
    protected int dataBaseId = 0;
    protected ArrayList preparedStatementArgumentList = null;
    protected static ConcurrentHashMap preparedUpdateStatements = new ConcurrentHashMap();
    protected static ConcurrentHashMap preparedQueryStatements = new ConcurrentHashMap();
    public static long hits = 0L;
    public static long lookups = 0L;
    public static int maxCacheSize = 250;
    private static final boolean printCacheStatistics = DBConfig.getPrintCacheStatistics();
    private static final boolean cacheQueryTranslations = DBConfig.getCacheQueryTranslations();

    public QueryImplementation(String query, int maxRows) {
        this.freeQuery = query;
        this.maxRows = maxRows;
    }

    public QueryImplementation(String filter, String orderBy, int maxRows) {
        this.filterClause = filter;
        this.orderByClause = orderBy;
        this.maxRows = maxRows;
    }

    public Object execute(BusinessObjectManager manager, short instruction) throws Exception {
        return this.execute(manager, instruction, 0, 0);
    }

    public Object execute(BusinessObjectManager manager, short instruction, int begin, int end) throws Exception {
        return this.execute(manager, null, null, instruction, begin, end);
    }

    protected Object execute(BusinessObjectManager manager, Class return_clss, String[] return_mappings, short instruction) throws Exception {
        return this.execute(manager, return_clss, return_mappings, instruction, 0, 0);
    }

    protected Object execute(BusinessObjectManager manager, Class return_clss, String[] return_mappings, short instruction, int beginIndex, int endIndex) throws Exception {
        try {
            PersistenceMetaData pmd = manager.getPersistenceMetaData();
            ConnectionProvider provider = manager.getConnectionProvider();
            int dbId = provider.getDBId();
            if (this.basePmd == null || this.basePmd != pmd) {
                this.modified = true;
                this.basePmd = pmd;
            }
            if (this.dataBaseId != dbId) {
                this.modified = true;
                this.dataBaseId = dbId;
            }
            if (this.modified) {
                this.buildQuery(manager, provider);
            }
            Object object = this.executeQuery(manager, return_clss, return_mappings, instruction, beginIndex, endIndex);
            this.modified = false;
            return object;
        }
        catch (Exception e) {
            if (this.selectClause != null) {
                Log.error((String)("JSQL select: " + this.selectClause));
            }
            if (this.updateClause != null) {
                Log.error((String)("JSQL update: " + this.updateClause));
            }
            if (this.filterClause != null) {
                Log.error((String)("JSQL filter: " + this.filterClause));
            }
            if (this.orderByClause != null) {
                Log.error((String)("JSQL order: " + this.orderByClause));
            }
            if (this.freeQuery != null) {
                Log.error((String)("JSQL query: " + this.freeQuery));
            }
            if (this.preparedQueryString != null) {
                Log.error((String)("JSQL prepared query: " + this.preparedQueryString));
            }
            if (this.preparedUpdateString != null) {
                Log.error((String)("JSQL prepared select: " + this.preparedUpdateString));
            }
            if (this.sqlStatement != null) {
                Log.error((String)("JSQL sql statement: " + this.sqlStatement));
            }
            throw e;
        }
    }

    private void buildQuery(BusinessObjectManager manager, ConnectionProvider provider) throws Exception {
        String filter = this.getFilter();
        String key = "";
        boolean isQuery = false;
        if (cacheQueryTranslations) {
            key = QueryImplementation.getKey(filter, this.freeQuery, this.orderByClause);
            boolean bl = isQuery = this instanceof FreeQuery && this.freeQuery != null && !this.freeQuery.trim().equals("") || this.setClause == null;
            if (isQuery) {
                this.preparedUpdateString = null;
                this.preparedQueryString = QueryImplementation.getQueryFromCache(isQuery, this.basePmd, provider, key, this.imports);
                if (this.preparedQueryString != null) {
                    return;
                }
            } else {
                this.preparedQueryString = null;
                this.preparedUpdateString = QueryImplementation.getQueryFromCache(isQuery, this.basePmd, provider, key, this.imports);
                if (this.preparedUpdateString != null) {
                    return;
                }
            }
        }
        String where = QueryTranslator.translateObjectFilterClause(filter, this.basePmd, provider, this.imports);
        String select = null;
        String update = null;
        String set = null;
        String from = null;
        String orderBy = null;
        String classNameConstraint = null;
        if (this.basePmd instanceof ExtendedPersistenceMetaData) {
            classNameConstraint = ((ExtendedPersistenceMetaData)this.basePmd).getClassNameConstraint(provider);
        }
        if ((this instanceof FreeQuery || this instanceof NoResultQuery) && this.freeQuery != null && !this.freeQuery.trim().equals("")) {
            String tfq = this.freeQuery.trim();
            if (tfq.length() < 6 || !tfq.substring(0, 6).equalsIgnoreCase("SELECT") && !tfq.substring(0, CREATE_VIEW.length()).equalsIgnoreCase(CREATE_VIEW) && !tfq.substring(0, DROP_VIEW.length()).equalsIgnoreCase(DROP_VIEW)) {
                throw new Exception("JSQL: Your query statement should start with SELECT or select or create view, other values are currently not permitted");
            }
            this.preparedQueryString = QueryTranslator.translateFreeQuery(this.freeQuery, this.basePmd, provider, this.imports);
            if (classNameConstraint != null && !classNameConstraint.equals("") && !tfq.startsWith(DROP_VIEW)) {
                int index = this.preparedQueryString.indexOf(" ORDER ");
                this.preparedQueryString = index > -1 ? (this.preparedQueryString.indexOf(" WHERE ") > -1 ? String.valueOf(this.preparedQueryString.substring(0, index)) + " AND " + classNameConstraint + " " + this.preparedQueryString.substring(index) : String.valueOf(this.preparedQueryString.substring(0, index)) + " WHERE " + classNameConstraint + " " + this.preparedQueryString.substring(index)) : (this.preparedQueryString.indexOf(" WHERE ") > -1 ? String.valueOf(this.preparedQueryString) + " AND " + classNameConstraint : String.valueOf(this.preparedQueryString) + " WHERE " + classNameConstraint);
            }
        } else {
            if (classNameConstraint != null && !classNameConstraint.equals("")) {
                where = String.valueOf(where == null ? "" : String.valueOf(where) + " AND ") + classNameConstraint;
            }
            if (this.setClause != null) {
                update = String.valueOf(provider.getPrefix()) + this.basePmd.getTableName(provider);
                set = QueryTranslator.translateObjectSetClause(this.setClause, this.basePmd, provider, this.imports);
                this.preparedUpdateString = "UPDATE " + update + " SET " + set + (where != null ? " WHERE " + where : "");
                this.preparedQueryString = null;
            } else {
                if (this.tables == null) {
                    this.tables = new HashSet();
                }
                from = QueryTranslator.translateObjectFromClause(this.tables, this.basePmd, provider, this.imports);
                StringBuffer orderBuffer = new StringBuffer();
                StringBuffer fromBuffer = new StringBuffer(from);
                StringBuffer selectBuffer = new StringBuffer(QueryTranslator.translateObjectSelectClause(this.selectClause == null ? "" : this.selectClause, this.basePmd, provider, this.imports));
                QueryTranslator.processObjectOrderClause(this.orderByClause, this.basePmd, provider, this.imports, this.tables, orderBuffer, fromBuffer, selectBuffer);
                orderBy = orderBuffer.toString();
                from = fromBuffer.toString();
                select = selectBuffer.toString();
                this.preparedQueryString = "SELECT " + select + " FROM " + from + (where == null ? "" : " WHERE " + where) + (orderBy == null || orderBy.trim().length() == 0 ? "" : " ORDER BY " + orderBy);
                this.preparedUpdateString = null;
            }
        }
        if (cacheQueryTranslations) {
            if (isQuery) {
                QueryImplementation.putQueryOnCache(this.preparedQueryString, isQuery, this.basePmd, provider, key, this.imports);
            } else {
                QueryImplementation.putQueryOnCache(this.preparedUpdateString, isQuery, this.basePmd, provider, key, this.imports);
            }
        }
    }

    private Object executeQuery(BusinessObjectManager manager, Class return_clss, String[] return_mappings, short instruction, int beginIndex, int endIndex) throws Exception {
        if (beginIndex < 0) {
            throw new IllegalArgumentException("beginIndex < 0: beginIndex = " + beginIndex);
        }
        if (endIndex < 0) {
            throw new IllegalArgumentException("endIndex < 0: endIndex = " + endIndex);
        }
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("beginIndex > endIndex: beginIndex = " + beginIndex + ", endIndex = " + endIndex);
        }
        if (this.cacheable) {
            return this.executePreparedQueryStatement(manager, return_clss, return_mappings, instruction, beginIndex, endIndex);
        }
        return this.executeQueryStatement(manager, return_clss, return_mappings, instruction, beginIndex, endIndex);
    }

    private Object executeQueryStatement(BusinessObjectManager manager, Class return_clss, String[] return_mappings, short instruction, int beginIndex, int endIndex) throws Exception {
        if (this.modified || this.parameters_modified) {
            this.sqlStatement = this.preprocesPreparedQueryForExecution(this.preparedQueryString);
        }
        Object result = null;
        ConnectionProvider provider = manager.getConnectionProvider();
        if (provider instanceof AtomicDBTransaction && instruction != 103) {
            result = ((AtomicDBTransaction)provider).getCachedResult(this.sqlStatement);
            if (result != null) {
                if (instruction == -1 || instruction == 102) {
                    if (result instanceof Collection) {
                        return result;
                    }
                    if (result == null) {
                        return new ArrayList(0);
                    }
                    if (!(result instanceof Object[][])) {
                        ArrayList<Object> col = new ArrayList<Object>(1);
                        col.add(result);
                        return col;
                    }
                } else if (instruction == 101) {
                    if (result instanceof Object[][]) {
                        return result;
                    }
                } else if (instruction == 0) {
                    if (result instanceof ArrayList) {
                        ArrayList list = (ArrayList)result;
                        return list.isEmpty() ? null : list.get(0);
                    }
                    if (!(result instanceof Object[][])) {
                        return result;
                    }
                }
            }
            result = null;
        }
        DBConnection dbc = provider.getConnection();
        Statement stat = null;
        ResultSet rs = null;
        try {
            try {
                Connection con = dbc.getConnection();
                stat = con.createStatement();
                if (beginIndex == 0 && endIndex == 0) {
                    stat.setMaxRows(this.maxRows);
                } else {
                    stat.setMaxRows(endIndex);
                }
                if (instruction == 103) {
                    int n = stat.executeUpdate(this.sqlStatement);
                } else {
                    rs = stat.executeQuery(this.sqlStatement);
                    if (beginIndex > 0) {
                        int i = beginIndex;
                        while (i > 0 && rs.next()) {
                            --i;
                        }
                    }
                    result = this.buildResult(manager, rs, return_clss, return_mappings, instruction);
                }
            }
            catch (SQLException e) {
                Log.error((String)("JSQL: Error executing query '" + this.sqlStatement + "'"));
                Log.error((String)e.getMessage());
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stat != null) {
                try {
                    stat.close();
                }
                catch (Exception exception) {}
            }
            provider.returnConnection(dbc);
        }
        if (provider instanceof AtomicDBTransaction) {
            if (instruction == -1 || instruction == 101 || instruction == 102) {
                ((AtomicDBTransaction)provider).setCachedResult(this.sqlStatement, result);
            } else if (instruction == 0) {
                ((AtomicDBTransaction)provider).setCachedResult(this.sqlStatement, result == null ? new ArrayList(0) : result);
            }
        }
        return result;
    }

    private Object executePreparedQueryStatement(BusinessObjectManager manager, Class return_clss, String[] return_mappings, short instruction, int beginIndex, int endIndex) throws Exception {
        if (this.modified) {
            this.sqlStatement = this.preprocesPreparedQueryForPreparedStatement(this.preparedQueryString);
        }
        Object result = null;
        ConnectionProvider provider = manager.getConnectionProvider();
        DBConnection dbc = provider.getConnection();
        ResultSet rs = null;
        try {
            try {
                PreparedStatement prep = dbc.getPreparedStatement(this.sqlStatement);
                if (prep == null) {
                    prep = dbc.getPreparedStatement(this.sqlStatement, this.sqlStatement);
                }
                int i = 0;
                while (i < this.preparedStatementArgumentList.size()) {
                    if (this.parameters == null) {
                        throw new Exception("JSQL Exception: no value provided for parameter " + this.preparedStatementArgumentList.get(i) + "!");
                    }
                    Object object = this.parameters.get(this.preparedStatementArgumentList.get(i));
                    if (object == null) {
                        throw new Exception("JSQL Exception: no value provided for parameter " + this.preparedStatementArgumentList.get(i) + "!");
                    }
                    prep.setObject(i + 1, object);
                    ++i;
                }
                if (beginIndex == 0 && endIndex == 0) {
                    prep.setMaxRows(this.maxRows);
                } else {
                    prep.setMaxRows(endIndex);
                }
                if (instruction == 103) {
                    i = prep.executeUpdate(this.sqlStatement);
                } else {
                    rs = prep.executeQuery();
                    if (beginIndex > 0) {
                        i = beginIndex;
                        while (i > 0 && rs.next()) {
                            --i;
                        }
                    }
                    result = this.buildResult(manager, rs, return_clss, return_mappings, instruction);
                }
            }
            catch (SQLException e) {
                Log.error((String)("JSQL: Error executing query '" + this.sqlStatement + "'"));
                Log.error((String)e.getMessage());
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            provider.returnConnection(dbc);
        }
        return result;
    }

    private Object buildResult(BusinessObjectManager manager, ResultSet rs, Class return_clss, String[] return_mappings, short instruction) throws Exception {
        if (instruction == 101) {
            return this.buildObjectArray(rs);
        }
        if (instruction == 102) {
            return this.buildObjectCollection(rs, return_clss, return_mappings);
        }
        return manager.processResultSet(rs, instruction);
    }

    private Object buildObjectArray(ResultSet rs) throws Exception {
        ArrayList<Object[]> al = new ArrayList<Object[]>();
        ResultSetMetaData md = rs.getMetaData();
        int cc = md.getColumnCount();
        while (rs.next()) {
            Object[] row = new Object[cc];
            int i = 0;
            while (i < cc) {
                row[i] = rs.getObject(i + 1);
                ++i;
            }
            al.add(row);
        }
        return al.toArray((T[])new Object[al.size()][cc]);
    }

    private Object buildObjectCollection(ResultSet rs, Class return_clss, String[] return_mappings) throws Exception {
        ArrayList al = new ArrayList();
        ResultSetMetaData md = rs.getMetaData();
        int cc = md.getColumnCount();
        while (rs.next()) {
            int i;
            Object object = return_clss.newInstance();
            if (return_mappings == null) {
                i = 0;
                while (i < cc) {
                    try {
                        this.getAttributeAccessor().forceAttribute(object, md.getColumnName(i + 1), rs.getObject(i + 1), true);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        throw new Exception("Exception trying to map column " + md.getColumnName(i + 1) + " from result to an attribute with the same name. See previous messages for details, check aliases in your select clause and the types to correct the problem (you can also provide mappings instead of using aliases)!");
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < return_mappings.length && i < cc) {
                    try {
                        if (return_mappings[i] != null && !return_mappings[i].equals("")) {
                            this.getAttributeAccessor().forceAttribute(object, return_mappings[i], rs.getObject(i + 1), false);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        throw new Exception("Exception trying to map result set column " + (i + 1) + " [" + md.getColumnName(i + 1) + "] to attribute " + return_mappings[i] + ". See previous messages for details, check names and types and correct your mapping!");
                    }
                    ++i;
                }
            }
            al.add(object);
            if (!(object instanceof Fillable)) continue;
            Fillable fillable = (Fillable)object;
            fillable.fill();
        }
        return al;
    }

    private AttributeAccessor getAttributeAccessor() {
        if (this.attributeAccessor == null) {
            this.attributeAccessor = new AttributeAccessor();
        }
        return this.attributeAccessor;
    }

    private String preprocesPreparedQueryForExecution(String preparedString) {
        return this.preprocesPreparedQuery(preparedString, false);
    }

    private String preprocesPreparedQueryForPreparedStatement(String preparedString) {
        if (this.preparedStatementArgumentList == null) {
            this.preparedStatementArgumentList = new ArrayList();
        } else {
            this.preparedStatementArgumentList.clear();
        }
        return this.preprocesPreparedQuery(preparedString, true);
    }

    private String preprocesPreparedQuery(String preparedString, boolean preparedStatement) {
        int x = 0;
        int y = preparedString.indexOf("<?");
        if (y < 0) {
            return preparedString;
        }
        StringBuffer buffer = new StringBuffer();
        while (y >= 0) {
            boolean quote = false;
            int i = 0;
            while (i < y) {
                if (preparedString.charAt(i) == '\'') {
                    if (!quote) {
                        quote = true;
                    } else if (i + 1 < y && preparedString.charAt(i + 1) == '\'') {
                        ++i;
                    } else {
                        quote = false;
                    }
                }
                ++i;
            }
            if (quote) {
                y = preparedString.indexOf("<?", y + 2);
                continue;
            }
            buffer.append(preparedString.substring(x, y));
            x = y + 2;
            y = preparedString.indexOf("?>", x);
            String variableName = preparedString.substring(x, y);
            if (preparedStatement) {
                this.preparedStatementArgumentList.add(variableName);
                buffer.append(" ? ");
            } else if (this.parameters != null && this.parameters.containsKey(variableName)) {
                Object object = this.parameters.get(variableName);
                if (object instanceof String) {
                    object = QueryImplementation.escapeSingleQuotes((String)object);
                }
                buffer.append(QueryImplementation.getValueAsSQLString(object));
            } else {
                buffer.append(variableName);
            }
            x = Math.min(preparedString.length(), y + 2);
            y = preparedString.indexOf("<?", x);
            if (y >= 0 || x >= preparedString.length()) continue;
            buffer.append(preparedString.substring(x));
        }
        return buffer.toString();
    }

    public String getSelectClause() {
        return this.selectClause;
    }

    public void setSelectClause(String clause) {
        if (this.selectClause == null || !this.selectClause.equals(clause)) {
            this.modified = true;
            this.selectClause = clause;
        }
    }

    public void setFromTables(Set tableSet) {
        this.modified = true;
        this.tables = tableSet;
    }

    public void addTableToFrom(String table) {
        if (this.tables == null || !this.tables.contains(table)) {
            if (this.tables == null) {
                this.tables = new HashSet();
            }
            this.tables.add(table);
            this.modified = true;
        }
    }

    private String getFilter() {
        String filter = this.classFilterClause;
        if (filter == null) {
            filter = this.relationFilterClause;
        } else if (this.relationFilterClause != null && !this.relationFilterClause.trim().equals("")) {
            filter = String.valueOf(filter) + " AND " + this.relationFilterClause;
        }
        if (filter == null) {
            filter = this.filterClause;
        } else if (this.filterClause != null && !this.filterClause.trim().equals("")) {
            filter = String.valueOf(filter) + " AND ( " + this.filterClause + " )";
        }
        return filter;
    }

    public void setQuery(String qry, Map replacements) {
        if (replacements != null) {
            for (String org : replacements.keySet()) {
                int index;
                while ((index = qry.indexOf(org)) >= 0) {
                    qry = String.valueOf(qry.substring(0, index)) + replacements.get(org) + qry.substring(index + org.length(), qry.length());
                }
            }
        }
        this.setQuery(qry);
    }

    public void setQuery(String query) {
        if (query == null || !query.equals(this.freeQuery)) {
            this.modified = true;
            this.freeQuery = query;
            this.classFilterClause = null;
            this.relationFilterClause = null;
        }
    }

    @Override
    public void setFilter(String filter) {
        if (this.filterClause == null || !this.filterClause.equals(filter)) {
            this.modified = true;
            this.filterClause = filter;
            this.classFilterClause = null;
            this.relationFilterClause = null;
        }
    }

    public void setRelationFilter(String relationFilter) {
        if (this.relationFilterClause == null || !this.relationFilterClause.equals(relationFilter)) {
            this.modified = true;
            this.relationFilterClause = relationFilter;
        }
    }

    public void setClassFilter(String classFilter) {
        if (this.classFilterClause == null || !this.classFilterClause.equals(classFilter)) {
            this.modified = true;
            this.classFilterClause = classFilter;
        }
    }

    public String getOrdering() {
        return this.orderByClause;
    }

    @Override
    public void setOrdering(String orderBy) {
        if (this.orderByClause == null || !this.orderByClause.equals(orderBy)) {
            this.modified = true;
            this.orderByClause = orderBy;
        }
    }

    @Override
    public void setCacheable(boolean cache) {
        if (this.cacheable != cache) {
            this.modified = true;
            this.cacheable = cache;
        }
    }

    @Override
    public boolean getCacheable() {
        return this.cacheable;
    }

    @Override
    public void setMaxObjects(int max) {
        this.maxRows = max;
    }

    @Override
    public int getMaxObjects() {
        return this.maxRows;
    }

    @Override
    public void addImport(Class businessObjectClass) throws Exception {
        String name = QueryImplementation.getName(businessObjectClass);
        this.addImport(name, businessObjectClass);
    }

    @Override
    public void addImport(BusinessObjectManager manager) {
        this.addImport(manager.getPersistenceMetaData());
    }

    @Override
    public void addImport(String alias, BusinessObjectManager manager) {
        this.addImport(alias, manager.getPersistenceMetaData());
    }

    @Override
    public void addImport(String alias, Class businessObjectClass) throws Exception {
        try {
            PersistenceMetaData pmd = QueryImplementation.getPersistenceMetaData(businessObjectClass);
            this.addImport(alias, pmd);
        }
        catch (Exception e) {
            Log.error((String)e.getMessage());
            e.printStackTrace();
            String namePMDClass = null;
            try {
                namePMDClass = QueryImplementation.getNamePersistenceMetaDataClass(businessObjectClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception("Could not import " + businessObjectClass.getName() + "! Verify that that this class implements BusinessObject and that class " + namePMDClass + " exists!");
        }
    }

    public void addImport(PersistenceMetaData pmd) {
        this.addImport(pmd.getBusinessObjectName(), pmd);
    }

    public void addImport(String name, PersistenceMetaData pmd) {
        if (this.imports == null) {
            this.imports = new HashMap();
        }
        if (!this.imports.containsKey(name) || this.imports.get(name) != pmd) {
            this.modified = true;
            this.imports.put(name, pmd);
        }
    }

    @Override
    public void setParameters(Map map) {
        if (this.parameters == null != (map == null) || this.parameters != null && !this.parameters.equals(map)) {
            this.parameters_modified = true;
            this.parameters = map == null ? null : new HashMap(map);
        }
    }

    public void addParameters(Map map) {
        if (map != null && !map.isEmpty()) {
            this.parameters_modified = true;
            if (this.parameters == null) {
                this.parameters = new HashMap(map);
            } else {
                this.parameters.putAll(map);
            }
        }
    }

    @Override
    public void setParameter(String name, Object value) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        if (!this.parameters.containsKey(name) || this.parameters.get(name) != value) {
            this.parameters_modified = true;
            this.parameters.put(name, value);
        }
    }

    @Override
    public void setParameter(String name, long value) {
        this.setParameter(name, new Long(value));
    }

    @Override
    public void setParameter(String name, short value) {
        this.setParameter(name, new Short(value));
    }

    @Override
    public void setParameter(String name, int value) {
        this.setParameter(name, new Integer(value));
    }

    @Override
    public void setParameter(String name, double value) {
        this.setParameter(name, new Double(value));
    }

    @Override
    public void setParameter(String name, float value) {
        this.setParameter(name, new Float(value));
    }

    @Override
    public void setParameter(String name, boolean value) {
        this.setParameter(name, new Boolean(value));
    }

    private static String getName(Class _class) throws Exception {
        String name = _class.getName();
        int i = name.lastIndexOf(46);
        if (i < 0) {
            return name;
        }
        if (i < name.length()) {
            return name.substring(i + 1);
        }
        return null;
    }

    private static PersistenceMetaData getPersistenceMetaData(Class _class) throws Exception {
        String name = QueryImplementation.getNamePersistenceMetaDataClass(_class);
        Class<?> pmdClass = classLoader.loadClass(name);
        Method method = pmdClass.getDeclaredMethod("getInstance", emptyClassArray);
        return (PersistenceMetaData)method.invoke(null, emptyObjectArray);
    }

    private static String getNamePersistenceMetaDataClass(Class _class) throws Exception {
        String prefix = "impl.PersistenceMetaData";
        String name = _class.getName();
        int i = name.lastIndexOf(46);
        if (i < 0) {
            name = String.valueOf(prefix) + name;
        } else if (i < name.length()) {
            name = String.valueOf(name.substring(0, i + 1)) + prefix + name.substring(i + 1);
        }
        return name;
    }

    private static String getValueAsSQLString(Object obj) {
        if (obj instanceof Short || obj instanceof Integer || obj instanceof Long || obj instanceof BigInteger || obj instanceof BigDecimal) {
            return String.valueOf(obj);
        }
        if (obj instanceof Float || obj instanceof Double) {
            return String.valueOf(new BigDecimal(String.valueOf(obj)));
        }
        if (obj instanceof java.util.Date) {
            return "'" + new Date(((java.util.Date)obj).getTime()).toString() + "'";
        }
        return "'" + String.valueOf(obj) + "'";
    }

    private static String escapeSingleQuotes(String string) {
        if (string.indexOf(39) < 0) {
            return string;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) == '\'') {
                buffer.append('\'');
            }
            buffer.append(string.charAt(i));
            ++i;
        }
        return buffer.toString();
    }

    private static void resizeCache(Map map) {
        long t1 = 172800000L;
        while ((double)map.size() > 0.75 * (double)maxCacheSize) {
            long t2 = System.currentTimeMillis() - t1;
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (((PreparedQ)entry.getValue()).lastTime >= t2) continue;
                it.remove();
            }
            t1 /= 10L;
        }
        maxCacheSize = map.size() + maxCacheSize;
        if (printCacheStatistics) {
            Log.info((String)("Tuned query cache: new current size = " + map.size() + ", new maximum size = " + maxCacheSize));
        }
    }

    private static void putQueryOnCache(String translation, boolean isQuery, PersistenceMetaData pmd, ConnectionProvider provider, String key, Map imports) throws Exception {
        Map cacheMap = QueryImplementation.getCacheMap(isQuery, pmd);
        PreparedQ pQ = new PreparedQ();
        pQ.translation = translation;
        pQ.dbId = provider.getDBId();
        pQ.imports = imports;
        cacheMap.put(key, pQ);
        if (cacheMap.size() > maxCacheSize) {
            QueryImplementation.resizeCache(cacheMap);
        }
    }

    private static String getQueryFromCache(boolean isQuery, PersistenceMetaData pmd, ConnectionProvider provider, String key, Map imports) throws Exception {
        String query = null;
        Map cacheMap = QueryImplementation.getCacheMap(isQuery, pmd);
        PreparedQ pQ = (PreparedQ)cacheMap.get(key);
        if (pQ != null && pQ.dbId == provider.getDBId()) {
            pQ.lastTime = System.currentTimeMillis();
            query = pQ.translation;
        }
        if (printCacheStatistics) {
            long l = hits = query != null ? hits + 1L : hits;
            if (++lookups % 1000L == 0L) {
                Log.info((String)("Hit ratio: " + hits * 100L / lookups + "%. (" + lookups + " lookups," + hits + " hits)"));
            }
        }
        return query;
    }

    private static Map getCacheMap(boolean isQuery, PersistenceMetaData pmd) {
        ConcurrentHashMap cache1 = isQuery ? preparedQueryStatements : preparedUpdateStatements;
        Map cache2 = (Map)cache1.get(pmd.getClass());
        if (cache2 == null) {
            cache2 = new ConcurrentHashMap();
            cache1.put(pmd.getClass(), cache2);
        }
        return cache2;
    }

    private static String getKey(String s1, String s2, String s3) {
        StringBuffer buffer = new StringBuffer(2 + (s1 == null ? 0 : s1.length()) + (s2 == null ? 0 : s2.length()) + (s3 == null ? 0 : s3.length()));
        if (s1 != null) {
            buffer.append(s1);
        }
        buffer.append("#");
        if (s2 != null) {
            buffer.append(s2);
        }
        buffer.append("#");
        if (s3 != null) {
            buffer.append(s3);
        }
        return buffer.toString();
    }

    static class PreparedQ {
        String translation;
        Map imports;
        int dbId;
        long lastTime;

        PreparedQ() {
        }
    }
}

