/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql.sql;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class AttributeAccessor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Class clss;
    private transient HashMap fields = null;
    private transient HashMap classes = null;

    public AttributeAccessor(Class aClass) {
        this.clss = aClass;
    }

    public AttributeAccessor() {
    }

    public int getIntAttribute(Object object, String attributeName) throws Exception {
        return this.getField(object.getClass(), attributeName).getInt(object);
    }

    public Object getObjectAttribute(Object object, String attributeName) throws Exception {
        return this.getField(object.getClass(), attributeName).get(object);
    }

    public boolean getBooleanAttribute(Object object, String attributeName) throws Exception {
        return this.getField(object.getClass(), attributeName).getBoolean(object);
    }

    public byte getByteAttribute(Object object, String attributeName) throws Exception {
        return this.getField(object.getClass(), attributeName).getByte(object);
    }

    public char getCharAttribute(Object object, String attributeName) throws Exception {
        return this.getField(object.getClass(), attributeName).getChar(object);
    }

    public double getDoubleAttribute(Object object, String attributeName) throws Exception {
        return this.getField(object.getClass(), attributeName).getDouble(object);
    }

    public float getFloatAttribute(Object object, String attributeName) throws Exception {
        return this.getField(object.getClass(), attributeName).getFloat(object);
    }

    public long getLongAttribute(Object object, String attributeName) throws Exception {
        return this.getField(object.getClass(), attributeName).getLong(object);
    }

    public short getShortAttribute(Object object, String attributeName) throws Exception {
        return this.getField(object.getClass(), attributeName).getShort(object);
    }

    public void setAttribute(Object object, String attributeName, int value) throws Exception {
        this.getField(object.getClass(), attributeName).setInt(object, value);
    }

    public void setAttribute(Object object, String attributeName, Object value) throws Exception {
        this.getField(object.getClass(), attributeName).set(object, value);
    }

    public void setAttribute(Object object, String attributeName, boolean value) throws Exception {
        this.getField(object.getClass(), attributeName).setBoolean(object, value);
    }

    public void setAttribute(Object object, String attributeName, byte value) throws Exception {
        this.getField(object.getClass(), attributeName).setByte(object, value);
    }

    public void setAttribute(Object object, String attributeName, char value) throws Exception {
        this.getField(object.getClass(), attributeName).setChar(object, value);
    }

    public void setAttribute(Object object, String attributeName, double value) throws Exception {
        this.getField(object.getClass(), attributeName).setDouble(object, value);
    }

    public void setAttribute(Object object, String attributeName, float value) throws Exception {
        this.getField(object.getClass(), attributeName).setFloat(object, value);
    }

    public void setAttribute(Object object, String attributeName, long value) throws Exception {
        this.getField(object.getClass(), attributeName).setLong(object, value);
    }

    public void setAttribute(Object object, String attributeName, short value) throws Exception {
        this.getField(object.getClass(), attributeName).setShort(object, value);
    }

    public HashMap getFields() {
        if (this.clss == null) {
            return null;
        }
        if (this.fields == null) {
            this.fields = this.collectFields(this.clss, new HashMap());
        }
        return this.fields;
    }

    private Field getField(Class theClass, String attributeName) throws Exception {
        if (this.clss != null) {
            return this.getFieldFromCache(attributeName);
        }
        return this.getFieldFromObject(theClass, attributeName);
    }

    private Field getFieldFromObject(Class theClass, String attributeName) throws Exception {
        Field field = (Field)this.getFieldMap(theClass).get(attributeName);
        if (field == null) {
            throw new Exception("Atribute " + attributeName + " not found in class " + theClass + "!");
        }
        return field;
    }

    private Map getFieldMap(Class theClass) {
        HashMap fields = null;
        if (this.classes == null) {
            this.classes = new HashMap();
        } else {
            fields = (HashMap)this.classes.get(theClass);
        }
        if (fields == null) {
            fields = this.collectFields(theClass, new HashMap());
            this.classes.put(theClass, fields);
        }
        return fields;
    }

    private Field getFieldFromCache(String attributeName) throws Exception {
        Field field;
        Field field2 = field = this.clss == null ? null : (Field)this.getFields().get(attributeName);
        if (field == null) {
            throw new Exception("Atribute " + attributeName + " not found in cache!");
        }
        return field;
    }

    private HashMap collectFields(Class theClass, HashMap fields) {
        if (theClass == null) {
            return fields;
        }
        Field[] fArray = theClass.getDeclaredFields();
        int i = 0;
        while (i < fArray.length) {
            Field f = fArray[i];
            f.setAccessible(true);
            if (!fields.containsKey(f.getName())) {
                fields.put(f.getName(), f);
            }
            ++i;
        }
        return this.collectFields(theClass.getSuperclass(), fields);
    }

    public void forceAttribute(Object object, String attributeName, Object value, boolean ignoreFieldsNotFound) throws Exception {
        Class<?> theClass = object.getClass();
        Map fieldMap = this.clss != null ? this.getFields() : this.getFieldMap(theClass);
        Field field = (Field)fieldMap.get(attributeName);
        if (field == null) {
            for (String name : fieldMap.keySet()) {
                if (!attributeName.equalsIgnoreCase(name)) continue;
                field = (Field)fieldMap.get(name);
                break;
            }
        }
        if (field == null) {
            if (ignoreFieldsNotFound) {
                return;
            }
            throw new Exception("Could not find field " + attributeName + " on " + theClass.getName());
        }
        AttributeAccessor.set(object, value, field);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void set(Object object, Object value, Field field) throws IllegalAccessException, Exception {
        Class<?> valueType;
        if (value == null) {
            field.set(object, value);
            return;
        }
        Class<?> fieldType = field.getType();
        if (fieldType.isAssignableFrom(valueType = value.getClass())) {
            field.set(object, value);
            return;
        } else if (fieldType == Boolean.TYPE && value.getClass() == Boolean.class || fieldType == Integer.TYPE && valueType == Integer.class || fieldType == Short.TYPE && value.getClass() == Short.class || fieldType == Long.TYPE && value.getClass() == Long.class || fieldType == Double.TYPE && value.getClass() == Double.class || fieldType == Float.TYPE && value.getClass() == Float.class) {
            field.set(object, value);
            return;
        } else if (String.class.isAssignableFrom(fieldType)) {
            field.set(object, String.valueOf(value));
            return;
        } else if (valueType == String.class) {
            String st = (String)value;
            if (st != null && (st = st.trim()).endsWith("-")) {
                st = "-" + st.substring(0, st.length() - 1);
            }
            if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                field.set(object, new Integer(st == null || (st = st.trim()).length() == 0 ? "0" : st));
                return;
            } else if (fieldType == Short.class || fieldType == Short.TYPE) {
                field.set(object, new Short(st == null || (st = st.trim()).length() == 0 ? "0" : st));
                return;
            } else if (fieldType == Long.class || fieldType == Long.TYPE) {
                field.set(object, new Long(st == null || (st = st.trim()).length() == 0 ? "0" : st));
                return;
            } else if (fieldType == Double.class || fieldType == Double.TYPE) {
                field.set(object, new Double(st == null || (st = st.trim()).length() == 0 ? "0" : st));
                return;
            } else if (fieldType == Float.class || fieldType == Float.TYPE) {
                field.set(object, new Float(st == null || (st = st.trim()).length() == 0 ? "0" : st));
                return;
            } else if (fieldType == BigInteger.class) {
                field.set(object, new BigInteger(st == null || (st = st.trim()).length() == 0 ? "0" : st));
                return;
            } else {
                if (fieldType != BigDecimal.class) throw new Exception("Could not convert from " + valueType.getName() + " to " + fieldType.getName());
                field.set(object, new BigDecimal(st == null || (st = st.trim()).length() == 0 ? "0" : st));
            }
            return;
        } else if (BigInteger.class.isAssignableFrom(valueType)) {
            BigInteger bi = (BigInteger)value;
            if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                field.set(object, new Integer(bi.intValue()));
                return;
            } else if (fieldType == Short.class || fieldType == Short.TYPE) {
                field.set(object, new Short(bi.shortValue()));
                return;
            } else if (fieldType == Long.class || fieldType == Long.TYPE) {
                field.set(object, new Long(bi.longValue()));
                return;
            } else if (fieldType == Double.class || fieldType == Double.TYPE) {
                field.set(object, new Double(bi.doubleValue()));
                return;
            } else {
                if (fieldType != Float.class && fieldType != Float.TYPE) throw new Exception("Could not convert from " + valueType.getName() + " to " + fieldType.getName());
                field.set(object, new Float(bi.floatValue()));
            }
            return;
        } else if (BigDecimal.class.isAssignableFrom(valueType)) {
            BigDecimal bd = (BigDecimal)value;
            if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                field.set(object, new Integer(bd.intValue()));
                return;
            } else if (fieldType == Short.class || fieldType == Short.TYPE) {
                field.set(object, new Short(bd.shortValue()));
                return;
            } else if (fieldType == Long.class || fieldType == Long.TYPE) {
                field.set(object, new Long(bd.longValue()));
                return;
            } else if (fieldType == Double.class || fieldType == Double.TYPE) {
                field.set(object, new Double(bd.doubleValue()));
                return;
            } else {
                if (fieldType != Float.class && fieldType != Float.TYPE) throw new Exception("Could not convert from " + valueType.getName() + " to " + fieldType.getName());
                field.set(object, new Float(bd.floatValue()));
            }
            return;
        } else if (Integer.class.isAssignableFrom(valueType)) {
            Integer i = (Integer)value;
            if (fieldType == BigDecimal.class) {
                field.set(object, new BigDecimal(i));
                return;
            } else if (fieldType == BigInteger.class) {
                field.set(object, new BigInteger(String.valueOf(i)));
                return;
            } else if (fieldType == Short.class || fieldType == Short.TYPE) {
                field.set(object, new Short(i.shortValue()));
                return;
            } else if (fieldType == Long.class || fieldType == Long.TYPE) {
                field.set(object, new Long(i.longValue()));
                return;
            } else if (fieldType == Double.class || fieldType == Double.TYPE) {
                field.set(object, new Double(i.doubleValue()));
                return;
            } else {
                if (fieldType != Float.class && fieldType != Float.TYPE) throw new Exception("Could not convert from " + valueType.getName() + " to " + fieldType.getName());
                field.set(object, new Float(i.floatValue()));
            }
            return;
        } else if (Short.class.isAssignableFrom(valueType)) {
            Short s = (Short)value;
            if (fieldType == BigDecimal.class) {
                field.set(object, new BigDecimal(s.shortValue()));
                return;
            } else if (fieldType == BigInteger.class) {
                field.set(object, new BigInteger(String.valueOf(s.shortValue())));
                return;
            } else if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                field.set(object, new Integer(s.intValue()));
                return;
            } else if (fieldType == Long.class || fieldType == Long.TYPE) {
                field.set(object, new Long(s.longValue()));
                return;
            } else if (fieldType == Double.class || fieldType == Double.TYPE) {
                field.set(object, new Double(s.doubleValue()));
                return;
            } else {
                if (fieldType != Float.class && fieldType != Float.TYPE) throw new Exception("Could not convert from " + valueType.getName() + " to " + fieldType.getName());
                field.set(object, new Float(s.floatValue()));
            }
            return;
        } else if (Long.class.isAssignableFrom(valueType)) {
            Long l = (Long)value;
            if (fieldType == BigDecimal.class) {
                field.set(object, new BigDecimal(l));
                return;
            } else if (fieldType == BigInteger.class) {
                field.set(object, new BigInteger(String.valueOf(l)));
                return;
            } else if (fieldType == Short.class || fieldType == Short.TYPE) {
                field.set(object, new Short(l.shortValue()));
                return;
            } else if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                field.set(object, new Integer(l.intValue()));
                return;
            } else if (fieldType == Double.class || fieldType == Double.TYPE) {
                field.set(object, new Double(l.doubleValue()));
                return;
            } else {
                if (fieldType != Float.class && fieldType != Float.TYPE) throw new Exception("Could not convert from " + valueType.getName() + " to " + fieldType.getName());
                field.set(object, new Float(l.floatValue()));
            }
            return;
        } else if (Double.class.isAssignableFrom(valueType)) {
            Double d = (Double)value;
            if (fieldType == BigDecimal.class) {
                field.set(object, new BigDecimal(d));
                return;
            } else if (fieldType == BigInteger.class) {
                field.set(object, new BigInteger(String.valueOf(d)));
                return;
            } else if (fieldType == Short.class || fieldType == Short.TYPE) {
                field.set(object, new Short(d.shortValue()));
                return;
            } else if (fieldType == Long.class || fieldType == Long.TYPE) {
                field.set(object, new Long(d.longValue()));
                return;
            } else if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                field.set(object, new Integer(d.intValue()));
                return;
            } else {
                if (fieldType != Float.class && fieldType != Float.TYPE) throw new Exception("Could not convert from " + valueType.getName() + " to " + fieldType.getName());
                field.set(object, new Float(d.floatValue()));
            }
            return;
        } else {
            if (!Float.class.isAssignableFrom(valueType)) throw new Exception("Could not convert from " + valueType.getName() + " to " + fieldType.getName());
            Float f = (Float)value;
            if (fieldType == BigDecimal.class) {
                field.set(object, new BigDecimal(f.floatValue()));
                return;
            } else if (fieldType == BigInteger.class) {
                field.set(object, new BigInteger(String.valueOf(f.floatValue())));
                return;
            } else if (fieldType == Short.class || fieldType == Short.TYPE) {
                field.set(object, new Short(f.shortValue()));
                return;
            } else if (fieldType == Long.class || fieldType == Long.TYPE) {
                field.set(object, new Long(f.longValue()));
                return;
            } else if (fieldType == Double.class || fieldType == Double.TYPE) {
                field.set(object, new Double(f.doubleValue()));
                return;
            } else {
                if (fieldType != Integer.class && fieldType != Integer.TYPE) throw new Exception("Could not convert from " + valueType.getName() + " to " + fieldType.getName());
                field.set(object, new Integer(f.intValue()));
            }
        }
    }
}

