/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.sql.DBMapping;

public class DBConnection {
    protected String urlText = new String();
    protected String driver = new String();
    protected String user = new String();
    protected String password = new String();
    protected Connection con = null;
    protected boolean connected = false;
    private HashMap preparedStatementMap = new HashMap();
    private ArrayList preparedStatementList = new ArrayList();
    private DBMapping mapping;
    private Statement stmt;
    private long pooledAt;

    public DBConnection(String _driver, String _url, String _user, String _password, DBMapping _mapping) {
        this.urlText = _url;
        this.driver = _driver;
        this.user = _user;
        this.password = _password;
        this.mapping = _mapping;
    }

    public boolean connect() {
        if (this.connect_DB()) {
            Log.info((String)("Connected to Database: " + this.urlText));
            return true;
        }
        Log.error((String)("Failed to connect to Database: " + this.urlText + ".\nSee previous messages!"));
        return false;
    }

    public boolean connect_DB() {
        this.loadDriver(this.driver);
        Log.info((String)("Connecting to " + this.urlText + " ... "));
        try {
            this.con = DriverManager.getConnection(this.urlText, this.user, this.password);
            DBPersistenceManager.invokeConnectionLifeCycleListenersPostConnected(this.con);
            Log.info((String)("Succesful connected to " + this.con.getMetaData().getDatabaseProductName() + " " + this.con.getMetaData().getDatabaseProductVersion()));
            this.connected = true;
            return true;
        }
        catch (Exception e) {
            Log.info((String)("Cann not connect to " + this.urlText));
            Log.error((String)e.getMessage());
            e.printStackTrace();
            this.connected = false;
            throw new RuntimeException(e.getMessage());
        }
    }

    public void disconnect() {
        block7: {
            try {
                try {
                    if (this.con != null && !this.con.isClosed()) {
                        DBPersistenceManager.invokeConnectionLifeCycleListenersPreDisconnected(this.con);
                        this.con.close();
                    }
                }
                catch (Exception e) {
                    if (Log.debug()) {
                        Log.error((Exception)e);
                    }
                    this.con = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.con = null;
                throw throwable;
            }
            this.con = null;
        }
        this.connected = false;
    }

    public ResultSet executeQuery(String query) throws SQLException {
        return this.executeQuery(query, false);
    }

    public void reset() {
        if (this.stmt != null) {
            try {
                this.stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.stmt = null;
        }
    }

    public ResultSet executeQuery(String sql, boolean silent) throws SQLException {
        ResultSet rs = null;
        boolean debug = Log.debug() && !silent;
        String query = this.mapping.convertSQLStatement(sql);
        if (debug) {
            Log.debug((String)("Executing query " + query));
        }
        try {
            if (this.stmt == null) {
                this.stmt = this.con.createStatement();
            }
            if (this.stmt.execute(query)) {
                rs = this.stmt.getResultSet();
                if (rs != null) {
                    if (debug) {
                        Log.debug((String)"SQL Executed resultset available");
                    }
                } else {
                    this.reset();
                    if (debug) {
                        Log.debug((String)"SQL Executed no resultset available");
                    }
                }
            } else {
                this.reset();
                if (debug) {
                    Log.debug((String)"SQL Executed no resultset available");
                }
            }
        }
        catch (SQLException e) {
            if (debug) {
                Log.warn((String)("SQLState: " + e.getSQLState()));
            }
            if (!silent) {
                Log.error((String)("Exception '" + e.getMessage() + "' thrown while executing statement '" + query + "'."));
            }
            throw e;
        }
        if (debug) {
            Log.debug((String)("Return resultset = " + rs));
        }
        return rs;
    }

    public int executeUpdate(String update) throws SQLException {
        return this.executeUpdate(update, false);
    }

    public int executeUpdate(String sql, boolean silent) throws SQLException {
        int rst = 0;
        boolean debug = !silent && Log.debug();
        String update = this.mapping.convertSQLStatement(sql);
        if (debug) {
            Log.debug((String)("Executing update " + update));
        }
        try {
            try {
                if (this.stmt == null) {
                    this.stmt = this.con.createStatement();
                }
                rst = this.stmt.executeUpdate(update);
                if (debug) {
                    Log.debug((String)(String.valueOf(rst) + " rows updated"));
                }
            }
            catch (SQLException e) {
                if (debug) {
                    Log.warn((String)("SQLState " + e.getSQLState()));
                    Log.error((String)e.getMessage());
                    e.printStackTrace();
                }
                if (!silent) {
                    Log.error((String)("Exception '" + e.getMessage() + "' thrown while executing statement '" + update + "'."));
                }
                throw e;
            }
        }
        finally {
            this.reset();
        }
        return rst;
    }

    public String getUrl() {
        return this.urlText;
    }

    public Connection getConnection() {
        return this.con;
    }

    public boolean isConnected() {
        try {
            return this.connected && this.con != null && !this.con.isClosed();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void loadDriver(String driver) {
        try {
            Log.info((String)("Loading driver: " + driver + "..."));
            Class.forName(driver.trim()).newInstance();
            Log.info((String)"success!");
        }
        catch (Exception e) {
            Log.error((String)e.getMessage());
            e.printStackTrace();
        }
    }

    public PreparedStatement getPreparedStatement(String key) {
        PreparedStatement ps = (PreparedStatement)this.preparedStatementMap.get(key);
        if (ps != null) {
            try {
                ps.clearParameters();
            }
            catch (Exception e) {
                ps = null;
            }
        }
        return ps;
    }

    public void addPreparedStatement(String key, PreparedStatement statement) {
        if (this.preparedStatementMap.size() >= 254) {
            this.removePreparedStatement();
        }
        this.preparedStatementMap.put(key, statement);
        this.preparedStatementList.add(key);
    }

    private void removePreparedStatement() {
        Object key = this.preparedStatementList.get(0);
        PreparedStatement statement = (PreparedStatement)this.preparedStatementMap.get(key);
        try {
            statement.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.preparedStatementMap.remove(key);
        this.preparedStatementList.remove(0);
    }

    public PreparedStatement getPreparedStatement(String key, String sql) throws Exception {
        return this.getPreparedStatement(key, sql, 0);
    }

    public PreparedStatement getPreparedStatement(String key, String sql, int maxRows) throws Exception {
        if (this.preparedStatementMap.containsKey(key)) {
            return this.getPreparedStatement(key);
        }
        PreparedStatement statement = this.createPreparedStatement(this.mapping.convertSQLStatement(sql), maxRows);
        this.addPreparedStatement(key, statement);
        return statement;
    }

    public PreparedStatement createPreparedStatement(String sql, int maxRows) throws Exception {
        PreparedStatement stmt = this.con.prepareStatement(sql);
        stmt.setMaxRows(maxRows);
        return stmt;
    }

    protected void finalize() throws Throwable {
        if (this.con != null) {
            this.con.close();
            this.con = null;
        }
        super.finalize();
    }

    void setPooledAt(long time) {
        this.pooledAt = time;
    }

    long getPooledAt() {
        return this.pooledAt;
    }
}

