/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql.sql;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.sql.ConnectionPool;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBManager;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.ORMapping;

public class DBConnectionPool
extends ConnectionPool {
    private static final long serialVersionUID = 1L;
    private static Hashtable applicationPools = new Hashtable();
    private Stack stack = null;
    private Set activeConnections = null;
    private String applicationName = null;
    private DBData dbData = null;
    private String seperator = null;
    private String prefix = "";
    private String searchStringEscape = null;
    private ORMapping orMapping = null;
    private DBMapping dbMapping = null;
    private int SQLStateType = -1;
    private String messageIllegalState = null;
    private static HashMap managers = new HashMap();

    public static DBConnectionPool getInstance(String application) {
        return DBConnectionPool.getInstance(DBData.getDefaultDBData(application));
    }

    public static boolean instanceExistsFor(String application, DBData dbd) {
        Hashtable pools = (Hashtable)applicationPools.get(application);
        return pools != null && pools.containsKey(dbd);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBConnectionPool getInstance(DBData dbd) {
        DBConnectionPool pool;
        Hashtable<DBData, DBConnectionPool> pools = (Hashtable<DBData, DBConnectionPool>)applicationPools.get(dbd.getApplication());
        if (pools == null) {
            pools = new Hashtable<DBData, DBConnectionPool>();
            applicationPools.put(dbd.getApplication(), pools);
        }
        if ((pool = (DBConnectionPool)pools.get(dbd)) == null) {
            DBConnectionPool dBConnectionPool = pool = new DBConnectionPool(dbd.getApplication(), dbd);
            synchronized (dBConnectionPool) {
                try {
                    pools.put(dbd, pool);
                    DBManager manager = DBConnectionPool.getManager(dbd.getApplication(), pool);
                    DBTransaction tx = DBPersistenceManager.getTransaction();
                    DBPersistenceManager.setTransaction(null);
                    manager.init(pool);
                    DBPersistenceManager.setTransaction(tx);
                }
                catch (Exception e) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(baos));
                    pool.messageIllegalState = "Can not approach database: " + e.getMessage() + "\n" + baos.toString();
                }
            }
        }
        if (pool.messageIllegalState != null) {
            throw new RuntimeException(pool.messageIllegalState);
        }
        return pool;
    }

    private static DBManager getManager(String applicationName, DBConnectionPool pool) throws Exception {
        DBManager manager = (DBManager)managers.get(pool);
        if (manager == null) {
            manager = DBManager.getDBManager(applicationName);
            managers.put(pool, manager);
        }
        return manager;
    }

    private DBConnectionPool(String applicationName, DBData dbd) {
        this.applicationName = applicationName;
        this.dbData = dbd;
        this.stack = new Stack();
        this.activeConnections = new HashSet();
        String schema = this.dbData.getSchema();
        if (schema == null || schema.equals("")) {
            this.prefix = "";
        } else {
            this.seperator = this.getCatalogSeparator();
            if (this.seperator == null || this.seperator.equals("")) {
                this.seperator = ".";
            }
            this.prefix = String.valueOf(schema) + this.seperator;
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    DBConnectionPool.this.disconnectInactiveInvalidConnections();
                    try {
                        Thread.sleep(300000L);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        });
        t.setDaemon(true);
        t.start();
    }

    public String getName() {
        return this.dbData.getName();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ORMapping getORMapping() {
        if (this.orMapping == null) {
            this.orMapping = ORMapping.getInstance(this.getName());
        }
        return this.orMapping;
    }

    @Override
    public DBMapping getDBMapping() {
        if (this.dbMapping == null) {
            this.dbMapping = DBMapping.getInstance(this.getDriver());
        }
        return this.dbMapping;
    }

    public DatabaseMetaData getDatabaseMetaData() throws SQLException {
        DatabaseMetaData databaseMetaData = null;
        DBConnection con = this.getConnection();
        databaseMetaData = con.getConnection().getMetaData();
        this.returnConnection(con);
        return databaseMetaData;
    }

    public int executeUpdate(String sql) throws SQLException {
        if (this.messageIllegalState != null) {
            throw new RuntimeException(this.messageIllegalState);
        }
        DBConnection con = this.getConnection();
        int rslt = con.executeUpdate(sql);
        this.returnConnection(con);
        return rslt;
    }

    @Override
    public DBConnection getConnection() {
        if (this.messageIllegalState != null) {
            throw new RuntimeException(this.messageIllegalState);
        }
        DBConnection connection = null;
        while (!this.stack.isEmpty()) {
            DBConnection con = (DBConnection)this.stack.pop();
            if (con == null || !con.isConnected()) continue;
            connection = con;
            break;
        }
        if (connection == null) {
            connection = this.createNewDBConnection();
        }
        this.activeConnections.add(connection);
        return connection;
    }

    @Override
    public void returnConnection(DBConnection con) {
        if (con != null && con.isConnected() && this.activeConnections.contains(con)) {
            con.reset();
            con.setPooledAt(System.currentTimeMillis());
            this.stack.push(con);
            this.activeConnections.remove(con);
        }
    }

    private DBConnection createNewDBConnection() {
        DBConnection con = new DBConnection(this.getDriver(), this.getURL(), this.dbData.getUser(), this.dbData.getPassword(), this.getDBMapping());
        con.connect();
        return con;
    }

    public String getCatalogSeparator() {
        if (this.seperator == null) {
            try {
                this.seperator = this.getDatabaseMetaData().getCatalogSeparator();
            }
            catch (Exception e) {
                Log.error((String)e.getMessage());
                e.printStackTrace();
            }
        }
        return this.seperator;
    }

    @Override
    public String getSearchStringEscape() {
        if (this.searchStringEscape == null) {
            try {
                this.searchStringEscape = this.getDatabaseMetaData().getSearchStringEscape();
            }
            catch (Exception e) {
                Log.error((String)e.getMessage());
                e.printStackTrace();
            }
            if (this.searchStringEscape == null || this.searchStringEscape.trim().equals("")) {
                this.searchStringEscape = "\\";
            }
        }
        return this.searchStringEscape;
    }

    public String escapeSearchString(String like) {
        if (like.indexOf(37) < 0 && like.indexOf(95) < 0) {
            return like;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < like.length()) {
            char c = like.charAt(i);
            if (c == '%' || c == '_') {
                buffer.append(this.getSearchStringEscape());
            }
            buffer.append(c);
            ++i;
        }
        return buffer.toString();
    }

    public String escapeSingleQuotes(String string) {
        if (string.indexOf(39) < 0) {
            return string;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) == '\'') {
                buffer.append('\'');
            }
            buffer.append(string.charAt(i));
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public String getDriver() {
        return this.dbData.getDriver();
    }

    public String getURL() {
        return this.dbData.getURL();
    }

    public String getSchema() {
        return this.dbData.getSchema();
    }

    public boolean getAutoCreateTables() {
        return this.dbData.getAutoCreateTables();
    }

    public boolean getAutoAddColumns() {
        return this.dbData.getAutoAddColumns();
    }

    public boolean getAutoModifyColumns() {
        return this.dbData.getAutoModifyColumns();
    }

    public boolean getAutoDropColumns() {
        return this.dbData.getAutoDropColumns();
    }

    @Override
    public boolean sameDataBase(ConnectionPool pool) {
        return this == pool || this.getDBId() == pool.getDBId();
    }

    @Override
    public DBData getDBData() {
        return this.dbData;
    }

    protected void finalize() throws Throwable {
        this.disconnectAll();
        super.finalize();
    }

    public void disconnectInactiveConnections() {
        while (!this.stack.isEmpty()) {
            DBConnection con = (DBConnection)this.stack.pop();
            if (con == null || !con.isConnected()) continue;
            con.disconnect();
        }
    }

    public void disconnectAll() {
        while (!this.stack.isEmpty()) {
            DBConnection con = (DBConnection)this.stack.pop();
            if (con == null || !con.isConnected()) continue;
            con.disconnect();
        }
        for (DBConnection con : this.activeConnections) {
            if (con == null || !con.isConnected()) continue;
            con.disconnect();
        }
        this.activeConnections.clear();
        Log.info((String)"Closed connections!");
    }

    public static void disconnectAllPools() {
        Iterator pools = applicationPools.values().iterator();
        while (pools.hasNext()) {
            Iterator iter = ((Hashtable)pools.next()).values().iterator();
            while (iter.hasNext()) {
                ((DBConnectionPool)iter.next()).disconnectAll();
            }
        }
    }

    public void disconnectInactiveInvalidConnections() {
        int i = 0;
        while (i < this.stack.size()) {
            boolean remove;
            DBConnection temp;
            block9: {
                temp = null;
                remove = false;
                try {
                    temp = (DBConnection)this.stack.get(i);
                    if (System.currentTimeMillis() - temp.getPooledAt() > 300000L) {
                        remove = true;
                    } else {
                        temp.getConnection().getMetaData().getCatalogs();
                    }
                }
                catch (Exception e) {
                    if (temp != null && temp.isConnected()) break block9;
                    remove = true;
                }
            }
            if (remove) {
                try {
                    if (temp != null && temp.isConnected()) {
                        temp.disconnect();
                    }
                    this.stack.remove(temp);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    public static void reset(DBData dbd) {
        Hashtable pools = (Hashtable)applicationPools.get(dbd.getApplication());
        if (pools == null) {
            return;
        }
        DBConnectionPool pool = (DBConnectionPool)pools.get(dbd);
        if (pool != null) {
            pool.disconnectAll();
            pools.remove(dbd);
        }
    }
}

