/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql.sql;

import java.io.Serializable;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DBMapping
implements Serializable {
    private static Document defaultMappings;
    private static Document customMappings;
    private static Map mappings;
    private static String[] javaTypes;
    private static HashMap defaultJDBCMappings;
    private static HashMap defaultSQLMappings;
    private Map jdbcMappings = new HashMap();
    private Map sqlMappings = new HashMap();
    private Map instructionMappings = new HashMap();
    private ArrayList instructionList = new ArrayList();
    private boolean commentOnTableSupport = false;
    private boolean commentOnColumnSupport = false;
    private boolean cascadeDeletionSupport = false;
    private boolean cascadeUpdateSupport = false;
    private boolean addConstraintForeignKeyColumns = false;
    private String constraintForeignKeyColumns = "";

    static {
        mappings = new Hashtable();
        javaTypes = new String[]{"String", "boolean", "Boolean", "short", "Short", "int", "Integer", "long", "Long", "double", "Double", "float", "Float", "BigInteger", "BigDecimal", "Date", "Time", "Timestamp"};
        defaultJDBCMappings = new HashMap();
        defaultJDBCMappings.put("String", new Integer(12));
        defaultJDBCMappings.put("boolean", new Integer(1));
        defaultJDBCMappings.put("Boolean", new Integer(1));
        defaultJDBCMappings.put("short", new Integer(4));
        defaultJDBCMappings.put("Short", new Integer(4));
        defaultJDBCMappings.put("int", new Integer(4));
        defaultJDBCMappings.put("Integer", new Integer(4));
        defaultJDBCMappings.put("long", new Integer(-5));
        defaultJDBCMappings.put("Long", new Integer(-5));
        defaultJDBCMappings.put("BigInteger", new Integer(-5));
        defaultJDBCMappings.put("double", new Integer(3));
        defaultJDBCMappings.put("Double", new Integer(3));
        defaultJDBCMappings.put("Float", new Integer(3));
        defaultJDBCMappings.put("float", new Integer(3));
        defaultJDBCMappings.put("BigDecimal", new Integer(3));
        defaultJDBCMappings.put("Date", new Integer(91));
        defaultJDBCMappings.put("Time", new Integer(92));
        defaultJDBCMappings.put("Timestamp", new Integer(93));
        defaultJDBCMappings.put("byte[]", new Integer(-4));
        defaultSQLMappings = new HashMap();
        defaultSQLMappings.put("String", "VARCHAR(254)");
        defaultSQLMappings.put("boolean", "CHAR(5)");
        defaultSQLMappings.put("boolean", "CHAR(5)");
        defaultSQLMappings.put("short", "INTEGER(5)");
        defaultSQLMappings.put("Short", "INTEGER(5)");
        defaultSQLMappings.put("int", "INTEGER(9)");
        defaultSQLMappings.put("Integer", "INTEGER(9)");
        defaultSQLMappings.put("long", "INTEGER(19)");
        defaultSQLMappings.put("Long", "INTEGER(19)");
        defaultSQLMappings.put("BigInteger", "INTEGER(23)");
        defaultSQLMappings.put("double", "DECIMAL(15)");
        defaultSQLMappings.put("Double", "DECIMAL(15)");
        defaultSQLMappings.put("float", "DECIMAL(23)");
        defaultSQLMappings.put("Float", "DECIMAL(23)");
        defaultSQLMappings.put("BigDecimal", "DECIMAL(23,0)");
        defaultSQLMappings.put("Date", "DATE");
        defaultSQLMappings.put("Time", "TIME");
        defaultSQLMappings.put("Timestamp", "TIMESTAMP");
        defaultSQLMappings.put("byte[]", "BLOB");
        java.io.File defaultmappings = null;
        try {
            Log.info((String)"Search defaultjsql.xml in root classpath");
            defaultmappings = new File(DBMapping.class.getClassLoader().getResource("defaultjsql.xml"));
            if (defaultmappings != null && defaultmappings.exists()) {
                Log.info((String)"Found defaultjsql.xml in root classpath");
            } else {
                Log.info((String)"No defaultjsql.xml found in root classpath");
            }
        }
        catch (Exception e) {
            Log.info((String)"No defaultjsql.xml found in root classpath!");
        }
        if (defaultmappings == null || !defaultmappings.exists()) {
            String importPackage = "nl.ibs.jsql";
            try {
                Log.info((String)("Search for defaultjsql.xml in package " + importPackage));
                defaultmappings = new File(DBMapping.class.getClassLoader().getResource(String.valueOf(importPackage.replace('.', '/')) + "/defaultjsql.xml"));
                if (defaultmappings != null && defaultmappings.exists()) {
                    Log.info((String)("Found defaultjsql.xml in package " + importPackage));
                } else {
                    Log.info((String)("No defaultjsql.xml found in package " + importPackage));
                }
            }
            catch (Exception e) {
                Log.warn((String)("Neither found defaultjsql.xml in package " + importPackage + "!"));
            }
        }
        File custommappings = new File(DBConfig.getCustomMappings());
        if (defaultmappings != null && defaultmappings.exists()) {
            try {
                Log.info((String)("Loading DefaultMappings (\"" + defaultmappings.getPath() + "\")"));
                defaultMappings = DBConfig.getDocument(defaultmappings);
                Log.info((String)("DefaultMappings (\"" + defaultmappings.getPath() + "\") loaded"));
            }
            catch (Exception e) {
                Log.error((String)e.getMessage());
                e.printStackTrace();
            }
        }
        if (custommappings != null && custommappings.exists()) {
            try {
                Log.info((String)("Loading CustomMappings (\"" + custommappings.getPath() + "\")"));
                customMappings = DBConfig.getDocument(custommappings);
                Log.info((String)("CustomMappings (\"" + custommappings.getPath() + "\") loaded!"));
            }
            catch (Exception e) {
                Log.error((String)e.getMessage());
                e.printStackTrace();
            }
        }
        if (defaultMappings == null && customMappings == null) {
            Log.error((String)"No mappings found, will use hardcoded default mappings wich are not driver specific!, This might casue serious problems!");
        }
    }

    static DBMapping getInstance(DBData data) {
        return DBMapping.getInstance(data.getDriver());
    }

    static DBMapping getInstance(String driver) {
        Object mapping = mappings.get(driver);
        if (mapping == null) {
            mapping = new DBMapping(driver);
            mappings.put(driver, mapping);
        }
        return (DBMapping)mapping;
    }

    protected DBMapping(String driver) {
        Node mapping = null;
        if (customMappings != null) {
            mapping = DBMapping.getTypeMappingForDriver(customMappings, driver);
        }
        if (mapping == null && defaultMappings != null) {
            mapping = DBMapping.getTypeMappingForDriver(defaultMappings, driver);
        }
        if (mapping == null && customMappings != null) {
            mapping = DBMapping.getTypeMappingForDriver(customMappings, "default");
        }
        if (mapping == null && defaultMappings != null) {
            mapping = DBMapping.getTypeMappingForDriver(defaultMappings, "default");
        }
        this.map(mapping);
    }

    public String convertSQLStatement(String statement) {
        String sql = statement.trim();
        int i = 0;
        int z = 0;
        while (i < this.instructionList.size()) {
            String instruction = (String)this.instructionList.get(i);
            if (instruction.charAt(0) == '^') {
                z = DBMapping.firstOccurenceOfCharacter(instruction, "? ");
                if (sql.startsWith(instruction.substring(1, z < 0 ? instruction.length() : z))) {
                    String replacement = (String)this.instructionMappings.get(instruction);
                    sql = z < 0 ? String.valueOf(replacement) + sql.substring(instruction.length() - 1) : DBMapping.convert(0, sql, instruction.substring(1), replacement, false);
                }
            } else {
                z = DBMapping.firstOccurenceOfCharacter(instruction, "? ");
                int from = sql.indexOf(instruction.substring(0, z < 0 ? instruction.length() : z));
                if (from > -1) {
                    String replacement = (String)this.instructionMappings.get(instruction);
                    sql = DBMapping.convert(from, sql, instruction, replacement, true);
                }
            }
            ++i;
        }
        return sql;
    }

    private static String convert(int from, String sql, String instruction, String replacement, boolean repeat) {
        StringTokenizer st = new StringTokenizer(instruction, "? ", true);
        String[] tokens = new String[st.countTokens()];
        int x = 0;
        while (st.hasMoreElements()) {
            tokens[x++] = st.nextToken();
        }
        return DBMapping.convert(from, sql, tokens, replacement, repeat);
    }

    private static String convert(int _from, String sql, String[] tokens, String replacement, boolean repeat) {
        int i;
        int x = 0;
        int from = _from;
        int until = 0;
        HashMap<String, String> variables = new HashMap<String, String>();
        boolean valid = true;
        x = 0;
        while (x < tokens.length && valid) {
            if (tokens[x].equals("?") && x + 1 < tokens.length && !tokens[x + 1].equals(" ")) {
                int n = until = x + 2 < tokens.length ? sql.indexOf(" ", from + 1) : sql.length();
                if (until < 0) {
                    from = sql.length();
                } else {
                    variables.put(String.valueOf(tokens[x++]) + tokens[x], sql.substring(from, until));
                    from = until;
                }
            } else {
                int end = from + tokens[x].length();
                String fragment = null;
                if (end <= sql.length() && (fragment = sql.substring(from, end)).equalsIgnoreCase(tokens[x])) {
                    from += tokens[x].length();
                    until = end;
                } else {
                    valid = false;
                    int counter = 0;
                    if (x > 0 && tokens[x - 1].equals(" ")) {
                        while (!valid && fragment != null && fragment.length() > 0 && fragment.charAt(0) == ' ' && end + ++counter < sql.length()) {
                            fragment = sql.substring(from + counter, end + counter);
                            if (!fragment.equalsIgnoreCase(tokens[x])) continue;
                            valid = true;
                            from = end + counter;
                        }
                    }
                }
            }
            ++x;
        }
        if (valid) {
            String insert = replacement;
            if (variables.size() > 0) {
                for (String key : variables.keySet()) {
                    String value = (String)variables.get(key);
                    int i2 = 0;
                    while (i2 < insert.length() && (i2 = insert.indexOf(key, i2)) >= 0) {
                        insert = String.valueOf(insert.substring(0, i2)) + value + insert.substring(i2 + key.length());
                    }
                }
            }
            sql = String.valueOf(sql.substring(0, _from)) + insert + sql.substring(until);
        }
        if (repeat && (i = _from + replacement.length()) < sql.length() && (from = sql.indexOf(tokens[0], i)) > 0) {
            sql = DBMapping.convert(from, sql, tokens, replacement, repeat);
        }
        return sql;
    }

    private static int firstOccurenceOfCharacter(String string, String characters) {
        int i = 0;
        while (i < string.length()) {
            int j = 0;
            while (j < characters.length()) {
                if (string.charAt(i) == characters.charAt(j)) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    protected void addInstructionMapping(String key, String value) {
        if (key == null || key.trim().length() == 0 || key.trim().length() == 1 && key.charAt(0) == '^') {
            return;
        }
        this.instructionMappings.put(key.trim(), value);
        this.instructionList.add(key.trim());
    }

    public int getJDBCTypeFor(String javaType) {
        return (Integer)this.jdbcMappings.get(javaType);
    }

    public boolean instructionCommentOnTableSupported() {
        return this.commentOnTableSupport;
    }

    public boolean instructionCommentOnColumnSupported() {
        return this.commentOnColumnSupport;
    }

    public boolean cascadeUpdateSupport() {
        return this.cascadeUpdateSupport;
    }

    public boolean cascadeDeletionSupport() {
        return this.cascadeDeletionSupport;
    }

    public boolean addConstraintForeignKeyColumns() {
        return !this.constraintForeignKeyColumns.equals("");
    }

    public String getConstraintForeignKeyColumns() {
        return this.constraintForeignKeyColumns;
    }

    public String getSQLDefinition(String javaType) {
        return this.getSQLDefinition(javaType, 0, 0);
    }

    public String getSQLDefinition(String javaType, int length) {
        return this.getSQLDefinition(javaType, length, 0);
    }

    public String getSQLDefinition(String javaType, int length, int scale) {
        String definition = null;
        try {
            definition = (String)this.sqlMappings.get(javaType.trim());
            if (length != 0 || scale != 0) {
                String stripped_definition = null;
                String definition_extension = "";
                String sLength = null;
                String sScale = null;
                if (definition.indexOf(40) > -1) {
                    stripped_definition = definition.substring(0, definition.indexOf(40));
                    String ls = definition.substring(definition.indexOf(40) + 1, definition.indexOf(41));
                    definition_extension = definition.substring(definition.indexOf(41) + 1);
                    if (ls.indexOf(44) == -1) {
                        sLength = ls.trim();
                    } else {
                        sLength = ls.substring(0, ls.indexOf(44)).trim();
                        sScale = ls.substring(ls.indexOf(44) + 1).trim();
                    }
                }
                if (length != 0) {
                    sLength = Integer.toString(length);
                }
                if (scale != 0) {
                    sScale = Integer.toString(scale);
                }
                definition = stripped_definition;
                if (sLength != null) {
                    definition = String.valueOf(definition) + "(" + sLength;
                    if (sScale != null) {
                        definition = String.valueOf(definition) + "," + sScale;
                    }
                    definition = String.valueOf(definition) + ")";
                }
                definition = String.valueOf(definition) + definition_extension;
            }
        }
        catch (Exception e) {
            Log.error((String)e.getMessage());
            e.printStackTrace();
        }
        return definition;
    }

    private void map(Node node) {
        if (node != null) {
            NodeList nl = node.getChildNodes();
            int x = 0;
            while (x < nl.getLength()) {
                if (nl.item(x).getNodeType() == 1) {
                    Element mapping = (Element)nl.item(x);
                    if (mapping.getNodeName().equals("type-mapping")) {
                        String jdbcType;
                        String javaType = mapping.getAttribute("javatype");
                        Log.info((String)("(Re)map javaType " + javaType + " to JDBCType " + mapping.getAttribute("jdbctype") + " and SQLType " + mapping.getAttribute("sqltype")));
                        String sqlType = mapping.getAttribute("sqltype");
                        if (sqlType != null && !sqlType.equals("")) {
                            this.sqlMappings.put(javaType, sqlType);
                        }
                        if ((jdbcType = mapping.getAttribute("jdbctype")) != null && !jdbcType.equals("")) {
                            int type = DBMapping.translateToJDBCType(jdbcType);
                            this.jdbcMappings.put(javaType, new Integer(type));
                        }
                    } else if (mapping.getNodeName().equals("instruction-mapping")) {
                        String from = mapping.getAttribute("instruction");
                        String to = mapping.getAttribute("replacement");
                        Log.info((String)("(Re)map instruction " + from + " with " + to));
                        this.addInstructionMapping(from, to);
                    } else if (mapping.getNodeName().equals("non-standard-sql-instructions-support")) {
                        this.commentOnTableSupport = mapping.getAttribute("comment-on-table").equals("true");
                        this.commentOnColumnSupport = mapping.getAttribute("comment-on-column").equals("true");
                        this.cascadeDeletionSupport = mapping.getAttribute("cascade-deletion").equals("true");
                        this.cascadeUpdateSupport = mapping.getAttribute("cascade-update").equals("true");
                        this.constraintForeignKeyColumns = mapping.getAttribute("constraint-on-foreignkey-columns");
                    }
                }
                ++x;
            }
        }
        int x = 0;
        while (x < javaTypes.length) {
            if (!this.jdbcMappings.containsKey(javaTypes[x])) {
                this.jdbcMappings.put(javaTypes[x], defaultJDBCMappings.get(javaTypes[x]));
            }
            if (!this.sqlMappings.containsKey(javaTypes[x])) {
                this.sqlMappings.put(javaTypes[x], defaultSQLMappings.get(javaTypes[x]));
            }
            ++x;
        }
    }

    private static int translateToJDBCType(String type) {
        if (type.equals("ARRAY")) {
            return 2003;
        }
        if (type.equals("BIGINT")) {
            return -5;
        }
        if (type.equals("BINARY")) {
            return -2;
        }
        if (type.equals("BIT")) {
            return -7;
        }
        if (type.equals("BLOB")) {
            return 2004;
        }
        if (type.equals("BOOLEAN")) {
            return 16;
        }
        if (type.equals("CHAR")) {
            return 1;
        }
        if (type.equals("CLOB")) {
            return 2005;
        }
        if (type.equals("DATE")) {
            return 91;
        }
        if (type.equals("DECIMAL")) {
            return 3;
        }
        if (type.equals("DISTINCT")) {
            return 2001;
        }
        if (type.equals("DOUBLE")) {
            return 8;
        }
        if (type.equals("FLOAT")) {
            return 6;
        }
        if (type.equals("INTEGER")) {
            return 4;
        }
        if (type.equals("JAVA_OBJECT")) {
            return 2000;
        }
        if (type.equals("LONGVARBINARY")) {
            return -4;
        }
        if (type.equals("LONGVARCHAR")) {
            return -1;
        }
        if (type.equals("NULL")) {
            return 0;
        }
        if (type.equals("NUMERIC")) {
            return 2;
        }
        if (type.equals("OTHER")) {
            return 1111;
        }
        if (type.equals("REAL")) {
            return 7;
        }
        if (type.equals("REF")) {
            return 2006;
        }
        if (type.equals("SMALLINT")) {
            return 5;
        }
        if (type.equals("STRUCT")) {
            return 2002;
        }
        if (type.equals("TIME")) {
            return 92;
        }
        if (type.equals("TIMESTAMP")) {
            return 93;
        }
        if (type.equals("VARBINARY")) {
            return -3;
        }
        if (type.equals("VARCHAR")) {
            return 12;
        }
        Log.error((String)("Problem: JDBCType " + type + " is not a valid type! Correct your mapping file!"));
        return Integer.MIN_VALUE;
    }

    private static Node getTypeMappingForDriver(Document doc, String driver) {
        Node node = null;
        NodeList nl = doc.getDocumentElement().getElementsByTagName("driver-mapping");
        int x = 0;
        while (x < nl.getLength()) {
            if (((Element)nl.item(x)).getAttribute("driver").equals(driver)) {
                node = nl.item(x);
                break;
            }
            ++x;
        }
        return node;
    }

    static final class File
    extends java.io.File {
        public File(URL resource) throws Exception {
            super(URLDecoder.decode(resource.getFile(), "UTF-8"));
        }

        public File(String path) {
            super(path);
        }
    }
}

