/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBConnectionPool;
import nl.ibs.jsql.sql.PersistenceMetaData;

public class DBObjectIDGenerator
implements PersistenceMetaData {
    private static Hashtable ids = new Hashtable();
    private static Set javaVariableNames = new HashSet();
    private static HashMap fieldNames = new HashMap();
    private static HashMap fieldDescriptions = new HashMap();
    private static HashMap javaToBONameMapping = new HashMap();
    private static Set javaPKVariableNames = new HashSet();
    private static final String AUTO_ID = "AutoID";
    private static final String LOWEST_ID = "LowestID";
    private static final long INITIAL_ID = 1L;
    private static final String BUSINESSOBJECT_NAME = "BusinessObjectName";
    private static PersistenceMetaData inst = new DBObjectIDGenerator();

    public DBObjectIDGenerator() {
        fieldNames.put(BUSINESSOBJECT_NAME, "BONAME");
        fieldNames.put(LOWEST_ID, "HIGHESTID");
        fieldDescriptions.put(BUSINESSOBJECT_NAME, "Key to BusinessObject");
        fieldDescriptions.put(LOWEST_ID, "LowestID that is not yet claimed!");
        javaToBONameMapping.put("name", BUSINESSOBJECT_NAME);
        javaToBONameMapping.put("objectId", LOWEST_ID);
        javaVariableNames.add("name");
        javaVariableNames.add("objectId");
        javaPKVariableNames.add("objectId");
    }

    public static PersistenceMetaData getInstance() {
        return inst;
    }

    @Override
    public PersistenceMetaData getPersistingPMD() {
        return inst;
    }

    @Override
    public String getBusinessObjectName() {
        return "DBObjectIDGenerator";
    }

    @Override
    public String getTableName(ConnectionProvider provider) {
        return provider.getORMapping().getTableName(AUTO_ID, "AUTOID");
    }

    @Override
    public String getTableName(String objectName, ConnectionProvider provider) {
        return provider.getORMapping().getTableName(objectName, objectName.toUpperCase());
    }

    @Override
    public String getFieldDescription(String name) {
        return (String)fieldDescriptions.get(name);
    }

    @Override
    public String getFieldName(String name, ConnectionProvider provider) {
        return provider.getORMapping().getTableFieldName(name, "CD", (String)fieldNames.get(name));
    }

    @Override
    public String getFieldName(String fieldName, String objectName, ConnectionProvider provider) {
        return provider.getORMapping().getTableFieldName(fieldName, objectName, fieldName.toUpperCase());
    }

    @Override
    public String getFieldNameForJavaField(String javaFieldName, ConnectionProvider provider) {
        return this.getFieldName((String)javaToBONameMapping.get(javaFieldName), provider);
    }

    @Override
    public String getTableDescription() {
        return "Table contains the lowest free ID for BuinessObjects";
    }

    @Override
    public String getTableDefinition(ConnectionProvider provider) {
        return new String("CREATE TABLE " + provider.getPrefix() + this.getTableName(provider) + " (" + this.getFieldName(BUSINESSOBJECT_NAME, provider) + " " + provider.getDBMapping().getSQLDefinition("String", 254, 0) + " NOT NULL\t," + this.getFieldName(LOWEST_ID, provider) + " " + provider.getDBMapping().getSQLDefinition("long", 19, 0) + " DEFAULT " + 1L + " NOT NULL )");
    }

    @Override
    public Set getJavaVariableNames() {
        return javaVariableNames;
    }

    @Override
    public Set getJavaPKFieldNames() {
        return javaPKVariableNames;
    }

    @Override
    public boolean isBackwardReference(String javaVariableNameOfRelation) {
        return false;
    }

    @Override
    public Map getAssociativeTableDefinitions(ConnectionProvider provider) {
        return new HashMap();
    }

    @Override
    public String[][] getColumnDefinitions(ConnectionProvider provider) {
        String[][] columnDefinitions = new String[2][4];
        columnDefinitions[0] = new String[]{this.getFieldName(BUSINESSOBJECT_NAME, provider), provider.getDBMapping().getSQLDefinition("String", 254, 0), "''", " NOT NULL", "Key to BusinessObject"};
        columnDefinitions[1] = new String[]{this.getFieldName(LOWEST_ID, provider), provider.getDBMapping().getSQLDefinition("long", 19, 0), String.valueOf(1L), " NOT NULL", "LowestID that is not yet claimed!"};
        return columnDefinitions;
    }

    @Override
    public Map getIndexDefinitions(ConnectionProvider provider) {
        return new HashMap();
    }

    @Override
    public Map getConstraintDefinitions(ConnectionProvider provider) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("JSQL_PK_DBOBJECTIDGENERATOR", " CONSTRAINT " + provider.getPrefix() + "JSQL_PK_DBOBJECTIDGENERATOR PRIMARY KEY(" + this.getFieldName(BUSINESSOBJECT_NAME, provider) + ")");
        return map;
    }

    @Override
    public PersistenceMetaData getRelationPersistenceMetaData(String javaFieldName) {
        return null;
    }

    @Override
    public String[][] getRelationColomnPairs(String javaFieldName, ConnectionProvider provider) {
        return null;
    }

    @Override
    public String[][] getManyToManyColomnPairs(String javaFieldName, ConnectionProvider provider, String type) {
        return null;
    }

    @Override
    public String getRelationType(String javaVariableNameOfRelation) {
        return null;
    }

    @Override
    public String getRelationMultiplicity(String javaVariableNameOfRelation) {
        return null;
    }

    @Override
    public String getAssociationTableName(String javaVariableNameOfRelation, ConnectionProvider provider) {
        return null;
    }

    @Override
    public boolean containsJavaVariable(String javaFieldName) {
        return javaToBONameMapping.containsKey(javaFieldName);
    }

    @Override
    public boolean definesTable() {
        return true;
    }

    @Override
    public boolean isPersistable(Object object) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNewID(String name, ConnectionProvider provider) throws Exception {
        Hashtable hashtable = ids;
        synchronized (hashtable) {
            ObjectID id = (ObjectID)ids.get(name);
            if (id != null && id.lowID == 0L) {
                ++id.lowID;
            }
            if (id == null || id.lowID >= id.highID) {
                id = DBObjectIDGenerator.getNewObjectID(name, id, provider);
                ids.put(name, id);
            }
            return id.lowID++;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ObjectID getNewObjectID(String name, ObjectID prev, ConnectionProvider provider) throws Exception {
        ObjectID id;
        block20: {
            int n;
            int attempsLeft;
            block19: {
                String pskeyQuery = "autoIDUpdtQryStmt";
                String pskeyUpdate = "autoIDUpdtWrtStmt";
                String pskeyInsert = "autoIDUpdtInsStmt";
                id = prev;
                attempsLeft = 15;
                if (!true) break block19;
                n = attempsLeft;
                attempsLeft = (short)(n - 1);
                if (n <= 0) break block20;
            }
            do {
                DBData dbData = provider.getDBData();
                DBConnectionPool pool = DBConnectionPool.getInstance(dbData);
                DBConnection con = pool.getConnection();
                ResultSet rs = null;
                try {
                    try {
                        int updated;
                        PreparedStatement readStatement = con.getPreparedStatement("autoIDUpdtQryStmt");
                        if (readStatement == null) {
                            readStatement = con.getPreparedStatement("autoIDUpdtQryStmt", " SELECT " + DBObjectIDGenerator.getInstance().getFieldName(LOWEST_ID, provider) + " FROM " + provider.getPrefix() + DBObjectIDGenerator.getInstance().getTableName(provider) + " WHERE " + DBObjectIDGenerator.getInstance().getFieldName(BUSINESSOBJECT_NAME, provider) + "=?");
                        }
                        readStatement.setString(1, name);
                        readStatement.execute();
                        rs = readStatement.getResultSet();
                        if (rs.next()) {
                            long prevLowest = rs.getLong(1);
                            id = DBObjectIDGenerator.createOrUpdateObjectID(name, id, prevLowest);
                            PreparedStatement updateStatement = con.getPreparedStatement("autoIDUpdtWrtStmt");
                            if (updateStatement == null) {
                                updateStatement = con.getPreparedStatement("autoIDUpdtWrtStmt", " UPDATE " + provider.getPrefix() + DBObjectIDGenerator.getInstance().getTableName(provider) + " SET " + DBObjectIDGenerator.getInstance().getFieldName(LOWEST_ID, provider) + "=?" + " WHERE " + DBObjectIDGenerator.getInstance().getFieldName(BUSINESSOBJECT_NAME, provider) + "=?" + " AND " + DBObjectIDGenerator.getInstance().getFieldName(LOWEST_ID, provider) + "=?");
                            }
                            updateStatement.setLong(1, id.highID);
                            updateStatement.setString(2, id.name);
                            updateStatement.setLong(3, prevLowest);
                            updated = updateStatement.executeUpdate();
                        } else {
                            id = DBObjectIDGenerator.createOrUpdateObjectID(name, id, 1L);
                            PreparedStatement insertStatement = con.getPreparedStatement("autoIDUpdtInsStmt");
                            if (insertStatement == null) {
                                insertStatement = con.getPreparedStatement("autoIDUpdtInsStmt", " INSERT INTO " + provider.getPrefix() + DBObjectIDGenerator.getInstance().getTableName(provider) + " VALUES (?,?)");
                            }
                            insertStatement.setString(1, id.name);
                            insertStatement.setLong(2, id.highID);
                            updated = insertStatement.executeUpdate();
                        }
                        if (updated > 0) {
                            attempsLeft = 0;
                        }
                    }
                    catch (Exception e) {
                        Log.error((String)e.getMessage());
                        e.printStackTrace();
                        throw e;
                    }
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception exception) {}
                    }
                    pool.returnConnection(con);
                }
                n = attempsLeft;
                attempsLeft = (short)(n - 1);
            } while (n > 0);
        }
        return id;
    }

    public static ObjectID createOrUpdateObjectID(String name, ObjectID id, long low) {
        long timeSpan;
        if (id == null) {
            id = new ObjectID(name);
        }
        if ((timeSpan = System.currentTimeMillis() - id.time) > 10000L) {
            id.span /= 10L;
        } else if (timeSpan < 1000L) {
            id.span *= 10L;
        }
        if (id.span < 1L) {
            id.span = 1L;
        } else if (id.span > 100L) {
            id.span = 100L;
        }
        id.lowID = low;
        id.highID = id.lowID + id.span;
        id.time = System.currentTimeMillis();
        return id;
    }

    static class ObjectID {
        String name = "";
        long lowID = 0L;
        long highID = 0L;
        long span = 1L;
        long time = 0L;

        public ObjectID(String _name) {
            this.name = _name;
        }
    }
}

