/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql.sql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.sql.ForeignKeyColumnPair;

public class ForeignKeyDefinition {
    private TreeMap foreignKeyColumnPairs = new TreeMap();
    public static final short UPDATE_RULE_KEY_NO_ACTION = 3;
    public static final short UPDATE_RULE_KEY_CASCADE = 0;
    public static final short UPDATE_RULE_KEY_SET_NULL = 2;
    public static final short UPDATE_RULE_KEY_SET_DEFAULT = 4;
    public static final short UPDATE_RULE_KEY_RESTRICT = 1;
    public static final short DELETE_RULE_KEY_NO_ACTION = 3;
    public static final short DELETE_RULE_KEY_CASCADE = 0;
    public static final short DELETE_RULE_KEY_SET_NULL = 2;
    public static final short DELETE_RULE_KEY_RESTRICT = 1;
    public static final short DELETE_RULE_KEY_SET_DEFAULT = 4;
    public static final short DEFERRABLITY_KEY_INITIALLY_DEFERRED = 5;
    public static final short DEFERRABLITY_KEY_INITIALLY_IMMEDIATE = 6;
    public static final short DEFERRABLITY_KEY_NOT_DEFERABLE = 7;
    private String PKTableCatalog;
    private String PKTableSchema;
    private String PKTableName;
    private String FKTableCatalog;
    private String FKTableSchema;
    private String FKTableName;
    private short updateRule;
    private short deleteRule;
    private String FKName;
    private String PKName;
    private short deferrability;

    public static HashMap getForeignKeyDefinitions(String schemaPattern, String tablePattern, DatabaseMetaData meta) {
        HashMap<String, ForeignKeyDefinition> map;
        block15: {
            map = new HashMap<String, ForeignKeyDefinition>();
            ResultSet rs = null;
            String _schemaPattern = schemaPattern == null || schemaPattern.equals("") ? null : schemaPattern;
            try {
                try {
                    rs = meta.getImportedKeys(null, _schemaPattern, tablePattern);
                    while (rs.next()) {
                        String name = rs.getString(12);
                        if (name == null || name.trim().equals("")) {
                            Log.error((String)"Found foreign key without name, this is not permitted and may cause problems");
                            continue;
                        }
                        ForeignKeyDefinition definition = (ForeignKeyDefinition)map.get(name);
                        if (definition == null) {
                            definition = new ForeignKeyDefinition(rs, meta);
                            map.put(name, definition);
                            continue;
                        }
                        definition.update(rs, meta);
                    }
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                    e.printStackTrace();
                    if (rs == null) break block15;
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return map;
    }

    private ForeignKeyDefinition(ResultSet rs, DatabaseMetaData meta) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int z = rsmd.getColumnCount();
            if (z < 1) {
                return;
            }
            this.PKTableCatalog = rs.getString(1);
            if (z < 2) {
                return;
            }
            this.PKTableSchema = rs.getString(2);
            if (z < 3) {
                return;
            }
            this.PKTableName = rs.getString(3);
            if (z < 5) {
                return;
            }
            this.FKTableCatalog = rs.getString(5);
            if (z < 6) {
                return;
            }
            this.FKTableSchema = rs.getString(6);
            if (z < 7) {
                return;
            }
            this.FKTableName = rs.getString(7);
            if (z < 10) {
                return;
            }
            this.updateRule = rs.getShort(10);
            if (z < 11) {
                return;
            }
            this.deleteRule = rs.getShort(11);
            if (z < 12) {
                return;
            }
            this.FKName = rs.getString(12);
            if (z < 13) {
                return;
            }
            this.PKName = rs.getString(13);
            if (z < 14) {
                return;
            }
            this.deferrability = rs.getShort(14);
            this.update(rs, meta);
        }
        catch (Exception e) {
            Log.error((String)e.getMessage());
            e.printStackTrace();
        }
    }

    public void update(ResultSet rs, DatabaseMetaData meta) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            if (rsmd.getColumnCount() < 9) {
                return;
            }
            ForeignKeyColumnPair pair = new ForeignKeyColumnPair();
            pair.PKColumnName = rs.getString(4);
            pair.FKColumnName = rs.getString(8);
            short _keySeq = rs.getShort(9);
            this.foreignKeyColumnPairs.put(new Integer(_keySeq - 1), pair);
        }
        catch (Exception e) {
            Log.error((String)e.getMessage());
            e.printStackTrace();
        }
    }

    public short getDeferrability() {
        return this.deferrability;
    }

    public String getFKName() {
        return this.FKName;
    }

    public String getFKTableCatalog() {
        return this.FKTableCatalog;
    }

    public String getFKTableName() {
        return this.FKTableName;
    }

    public String getFKTableSchema() {
        return this.FKTableSchema;
    }

    public ForeignKeyColumnPair[] getForeignKeyColumnPairs() {
        ForeignKeyColumnPair[] fkcps = new ForeignKeyColumnPair[this.foreignKeyColumnPairs.size()];
        Iterator it = this.foreignKeyColumnPairs.values().iterator();
        int i = 0;
        while (i < fkcps.length && it.hasNext()) {
            fkcps[i] = (ForeignKeyColumnPair)it.next();
            ++i;
        }
        return fkcps;
    }

    public String getPKName() {
        return this.PKName;
    }

    public String getPKTableCatalog() {
        return this.PKTableCatalog;
    }

    public String getPKTableName() {
        return this.PKTableName;
    }

    public String getPKTableSchema() {
        return this.PKTableSchema;
    }

    public short getUpdateRule() {
        return this.updateRule;
    }

    public short getDeleteRule() {
        return this.deleteRule;
    }
}

