/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql.sql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.sql.IndexColumn;

public class IndexDefinition {
    private TreeMap indexColumns = new TreeMap();
    public static final short TYPE_TABLE_STATISTICS_AND_INDEX_DESCRIPTIONS = 0;
    public static final short TYPE_CLUSTERED_INDEX = 1;
    public static final short TYPE_HASHED_INDEX = 2;
    public static final short TYPE_OTHER_INDEX = 3;
    private String tableCatalog;
    private String tableSchema;
    private String tableName;
    private boolean nonUnique;
    private String indexQualifier;
    private String indexName;
    private short indexType;
    private int cardinality;
    private int pages;
    private String filterCondition;

    public static HashMap getIndexDefinitions(String schemaPattern, String tablePattern, DatabaseMetaData meta) {
        HashMap<String, IndexDefinition> map;
        block15: {
            map = new HashMap<String, IndexDefinition>();
            String _schemaPattern = schemaPattern == null || schemaPattern.equals("") ? null : schemaPattern;
            ResultSet rs = null;
            try {
                try {
                    rs = meta.getIndexInfo(null, _schemaPattern, tablePattern, false, false);
                    while (rs.next()) {
                        String name = rs.getString(6);
                        if (name == null || name.trim().equals("")) {
                            if (rs.getShort(7) == 0) continue;
                            Log.warn((String)("Found index without name omn table " + rs.getString(3) + ". Index will not be deleted"));
                            continue;
                        }
                        IndexDefinition definition = (IndexDefinition)map.get(name);
                        if (definition == null) {
                            definition = new IndexDefinition(rs, meta);
                            map.put(name, definition);
                            continue;
                        }
                        definition.update(rs, meta);
                    }
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                    e.printStackTrace();
                    if (rs == null) break block15;
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return map;
    }

    private IndexDefinition(ResultSet rs, DatabaseMetaData meta) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int z = rsmd.getColumnCount();
            if (z < 1) {
                return;
            }
            this.tableCatalog = rs.getString(1);
            if (z < 2) {
                return;
            }
            this.tableSchema = rs.getString(2);
            if (z < 3) {
                return;
            }
            this.tableName = rs.getString(3);
            if (z < 4) {
                return;
            }
            this.nonUnique = rs.getBoolean(4);
            if (z < 5) {
                return;
            }
            this.indexQualifier = rs.getString(5);
            if (z < 6) {
                return;
            }
            this.indexName = rs.getString(6);
            if (z < 7) {
                return;
            }
            this.indexType = rs.getShort(7);
            this.update(rs, meta);
            if (z < 11) {
                return;
            }
            this.cardinality = rs.getInt(11);
            if (z < 12) {
                return;
            }
            this.pages = rs.getInt(12);
            if (z < 13) {
                return;
            }
            this.filterCondition = rs.getString(13);
        }
        catch (Exception e) {
            Log.error((String)e.getMessage());
            e.printStackTrace();
        }
    }

    public void update(ResultSet rs, DatabaseMetaData meta) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            if (rsmd.getColumnCount() < 10) {
                return;
            }
            IndexColumn ic = new IndexColumn();
            ic.columnName = rs.getString(9);
            ic.sortSequence = rs.getString(10);
            short seq = rs.getShort(8);
            this.indexColumns.put(new Integer(seq - 1), ic);
        }
        catch (Exception e) {
            Log.error((String)e.getMessage());
            e.printStackTrace();
        }
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public IndexColumn[] getIndexColumns() {
        IndexColumn[] ics = new IndexColumn[this.indexColumns.size()];
        Iterator it = this.indexColumns.values().iterator();
        int i = 0;
        while (i < ics.length && it.hasNext()) {
            ics[i] = (IndexColumn)it.next();
            ++i;
        }
        return ics;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getIndexQualifier() {
        return this.indexQualifier;
    }

    public short getIndexType() {
        return this.indexType;
    }

    public boolean isNonUnique() {
        return this.nonUnique;
    }

    public int getPages() {
        return this.pages;
    }

    public String getTableCatalog() {
        return this.tableCatalog;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableSchema() {
        return this.tableSchema;
    }
}

