/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql.sql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Iterator;
import java.util.TreeMap;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.sql.PrimaryKeyColumn;

public class PrimaryKeyDefinition {
    private TreeMap keyColumns = new TreeMap();
    private String tableCatalog;
    private String tableSchema;
    private String tableName;
    private String name;

    public static PrimaryKeyDefinition getPrimaryKeyDefinition(String schemaPattern, String tablePattern, DatabaseMetaData meta) {
        PrimaryKeyDefinition definition;
        block14: {
            definition = null;
            String _schemaPattern = schemaPattern == null || schemaPattern.equals("") ? null : schemaPattern;
            ResultSet rs = null;
            try {
                try {
                    rs = meta.getPrimaryKeys(null, _schemaPattern, tablePattern);
                    while (rs.next()) {
                        if (definition == null) {
                            definition = new PrimaryKeyDefinition(rs, meta);
                            continue;
                        }
                        definition.update(rs, meta);
                    }
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                    e.printStackTrace();
                    if (rs == null) break block14;
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return definition;
    }

    private PrimaryKeyDefinition(ResultSet rs, DatabaseMetaData meta) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int z = rsmd.getColumnCount();
            if (z < 1) {
                return;
            }
            this.tableCatalog = rs.getString(1);
            if (z < 2) {
                return;
            }
            this.tableSchema = rs.getString(2);
            if (z < 3) {
                return;
            }
            this.tableName = rs.getString(3);
            if (z < 4) {
                return;
            }
            if (z < 5) {
                return;
            }
            this.update(rs, meta);
            if (z < 6) {
                return;
            }
            this.name = rs.getString(6);
        }
        catch (Exception e) {
            Log.error((String)e.getMessage());
            e.printStackTrace();
        }
    }

    public void update(ResultSet rs, DatabaseMetaData meta) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            if (rsmd.getColumnCount() < 5) {
                return;
            }
            PrimaryKeyColumn pkc = new PrimaryKeyColumn();
            pkc.columnName = rs.getString(4);
            short seq = rs.getShort(5);
            this.keyColumns.put(new Integer(seq - 1), pkc);
        }
        catch (Exception e) {
            Log.error((String)e.getMessage());
            e.printStackTrace();
        }
    }

    public PrimaryKeyColumn[] getPrimaryKeyColumns() {
        PrimaryKeyColumn[] pks = new PrimaryKeyColumn[this.keyColumns.size()];
        Iterator it = this.keyColumns.values().iterator();
        int i = 0;
        while (i < pks.length && it.hasNext()) {
            pks[i] = (PrimaryKeyColumn)it.next();
            ++i;
        }
        return pks;
    }

    public String getTableCatalog() {
        return this.tableCatalog;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableSchema() {
        return this.tableSchema;
    }

    public String getName() {
        return this.name;
    }
}

