/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql.sql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.HashMap;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.sql.ColumnDefinition;
import nl.ibs.jsql.sql.DBConnectionPool;
import nl.ibs.jsql.sql.ForeignKeyDefinition;
import nl.ibs.jsql.sql.IndexDefinition;
import nl.ibs.jsql.sql.PrimaryKeyDefinition;

public class TableDefinition {
    public String tableCatalog;
    public String tableSchema;
    public String tableName;
    public String tableType;
    public String explanatoryComment;
    private HashMap columnDefinitions;
    private HashMap indexDefinitions;
    private HashMap foreignKeyDefinitions;
    private PrimaryKeyDefinition primaryKeyDefinition;
    private DatabaseMetaData meta;

    public static HashMap getTableDefinitions(DBConnectionPool pool) throws Exception {
        return TableDefinition.getTableDefinitions(new String[]{"TABLE"}, pool);
    }

    public static HashMap getTableDefinitions(String[] types, DBConnectionPool pool) throws Exception {
        return TableDefinition.getTableDefinitions("_%", types, pool);
    }

    public HashMap getColumnDefinitions() {
        return this.columnDefinitions;
    }

    public static HashMap getTableDefinitions(String table, String[] types, DBConnectionPool pool) throws Exception {
        HashMap<String, TableDefinition> map;
        block13: {
            map = new HashMap<String, TableDefinition>();
            DatabaseMetaData metaData = pool.getDatabaseMetaData();
            String schema = pool.getSchema();
            String _schema = schema == null || schema.equals("") ? null : schema;
            ResultSet rs = null;
            try {
                try {
                    rs = metaData.getTables(null, _schema, table, types);
                    while (rs.next()) {
                        TableDefinition definition = new TableDefinition(rs, metaData);
                        String name = definition.tableName.toUpperCase();
                        if (map.containsKey(name)) continue;
                        map.put(name, definition);
                    }
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                    e.printStackTrace();
                    if (rs == null) break block13;
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return map;
    }

    private TableDefinition(ResultSet rs, DatabaseMetaData meta) {
        this.meta = meta;
        try {
            this.tableCatalog = rs.getString(1);
            this.tableSchema = rs.getString(2);
            this.tableName = rs.getString(3);
            this.tableType = rs.getString(4);
            this.explanatoryComment = rs.getString(5);
        }
        catch (Exception e) {
            Log.error((String)e.getMessage());
            e.printStackTrace();
        }
        this.columnDefinitions = ColumnDefinition.getColumnDefinitions(this.tableSchema, this.tableName, meta);
    }

    public String getExplanatoryComment() {
        return this.explanatoryComment;
    }

    public PrimaryKeyDefinition getPrimaryKeyDefinition() {
        if (this.primaryKeyDefinition == null) {
            this.primaryKeyDefinition = PrimaryKeyDefinition.getPrimaryKeyDefinition(this.tableSchema, this.tableName, this.meta);
        }
        return this.primaryKeyDefinition;
    }

    public HashMap getForeignKeyDefinitions() {
        if (this.foreignKeyDefinitions == null) {
            this.foreignKeyDefinitions = ForeignKeyDefinition.getForeignKeyDefinitions(this.tableSchema, this.tableName, this.meta);
        }
        return this.foreignKeyDefinitions;
    }

    public HashMap getIndexDefinitions() {
        if (this.indexDefinitions == null) {
            this.indexDefinitions = IndexDefinition.getIndexDefinitions(this.tableSchema, this.tableName, this.meta);
        }
        return this.indexDefinitions;
    }

    public String getTableCatalog() {
        return this.tableCatalog;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableSchema() {
        return this.tableSchema;
    }

    public String getTableType() {
        return this.tableType;
    }
}

