/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CharacterDataArea;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import nl.ibs.util.AS400Enhanced;
import nl.ibs.util.DetectCallerClass;

public class AS400ConnectionManager {
    private Hashtable as400Connections = new Hashtable();
    private Hashtable leasedObjects = new Hashtable();
    private static AS400ConnectionManager singleton = null;
    private int activeConnections = 0;
    private long maximumIdleTime = 1800000L;
    private Thread itm = null;
    private IdleTimeManager idleTimemanager = new IdleTimeManager();
    private int iMaxPoolsize = 20;
    private int leasedConnections = 0;
    private boolean debug = false;
    private static final String LINESEPARATOR = System.getProperty("line.separator");

    private AS400ConnectionManager() {
        this.itm = new Thread(this.idleTimemanager);
        this.itm.setDaemon(true);
        this.itm.start();
    }

    public static synchronized AS400ConnectionManager instance() {
        if (singleton == null) {
            singleton = new AS400ConnectionManager();
        }
        return singleton;
    }

    public synchronized AS400Enhanced getConnection() {
        return new AS400Enhanced();
    }

    public AS400Enhanced getConnection(String systemName, String userProfile, String passWord) {
        try {
            return this.getNonNullConnection(systemName, userProfile, passWord);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AS400Enhanced getNonNullConnection(String systemName, String userProfile, String password) throws Exception {
        String key = this.createKey(systemName, userProfile, password);
        AS400Enhanced as = null;
        Vector connectionPool = null;
        Hashtable hashtable = this.as400Connections;
        synchronized (hashtable) {
            if (this.as400Connections.containsKey(key)) {
                connectionPool = (Vector)this.as400Connections.get(key);
                if (!connectionPool.isEmpty()) {
                    try {
                        AS400Enhanced ast = (AS400Enhanced)((Object)connectionPool.elementAt(0));
                        CharacterDataArea da = new CharacterDataArea((AS400)ast, "/QSYS.LIB/QTEMP.LIB/CHKCONN.dtaara");
                        da.create();
                        da.delete();
                    }
                    catch (Exception e) {
                        connectionPool = new Vector();
                        this.putAs400Connections(key, connectionPool);
                    }
                }
            } else {
                connectionPool = new Vector();
                this.putAs400Connections(key, connectionPool);
            }
            if (connectionPool.isEmpty()) {
                as = new AS400Enhanced(systemName, userProfile, password);
                AS400.addPasswordCacheEntry((String)systemName, (String)userProfile, (String)password);
            } else {
                as = (AS400Enhanced)((Object)connectionPool.elementAt(0));
                connectionPool.removeElement((Object)as);
                --this.activeConnections;
                if (this.debug) {
                    System.out.println("AS400ConnectionManager- Recycled connection for " + systemName + "," + userProfile + " ActiveConnections=" + ++this.activeConnections);
                }
            }
        }
        if (this.debug) {
            this.leasedObjects.put(as, new LeaseInformation(DetectCallerClass.detectCaller()));
        }
        ++this.leasedConnections;
        return as;
    }

    public void returnConnection(String systemName, String userProfile, String passWord, AS400Enhanced connection) {
        String key = this.createKey(systemName, userProfile, passWord);
        this.returnConnection(key, connection);
    }

    public void returnConnection(AS400Enhanced connection) {
        String key = this.createKey(connection, "????");
        this.returnConnection(key, connection);
    }

    public void returnConnection(AS400Enhanced connection, String password) {
        String key = this.createKey(connection, password);
        this.returnConnection(key, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnConnection(String key, AS400Enhanced connection) {
        --this.leasedConnections;
        if (this.debug) {
            this.leasedObjects.remove((Object)connection);
        }
        if (this.activeConnections > this.iMaxPoolsize) {
            connection.disconnectAllServices();
            connection = null;
            return;
        }
        Vector connectionPool = null;
        Hashtable hashtable = this.as400Connections;
        synchronized (hashtable) {
            if (this.as400Connections.containsKey(key)) {
                connectionPool = (Vector)this.as400Connections.get(key);
            } else {
                connectionPool = new Vector();
                this.putAs400Connections(key, connectionPool);
            }
            connection.setStartIdleTime(System.currentTimeMillis());
            connectionPool.addElement(connection);
            ++this.activeConnections;
        }
    }

    public void setMaxPoolsize(int iMaxPoolsize) {
        this.iMaxPoolsize = iMaxPoolsize;
    }

    private synchronized void putAs400Connections(String key, Vector connectionpool) {
        this.as400Connections.put(key, connectionpool);
    }

    private String createKey(AS400Enhanced connection, String password) {
        return this.createKey(connection.getSystemName(), connection.getUserId(), password);
    }

    private String createKey(String system, String userId, String password) {
        return String.valueOf(system.toUpperCase().trim()) + ";" + userId.toUpperCase().trim() + ";" + password.toUpperCase().trim();
    }

    public long getMaximumIdleTime() {
        return this.maximumIdleTime;
    }

    public void setMaximumIdleTime(long maximumIdleTime) {
        this.maximumIdleTime = maximumIdleTime;
    }

    protected void finalize() throws Throwable {
        this.disconnectAll();
    }

    public void disconnectAll() {
        for (Map.Entry entry : this.as400Connections.entrySet()) {
            Vector pool = (Vector)entry.getValue();
            if (pool == null) continue;
            for (AS400Enhanced ast : pool) {
                ast.disconnectAllServices();
                if (!this.debug) continue;
                System.out.println("Disconnected: " + (Object)((Object)ast));
            }
        }
        this.as400Connections.clear();
        this.idleTimemanager.shutDown();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getJobLogs(String systemName, String userProfile, String password) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("Id");
        sb.append(';');
        sb.append("Type");
        sb.append(';');
        sb.append("Severity");
        sb.append(';');
        sb.append("Time");
        sb.append(';');
        sb.append("FromProgram");
        sb.append(';');
        sb.append("Text");
        sb.append(';');
        sb.append("Help");
        sb.append(';');
        sb.append("SubstitutionData");
        sb.append(';');
        sb.append(LINESEPARATOR);
        Vector connections = this.getConnections(systemName, userProfile, password);
        if (connections != null) {
            int i = 0;
            while (i < connections.size()) {
                AS400Enhanced as400 = (AS400Enhanced)((Object)connections.get(i));
                sb = as400.getJobMessages(sb);
                ++i;
            }
        }
        return sb.toString();
    }

    private Vector getConnections(String systemName, String userProfile, String password) throws Exception {
        String key = this.createKey(systemName, userProfile, password);
        if (this.as400Connections.containsKey(key)) {
            return (Vector)this.as400Connections.get(key);
        }
        return null;
    }

    public class IdleTimeManager
    implements Runnable {
        long checkInterval = 300000L;
        private boolean shutDown = false;

        public IdleTimeManager() {
        }

        public IdleTimeManager(long checkInterval) {
            this.checkInterval = checkInterval;
        }

        public void shutDown() {
            this.shutDown = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.shutDown) {
                try {
                    Thread.sleep(this.checkInterval);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                long currentTime = System.currentTimeMillis();
                Hashtable hashtable = AS400ConnectionManager.this.as400Connections;
                synchronized (hashtable) {
                    Enumeration pools = AS400ConnectionManager.this.as400Connections.elements();
                    int closedConnections = 0;
                    while (pools.hasMoreElements()) {
                        Vector all = (Vector)pools.nextElement();
                        Enumeration connections = all.elements();
                        while (connections.hasMoreElements()) {
                            AS400Enhanced as400 = (AS400Enhanced)((Object)connections.nextElement());
                            if (currentTime - as400.getStartIdleTime() <= AS400ConnectionManager.this.maximumIdleTime) continue;
                            if (AS400ConnectionManager.this.debug) {
                                System.out.println(" ..connection removed by Idletime manager due to exceeding the Idle time limit. Idle time was " + (currentTime - as400.getStartIdleTime()));
                            }
                            all.removeElementAt(all.indexOf((Object)as400));
                            as400.disconnectAllServices();
                            AS400ConnectionManager aS400ConnectionManager = AS400ConnectionManager.this;
                            aS400ConnectionManager.activeConnections = aS400ConnectionManager.activeConnections - 1;
                            ++closedConnections;
                        }
                    }
                    if (AS400ConnectionManager.this.debug) {
                        System.out.println("IdleTimeManager has checked live connections:");
                        System.out.println("         " + closedConnections + " connections are closed.");
                        System.out.println("         " + AS400ConnectionManager.this.activeConnections + " connections residing in the pool.");
                        System.out.println("         " + AS400ConnectionManager.this.leasedConnections + " connections are currently in use by applications.");
                    }
                }
                if (!AS400ConnectionManager.this.debug) continue;
                System.out.println("Warning!!! AS400ConnectionManager is running in debug mode. This will slow down performance significant!!");
                hashtable = AS400ConnectionManager.this.leasedObjects;
                synchronized (hashtable) {
                    Enumeration lo = AS400ConnectionManager.this.leasedObjects.elements();
                    while (lo.hasMoreElements()) {
                        LeaseInformation li = (LeaseInformation)lo.nextElement();
                        int minutes = 5;
                        if (currentTime - li.getLeaseStartTime() <= (long)(minutes * 60 * 1000)) continue;
                        System.out.println("\n========= Warning! leased connection older than " + minutes + " minutes. Callstack was :" + li.leaseStackInformation);
                    }
                }
            }
        }

        protected void finalize() throws Throwable {
            System.out.println("Idletime manager is shutting down now.");
        }
    }

    public class LeaseInformation {
        long leaseStartTime = 0L;
        String leaseStackInformation = null;

        public LeaseInformation(String leaseStackInformation) {
            this.leaseStackInformation = leaseStackInformation;
            this.leaseStartTime = System.currentTimeMillis();
        }

        public String getLeaseStackInformation() {
            return this.leaseStackInformation;
        }

        public long getLeaseStartTime() {
            return this.leaseStartTime;
        }
    }
}

