/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.util;

import java.lang.reflect.Field;
import java.util.HashMap;

public class AttributeChanger {
    private HashMap fields = null;

    public AttributeChanger(Class aClass) {
        this.fields = this.collectFields(aClass, new HashMap());
    }

    public AttributeChanger() {
    }

    public int getIntAttribute(Object object, String attributeName) throws Exception {
        return this.getField(object.getClass(), attributeName).getInt(object);
    }

    public Object getObjectAttribute(Object object, String attributeName) throws Exception {
        return this.getField(object.getClass(), attributeName).get(object);
    }

    public boolean getBooleanAttribute(Object object, String attributeName) throws Exception {
        return this.getField(object.getClass(), attributeName).getBoolean(object);
    }

    public byte getByteAttribute(Object object, String attributeName) throws Exception {
        return this.getField(object.getClass(), attributeName).getByte(object);
    }

    public char getCharAttribute(Object object, String attributeName) throws Exception {
        return this.getField(object.getClass(), attributeName).getChar(object);
    }

    public double getDoubleAttribute(Object object, String attributeName) throws Exception {
        return this.getField(object.getClass(), attributeName).getDouble(object);
    }

    public float getFloatAttribute(Object object, String attributeName) throws Exception {
        return this.getField(object.getClass(), attributeName).getFloat(object);
    }

    public long getLongAttribute(Object object, String attributeName) throws Exception {
        return this.getField(object.getClass(), attributeName).getLong(object);
    }

    public short getShortAttribute(Object object, String attributeName) throws Exception {
        return this.getField(object.getClass(), attributeName).getShort(object);
    }

    public void getAttribute(Object object, String attributeName, int value) throws Exception {
        value = this.getField(object.getClass(), attributeName).getInt(object);
    }

    public void getAttribute(Object object, String attributeName, Object value) throws Exception {
        value = this.getField(object.getClass(), attributeName).get(object);
    }

    public void getAttribute(Object object, String attributeName, boolean value) throws Exception {
        value = this.getField(object.getClass(), attributeName).getBoolean(object);
    }

    public void getAttribute(Object object, String attributeName, byte value) throws Exception {
        value = this.getField(object.getClass(), attributeName).getByte(object);
    }

    public void getAttribute(Object object, String attributeName, char value) throws Exception {
        value = this.getField(object.getClass(), attributeName).getChar(object);
    }

    public void getAttribute(Object object, String attributeName, double value) throws Exception {
        value = this.getField(object.getClass(), attributeName).getDouble(object);
    }

    public void getAttribute(Object object, String attributeName, float value) throws Exception {
        value = this.getField(object.getClass(), attributeName).getFloat(object);
    }

    public void getAttribute(Object object, String attributeName, long value) throws Exception {
        value = this.getField(object.getClass(), attributeName).getLong(object);
    }

    public void getAttribute(Object object, String attributeName, short value) throws Exception {
        value = this.getField(object.getClass(), attributeName).getShort(object);
    }

    public void setAttribute(Object object, String attributeName, int value) throws Exception {
        this.getField(object.getClass(), attributeName).setInt(object, value);
    }

    public void setAttribute(Object object, String attributeName, Object value) throws Exception {
        this.getField(object.getClass(), attributeName).set(object, value);
    }

    public void setAttribute(Object object, String attributeName, boolean value) throws Exception {
        this.getField(object.getClass(), attributeName).setBoolean(object, value);
    }

    public void setAttribute(Object object, String attributeName, byte value) throws Exception {
        this.getField(object.getClass(), attributeName).setByte(object, value);
    }

    public void setAttribute(Object object, String attributeName, char value) throws Exception {
        this.getField(object.getClass(), attributeName).setChar(object, value);
    }

    public void setAttribute(Object object, String attributeName, double value) throws Exception {
        this.getField(object.getClass(), attributeName).setDouble(object, value);
    }

    public void setAttribute(Object object, String attributeName, float value) throws Exception {
        this.getField(object.getClass(), attributeName).setFloat(object, value);
    }

    public void setAttribute(Object object, String attributeName, long value) throws Exception {
        this.getField(object.getClass(), attributeName).setLong(object, value);
    }

    public void setAttribute(Object object, String attributeName, short value) throws Exception {
        this.getField(object.getClass(), attributeName).setShort(object, value);
    }

    private Field getField(Class theClass, String attributeName) throws Exception {
        if (this.fields != null) {
            return this.getFieldFromCache(attributeName);
        }
        return this.getFieldFromObject(theClass, attributeName);
    }

    private Field getFieldFromObject(Class theClass, String attributeName) throws Exception {
        if (theClass == null) {
            throw new Exception("Atribute " + attributeName + " not found in class " + theClass + "!");
        }
        try {
            Field f = theClass.getDeclaredField(attributeName);
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException nf) {
            return this.getField(theClass.getSuperclass(), attributeName);
        }
    }

    private Field getFieldFromCache(String attributeName) throws Exception {
        if (!this.fields.containsKey(attributeName)) {
            throw new Exception("Atribute " + attributeName + " not found in cache!");
        }
        return (Field)this.fields.get(attributeName);
    }

    private HashMap collectFields(Class theClass, HashMap fields) {
        if (theClass == null) {
            return fields;
        }
        Field[] fArray = theClass.getDeclaredFields();
        int i = 0;
        while (i < fArray.length) {
            Field f = fArray[i];
            f.setAccessible(true);
            if (!fields.containsKey(f.getName())) {
                fields.put(f.getName(), f);
            }
            ++i;
        }
        return this.collectFields(theClass.getSuperclass(), fields);
    }
}

