/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.util;

import com.itextpdf.text.Document;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;
import nl.ibs.jeelog.Log;

public class ContentUnderPdf {
    public byte[] createPdf(byte[] sourcePdf, URL contentUnderURL, byte[] contentUnder) throws Exception {
        return this.createPdf(sourcePdf, contentUnderURL, contentUnder, 72.0f, 20.0f);
    }

    public byte[] createPdf(byte[] sourcePdf, URL contentUnderURL, byte[] contentUnder, float left, float top) throws Exception {
        PdfReader contentUnderPdf = null;
        try {
            contentUnderPdf = contentUnderURL != null ? new PdfReader(contentUnderURL) : new PdfReader(contentUnder);
        }
        catch (Exception e) {
            Log.debug((String)e.getMessage());
            return sourcePdf;
        }
        PdfReader reader = new PdfReader(sourcePdf);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Document document = new Document();
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)stream);
        document.setPageSize(reader.getPageSizeWithRotation(1));
        document.open();
        writer.setPageEvent((PdfPageEvent)new ContentUnderPageEvent(writer, contentUnderPdf, reader.getPageSizeWithRotation(1)));
        int i = 1;
        while (i <= reader.getNumberOfPages()) {
            PdfImportedPage page = writer.getImportedPage(reader, i);
            writer.getDirectContent().addTemplate((PdfTemplate)page, left, 20.0f - top);
            document.newPage();
            ++i;
        }
        document.close();
        return stream.toByteArray();
    }

    private class ContentUnderPageEvent
    extends PdfPageEventHelper {
        private PdfImportedPage page;
        private float top;
        private float right;

        public ContentUnderPageEvent(PdfWriter writer, PdfReader reader, Rectangle targetRectangle) throws Exception {
            Rectangle rectangle = reader.getPageSize(1);
            this.top = targetRectangle.getTop() - rectangle.getTop();
            this.right = targetRectangle.getRight() - rectangle.getRight();
            this.page = writer.getImportedPage(reader, 1);
        }

        public void onEndPage(PdfWriter writer, Document document) {
            PdfContentByte contentunder = writer.getDirectContentUnder();
            contentunder.saveState();
            contentunder.addTemplate((PdfTemplate)this.page, this.top / 2.0f, this.right / 2.0f);
            contentunder.restoreState();
        }
    }
}

