/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import nl.ibs.util.InvalidDateException;

public class DateConverter {
    private String uiFormat = "dd-mm-yyyy";
    private String storageFormat = "ddmmyyyy";
    private int day = 0;
    private int month = 0;
    private int year = 0;
    private int smallYear = 0;
    private int century = 0;

    public DateConverter() {
    }

    public DateConverter(String uiFormatString, String storageFormatString) {
        this.setUIFormatString(uiFormatString);
        this.setStorageFormatString(storageFormatString);
    }

    public synchronized void setUIFormatString(String formatString) {
        this.uiFormat = formatString;
    }

    public synchronized String getUIFormatString() {
        return this.uiFormat;
    }

    public synchronized void setStorageFormatString(String formatString) {
        this.storageFormat = formatString;
    }

    public synchronized String getStorageFormatString() {
        return this.storageFormat;
    }

    public synchronized String formatDate(BigDecimal date) throws InvalidDateException {
        this.extractDate(date);
        return this.formatDate();
    }

    public synchronized Calendar toCalendar(BigDecimal date) throws InvalidDateException {
        this.extractDate(date);
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.year, this.month, this.day);
        return calendar;
    }

    private void initializeDate() {
        this.day = 0;
        this.month = 0;
        this.year = 0;
        this.smallYear = 0;
        this.century = 0;
    }

    private void extractDate(BigDecimal date) throws InvalidDateException {
        try {
            this.initializeDate();
            BigInteger bi = new BigInteger(date.toString());
            String storageRemainder = this.storageFormat;
            while (storageRemainder.length() > 0) {
                int sLength = storageRemainder.length();
                char lastChar = storageRemainder.charAt(storageRemainder.length() - 1);
                int firstOccurance = storageRemainder.indexOf(lastChar);
                BigInteger[] result = bi.divideAndRemainder(new BigInteger("100000000000000".substring(0, sLength - firstOccurance + 1)));
                bi = result[0];
                if (lastChar == 'y' || lastChar == 'Y') {
                    this.year = result[1].intValue();
                }
                if (lastChar == 'm' || lastChar == 'M') {
                    this.month = result[1].intValue();
                }
                if (lastChar == 'd' || lastChar == 'D') {
                    this.day = result[1].intValue();
                }
                if (lastChar == 'c' || lastChar == 'C') {
                    this.century = result[1].intValue();
                }
                storageRemainder = storageRemainder.substring(0, firstOccurance);
            }
            this.smallYear = this.year;
            if (this.smallYear > 2199) {
                this.smallYear -= 2100;
            }
            if (this.smallYear > 1999) {
                this.smallYear -= 2000;
            }
            if (this.smallYear > 1899) {
                this.smallYear -= 1900;
            }
            if (this.year < 100) {
                this.year = this.century == 0 ? (this.year += 1900) : (this.year += 2000);
            }
        }
        catch (Exception e) {
            throw new InvalidDateException(this.storageFormat, date);
        }
        if (-1 >= this.day || this.day >= 32) {
            throw new InvalidDateException(this.storageFormat, date);
        }
        if (-1 >= this.month || this.month >= 13) {
            throw new InvalidDateException(this.storageFormat, date);
        }
        if (-1 >= this.smallYear || this.smallYear >= 100) {
            throw new InvalidDateException(this.storageFormat, date);
        }
        if (1850 >= this.year || this.year >= 2200) {
            throw new InvalidDateException(this.storageFormat, date);
        }
        if (-1 >= this.century || this.century >= 2) {
            throw new InvalidDateException(this.storageFormat, date);
        }
    }

    private String formatDate() {
        String result = this.uiFormat;
        result = this.replace(result, "dd", this.day);
        result = this.replace(result, "mm", this.month);
        result = this.replace(result, "yyyy", this.year);
        result = this.replace(result, "yy", this.smallYear);
        return result;
    }

    private String replace(String r, String ri, int replacement) {
        if (r.indexOf(ri) < 0) {
            return r;
        }
        StringBuffer b = new StringBuffer();
        b.append(r.substring(0, r.indexOf(ri)));
        b.append(replacement);
        b.append(r.substring(r.indexOf(ri) + ri.length(), r.length()));
        return b.toString();
    }
}

