/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.util;

public class FieldInformation {
    private String fieldName = null;
    private String fieldDescription = null;
    private int length = 0;
    private int packedLength = -1;
    private int decimals = 0;
    private int fieldType = 3;
    private String descriptiveName = null;

    public FieldInformation(String fName, String fDescription, String fDescriptiveName, int fLength, int fDecimals, int fType) {
        this.fieldName = fName.trim();
        this.fieldDescription = fDescription;
        if (this.fieldDescription == null || this.fieldDescription.trim().equals("")) {
            this.fieldDescription = this.fieldName;
        }
        this.descriptiveName = fDescriptiveName;
        if (this.descriptiveName == null || this.descriptiveName.trim().equals("")) {
            this.descriptiveName = this.fieldName;
        }
        this.length = fLength;
        this.decimals = fDecimals;
        this.fieldType = fType;
    }

    public FieldInformation(String fName, String fDescription, int fLength, int fDecimals, int fType) {
        this.fieldName = fName.trim();
        this.fieldDescription = fDescription;
        if (this.fieldDescription == null || this.fieldDescription.trim().equals("")) {
            this.fieldDescription = this.fieldName;
        }
        this.descriptiveName = this.fieldDescription;
        this.length = fLength;
        this.decimals = fDecimals;
        this.fieldType = fType;
    }

    public FieldInformation(String fName, String fDescription, int fLength, int fDecimals) {
        this.fieldName = fName.trim();
        this.fieldDescription = fDescription;
        if (this.fieldDescription == null || this.fieldDescription.trim().equals("")) {
            this.fieldDescription = this.fieldName;
        }
        this.length = fLength;
        this.decimals = fDecimals;
    }

    public FieldInformation(String fName, String fDescription) {
        this.fieldName = fName.trim();
        this.fieldDescription = fDescription.trim();
    }

    protected void setFieldName(String name) {
        this.fieldName = name;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    protected void setFieldDescription(String description) {
        if (description != null && !description.trim().equals("")) {
            this.fieldDescription = description.trim();
        }
    }

    public String getFieldDescription() {
        return this.fieldDescription;
    }

    public String getDescriptiveName() {
        return this.descriptiveName;
    }

    protected void setDescriptiveName(String name) {
        if (name != null && !name.trim().equals("")) {
            this.descriptiveName = name.trim();
        }
    }

    protected void setLength(int len) {
        this.length = len;
        if (this.isPacked() && this.packedLength == -1) {
            this.packedLength = this.length / 2;
        }
    }

    public int getLength() {
        return this.length;
    }

    protected void setPackedLength(int len) {
        this.packedLength = len;
    }

    public int getPackedLength() {
        return this.packedLength;
    }

    protected void setDecimals(int dec) {
        this.decimals = dec;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public int getFieldType() {
        return this.fieldType;
    }

    protected void setFieldType(int t) {
        this.fieldType = t;
        if (this.isPacked() && this.packedLength == -1) {
            this.packedLength = (this.length + 1) / 2;
        }
    }

    public boolean isText() {
        return this.fieldType == 3;
    }

    public boolean isZoned() {
        return this.fieldType == 2;
    }

    public boolean isPacked() {
        return this.fieldType == 1;
    }

    public String getFieldTypeAsString() {
        if (this.fieldType == 2) {
            return "ZONED";
        }
        if (this.fieldType == 1) {
            return "PACKED";
        }
        return "TEXT";
    }

    public String getFormatPattern() {
        return this.getFormatPattern(true, true, 3);
    }

    public String getFormatPattern(boolean showZeroValues, boolean allowNegativeValues, int decimalGroupSize) {
        if (this.isText()) {
            return "";
        }
        StringBuffer f = new StringBuffer();
        char sign = '#';
        if (showZeroValues) {
            sign = '0';
        }
        if (this.getDecimals() > 0) {
            int i = 0;
            while (i < this.getDecimals()) {
                f.append(sign);
                ++i;
            }
            f.append('.');
        }
        f.append(sign);
        int decimalgroupCount = 1;
        int x = this.getDecimals() + 1;
        while (x < this.getLength()) {
            if (decimalGroupSize > 0 && decimalgroupCount == decimalGroupSize) {
                f.append(',');
                decimalgroupCount = 0;
            }
            f.append('#');
            ++decimalgroupCount;
            ++x;
        }
        String s = f.reverse().toString();
        if (allowNegativeValues) {
            s = String.valueOf(s) + ";" + s + '-';
        }
        return s;
    }

    public String toString() {
        String s = "FieldName=" + this.getFieldName() + ", description= " + this.getFieldDescription() + ", length= " + this.getLength() + ", packedlength= " + this.getPackedLength() + ", decimals= " + this.getDecimals() + ", fieldtype=" + this.getFieldTypeAsString() + ", formatpattern=" + this.getFormatPattern();
        return s;
    }
}

