/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400FTP;
import com.ibm.as400.access.CommandCall;
import java.io.File;
import nl.ibs.jeelog.Log;

public class LibraryDownload {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            throw new Exception("library is missing");
        }
        String library = args[0];
        String toFile = String.valueOf(library) + ".savf";
        if (args.length == 2) {
            toFile = String.valueOf(args[1]) + "/" + toFile;
        }
        library = library.toUpperCase();
        try {
            AS400 as400 = new AS400();
            as400.setGuiAvailable(true);
            as400.setShowCheckboxes(false);
            as400.connectService(0);
            LibraryDownload.runCommand(as400, "CRTSAVF QGPL/" + library);
            LibraryDownload.runCommand(as400, "CLRSAVF QGPL/" + library);
            LibraryDownload.runCommand(as400, "SAVLIB LIB(" + library + ") DEV(*SAVF) SAVF(QGPL/" + library + ") TGTRLS(*PRV) UPDHST(*NO) DTACPR(*YES)");
            File file = new File(toFile);
            AS400FTP ftp = new AS400FTP(as400);
            ftp.setDataTransferType(1);
            ftp.get("QSYS.LIB/QGPL.LIB/" + library + ".FILE", file);
            ftp.disconnect();
            Log.info((String)("file size is: " + file.length()));
            Log.info((String)"savefile successfully downloaded");
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(1);
        }
        System.exit(0);
    }

    private static void runCommand(AS400 as400, String command) throws Exception {
        Log.info((String)command);
        String[] result = new String[2];
        CommandCall commandCall = new CommandCall(as400);
        commandCall.run(command);
        if (commandCall.getMessageList().length > 0) {
            result[0] = commandCall.getMessageList()[0].getText();
            result[1] = commandCall.getMessageList()[0].getID();
        }
        Log.info((String)result[0]);
        Log.info((String)result[1]);
    }
}

