/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400FTP;
import com.ibm.as400.access.CommandCall;
import java.io.File;
import nl.ibs.jeelog.Log;

public class LibraryUpload {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            throw new Exception("library is missing");
        }
        String library = args[0];
        String fromFile = String.valueOf(library) + ".savf";
        String toLibrary = library = library.toUpperCase();
        if (args.length > 1) {
            toLibrary = args[1].toUpperCase();
        }
        String fromFileAndPath = fromFile;
        if (args.length == 3) {
            fromFileAndPath = String.valueOf(args[2]) + "/" + fromFile;
        }
        try {
            File file = new File(fromFileAndPath);
            Log.info((String)file.getName());
            Log.info((String)("" + file.length()));
            AS400 as400 = new AS400();
            as400.setGuiAvailable(true);
            as400.setShowCheckboxes(false);
            as400.connectService(0);
            LibraryUpload.runCommand(as400, "CRTSAVF QGPL/" + library);
            LibraryUpload.runCommand(as400, "CLRSAVF QGPL/" + library);
            AS400FTP ftp = new AS400FTP(as400);
            ftp.setDataTransferType(1);
            boolean ok = ftp.append(file, "QSYS.LIB/QGPL.LIB/" + library + ".FILE");
            Log.info((String)("upload finished: " + ok));
            ftp.disconnect();
            LibraryUpload.runCommand(as400, "CLRLIB LIB(" + toLibrary + ")");
            LibraryUpload.runCommand(as400, "RSTLIB SAVLIB(" + library + ") DEV(*SAVF) SAVF(QGPL/" + library + ") MBROPT(*ALL) RSTLIB(" + toLibrary + ")");
            Log.info((String)("library: " + library + " successfully restored"));
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(1);
        }
        System.exit(0);
    }

    private static void runCommand(AS400 as400, String command) throws Exception {
        Log.info((String)command);
        String[] result = new String[2];
        CommandCall commandCall = new CommandCall(as400);
        commandCall.run(command);
        if (commandCall.getMessageList().length > 0) {
            result[0] = commandCall.getMessageList()[0].getText();
            result[1] = commandCall.getMessageList()[0].getID();
        }
        Log.info((String)result[0]);
        Log.info((String)result[1]);
    }
}

