/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.util;

import java.io.FileInputStream;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import nl.ibs.util.ByteArrayDataSource;

public abstract class MailHelper {
    public static final String SEPARATOR = ",";
    private static final String MAILTO = "Jos.Coenen, Jos.Koenen";

    public static void sendMail(String smtpHost, int port, String mailTo, String mailCC, String mailBCC, String mailFrom, String subject, String text, byte[] textData, String mimeType, String fileName, byte[] fileData, String fileType, boolean urgent) throws Exception {
        ByteArrayDataSource dataSource;
        MimeBodyPart bodyPart;
        Properties systemproperties = System.getProperties();
        systemproperties.put("mail.smtp.host", smtpHost);
        systemproperties.put("mail.smtp.port", "" + port);
        System.setProperties(systemproperties);
        Session session = Session.getDefaultInstance((Properties)System.getProperties(), null);
        MimeMessage message = new MimeMessage(session);
        StringTokenizer st = new StringTokenizer(mailTo, SEPARATOR);
        while (st.hasMoreTokens()) {
            message.addRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress(st.nextToken().trim()));
        }
        if (mailCC != null && mailCC.length() > 0) {
            st = new StringTokenizer(mailCC, SEPARATOR);
            while (st.hasMoreTokens()) {
                message.addRecipient(MimeMessage.RecipientType.CC, (Address)new InternetAddress(st.nextToken().trim()));
            }
        }
        if (mailBCC != null && mailBCC.length() > 0) {
            message.addRecipient(MimeMessage.RecipientType.BCC, (Address)new InternetAddress(mailBCC));
        }
        message.addFrom(new Address[]{new InternetAddress(mailFrom)});
        message.setSentDate(new Date());
        message.setSubject(subject);
        if (urgent) {
            message.addHeader("Priority", "Urgent");
            message.addHeader("Importance", "high");
        }
        MimeMultipart mimeMultipart = new MimeMultipart();
        if (text != null) {
            MimeBodyPart messagePart = new MimeBodyPart();
            messagePart.setText(String.valueOf(text) + "\n\r");
            mimeMultipart.addBodyPart((BodyPart)messagePart);
        }
        if (textData != null) {
            bodyPart = new MimeBodyPart();
            dataSource = new ByteArrayDataSource(null, mimeType, textData);
            bodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
            mimeMultipart.addBodyPart((BodyPart)bodyPart);
        }
        if (fileData != null) {
            bodyPart = new MimeBodyPart();
            bodyPart.setFileName(fileName);
            dataSource = new ByteArrayDataSource(fileName, fileType, fileData);
            bodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
            mimeMultipart.addBodyPart((BodyPart)bodyPart);
        }
        message.setContent((Multipart)mimeMultipart);
        Transport.send((Message)message);
    }

    public static void main(String[] args) throws Exception {
        StringBuffer sb = new StringBuffer();
        String[] address = MAILTO.split(SEPARATOR);
        int i = 0;
        while (i < address.length) {
            sb.append(address[i].toLowerCase());
            sb.append("@ibs.nl");
            if (i < address.length - 1) {
                sb.append(SEPARATOR);
            }
            ++i;
        }
        String mailTo = sb.toString();
        String fileName = "cotag.jpg";
        FileInputStream fis = new FileInputStream(fileName);
        byte[] bytes = new byte[fis.available()];
        fis.read(bytes);
        fis.close();
        MailHelper.sendMail("fred", 25, mailTo, null, null, "urgent@ibs.nl", "Toegangspasjes", "In verband met gestegen licentiekosten van het pasjessysteem wordt iedereen verzocht de toegangspasjes bij de receptie in te leveren.\nKun je, gezien de administratieve afwikkeling, dit bij voorkeur vandaag nog doen.\nBij voorbaat dank voor je bereidwillige medewerking.", null, null, fileName, bytes, "image/jpeg", true);
        System.exit(0);
    }
}

