/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.util;

import java.math.BigDecimal;

public class Stopwatch {
    public static final int SECONDS = 1;
    public static final int TENTH_OF_SECONDS = 2;
    public static final int HUNDREDS_OF_SECONDS = 3;
    public static final int MILLISECONDS = 4;
    private boolean started = false;
    private long startTime = 0L;
    private long totalTime = 0L;

    public Stopwatch() {
        this.start();
    }

    public void start() {
        this.started = true;
        this.totalTime = 0L;
        this.startTime = System.currentTimeMillis();
    }

    public BigDecimal suspend(int precision) {
        this.suspend();
        return this.getTotalTime(precision);
    }

    public void suspend() {
        if (this.started) {
            this.totalTime += System.currentTimeMillis() - this.startTime;
        }
    }

    public void resume() {
        if (this.started) {
            this.startTime = System.currentTimeMillis();
        }
    }

    public BigDecimal stop(int precision) {
        BigDecimal result = this.suspend(precision);
        this.started = false;
        this.startTime = 0L;
        this.totalTime = 0L;
        return result;
    }

    private BigDecimal getTotalTime(int precision) {
        return this.formatValue(this.totalTime, precision);
    }

    public BigDecimal getElapsedTime(int precision) {
        long elapsedTime = 0L;
        if (this.started) {
            elapsedTime = System.currentTimeMillis() - this.startTime + this.totalTime;
        }
        return this.formatValue(elapsedTime, precision);
    }

    private BigDecimal formatValue(long value, int precision) {
        switch (precision) {
            case 1: {
                return new BigDecimal(new Long(value / 1000L).doubleValue());
            }
            case 2: {
                return new BigDecimal(new Long(value / 100L).doubleValue()).movePointLeft(1);
            }
            case 3: {
                return new BigDecimal(new Long(value / 10L).doubleValue()).movePointLeft(2);
            }
        }
        return new BigDecimal(new Long(value).doubleValue()).movePointLeft(3);
    }
}

