/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.util.socket.requestdispatcher;

import java.io.DataInputStream;
import java.net.Socket;
import java.util.StringTokenizer;
import nl.ibs.util.http.CorruptParameterException;
import nl.ibs.util.http.DecodedURLParameters;
import nl.ibs.util.socket.requestdispatcher.RequestDispatcher;

public class ExternalRequest
extends DecodedURLParameters {
    private static final long serialVersionUID = 1L;
    private String userId = "";
    private String password = "";
    private String answerHost = "";
    private int answerPort = -1;
    private String requestData = null;
    private boolean replyExpected = false;

    public ExternalRequest(String encodedString) throws Exception {
        try {
            this.decode(encodedString);
        }
        catch (CorruptParameterException e) {
            this.decode2(encodedString);
        }
        this.replyExpected = true;
    }

    public ExternalRequest(String answerHost, int answerPort) {
        this.answerHost = answerHost;
        this.answerPort = answerPort;
    }

    public ExternalRequest(String userId, String password, String answerHost, int answerPort, String requestData) {
        this.userId = userId;
        this.password = password;
        this.answerHost = answerHost;
        this.answerPort = answerPort;
        this.requestData = requestData;
    }

    public String getAnswerHost() {
        return this.answerHost;
    }

    public int getAnswerPort() {
        return this.answerPort;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setAnswerHost(String answerHost) {
        this.answerHost = answerHost;
    }

    public void setAnswerPort(int answerPort) {
        this.answerPort = answerPort;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    protected void validate() throws CorruptParameterException {
    }

    public void reply(String reply) throws Exception {
        if (!this.replyExpected) {
            throw new Exception("No reply excpected!");
        }
        RequestDispatcher.sendRequestAnswer(reply, this.getAnswerHost(), this.getAnswerPort());
        this.replyExpected = false;
    }

    public String toString() {
        return "UserId   = " + this.getUserId() + "\nPassword = non-of-your-business" + "\nAnswerHost= " + this.getAnswerHost() + "\nAnswerPort= " + this.getAnswerPort() + "\nRequestdata= " + this.getRequestData();
    }

    public static void main(String[] args) {
        try {
            ExternalRequest re = new ExternalRequest("jvdk", "geheim", "myhost", 1235, "my payload Data");
            System.out.println(" ================== original state ===");
            System.out.println(re.toString());
            String x = re.encode();
            ExternalRequest re2 = new ExternalRequest(x);
            System.out.println(" ================== encoded/decoded state ===");
            System.out.println(re2.toString());
            x = String.valueOf(x.substring(0, 10)) + "X" + x.substring(11);
            System.out.println(" ================== string changed state (checksum must fail!) ===");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public String getRequestData() {
        try {
            if (this.requestData == null) {
                this.requestData = ExternalRequest.getRequestXML(this.getAnswerHost(), this.getAnswerPort());
            }
        }
        catch (Exception e) {
            System.out.println("ERROR during reading the external xml request data");
            e.printStackTrace();
        }
        return this.requestData;
    }

    public void setRequestData(String requestData) {
        this.requestData = requestData;
    }

    protected void finalize() throws Throwable {
        if (this.replyExpected) {
            this.reply("AUTO_REPLY");
        }
    }

    public boolean isReplyExpected() {
        return this.replyExpected;
    }

    public void setReplyExpected(boolean replyExpected) {
        this.replyExpected = replyExpected;
    }

    public static String getRequestXML(String host, int port) throws Exception {
        if (host == null || host.trim().equals("")) {
            host = "localhost";
        }
        try {
            Socket socket = new Socket(host, port);
            DataInputStream inputStream = new DataInputStream(socket.getInputStream());
            if (socket == null || inputStream == null) {
                throw new Exception("Socket Initialisation error");
            }
            String xml = ExternalRequest.readInputStream(inputStream);
            return xml;
        }
        catch (Exception e) {
            System.out.println("RequestDispatcher::getRequestXML - error during reading xml request!");
            e.printStackTrace();
            throw e;
        }
    }

    public static String readInputStream(DataInputStream inputStream) throws Exception {
        StringBuffer answer = new StringBuffer();
        int bufferSize = 300;
        byte[] b = new byte[bufferSize];
        int bytesRead = inputStream.read(b);
        int lastChar = 0;
        while (bytesRead == -1) {
            Thread.currentThread().wait(100L);
            bytesRead = inputStream.read(b);
        }
        while (bytesRead != -1) {
            String s = new String(b, 0, bytesRead);
            answer.append(s);
            lastChar = answer.length() - 1;
            if (answer.charAt(lastChar) == '\u00ff') {
                return answer.substring(0, lastChar);
            }
            bytesRead = inputStream.read(b);
        }
        return answer.toString();
    }

    protected String getEncodeData() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.userId) + SEPERATOR);
        sb.append(String.valueOf(this.password) + SEPERATOR);
        sb.append(String.valueOf(this.answerHost) + SEPERATOR);
        sb.append(String.valueOf(this.answerPort) + SEPERATOR);
        sb.append(String.valueOf(this.requestData) + SEPERATOR);
        sb.append(this.replyExpected);
        return sb.toString();
    }

    protected void setDecodeData(String decodedData) {
        StringTokenizer st = new StringTokenizer(decodedData, SEPERATOR);
        int i = 0;
        while (st.hasMoreTokens()) {
            switch (i) {
                case 0: {
                    this.setUserId(st.nextToken());
                    break;
                }
                case 1: {
                    this.setPassword(st.nextToken());
                    break;
                }
                case 2: {
                    this.setAnswerHost(st.nextToken());
                    break;
                }
                case 3: {
                    this.setAnswerPort(Integer.parseInt(st.nextToken()));
                    break;
                }
                case 4: {
                    this.setRequestData(st.nextToken());
                    break;
                }
                case 5: {
                    this.setReplyExpected(Boolean.getBoolean(st.nextToken()));
                    break;
                }
            }
            ++i;
        }
    }
}

