/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLDataFactory;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLNumeric
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private static final BigDecimal default_ = BigDecimal.valueOf(0L);
    private static final BigDecimal BYTE_MAX_VALUE = BigDecimal.valueOf(127L);
    private static final BigDecimal BYTE_MIN_VALUE = BigDecimal.valueOf(-128L);
    private static final BigDecimal SHORT_MAX_VALUE = BigDecimal.valueOf(32767L);
    private static final BigDecimal SHORT_MIN_VALUE = BigDecimal.valueOf(-32768L);
    private static final BigDecimal INTEGER_MAX_VALUE = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal INTEGER_MIN_VALUE = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal LONG_MAX_VALUE = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE);
    static final BigDecimal FLOAT_MAX_VALUE = new BigDecimal(3.4028234663852886E38);
    static final BigDecimal FLOAT_MIN_VALUE = new BigDecimal(1.4E-45f);
    static final BigDecimal DOUBLE_MAX_VALUE = new BigDecimal(Double.MAX_VALUE);
    static final BigDecimal DOUBLE_MIN_VALUE = new BigDecimal(Double.MIN_VALUE);
    private int precision_;
    private int scale_;
    private AS400ZonedDecimal typeConverter_;
    private BigDecimal value_;
    private JDProperties properties_;
    private int vrm_;

    SQLNumeric(int n, int n2, SQLConversionSettings sQLConversionSettings, int n3, JDProperties jDProperties) {
        super(sQLConversionSettings);
        this.precision_ = n;
        this.scale_ = n2;
        this.typeConverter_ = new AS400ZonedDecimal(this.precision_, this.scale_);
        this.value_ = default_;
        this.vrm_ = n3;
        this.properties_ = jDProperties;
    }

    public Object clone() {
        return new SQLNumeric(this.precision_, this.scale_, this.settings_, this.vrm_, this.properties_);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable, boolean bl) throws SQLException {
        this.value_ = (BigDecimal)this.typeConverter_.toObject(byArray, n);
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        try {
            this.typeConverter_.toBytes(this.value_, byArray, n);
        }
        catch (ExtendedIllegalArgumentException extendedIllegalArgumentException) {
            JDError.throwSQLException((Object)this, "07006", extendedIllegalArgumentException);
        }
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        String string;
        BigDecimal bigDecimal = null;
        if (object instanceof String) {
            try {
                string = SQLDataFactory.convertScientificNotation((String)object, this.settings_);
                if (n >= 0) {
                    string = SQLDataFactory.truncateScale(string, n);
                }
                bigDecimal = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                JDError.throwSQLException((Object)this, "07006");
                return;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                JDError.throwSQLException((Object)this, "07006");
                return;
            }
        } else if (object instanceof Number) {
            string = SQLDataFactory.convertScientificNotation(object.toString(), this.settings_);
            if (n >= 0) {
                string = SQLDataFactory.truncateScale(string, n);
            }
            bigDecimal = new BigDecimal(string);
        } else if (object instanceof Boolean) {
            bigDecimal = (Boolean)object == true ? BigDecimal.valueOf(1L) : BigDecimal.valueOf(0L);
        } else {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
            return;
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        int n2 = bigDecimal.scale();
        if (n2 > this.scale_) {
            this.truncated_ += n2 - this.scale_;
        }
        this.value_ = bigDecimal.setScale(this.scale_, 1);
        int n3 = SQLDataFactory.getDecimalPrecision(this.value_);
        if (this.precision_ == this.scale_ && this.value_.intValue() == 0) {
            --n3;
        }
        if (n3 > this.precision_) {
            int n4 = n3 - this.precision_;
            this.truncated_ += n4;
            this.outOfBounds_ = true;
            this.value_ = this.value_.doubleValue() > 0.0 ? SQLDataFactory.getMaximumBigDecimal(this.precision_, this.scale_) : SQLDataFactory.getMinimumBigDecimal(this.precision_, this.scale_);
        } else {
            this.truncated_ = 0;
            this.outOfBounds_ = false;
        }
    }

    public int getSQLType() {
        return 22;
    }

    public String getCreateParameters() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AS400JDBCDriver.getResource("PRECISION", null));
        stringBuffer.append(",");
        stringBuffer.append(AS400JDBCDriver.getResource("SCALE", null));
        return stringBuffer.toString();
    }

    public int getDisplaySize() {
        return this.precision_ + 2;
    }

    public String getJavaClassName() {
        return "java.math.BigDecimal";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "NUMERIC";
    }

    public int getMaximumPrecision() {
        if (this.vrm_ >= JDUtilities.vrm530) {
            return this.properties_.getInt(53);
        }
        return 31;
    }

    public int getMaximumScale() {
        if (this.vrm_ >= JDUtilities.vrm530) {
            return this.properties_.getInt(54);
        }
        return 31;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 488;
    }

    public int getPrecision() {
        return this.precision_;
    }

    public int getRadix() {
        return 10;
    }

    public int getScale() {
        return this.scale_;
    }

    public int getType() {
        return 2;
    }

    public String getTypeName() {
        return "NUMERIC";
    }

    public boolean isSigned() {
        return true;
    }

    public boolean isText() {
        return false;
    }

    public int getActualSize() {
        return this.precision_;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (n >= 0) {
            if (n >= this.value_.scale()) {
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return this.value_.setScale(n);
            }
            this.truncated_ = this.value_.scale() - n;
            return this.value_.setScale(n, 4);
        }
        return this.value_;
    }

    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public boolean getBoolean() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_.compareTo(BigDecimal.valueOf(0L)) != 0;
    }

    public byte getByte() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_.compareTo(BYTE_MAX_VALUE) > 0 || this.value_.compareTo(BYTE_MIN_VALUE) < 0) {
            int n = this.value_.toBigInteger().toByteArray().length;
            this.truncated_ = n - 1;
            this.outOfBounds_ = true;
        }
        return this.value_.byteValue();
    }

    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        double d = this.value_.doubleValue();
        if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            int n = this.value_.toBigInteger().toByteArray().length;
            this.truncated_ = n - 8;
            this.outOfBounds_ = true;
        }
        return d;
    }

    public float getFloat() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        float f = this.value_.floatValue();
        if (f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY) {
            int n = this.value_.toBigInteger().toByteArray().length;
            this.truncated_ = n - 4;
            this.outOfBounds_ = true;
        }
        return f;
    }

    public int getInt() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_.compareTo(INTEGER_MAX_VALUE) > 0 || this.value_.compareTo(INTEGER_MIN_VALUE) < 0) {
            int n = this.value_.toBigInteger().toByteArray().length;
            this.truncated_ = n - 4;
            this.outOfBounds_ = true;
        }
        return this.value_.intValue();
    }

    public long getLong() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_.compareTo(LONG_MAX_VALUE) > 0 || this.value_.compareTo(LONG_MIN_VALUE) < 0) {
            int n = this.value_.toBigInteger().toByteArray().length;
            this.truncated_ = n - 8;
            this.outOfBounds_ = true;
        }
        return this.value_.longValue();
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    public short getShort() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_.compareTo(SHORT_MAX_VALUE) > 0 || this.value_.compareTo(SHORT_MIN_VALUE) < 0) {
            int n = this.value_.toBigInteger().toByteArray().length;
            this.truncated_ = n - 2;
            this.outOfBounds_ = true;
        }
        return this.value_.shortValue();
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        String string = JDUtilities.bigDecimalToPlainString(this.value_);
        int n = string.indexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n) + this.settings_.getDecimalSeparator() + string.substring(n + 1);
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        String string = this.value_.toString();
        int n = string.indexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n) + this.settings_.getDecimalSeparator() + string.substring(n + 1);
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public void saveValue() {
        this.savedValue_ = this.value_;
    }
}

