/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.commtrace.CommTrace;
import com.ibm.as400.util.commtrace.Progress;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JOptionPane;

class Read
implements Runnable {
    private String rmtfile;
    private String lclfile;
    private AS400 sys;
    private CommTrace comm;
    private Progress pro;
    private Thread proThread;
    private Thread readThread_ = null;
    private int bytes = 0;
    private static final String CLASS = "Read";

    public Read(CommTrace commTrace, String string, String string2, AS400 aS400) {
        this.comm = commTrace;
        this.rmtfile = string;
        this.lclfile = string2;
        this.sys = aS400;
    }

    public void run() {
        byte[] byArray = null;
        int n = 0;
        this.bytes = 0;
        Thread thread = Thread.currentThread();
        while (this.readThread_ == thread) {
            IFSFileInputStream iFSFileInputStream = null;
            BufferedOutputStream bufferedOutputStream = null;
            try {
                int n2;
                iFSFileInputStream = new IFSFileInputStream(this.sys, this.rmtfile);
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.lclfile));
                this.pro = new Progress("Retrieving " + this.rmtfile, iFSFileInputStream.available(), " bytes");
                this.proThread = new Thread((Runnable)this.pro, "ProgDiag");
                this.proThread.start();
                int n3 = iFSFileInputStream.available();
                if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                    Trace.log(3, "Read.run() Transfer file size:" + n3);
                }
                if ((n2 = JOptionPane.showConfirmDialog(CommTrace.getMainFrame(), "Start transfer of " + this.rmtfile + "(" + n3 / 1024 + " KB)?", "Transfer", 0)) == 1) {
                    return;
                }
                if (n2 == 0) {
                    byte[] byArray2 = new byte[4096];
                    while ((n = iFSFileInputStream.read(byArray2)) != -1 && !this.pro.isCanceled() && this.readThread_ != null) {
                        byArray = new byte[n];
                        System.arraycopy(byArray2, 0, byArray, 0, n);
                        bufferedOutputStream.write(byArray);
                        this.bytes += n;
                        this.pro.updateProgress(this.bytes);
                    }
                    if (this.pro.isCanceled() || this.readThread_ == null) {
                        iFSFileInputStream.close();
                        bufferedOutputStream.close();
                        File file = new File(this.lclfile);
                        if (file.exists()) {
                            file.delete();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                CommTrace.error("File Error", "Error reading/writing file");
            }
            catch (AS400SecurityException aS400SecurityException) {
                CommTrace.error("Security Error", "Security problem opening file");
            }
            if (!this.pro.isCanceled() && this.readThread_ != null) {
                if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                    Trace.log(3, "Read.run() Transfering completed");
                }
                JOptionPane.showMessageDialog(CommTrace.getMainFrame(), "Transfer of " + this.rmtfile + " completed", "Transfer Complete", 1);
            }
            this.readThread_ = null;
            try {
                iFSFileInputStream.close();
                bufferedOutputStream.close();
            }
            catch (IOException iOException) {
                CommTrace.error("File Error", "Error closing file");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int getBytesRead() {
        return this.bytes;
    }

    public Thread getThread() {
        return this.readThread_;
    }

    public void setThread(Thread thread) {
        this.readThread_ = thread;
    }
}

