/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.IFSTextFileDocument;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

class IFSEditAction
implements VAction {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String copyText_ = ResourceLoader.getText("MENU_COPY");
    private static final String cutText_ = ResourceLoader.getText("MENU_CUT");
    private static final String editActionText_ = ResourceLoader.getText("ACTION_EDIT");
    private static final String editText_ = ResourceLoader.getText("MENU_EDIT");
    private static final String exitText_ = ResourceLoader.getText("MENU_EXIT");
    private static final String fileText_ = ResourceLoader.getText("MENU_FILE");
    private static final String pasteText_ = ResourceLoader.getText("MENU_PASTE");
    private static final String saveConfirmText_ = ResourceLoader.getText("DLG_CONFIRM_SAVE");
    private static final String saveConfirmTitle_ = ResourceLoader.getText("DLG_CONFIRM_SAVE_TITLE");
    private static final String saveText_ = ResourceLoader.getText("MENU_SAVE");
    private static final String selectAllText_ = ResourceLoader.getText("MENU_SELECT_ALL");
    private static final String viewActionText_ = ResourceLoader.getText("ACTION_VIEW");
    private boolean allowChanges_ = true;
    private boolean enabled_ = true;
    private IFSFile file_ = null;
    private VObject object_ = null;
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);

    public IFSEditAction(VObject vObject, IFSFile iFSFile, boolean bl) {
        this.object_ = vObject;
        this.file_ = iFSFile;
        this.allowChanges_ = bl;
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    void exit(IFSTextFileDocument iFSTextFileDocument, JFrame jFrame, boolean bl) {
        boolean bl2 = false;
        if (iFSTextFileDocument.isModified()) {
            int n = bl ? 1 : 0;
            int n2 = JOptionPane.showConfirmDialog(jFrame, saveConfirmText_, saveConfirmTitle_, n);
            switch (n2) {
                case 0: {
                    this.save(iFSTextFileDocument);
                    break;
                }
                default: {
                    break;
                }
                case 2: {
                    bl2 = true;
                }
            }
        }
        if (!bl2) {
            jFrame.setVisible(false);
        }
    }

    public String getText() {
        return this.allowChanges_ ? editActionText_ : viewActionText_;
    }

    public boolean isEnabled() {
        return this.enabled_;
    }

    public void perform(VActionContext vActionContext) {
        if (Trace.isTraceOn()) {
            if (this.allowChanges_) {
                Trace.log(3, "Editing file [" + this.file_.getName() + "].");
            } else {
                Trace.log(3, "Viewing file [" + this.file_.getName() + "].");
            }
        }
        IFSTextFileDocument iFSTextFileDocument = new IFSTextFileDocument(this.file_);
        iFSTextFileDocument.load();
        JTextPane jTextPane = new JTextPane(iFSTextFileDocument);
        jTextPane.setEditable(this.allowChanges_);
        iFSTextFileDocument.addWorkingListener(new WorkingCursorAdapter(jTextPane));
        JScrollPane jScrollPane = new JScrollPane(jTextPane);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        JFrame jFrame = new JFrame(this.file_.getPath());
        jFrame.getRootPane().setPreferredSize(new Dimension(400, 400));
        JMenuBar jMenuBar = new JMenuBar();
        final IFSTextFileDocument iFSTextFileDocument2 = iFSTextFileDocument;
        final JFrame jFrame2 = jFrame;
        final JTextPane jTextPane2 = jTextPane;
        JMenu jMenu = new JMenu(fileText_);
        JMenuItem jMenuItem = new JMenuItem(saveText_);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IFSEditAction.this.save(iFSTextFileDocument2);
            }
        });
        jMenuItem.setEnabled(this.allowChanges_);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(exitText_);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IFSEditAction.this.exit(iFSTextFileDocument2, jFrame2, true);
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenu = new JMenu(editText_);
        jMenuItem = new JMenuItem(cutText_);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jTextPane2.cut();
            }
        });
        jMenuItem.setEnabled(this.allowChanges_);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(copyText_);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jTextPane2.copy();
            }
        });
        jMenuItem.setEnabled(true);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(pasteText_);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jTextPane2.paste();
            }
        });
        jMenuItem.setEnabled(this.allowChanges_);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(selectAllText_);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jTextPane2.selectAll();
            }
        });
        jMenuItem.setEnabled(true);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                IFSEditAction.this.exit(iFSTextFileDocument2, jFrame2, false);
            }
        });
        jFrame.getRootPane().setJMenuBar(jMenuBar);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add("Center", jScrollPane);
        jFrame.pack();
        jFrame.show();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    void save(IFSTextFileDocument iFSTextFileDocument) {
        iFSTextFileDocument.save();
        this.object_.load();
        this.objectEventSupport_.fireObjectChanged(this.object_);
    }

    public void setEnabled(boolean bl) {
        this.enabled_ = bl;
    }

    public String toString() {
        return this.getText();
    }
}

