/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.ChangeableResource;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.vaccess.ChangeEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceProperties;
import com.ibm.as400.vaccess.VUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

class ResourcePropertiesTabbedPane
extends JComponent {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private Hashtable changes_ = new Hashtable();
    private ResourceMetaData[] attributeMetaData_;
    private Presentation presentation_;
    private ResourceProperties properties_;
    private Resource resource_;
    private ChangeEventSupport changeEventSupport_ = new ChangeEventSupport(this);
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);

    public ResourcePropertiesTabbedPane(Resource resource, ResourceProperties resourceProperties) {
        this.resource_ = resource;
        this.properties_ = resourceProperties != null ? resourceProperties : new ResourceProperties();
        this.attributeMetaData_ = resource.getAttributeMetaData();
        this.presentation_ = resource.getPresentation();
        JTabbedPane jTabbedPane = new JTabbedPane();
        int n = this.properties_.getTabCount();
        for (int i = 0; i < n; ++i) {
            jTabbedPane.addTab(this.properties_.getLabel(i), this.createTabComponent(i));
        }
        this.setLayout(new BorderLayout());
        this.add("Center", jTabbedPane);
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.changeEventSupport_.addChangeListener(changeListener);
    }

    public void addErrorListener(ErrorListener errorListener) {
        if (errorListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChanges() {
        Hashtable hashtable = this.changes_;
        synchronized (hashtable) {
            try {
                if (this.resource_ instanceof ChangeableResource) {
                    Enumeration enumeration = this.changes_.keys();
                    while (enumeration.hasMoreElements()) {
                        Object k = enumeration.nextElement();
                        Object object = this.changes_.get(k);
                        if (this.resource_.getAttributeMetaData(k).getType() == Integer.class && object instanceof String) {
                            object = new Integer((String)object);
                        }
                        ((ChangeableResource)this.resource_).setAttributeValue(k, object);
                    }
                    ((ChangeableResource)this.resource_).commitAttributeChanges();
                }
            }
            catch (Exception exception) {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "Error applying changes", (Throwable)exception);
                }
                this.errorEventSupport_.fireError(exception);
            }
            this.changes_.clear();
        }
    }

    private Component createAttributeComponent(ResourceMetaData resourceMetaData) throws ResourceException {
        Object object;
        Object object2;
        Object object3 = resourceMetaData.getID();
        Object object4 = this.resource_.getAttributeValue(object3);
        boolean bl = this.properties_.isEditable() && !resourceMetaData.isReadOnly();
        Object object5 = null;
        Class clazz = resourceMetaData.getType();
        Object[] objectArray = resourceMetaData.getPossibleValues();
        if (clazz == Boolean.class) {
            object2 = new JCheckBox("", (boolean)((Boolean)object4));
            ((AbstractButton)object2).setEnabled(bl);
            ((AbstractButton)object2).addActionListener(new ChangeListener_(object3));
            object5 = object2;
        } else if (clazz.isArray()) {
            object2 = (Object[])object4;
            object = new JList((E[])object2);
            ((JComponent)object).setEnabled(false);
            ((JList)object).setVisibleRowCount(Math.min(5, ((Object)object2).length));
            object5 = object;
        } else if (objectArray != null && objectArray.length > 0) {
            if (bl) {
                object2 = new JComboBox();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((JComboBox)object2).addItem(objectArray[i]);
                }
                ((JComboBox)object2).setRenderer(new JComboBoxRenderer(resourceMetaData));
                ((JComboBox)object2).setEditor(new JComboBoxEditor(resourceMetaData));
                ((JComboBox)object2).setEditable(!resourceMetaData.isValueLimited());
                ((JComboBox)object2).setSelectedItem(object4);
                object = new ChangeListener_(object3);
                ((JComboBox)object2).addItemListener((ItemListener)object);
                ((JComboBox)object2).getEditor().getEditorComponent().addKeyListener((KeyListener)object);
                object5 = object2;
            } else {
                object5 = new JLabel(resourceMetaData.getPossibleValuePresentation(object4).getFullName());
            }
        }
        if (object5 == null) {
            if (bl) {
                object2 = new JTextField(object4.toString());
                int n = object4.toString().length();
                ((JTextField)object2).setColumns(Math.max(10, Math.min(30, n)));
                ((Component)object2).addKeyListener(new ChangeListener_(object3));
                object5 = object2;
            } else {
                object2 = object4.toString();
                if (((String)object2).length() > 30) {
                    object5 = new JTextArea(VUtilities.formatHelp2((String)object2, 40));
                    ((JTextArea)object5).setEditable(false);
                    ((Component)object5).setBackground(null);
                } else {
                    object5 = new JLabel(object4.toString());
                }
            }
        }
        return object5;
    }

    private Component createAttributeBox(Object[] objectArray, int n, int n2) {
        Serializable serializable;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            Serializable serializable2;
            serializable = this.resource_.getAttributeMetaData(objectArray[i]);
            if (serializable != null) {
                serializable2 = ((ResourceMetaData)serializable).getPresentation();
                String string = null;
                string = serializable2 != null ? serializable2.getFullName() : ((ResourceMetaData)serializable).getID().toString();
                JLabel jLabel = new JLabel(string + ':');
                jPanel.add(jLabel);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n3;
                gridBagLayout.setConstraints(jLabel, gridBagConstraints);
                try {
                    Component component = this.createAttributeComponent((ResourceMetaData)serializable);
                    jPanel.add(component);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.gridy = n3;
                    gridBagLayout.setConstraints(component, gridBagConstraints);
                }
                catch (ResourceException resourceException) {
                    if (Trace.isTraceOn()) {
                        Trace.log(2, "Error creating attribute component for:" + objectArray[i], (Throwable)resourceException);
                    }
                    this.errorEventSupport_.fireError(resourceException);
                }
            } else {
                serializable2 = new JLabel(objectArray[i].toString() + ':');
                jPanel.add((Component)serializable2);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n3;
                gridBagLayout.setConstraints((Component)serializable2, gridBagConstraints);
            }
            ++n3;
        }
        JPanel jPanel2 = new JPanel();
        jPanel.add(jPanel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        serializable = new Box(1);
        ((Container)serializable).add(jPanel);
        ((Container)serializable).add(Box.createVerticalGlue());
        return serializable;
    }

    private Component createTabComponent(int n) {
        Object object;
        Box box = new Box(1);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("Center", box);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        if (n == 0) {
            object = new JLabel(this.presentation_.getFullName(), new ImageIcon((Image)this.presentation_.getValue("32")), 2);
            Box box2 = new Box(0);
            box2.add((Component)object);
            box2.add(Box.createHorizontalGlue());
            box.add(box2);
            JSeparator jSeparator = new JSeparator();
            jSeparator.setMaximumSize(new Dimension(jSeparator.getMaximumSize().width, jSeparator.getPreferredSize().height));
            box.add(Box.createRigidArea(new Dimension(0, 6)));
            box.add(jSeparator);
            box.add(Box.createRigidArea(new Dimension(0, 6)));
        }
        object = this.properties_.getProperties(n);
        box.add(this.createAttributeBox((Object[])object, 0, ((Object[])object).length));
        box.add(Box.createVerticalGlue());
        return jPanel;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.changeEventSupport_.removeChangeListener(changeListener);
    }

    public void removeErrorListener(ErrorListener errorListener) {
        if (errorListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    private class JComboBoxRenderer
    extends DefaultListCellRenderer {
        private ResourceMetaData metaData_;

        public JComboBoxRenderer(ResourceMetaData resourceMetaData) {
            this.metaData_ = resourceMetaData;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2 = object;
            if (object != null) {
                object2 = this.metaData_.getPossibleValuePresentation(object).getFullName();
            }
            return super.getListCellRendererComponent((JList<?>)jList, object2, n, bl, bl2);
        }
    }

    private class JComboBoxEditor
    implements ComboBoxEditor {
        private ResourceMetaData metaData_;
        private JTextField editorComponent_ = new JTextField();

        public JComboBoxEditor(ResourceMetaData resourceMetaData) {
            this.metaData_ = resourceMetaData;
        }

        public void addActionListener(ActionListener actionListener) {
            this.editorComponent_.addActionListener(actionListener);
        }

        public Component getEditorComponent() {
            return this.editorComponent_;
        }

        public Object getItem() {
            Object object = this.editorComponent_.getText();
            Object[] objectArray = this.metaData_.getPossibleValues();
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!this.metaData_.getPossibleValuePresentation(objectArray[i]).getFullName().equals(object)) continue;
                    object = objectArray[i];
                }
            }
            return object;
        }

        public void removeActionListener(ActionListener actionListener) {
            this.editorComponent_.removeActionListener(actionListener);
        }

        public void selectAll() {
            this.editorComponent_.selectAll();
        }

        public void setItem(Object object) {
            Presentation presentation;
            Object object2 = object;
            if (object != null && (presentation = this.metaData_.getPossibleValuePresentation(object)) != null) {
                object2 = presentation.getFullName();
            }
            this.editorComponent_.setText(object2 == null ? "" : object2.toString());
        }
    }

    private class ChangeListener_
    extends KeyAdapter
    implements ActionListener,
    ItemListener {
        private Object attributeID_;

        public ChangeListener_(Object object) {
            this.attributeID_ = object;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.registerChange(new Boolean(((JCheckBox)actionEvent.getSource()).isSelected()));
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.registerChange(itemEvent.getItem());
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.registerChange(((JTextField)keyEvent.getSource()).getText());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerChange(Object object) {
            Hashtable hashtable = ResourcePropertiesTabbedPane.this.changes_;
            synchronized (hashtable) {
                ResourcePropertiesTabbedPane.this.changes_.put(this.attributeID_, object);
            }
            ResourcePropertiesTabbedPane.this.changeEventSupport_.fireStateChanged();
        }
    }
}

