/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac;

import com.ibm.as400.access.Job;
import com.ibm.as400.access.QueuedMessage;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import nl.ibs.fac.language.LanguageHelper;

public class BatchJob
implements Serializable {
    private static final long serialVersionUID = 2448056280309487106L;
    private Job job;
    private String number;
    private String name;
    private String status;
    private String statusInJobQueue;
    private String completionStatus;
    private String className = "";
    private String company = "";
    private Date jobDate;
    private String jobTime;
    private Date scheduleDate;
    private String scheduleTime = null;

    public BatchJob(Job job) throws Exception {
        this.job = job;
        this.number = job.getNumber();
        this.name = job.getName();
        this.className = LanguageHelper.getString("nl.ibs.fac.language", this.name);
        this.status = job.getStatus();
        this.statusInJobQueue = job.getJobStatusInJobQueue();
        this.setCompletionStatus(job.getCompletionStatus());
        try {
            Enumeration messages = job.getJobLog().getMessages();
            while (messages.hasMoreElements()) {
                QueuedMessage queuedMessage = (QueuedMessage)messages.nextElement();
                String text = queuedMessage.getText();
                if (text.startsWith("JAVA")) {
                    this.getJavaJobInfo(text);
                } else {
                    if (!text.startsWith("CALL PGM")) continue;
                    this.getRPGJobInfo(text);
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jobDate = job.getDate();
        this.jobTime = this.getTime(this.jobDate);
        this.scheduleDate = job.getScheduleDate();
        if (this.scheduleDate.before(Calendar.getInstance().getTime())) {
            this.scheduleDate = null;
        } else {
            this.scheduleTime = this.getTime(this.scheduleDate);
        }
    }

    private void setCompletionStatus(String status) {
        if (status.equals("0")) {
            this.completionStatus = LanguageHelper.getString("nl.ibs.fac.language", "job_completed_normally");
        } else if (status.equals("1")) {
            this.completionStatus = LanguageHelper.getString("nl.ibs.fac.language", "job_completed_abnormally");
        }
    }

    private void getJavaJobInfo(String text) {
        int i = text.indexOf("')");
        if (i < 0) {
            return;
        }
        String token = "JAVA CLASS('";
        this.className = LanguageHelper.getString("nl.ibs.fac.language", text.substring(token.length(), i));
        token = "'Environment' '";
        i = text.indexOf(token);
        if (i < 0) {
            return;
        }
        int l = token.length();
        int j = text.indexOf("'", i + l);
        this.company = text.substring(i + l, j);
        token = "'Company' '";
        i = text.indexOf(token);
        if (i < 0) {
            return;
        }
        l = token.length();
        j = text.indexOf("'", i + l);
        this.company = this.company + "/" + text.substring(i + l, j);
    }

    private void getRPGJobInfo(String text) {
        String operationArea = null;
        String dataLib = null;
        int e = 0;
        int b = 0;
        block7: for (int i = 0; i < 5 && e < text.length(); ++i) {
            b = text.indexOf("'", e + 1);
            if (b <= 0 || (e = text.indexOf("'", b + 1)) <= 0) continue;
            switch (i) {
                case 0: {
                    continue block7;
                }
                case 1: {
                    operationArea = text.substring(b + 1, e);
                    continue block7;
                }
                case 2: {
                    dataLib = text.substring(b + 1, e);
                    continue block7;
                }
                case 3: {
                    continue block7;
                }
                case 4: {
                    this.company = text.substring(b + 1, e);
                }
            }
        }
        this.company = dataLib != null && dataLib.length() > 0 ? dataLib + '/' + this.company : operationArea + '/' + this.company;
    }

    private String getTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        StringBuffer sb = new StringBuffer();
        int hour = cal.get(11);
        if (hour < 10) {
            sb.append("0");
        }
        sb.append(hour);
        sb.append(':');
        int minute = cal.get(12);
        if (minute < 10) {
            sb.append("0");
        }
        sb.append(minute);
        sb.append(':');
        int second = cal.get(13);
        if (second < 10) {
            sb.append("0");
        }
        sb.append(second);
        return sb.toString();
    }

    public Job getJob() {
        return this.job;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public Date getScheduleDate() {
        return this.scheduleDate;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStatusInJobQueue() {
        return this.statusInJobQueue;
    }

    public String getScheduleTime() {
        return this.scheduleTime;
    }

    public String getClassName() {
        return this.className;
    }

    public String getCompany() {
        return this.company;
    }

    public String getCompletionStatus() {
        return this.completionStatus;
    }

    public Date getJobDate() {
        return this.jobDate;
    }

    public String getJobTime() {
        return this.jobTime;
    }
}

