/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac;

import java.io.Serializable;
import java.math.BigDecimal;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.CreditBalance;
import nl.ibs.fac.db.Valuation;

public class CalculationValue
implements Serializable {
    private static final long serialVersionUID = -5915796931069860384L;
    public static final String YEAR = "year";
    public static final String PERIOD = "period";
    public static final String DEPRECIATIONAMOUNT = "depreciationAmount";
    public static final String INTERESTAMOUNT = "interestAmount";
    public static final String REASONCODE = "reasonCode";
    public static final String ASSET = "asset";
    public static final String BOOKVALUE = "bookValue";
    public static final String ACQUISITIONVALUE = "acquisitionValue";
    public static final String TOTALDEPRECIATIONAMOUNT = "totalDepreciationAmount";
    public static final String TOTALDEPRECIATIONAMOUNTBEYONDECONOMICLIFE = "totalDepreciationAmountBeyondEconomicLife";
    public static final String TOTALINTERESTAMOUNT = "totalInterestAmount";
    public static final String BOOKVALUEAFTERDEPRECIATION = "bookValueAfterDepreciation";
    public static final String PREVIOUSBOOKVALUEBALANCE = "previousBookvalueBalance";
    public static final String ASSETTYPEID = "assetTypeId";
    private int year;
    private int period;
    private BigDecimal depreciationAmount;
    private BigDecimal interestAmount;
    private int reasonCode;
    private Asset asset;
    private Valuation valuation;
    private Credit credit;
    private CreditBalance creditBalance;
    private BigDecimal bookValue;
    private BigDecimal acquisitionValue;
    private BigDecimal totalDepreciationAmount;
    private BigDecimal totalInterestAmount;
    private BigDecimal previousBookvalueBalance;
    private BigDecimal currentInterestPercentage;
    private String assetTypeId;
    private BigDecimal correctionAmount445;
    private boolean depreciationBeyondEconomicLife;
    private BigDecimal totalDepreciationAmountBeyondEconomicLife;

    public CalculationValue() {
    }

    public CalculationValue(int reasonCode, int year, int period, BigDecimal depreciationAmount, BigDecimal interestAmount, Asset asset, Valuation valuation, BigDecimal bookValue, BigDecimal acquisitionValue, BigDecimal totalDepreciationAmount, BigDecimal totalInterestAmount, BigDecimal previousBookvalueBalance, BigDecimal currentInterestPercentage, BigDecimal correctionAmount445, boolean depreciationBeyondEconomicLife, BigDecimal totalDepreciationAmountBeyondEconomicLife) {
        this.reasonCode = reasonCode;
        this.year = year;
        this.period = period;
        this.depreciationAmount = depreciationAmount;
        this.interestAmount = interestAmount;
        this.asset = asset;
        this.valuation = valuation;
        this.bookValue = bookValue;
        this.acquisitionValue = acquisitionValue;
        this.totalDepreciationAmount = totalDepreciationAmount;
        this.totalInterestAmount = totalInterestAmount;
        this.previousBookvalueBalance = previousBookvalueBalance;
        this.currentInterestPercentage = currentInterestPercentage;
        this.correctionAmount445 = correctionAmount445;
        this.depreciationBeyondEconomicLife = depreciationBeyondEconomicLife;
        this.totalDepreciationAmountBeyondEconomicLife = totalDepreciationAmountBeyondEconomicLife;
    }

    public boolean isDepreciationBeyondEconomicLife() {
        return this.depreciationBeyondEconomicLife;
    }

    public BigDecimal getCorrectionAmount445() {
        return this.correctionAmount445;
    }

    public void setAssetTypeId(String assetTypeId) {
        this.assetTypeId = assetTypeId;
    }

    public String getAssetTypeId() {
        if (this.reasonCode != 2) {
            return "";
        }
        return this.assetTypeId;
    }

    public void setCredit(Credit credit) {
        this.credit = credit;
    }

    public Credit getCredit() {
        return this.credit;
    }

    public void setCreditBalance(CreditBalance creditBalance) {
        this.creditBalance = creditBalance;
    }

    public CreditBalance getCreditBalance() {
        return this.creditBalance;
    }

    public BigDecimal getCurrentInterestPercentage() {
        return this.currentInterestPercentage;
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    public int getYear() {
        return this.year;
    }

    public int getPeriod() {
        return this.period;
    }

    public BigDecimal getDepreciationAmount() {
        return this.depreciationAmount;
    }

    public BigDecimal getInterestAmount() {
        return this.interestAmount;
    }

    public void setReasonCode(int reasonCode) {
        this.reasonCode = reasonCode;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public Valuation getValuation() {
        return this.valuation;
    }

    public BigDecimal getAcquisitionValue() {
        return this.acquisitionValue;
    }

    public BigDecimal getBookValue() {
        if (this.getReasonCode() == 98) {
            return this.bookValue.subtract(this.previousBookvalueBalance);
        }
        if (this.getReasonCode() == 99) {
            return new BigDecimal("0");
        }
        return this.bookValue;
    }

    public BigDecimal getBookValueAfterDepreciation() {
        if (this.depreciationAmount == null || this.depreciationBeyondEconomicLife) {
            return this.bookValue;
        }
        return this.bookValue.subtract(this.depreciationAmount);
    }

    public BigDecimal getTotalDepreciationAmount() {
        return this.totalDepreciationAmount;
    }

    public BigDecimal getTotalInterestAmount() {
        return this.totalInterestAmount;
    }

    public BigDecimal getPreviousBookvalueBalance() {
        return this.previousBookvalueBalance;
    }

    public void setPreviousBookvalueBalance(BigDecimal bd) {
        this.previousBookvalueBalance = bd;
    }

    public void setDepreciationAmount(BigDecimal depreciationAmount, boolean updatePreviousBookValueBalance) {
        if (updatePreviousBookValueBalance) {
            this.previousBookvalueBalance = this.previousBookvalueBalance.add(this.depreciationAmount).subtract(depreciationAmount);
        }
        this.totalDepreciationAmount = this.totalDepreciationAmount.subtract(this.depreciationAmount).add(depreciationAmount);
        this.depreciationAmount = depreciationAmount;
    }

    public void setInterestAmount(BigDecimal interestAmount) {
        this.totalInterestAmount = this.totalInterestAmount.subtract(this.interestAmount).add(interestAmount);
        this.interestAmount = interestAmount;
    }

    public void addToTotalDepreciationAmount(BigDecimal amount) {
        this.totalDepreciationAmount = this.totalDepreciationAmount.add(amount);
    }

    public BigDecimal getTotalDepreciationAmountBeyondEconomicLife() {
        return this.totalDepreciationAmountBeyondEconomicLife;
    }

    public void setTotalDepreciationAmount(BigDecimal totalDepreciationAmount) {
        this.totalDepreciationAmount = totalDepreciationAmount;
    }
}

