/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac;

import java.io.Serializable;
import nl.ibs.fac.language.LanguageHelper;

public class ColumnDefinition
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6816983758299125346L;
    private String ddsName;
    private String label;
    private String type;
    private String suffix;
    private int agSeqNr = 0;
    private int sort_1;
    private int sort_2;

    public ColumnDefinition(String ddsName, String label, String type) {
        this.ddsName = ddsName;
        if (ddsName.endsWith("PERIOD")) {
            String string = "";
        }
        this.label = label;
        this.type = type;
        this.suffix = "";
    }

    public ColumnDefinition(String ddsName, String label, String type, int agSeqNr) {
        this.ddsName = ddsName;
        this.label = label;
        this.type = type;
        this.suffix = "";
        this.agSeqNr = agSeqNr;
    }

    public ColumnDefinition(String ddsName, String label, String type, String suffix) {
        this.ddsName = ddsName;
        this.label = label;
        this.type = type;
        this.suffix = suffix;
    }

    public String retrieveCSVHeaderLabel() throws Exception {
        if (this.type.equals("FD") || this.type.equals("AC") || this.type.equals("AV")) {
            return this.label;
        }
        String[] labelParts = this.label.split("\\.");
        if (labelParts == null || labelParts.length < 2) {
            return this.label;
        }
        return (LanguageHelper.getString("nl.ibs.fac.language", labelParts[1]) + " " + this.suffix).trim();
    }

    public String getDdsName() {
        return this.ddsName;
    }

    public String getLabel() {
        return this.label;
    }

    public String getType() {
        return this.type;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public int getAgSeqNr() {
        return this.agSeqNr;
    }

    public void setSort_1(int s) {
        this.sort_1 = s;
    }

    public int getSort_1() {
        return this.sort_1;
    }

    public void setSort_2(int s) {
        this.sort_2 = s;
    }

    public int getSort_2() {
        return this.sort_2;
    }
}

